import 'package:agora_rtc_engine/agora_rtc_engine.dart';
import 'package:flutter_test/flutter_test.dart';
import 'package:integration_test/integration_test.dart';
import 'package:integration_test_app/main.dart' as app;

void testCases() {
  testWidgets(
    'getAssetAbsolutePath',
    (WidgetTester tester) async {
      app.main();
      await tester.pumpAndSettle();

      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));

      final assetPath =
          await rtcEngine.getAssetAbsolutePath('assets/agora-logo.png');
      expect(assetPath!.endsWith('agora-logo.png'), isTrue);

      await rtcEngine.release();
    },
//  skip: !(),
  );
}
