/// GENERATED BY testcase_gen. DO NOT MODIFY BY HAND.

// ignore_for_file: deprecated_member_use,constant_identifier_names

import 'package:agora_rtc_engine/agora_rtc_engine.dart';
import 'package:flutter_test/flutter_test.dart';
import 'package:flutter/foundation.dart';
import 'package:integration_test_app/main.dart' as app;

void mediaPlayerCacheManagerSmokeTestCases() {
  testWidgets(
    'MediaPlayerCacheManager.removeAllCaches',
    (WidgetTester tester) async {
      app.main();
      await tester.pumpAndSettle();

      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      final mediaPlayerCacheManager = getMediaPlayerCacheManager(rtcEngine);

      try {
        await mediaPlayerCacheManager.removeAllCaches();
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[MediaPlayerCacheManager.removeAllCaches] error: ${e.toString()}');
        }
        expect(e is AgoraRtcException, true);
        debugPrint(
            '[MediaPlayerCacheManager.removeAllCaches] errorcode: ${(e as AgoraRtcException).code}');
      }

      await rtcEngine.release();
    },
//  skip: !(),
  );

  testWidgets(
    'MediaPlayerCacheManager.removeOldCache',
    (WidgetTester tester) async {
      app.main();
      await tester.pumpAndSettle();

      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      final mediaPlayerCacheManager = getMediaPlayerCacheManager(rtcEngine);

      try {
        await mediaPlayerCacheManager.removeOldCache();
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[MediaPlayerCacheManager.removeOldCache] error: ${e.toString()}');
        }
        expect(e is AgoraRtcException, true);
        debugPrint(
            '[MediaPlayerCacheManager.removeOldCache] errorcode: ${(e as AgoraRtcException).code}');
      }

      await rtcEngine.release();
    },
//  skip: !(),
  );

  testWidgets(
    'MediaPlayerCacheManager.removeCacheByUri',
    (WidgetTester tester) async {
      app.main();
      await tester.pumpAndSettle();

      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      final mediaPlayerCacheManager = getMediaPlayerCacheManager(rtcEngine);

      try {
        String uri = "hello";
        await mediaPlayerCacheManager.removeCacheByUri(
          uri,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[MediaPlayerCacheManager.removeCacheByUri] error: ${e.toString()}');
        }
        expect(e is AgoraRtcException, true);
        debugPrint(
            '[MediaPlayerCacheManager.removeCacheByUri] errorcode: ${(e as AgoraRtcException).code}');
      }

      await rtcEngine.release();
    },
//  skip: !(),
  );

  testWidgets(
    'MediaPlayerCacheManager.setCacheDir',
    (WidgetTester tester) async {
      app.main();
      await tester.pumpAndSettle();

      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      final mediaPlayerCacheManager = getMediaPlayerCacheManager(rtcEngine);

      try {
        String path = "hello";
        await mediaPlayerCacheManager.setCacheDir(
          path,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[MediaPlayerCacheManager.setCacheDir] error: ${e.toString()}');
        }
        expect(e is AgoraRtcException, true);
        debugPrint(
            '[MediaPlayerCacheManager.setCacheDir] errorcode: ${(e as AgoraRtcException).code}');
      }

      await rtcEngine.release();
    },
//  skip: !(),
  );

  testWidgets(
    'MediaPlayerCacheManager.setMaxCacheFileCount',
    (WidgetTester tester) async {
      app.main();
      await tester.pumpAndSettle();

      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      final mediaPlayerCacheManager = getMediaPlayerCacheManager(rtcEngine);

      try {
        int count = 5;
        await mediaPlayerCacheManager.setMaxCacheFileCount(
          count,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[MediaPlayerCacheManager.setMaxCacheFileCount] error: ${e.toString()}');
        }
        expect(e is AgoraRtcException, true);
        debugPrint(
            '[MediaPlayerCacheManager.setMaxCacheFileCount] errorcode: ${(e as AgoraRtcException).code}');
      }

      await rtcEngine.release();
    },
//  skip: !(),
  );

  testWidgets(
    'MediaPlayerCacheManager.setMaxCacheFileSize',
    (WidgetTester tester) async {
      app.main();
      await tester.pumpAndSettle();

      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      final mediaPlayerCacheManager = getMediaPlayerCacheManager(rtcEngine);

      try {
        int cacheSize = 5;
        await mediaPlayerCacheManager.setMaxCacheFileSize(
          cacheSize,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[MediaPlayerCacheManager.setMaxCacheFileSize] error: ${e.toString()}');
        }
        expect(e is AgoraRtcException, true);
        debugPrint(
            '[MediaPlayerCacheManager.setMaxCacheFileSize] errorcode: ${(e as AgoraRtcException).code}');
      }

      await rtcEngine.release();
    },
//  skip: !(),
  );

  testWidgets(
    'MediaPlayerCacheManager.enableAutoRemoveCache',
    (WidgetTester tester) async {
      app.main();
      await tester.pumpAndSettle();

      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      final mediaPlayerCacheManager = getMediaPlayerCacheManager(rtcEngine);

      try {
        bool enable = true;
        await mediaPlayerCacheManager.enableAutoRemoveCache(
          enable,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[MediaPlayerCacheManager.enableAutoRemoveCache] error: ${e.toString()}');
        }
        expect(e is AgoraRtcException, true);
        debugPrint(
            '[MediaPlayerCacheManager.enableAutoRemoveCache] errorcode: ${(e as AgoraRtcException).code}');
      }

      await rtcEngine.release();
    },
//  skip: !(),
  );

  testWidgets(
    'MediaPlayerCacheManager.getCacheDir',
    (WidgetTester tester) async {
      app.main();
      await tester.pumpAndSettle();

      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      final mediaPlayerCacheManager = getMediaPlayerCacheManager(rtcEngine);

      try {
        int length = 5;
        await mediaPlayerCacheManager.getCacheDir(
          length,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[MediaPlayerCacheManager.getCacheDir] error: ${e.toString()}');
        }
        expect(e is AgoraRtcException, true);
        debugPrint(
            '[MediaPlayerCacheManager.getCacheDir] errorcode: ${(e as AgoraRtcException).code}');
      }

      await rtcEngine.release();
    },
//  skip: !(),
  );

  testWidgets(
    'MediaPlayerCacheManager.getMaxCacheFileCount',
    (WidgetTester tester) async {
      app.main();
      await tester.pumpAndSettle();

      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      final mediaPlayerCacheManager = getMediaPlayerCacheManager(rtcEngine);

      try {
        await mediaPlayerCacheManager.getMaxCacheFileCount();
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[MediaPlayerCacheManager.getMaxCacheFileCount] error: ${e.toString()}');
        }
        expect(e is AgoraRtcException, true);
        debugPrint(
            '[MediaPlayerCacheManager.getMaxCacheFileCount] errorcode: ${(e as AgoraRtcException).code}');
      }

      await rtcEngine.release();
    },
//  skip: !(),
  );

  testWidgets(
    'MediaPlayerCacheManager.getMaxCacheFileSize',
    (WidgetTester tester) async {
      app.main();
      await tester.pumpAndSettle();

      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      final mediaPlayerCacheManager = getMediaPlayerCacheManager(rtcEngine);

      try {
        await mediaPlayerCacheManager.getMaxCacheFileSize();
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[MediaPlayerCacheManager.getMaxCacheFileSize] error: ${e.toString()}');
        }
        expect(e is AgoraRtcException, true);
        debugPrint(
            '[MediaPlayerCacheManager.getMaxCacheFileSize] errorcode: ${(e as AgoraRtcException).code}');
      }

      await rtcEngine.release();
    },
//  skip: !(),
  );

  testWidgets(
    'MediaPlayerCacheManager.getCacheFileCount',
    (WidgetTester tester) async {
      app.main();
      await tester.pumpAndSettle();

      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      final mediaPlayerCacheManager = getMediaPlayerCacheManager(rtcEngine);

      try {
        await mediaPlayerCacheManager.getCacheFileCount();
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[MediaPlayerCacheManager.getCacheFileCount] error: ${e.toString()}');
        }
        expect(e is AgoraRtcException, true);
        debugPrint(
            '[MediaPlayerCacheManager.getCacheFileCount] errorcode: ${(e as AgoraRtcException).code}');
      }

      await rtcEngine.release();
    },
//  skip: !(),
  );
}
