/// GENERATED BY testcase_gen. DO NOT MODIFY BY HAND.

// ignore_for_file: deprecated_member_use,constant_identifier_names

import 'package:agora_rtc_engine/agora_rtc_engine.dart';
import 'package:flutter_test/flutter_test.dart';
import 'dart:typed_data';
import 'package:flutter/foundation.dart';
import 'package:fake_test_app/main.dart' as app;
import 'package:iris_tester/iris_tester.dart';
import 'package:iris_method_channel/iris_method_channel.dart';

void rtcEngineExSmokeTestCases() {
  testWidgets(
    'RtcEngineEx.joinChannelEx',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngineEx rtcEngineEx = createAgoraRtcEngineEx();
      await rtcEngineEx.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngineEx.setParameters('{"rtc.enable_debug_log": true}');

      try {
        String token = "hello";
        String connectionChannelId = "hello";
        int connectionLocalUid = 5;
        RtcConnection connection = RtcConnection(
          channelId: connectionChannelId,
          localUid: connectionLocalUid,
        );
        ClientRoleType optionsClientRoleType =
            ClientRoleType.clientRoleBroadcaster;
        AudienceLatencyLevelType optionsAudienceLatencyLevel =
            AudienceLatencyLevelType.audienceLatencyLevelLowLatency;
        VideoStreamType optionsDefaultVideoStreamType =
            VideoStreamType.videoStreamHigh;
        ChannelProfileType optionsChannelProfile =
            ChannelProfileType.channelProfileCommunication;
        bool optionsPublishCameraTrack = true;
        bool optionsPublishSecondaryCameraTrack = true;
        bool optionsPublishThirdCameraTrack = true;
        bool optionsPublishFourthCameraTrack = true;
        bool optionsPublishMicrophoneTrack = true;
        bool optionsPublishScreenCaptureVideo = true;
        bool optionsPublishScreenCaptureAudio = true;
        bool optionsPublishScreenTrack = true;
        bool optionsPublishSecondaryScreenTrack = true;
        bool optionsPublishThirdScreenTrack = true;
        bool optionsPublishFourthScreenTrack = true;
        bool optionsPublishCustomAudioTrack = true;
        int optionsPublishCustomAudioTrackId = 5;
        bool optionsPublishCustomVideoTrack = true;
        bool optionsPublishEncodedVideoTrack = true;
        bool optionsPublishMediaPlayerAudioTrack = true;
        bool optionsPublishMediaPlayerVideoTrack = true;
        bool optionsPublishTranscodedVideoTrack = true;
        bool optionsPublishMixedAudioTrack = true;
        bool optionsPublishLipSyncTrack = true;
        bool optionsAutoSubscribeAudio = true;
        bool optionsAutoSubscribeVideo = true;
        bool optionsEnableAudioRecordingOrPlayout = true;
        int optionsPublishMediaPlayerId = 5;
        int optionsAudioDelayMs = 5;
        int optionsMediaPlayerAudioDelayMs = 5;
        String optionsToken = "hello";
        bool optionsEnableBuiltInMediaEncryption = true;
        bool optionsPublishRhythmPlayerTrack = true;
        bool optionsIsInteractiveAudience = true;
        int optionsCustomVideoTrackId = 5;
        bool optionsIsAudioFilterable = true;
        String optionsParameters = "hello";
        ChannelMediaOptions options = ChannelMediaOptions(
          publishCameraTrack: optionsPublishCameraTrack,
          publishSecondaryCameraTrack: optionsPublishSecondaryCameraTrack,
          publishThirdCameraTrack: optionsPublishThirdCameraTrack,
          publishFourthCameraTrack: optionsPublishFourthCameraTrack,
          publishMicrophoneTrack: optionsPublishMicrophoneTrack,
          publishScreenCaptureVideo: optionsPublishScreenCaptureVideo,
          publishScreenCaptureAudio: optionsPublishScreenCaptureAudio,
          publishScreenTrack: optionsPublishScreenTrack,
          publishSecondaryScreenTrack: optionsPublishSecondaryScreenTrack,
          publishThirdScreenTrack: optionsPublishThirdScreenTrack,
          publishFourthScreenTrack: optionsPublishFourthScreenTrack,
          publishCustomAudioTrack: optionsPublishCustomAudioTrack,
          publishCustomAudioTrackId: optionsPublishCustomAudioTrackId,
          publishCustomVideoTrack: optionsPublishCustomVideoTrack,
          publishEncodedVideoTrack: optionsPublishEncodedVideoTrack,
          publishMediaPlayerAudioTrack: optionsPublishMediaPlayerAudioTrack,
          publishMediaPlayerVideoTrack: optionsPublishMediaPlayerVideoTrack,
          publishTranscodedVideoTrack: optionsPublishTranscodedVideoTrack,
          publishMixedAudioTrack: optionsPublishMixedAudioTrack,
          publishLipSyncTrack: optionsPublishLipSyncTrack,
          autoSubscribeAudio: optionsAutoSubscribeAudio,
          autoSubscribeVideo: optionsAutoSubscribeVideo,
          enableAudioRecordingOrPlayout: optionsEnableAudioRecordingOrPlayout,
          publishMediaPlayerId: optionsPublishMediaPlayerId,
          clientRoleType: optionsClientRoleType,
          audienceLatencyLevel: optionsAudienceLatencyLevel,
          defaultVideoStreamType: optionsDefaultVideoStreamType,
          channelProfile: optionsChannelProfile,
          audioDelayMs: optionsAudioDelayMs,
          mediaPlayerAudioDelayMs: optionsMediaPlayerAudioDelayMs,
          token: optionsToken,
          enableBuiltInMediaEncryption: optionsEnableBuiltInMediaEncryption,
          publishRhythmPlayerTrack: optionsPublishRhythmPlayerTrack,
          isInteractiveAudience: optionsIsInteractiveAudience,
          customVideoTrackId: optionsCustomVideoTrackId,
          isAudioFilterable: optionsIsAudioFilterable,
          parameters: optionsParameters,
        );
        await rtcEngineEx.joinChannelEx(
          token: token,
          connection: connection,
          options: options,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngineEx.joinChannelEx] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngineEx.release();
    },
//  skip: !(),
  );

  testWidgets(
    'RtcEngineEx.leaveChannelEx',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngineEx rtcEngineEx = createAgoraRtcEngineEx();
      await rtcEngineEx.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngineEx.setParameters('{"rtc.enable_debug_log": true}');

      try {
        String connectionChannelId = "hello";
        int connectionLocalUid = 5;
        RtcConnection connection = RtcConnection(
          channelId: connectionChannelId,
          localUid: connectionLocalUid,
        );
        bool optionsStopAudioMixing = true;
        bool optionsStopAllEffect = true;
        bool optionsStopMicrophoneRecording = true;
        LeaveChannelOptions options = LeaveChannelOptions(
          stopAudioMixing: optionsStopAudioMixing,
          stopAllEffect: optionsStopAllEffect,
          stopMicrophoneRecording: optionsStopMicrophoneRecording,
        );
        await rtcEngineEx.leaveChannelEx(
          connection: connection,
          options: options,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngineEx.leaveChannelEx] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngineEx.release();
    },
//  skip: !(),
  );

  testWidgets(
    'RtcEngineEx.leaveChannelWithUserAccountEx',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngineEx rtcEngineEx = createAgoraRtcEngineEx();
      await rtcEngineEx.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngineEx.setParameters('{"rtc.enable_debug_log": true}');

      try {
        String channelId = "hello";
        String userAccount = "hello";
        bool optionsStopAudioMixing = true;
        bool optionsStopAllEffect = true;
        bool optionsStopMicrophoneRecording = true;
        LeaveChannelOptions options = LeaveChannelOptions(
          stopAudioMixing: optionsStopAudioMixing,
          stopAllEffect: optionsStopAllEffect,
          stopMicrophoneRecording: optionsStopMicrophoneRecording,
        );
        await rtcEngineEx.leaveChannelWithUserAccountEx(
          channelId: channelId,
          userAccount: userAccount,
          options: options,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngineEx.leaveChannelWithUserAccountEx] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngineEx.release();
    },
//  skip: !(),
  );

  testWidgets(
    'RtcEngineEx.updateChannelMediaOptionsEx',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngineEx rtcEngineEx = createAgoraRtcEngineEx();
      await rtcEngineEx.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngineEx.setParameters('{"rtc.enable_debug_log": true}');

      try {
        ClientRoleType optionsClientRoleType =
            ClientRoleType.clientRoleBroadcaster;
        AudienceLatencyLevelType optionsAudienceLatencyLevel =
            AudienceLatencyLevelType.audienceLatencyLevelLowLatency;
        VideoStreamType optionsDefaultVideoStreamType =
            VideoStreamType.videoStreamHigh;
        ChannelProfileType optionsChannelProfile =
            ChannelProfileType.channelProfileCommunication;
        bool optionsPublishCameraTrack = true;
        bool optionsPublishSecondaryCameraTrack = true;
        bool optionsPublishThirdCameraTrack = true;
        bool optionsPublishFourthCameraTrack = true;
        bool optionsPublishMicrophoneTrack = true;
        bool optionsPublishScreenCaptureVideo = true;
        bool optionsPublishScreenCaptureAudio = true;
        bool optionsPublishScreenTrack = true;
        bool optionsPublishSecondaryScreenTrack = true;
        bool optionsPublishThirdScreenTrack = true;
        bool optionsPublishFourthScreenTrack = true;
        bool optionsPublishCustomAudioTrack = true;
        int optionsPublishCustomAudioTrackId = 5;
        bool optionsPublishCustomVideoTrack = true;
        bool optionsPublishEncodedVideoTrack = true;
        bool optionsPublishMediaPlayerAudioTrack = true;
        bool optionsPublishMediaPlayerVideoTrack = true;
        bool optionsPublishTranscodedVideoTrack = true;
        bool optionsPublishMixedAudioTrack = true;
        bool optionsPublishLipSyncTrack = true;
        bool optionsAutoSubscribeAudio = true;
        bool optionsAutoSubscribeVideo = true;
        bool optionsEnableAudioRecordingOrPlayout = true;
        int optionsPublishMediaPlayerId = 5;
        int optionsAudioDelayMs = 5;
        int optionsMediaPlayerAudioDelayMs = 5;
        String optionsToken = "hello";
        bool optionsEnableBuiltInMediaEncryption = true;
        bool optionsPublishRhythmPlayerTrack = true;
        bool optionsIsInteractiveAudience = true;
        int optionsCustomVideoTrackId = 5;
        bool optionsIsAudioFilterable = true;
        String optionsParameters = "hello";
        ChannelMediaOptions options = ChannelMediaOptions(
          publishCameraTrack: optionsPublishCameraTrack,
          publishSecondaryCameraTrack: optionsPublishSecondaryCameraTrack,
          publishThirdCameraTrack: optionsPublishThirdCameraTrack,
          publishFourthCameraTrack: optionsPublishFourthCameraTrack,
          publishMicrophoneTrack: optionsPublishMicrophoneTrack,
          publishScreenCaptureVideo: optionsPublishScreenCaptureVideo,
          publishScreenCaptureAudio: optionsPublishScreenCaptureAudio,
          publishScreenTrack: optionsPublishScreenTrack,
          publishSecondaryScreenTrack: optionsPublishSecondaryScreenTrack,
          publishThirdScreenTrack: optionsPublishThirdScreenTrack,
          publishFourthScreenTrack: optionsPublishFourthScreenTrack,
          publishCustomAudioTrack: optionsPublishCustomAudioTrack,
          publishCustomAudioTrackId: optionsPublishCustomAudioTrackId,
          publishCustomVideoTrack: optionsPublishCustomVideoTrack,
          publishEncodedVideoTrack: optionsPublishEncodedVideoTrack,
          publishMediaPlayerAudioTrack: optionsPublishMediaPlayerAudioTrack,
          publishMediaPlayerVideoTrack: optionsPublishMediaPlayerVideoTrack,
          publishTranscodedVideoTrack: optionsPublishTranscodedVideoTrack,
          publishMixedAudioTrack: optionsPublishMixedAudioTrack,
          publishLipSyncTrack: optionsPublishLipSyncTrack,
          autoSubscribeAudio: optionsAutoSubscribeAudio,
          autoSubscribeVideo: optionsAutoSubscribeVideo,
          enableAudioRecordingOrPlayout: optionsEnableAudioRecordingOrPlayout,
          publishMediaPlayerId: optionsPublishMediaPlayerId,
          clientRoleType: optionsClientRoleType,
          audienceLatencyLevel: optionsAudienceLatencyLevel,
          defaultVideoStreamType: optionsDefaultVideoStreamType,
          channelProfile: optionsChannelProfile,
          audioDelayMs: optionsAudioDelayMs,
          mediaPlayerAudioDelayMs: optionsMediaPlayerAudioDelayMs,
          token: optionsToken,
          enableBuiltInMediaEncryption: optionsEnableBuiltInMediaEncryption,
          publishRhythmPlayerTrack: optionsPublishRhythmPlayerTrack,
          isInteractiveAudience: optionsIsInteractiveAudience,
          customVideoTrackId: optionsCustomVideoTrackId,
          isAudioFilterable: optionsIsAudioFilterable,
          parameters: optionsParameters,
        );
        String connectionChannelId = "hello";
        int connectionLocalUid = 5;
        RtcConnection connection = RtcConnection(
          channelId: connectionChannelId,
          localUid: connectionLocalUid,
        );
        await rtcEngineEx.updateChannelMediaOptionsEx(
          options: options,
          connection: connection,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngineEx.updateChannelMediaOptionsEx] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngineEx.release();
    },
//  skip: !(),
  );

  testWidgets(
    'RtcEngineEx.setVideoEncoderConfigurationEx',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngineEx rtcEngineEx = createAgoraRtcEngineEx();
      await rtcEngineEx.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngineEx.setParameters('{"rtc.enable_debug_log": true}');

      try {
        VideoCodecType configCodecType = VideoCodecType.videoCodecNone;
        int dimensionsWidth = 5;
        int dimensionsHeight = 5;
        VideoDimensions configDimensions = VideoDimensions(
          width: dimensionsWidth,
          height: dimensionsHeight,
        );
        OrientationMode configOrientationMode =
            OrientationMode.orientationModeAdaptive;
        DegradationPreference configDegradationPreference =
            DegradationPreference.maintainAuto;
        VideoMirrorModeType configMirrorMode =
            VideoMirrorModeType.videoMirrorModeAuto;
        EncodingPreference advanceOptionsEncodingPreference =
            EncodingPreference.preferAuto;
        CompressionPreference advanceOptionsCompressionPreference =
            CompressionPreference.preferCompressionAuto;
        bool advanceOptionsEncodeAlpha = true;
        AdvanceOptions configAdvanceOptions = AdvanceOptions(
          encodingPreference: advanceOptionsEncodingPreference,
          compressionPreference: advanceOptionsCompressionPreference,
          encodeAlpha: advanceOptionsEncodeAlpha,
        );
        int configFrameRate = 5;
        int configBitrate = 5;
        int configMinBitrate = 5;
        VideoEncoderConfiguration config = VideoEncoderConfiguration(
          codecType: configCodecType,
          dimensions: configDimensions,
          frameRate: configFrameRate,
          bitrate: configBitrate,
          minBitrate: configMinBitrate,
          orientationMode: configOrientationMode,
          degradationPreference: configDegradationPreference,
          mirrorMode: configMirrorMode,
          advanceOptions: configAdvanceOptions,
        );
        String connectionChannelId = "hello";
        int connectionLocalUid = 5;
        RtcConnection connection = RtcConnection(
          channelId: connectionChannelId,
          localUid: connectionLocalUid,
        );
        await rtcEngineEx.setVideoEncoderConfigurationEx(
          config: config,
          connection: connection,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngineEx.setVideoEncoderConfigurationEx] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngineEx.release();
    },
//  skip: !(),
  );

  testWidgets(
    'RtcEngineEx.setupRemoteVideoEx',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngineEx rtcEngineEx = createAgoraRtcEngineEx();
      await rtcEngineEx.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngineEx.setParameters('{"rtc.enable_debug_log": true}');

      try {
        RenderModeType canvasRenderMode = RenderModeType.renderModeHidden;
        VideoMirrorModeType canvasMirrorMode =
            VideoMirrorModeType.videoMirrorModeAuto;
        VideoViewSetupMode canvasSetupMode =
            VideoViewSetupMode.videoViewSetupReplace;
        VideoSourceType canvasSourceType =
            VideoSourceType.videoSourceCameraPrimary;
        int cropAreaX = 5;
        int cropAreaY = 5;
        int cropAreaWidth = 5;
        int cropAreaHeight = 5;
        Rectangle canvasCropArea = Rectangle(
          x: cropAreaX,
          y: cropAreaY,
          width: cropAreaWidth,
          height: cropAreaHeight,
        );
        VideoModulePosition canvasPosition =
            VideoModulePosition.positionPostCapturer;
        int canvasUid = 5;
        int canvasSubviewUid = 5;
        int canvasView = 5;
        int canvasBackgroundColor = 5;
        int canvasMediaPlayerId = 5;
        bool canvasEnableAlphaMask = true;
        VideoCanvas canvas = VideoCanvas(
          uid: canvasUid,
          subviewUid: canvasSubviewUid,
          view: canvasView,
          backgroundColor: canvasBackgroundColor,
          renderMode: canvasRenderMode,
          mirrorMode: canvasMirrorMode,
          setupMode: canvasSetupMode,
          sourceType: canvasSourceType,
          mediaPlayerId: canvasMediaPlayerId,
          cropArea: canvasCropArea,
          enableAlphaMask: canvasEnableAlphaMask,
          position: canvasPosition,
        );
        String connectionChannelId = "hello";
        int connectionLocalUid = 5;
        RtcConnection connection = RtcConnection(
          channelId: connectionChannelId,
          localUid: connectionLocalUid,
        );
        await rtcEngineEx.setupRemoteVideoEx(
          canvas: canvas,
          connection: connection,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngineEx.setupRemoteVideoEx] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngineEx.release();
    },
//  skip: !(),
  );

  testWidgets(
    'RtcEngineEx.muteRemoteAudioStreamEx',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngineEx rtcEngineEx = createAgoraRtcEngineEx();
      await rtcEngineEx.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngineEx.setParameters('{"rtc.enable_debug_log": true}');

      try {
        int uid = 5;
        bool mute = true;
        String connectionChannelId = "hello";
        int connectionLocalUid = 5;
        RtcConnection connection = RtcConnection(
          channelId: connectionChannelId,
          localUid: connectionLocalUid,
        );
        await rtcEngineEx.muteRemoteAudioStreamEx(
          uid: uid,
          mute: mute,
          connection: connection,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngineEx.muteRemoteAudioStreamEx] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngineEx.release();
    },
//  skip: !(),
  );

  testWidgets(
    'RtcEngineEx.muteRemoteVideoStreamEx',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngineEx rtcEngineEx = createAgoraRtcEngineEx();
      await rtcEngineEx.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngineEx.setParameters('{"rtc.enable_debug_log": true}');

      try {
        int uid = 5;
        bool mute = true;
        String connectionChannelId = "hello";
        int connectionLocalUid = 5;
        RtcConnection connection = RtcConnection(
          channelId: connectionChannelId,
          localUid: connectionLocalUid,
        );
        await rtcEngineEx.muteRemoteVideoStreamEx(
          uid: uid,
          mute: mute,
          connection: connection,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngineEx.muteRemoteVideoStreamEx] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngineEx.release();
    },
//  skip: !(),
  );

  testWidgets(
    'RtcEngineEx.setRemoteVideoStreamTypeEx',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngineEx rtcEngineEx = createAgoraRtcEngineEx();
      await rtcEngineEx.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngineEx.setParameters('{"rtc.enable_debug_log": true}');

      try {
        int uid = 5;
        VideoStreamType streamType = VideoStreamType.videoStreamHigh;
        String connectionChannelId = "hello";
        int connectionLocalUid = 5;
        RtcConnection connection = RtcConnection(
          channelId: connectionChannelId,
          localUid: connectionLocalUid,
        );
        await rtcEngineEx.setRemoteVideoStreamTypeEx(
          uid: uid,
          streamType: streamType,
          connection: connection,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngineEx.setRemoteVideoStreamTypeEx] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngineEx.release();
    },
//  skip: !(),
  );

  testWidgets(
    'RtcEngineEx.muteLocalAudioStreamEx',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngineEx rtcEngineEx = createAgoraRtcEngineEx();
      await rtcEngineEx.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngineEx.setParameters('{"rtc.enable_debug_log": true}');

      try {
        bool mute = true;
        String connectionChannelId = "hello";
        int connectionLocalUid = 5;
        RtcConnection connection = RtcConnection(
          channelId: connectionChannelId,
          localUid: connectionLocalUid,
        );
        await rtcEngineEx.muteLocalAudioStreamEx(
          mute: mute,
          connection: connection,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngineEx.muteLocalAudioStreamEx] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngineEx.release();
    },
//  skip: !(),
  );

  testWidgets(
    'RtcEngineEx.muteLocalVideoStreamEx',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngineEx rtcEngineEx = createAgoraRtcEngineEx();
      await rtcEngineEx.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngineEx.setParameters('{"rtc.enable_debug_log": true}');

      try {
        bool mute = true;
        String connectionChannelId = "hello";
        int connectionLocalUid = 5;
        RtcConnection connection = RtcConnection(
          channelId: connectionChannelId,
          localUid: connectionLocalUid,
        );
        await rtcEngineEx.muteLocalVideoStreamEx(
          mute: mute,
          connection: connection,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngineEx.muteLocalVideoStreamEx] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngineEx.release();
    },
//  skip: !(),
  );

  testWidgets(
    'RtcEngineEx.muteAllRemoteAudioStreamsEx',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngineEx rtcEngineEx = createAgoraRtcEngineEx();
      await rtcEngineEx.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngineEx.setParameters('{"rtc.enable_debug_log": true}');

      try {
        bool mute = true;
        String connectionChannelId = "hello";
        int connectionLocalUid = 5;
        RtcConnection connection = RtcConnection(
          channelId: connectionChannelId,
          localUid: connectionLocalUid,
        );
        await rtcEngineEx.muteAllRemoteAudioStreamsEx(
          mute: mute,
          connection: connection,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngineEx.muteAllRemoteAudioStreamsEx] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngineEx.release();
    },
//  skip: !(),
  );

  testWidgets(
    'RtcEngineEx.muteAllRemoteVideoStreamsEx',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngineEx rtcEngineEx = createAgoraRtcEngineEx();
      await rtcEngineEx.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngineEx.setParameters('{"rtc.enable_debug_log": true}');

      try {
        bool mute = true;
        String connectionChannelId = "hello";
        int connectionLocalUid = 5;
        RtcConnection connection = RtcConnection(
          channelId: connectionChannelId,
          localUid: connectionLocalUid,
        );
        await rtcEngineEx.muteAllRemoteVideoStreamsEx(
          mute: mute,
          connection: connection,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngineEx.muteAllRemoteVideoStreamsEx] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngineEx.release();
    },
//  skip: !(),
  );

  testWidgets(
    'RtcEngineEx.setRemoteVideoSubscriptionOptionsEx',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngineEx rtcEngineEx = createAgoraRtcEngineEx();
      await rtcEngineEx.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngineEx.setParameters('{"rtc.enable_debug_log": true}');

      try {
        int uid = 5;
        VideoStreamType optionsType = VideoStreamType.videoStreamHigh;
        bool optionsEncodedFrameOnly = true;
        VideoSubscriptionOptions options = VideoSubscriptionOptions(
          type: optionsType,
          encodedFrameOnly: optionsEncodedFrameOnly,
        );
        String connectionChannelId = "hello";
        int connectionLocalUid = 5;
        RtcConnection connection = RtcConnection(
          channelId: connectionChannelId,
          localUid: connectionLocalUid,
        );
        await rtcEngineEx.setRemoteVideoSubscriptionOptionsEx(
          uid: uid,
          options: options,
          connection: connection,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngineEx.setRemoteVideoSubscriptionOptionsEx] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngineEx.release();
    },
//  skip: !(),
  );

  testWidgets(
    'RtcEngineEx.setRemoteVoicePositionEx',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngineEx rtcEngineEx = createAgoraRtcEngineEx();
      await rtcEngineEx.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngineEx.setParameters('{"rtc.enable_debug_log": true}');

      try {
        int uid = 5;
        double pan = 5.0;
        double gain = 5.0;
        String connectionChannelId = "hello";
        int connectionLocalUid = 5;
        RtcConnection connection = RtcConnection(
          channelId: connectionChannelId,
          localUid: connectionLocalUid,
        );
        await rtcEngineEx.setRemoteVoicePositionEx(
          uid: uid,
          pan: pan,
          gain: gain,
          connection: connection,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngineEx.setRemoteVoicePositionEx] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngineEx.release();
    },
//  skip: !(),
  );

  testWidgets(
    'RtcEngineEx.setRemoteUserSpatialAudioParamsEx',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngineEx rtcEngineEx = createAgoraRtcEngineEx();
      await rtcEngineEx.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngineEx.setParameters('{"rtc.enable_debug_log": true}');

      try {
        int uid = 5;
        double paramsSpeakerAzimuth = 5.0;
        double paramsSpeakerElevation = 5.0;
        double paramsSpeakerDistance = 5.0;
        int paramsSpeakerOrientation = 5;
        bool paramsEnableBlur = true;
        bool paramsEnableAirAbsorb = true;
        double paramsSpeakerAttenuation = 5.0;
        bool paramsEnableDoppler = true;
        SpatialAudioParams params = SpatialAudioParams(
          speakerAzimuth: paramsSpeakerAzimuth,
          speakerElevation: paramsSpeakerElevation,
          speakerDistance: paramsSpeakerDistance,
          speakerOrientation: paramsSpeakerOrientation,
          enableBlur: paramsEnableBlur,
          enableAirAbsorb: paramsEnableAirAbsorb,
          speakerAttenuation: paramsSpeakerAttenuation,
          enableDoppler: paramsEnableDoppler,
        );
        String connectionChannelId = "hello";
        int connectionLocalUid = 5;
        RtcConnection connection = RtcConnection(
          channelId: connectionChannelId,
          localUid: connectionLocalUid,
        );
        await rtcEngineEx.setRemoteUserSpatialAudioParamsEx(
          uid: uid,
          params: params,
          connection: connection,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngineEx.setRemoteUserSpatialAudioParamsEx] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngineEx.release();
    },
//  skip: !(),
  );

  testWidgets(
    'RtcEngineEx.setRemoteRenderModeEx',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngineEx rtcEngineEx = createAgoraRtcEngineEx();
      await rtcEngineEx.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngineEx.setParameters('{"rtc.enable_debug_log": true}');

      try {
        int uid = 5;
        RenderModeType renderMode = RenderModeType.renderModeHidden;
        VideoMirrorModeType mirrorMode =
            VideoMirrorModeType.videoMirrorModeAuto;
        String connectionChannelId = "hello";
        int connectionLocalUid = 5;
        RtcConnection connection = RtcConnection(
          channelId: connectionChannelId,
          localUid: connectionLocalUid,
        );
        await rtcEngineEx.setRemoteRenderModeEx(
          uid: uid,
          renderMode: renderMode,
          mirrorMode: mirrorMode,
          connection: connection,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngineEx.setRemoteRenderModeEx] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngineEx.release();
    },
//  skip: !(),
  );

  testWidgets(
    'RtcEngineEx.enableLoopbackRecordingEx',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngineEx rtcEngineEx = createAgoraRtcEngineEx();
      await rtcEngineEx.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngineEx.setParameters('{"rtc.enable_debug_log": true}');

      try {
        String connectionChannelId = "hello";
        int connectionLocalUid = 5;
        RtcConnection connection = RtcConnection(
          channelId: connectionChannelId,
          localUid: connectionLocalUid,
        );
        bool enabled = true;
        String deviceName = "hello";
        await rtcEngineEx.enableLoopbackRecordingEx(
          connection: connection,
          enabled: enabled,
          deviceName: deviceName,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngineEx.enableLoopbackRecordingEx] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngineEx.release();
    },
//  skip: !(),
  );

  testWidgets(
    'RtcEngineEx.adjustRecordingSignalVolumeEx',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngineEx rtcEngineEx = createAgoraRtcEngineEx();
      await rtcEngineEx.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngineEx.setParameters('{"rtc.enable_debug_log": true}');

      try {
        int volume = 5;
        String connectionChannelId = "hello";
        int connectionLocalUid = 5;
        RtcConnection connection = RtcConnection(
          channelId: connectionChannelId,
          localUid: connectionLocalUid,
        );
        await rtcEngineEx.adjustRecordingSignalVolumeEx(
          volume: volume,
          connection: connection,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngineEx.adjustRecordingSignalVolumeEx] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngineEx.release();
    },
//  skip: !(),
  );

  testWidgets(
    'RtcEngineEx.muteRecordingSignalEx',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngineEx rtcEngineEx = createAgoraRtcEngineEx();
      await rtcEngineEx.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngineEx.setParameters('{"rtc.enable_debug_log": true}');

      try {
        bool mute = true;
        String connectionChannelId = "hello";
        int connectionLocalUid = 5;
        RtcConnection connection = RtcConnection(
          channelId: connectionChannelId,
          localUid: connectionLocalUid,
        );
        await rtcEngineEx.muteRecordingSignalEx(
          mute: mute,
          connection: connection,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngineEx.muteRecordingSignalEx] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngineEx.release();
    },
//  skip: !(),
  );

  testWidgets(
    'RtcEngineEx.adjustUserPlaybackSignalVolumeEx',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngineEx rtcEngineEx = createAgoraRtcEngineEx();
      await rtcEngineEx.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngineEx.setParameters('{"rtc.enable_debug_log": true}');

      try {
        int uid = 5;
        int volume = 5;
        String connectionChannelId = "hello";
        int connectionLocalUid = 5;
        RtcConnection connection = RtcConnection(
          channelId: connectionChannelId,
          localUid: connectionLocalUid,
        );
        await rtcEngineEx.adjustUserPlaybackSignalVolumeEx(
          uid: uid,
          volume: volume,
          connection: connection,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngineEx.adjustUserPlaybackSignalVolumeEx] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngineEx.release();
    },
//  skip: !(),
  );

  testWidgets(
    'RtcEngineEx.getConnectionStateEx',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngineEx rtcEngineEx = createAgoraRtcEngineEx();
      await rtcEngineEx.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngineEx.setParameters('{"rtc.enable_debug_log": true}');

      try {
        String connectionChannelId = "hello";
        int connectionLocalUid = 5;
        RtcConnection connection = RtcConnection(
          channelId: connectionChannelId,
          localUid: connectionLocalUid,
        );
        await rtcEngineEx.getConnectionStateEx(
          connection,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngineEx.getConnectionStateEx] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngineEx.release();
    },
//  skip: !(),
  );

  testWidgets(
    'RtcEngineEx.enableEncryptionEx',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngineEx rtcEngineEx = createAgoraRtcEngineEx();
      await rtcEngineEx.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngineEx.setParameters('{"rtc.enable_debug_log": true}');

      try {
        String connectionChannelId = "hello";
        int connectionLocalUid = 5;
        RtcConnection connection = RtcConnection(
          channelId: connectionChannelId,
          localUid: connectionLocalUid,
        );
        bool enabled = true;
        EncryptionMode configEncryptionMode = EncryptionMode.aes128Xts;
        String configEncryptionKey = "hello";
        Uint8List configEncryptionKdfSalt = Uint8List.fromList([1, 1, 1, 1, 1]);
        bool configDatastreamEncryptionEnabled = true;
        EncryptionConfig config = EncryptionConfig(
          encryptionMode: configEncryptionMode,
          encryptionKey: configEncryptionKey,
          encryptionKdfSalt: configEncryptionKdfSalt,
          datastreamEncryptionEnabled: configDatastreamEncryptionEnabled,
        );
        await rtcEngineEx.enableEncryptionEx(
          connection: connection,
          enabled: enabled,
          config: config,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngineEx.enableEncryptionEx] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngineEx.release();
    },
//  skip: !(),
  );

  testWidgets(
    'RtcEngineEx.sendStreamMessageEx',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngineEx rtcEngineEx = createAgoraRtcEngineEx();
      await rtcEngineEx.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngineEx.setParameters('{"rtc.enable_debug_log": true}');

      try {
        int streamId = 5;
        Uint8List data = Uint8List.fromList([1, 1, 1, 1, 1]);
        int length = 5;
        String connectionChannelId = "hello";
        int connectionLocalUid = 5;
        RtcConnection connection = RtcConnection(
          channelId: connectionChannelId,
          localUid: connectionLocalUid,
        );
        await rtcEngineEx.sendStreamMessageEx(
          streamId: streamId,
          data: data,
          length: length,
          connection: connection,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngineEx.sendStreamMessageEx] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngineEx.release();
    },
//  skip: !(),
  );

  testWidgets(
    'RtcEngineEx.addVideoWatermarkEx',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngineEx rtcEngineEx = createAgoraRtcEngineEx();
      await rtcEngineEx.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngineEx.setParameters('{"rtc.enable_debug_log": true}');

      try {
        String watermarkUrl = "hello";
        int positionInLandscapeModeX = 5;
        int positionInLandscapeModeY = 5;
        int positionInLandscapeModeWidth = 5;
        int positionInLandscapeModeHeight = 5;
        Rectangle optionsPositionInLandscapeMode = Rectangle(
          x: positionInLandscapeModeX,
          y: positionInLandscapeModeY,
          width: positionInLandscapeModeWidth,
          height: positionInLandscapeModeHeight,
        );
        int positionInPortraitModeX = 5;
        int positionInPortraitModeY = 5;
        int positionInPortraitModeWidth = 5;
        int positionInPortraitModeHeight = 5;
        Rectangle optionsPositionInPortraitMode = Rectangle(
          x: positionInPortraitModeX,
          y: positionInPortraitModeY,
          width: positionInPortraitModeWidth,
          height: positionInPortraitModeHeight,
        );
        double watermarkRatioXRatio = 5.0;
        double watermarkRatioYRatio = 5.0;
        double watermarkRatioWidthRatio = 5.0;
        WatermarkRatio optionsWatermarkRatio = WatermarkRatio(
          xRatio: watermarkRatioXRatio,
          yRatio: watermarkRatioYRatio,
          widthRatio: watermarkRatioWidthRatio,
        );
        WatermarkFitMode optionsMode = WatermarkFitMode.fitModeCoverPosition;
        bool optionsVisibleInPreview = true;
        WatermarkOptions options = WatermarkOptions(
          visibleInPreview: optionsVisibleInPreview,
          positionInLandscapeMode: optionsPositionInLandscapeMode,
          positionInPortraitMode: optionsPositionInPortraitMode,
          watermarkRatio: optionsWatermarkRatio,
          mode: optionsMode,
        );
        String connectionChannelId = "hello";
        int connectionLocalUid = 5;
        RtcConnection connection = RtcConnection(
          channelId: connectionChannelId,
          localUid: connectionLocalUid,
        );
        await rtcEngineEx.addVideoWatermarkEx(
          watermarkUrl: watermarkUrl,
          options: options,
          connection: connection,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngineEx.addVideoWatermarkEx] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngineEx.release();
    },
//  skip: !(),
  );

  testWidgets(
    'RtcEngineEx.clearVideoWatermarkEx',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngineEx rtcEngineEx = createAgoraRtcEngineEx();
      await rtcEngineEx.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngineEx.setParameters('{"rtc.enable_debug_log": true}');

      try {
        String connectionChannelId = "hello";
        int connectionLocalUid = 5;
        RtcConnection connection = RtcConnection(
          channelId: connectionChannelId,
          localUid: connectionLocalUid,
        );
        await rtcEngineEx.clearVideoWatermarkEx(
          connection,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngineEx.clearVideoWatermarkEx] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngineEx.release();
    },
//  skip: !(),
  );

  testWidgets(
    'RtcEngineEx.sendCustomReportMessageEx',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngineEx rtcEngineEx = createAgoraRtcEngineEx();
      await rtcEngineEx.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngineEx.setParameters('{"rtc.enable_debug_log": true}');

      try {
        String id = "hello";
        String category = "hello";
        String event = "hello";
        String label = "hello";
        int value = 5;
        String connectionChannelId = "hello";
        int connectionLocalUid = 5;
        RtcConnection connection = RtcConnection(
          channelId: connectionChannelId,
          localUid: connectionLocalUid,
        );
        await rtcEngineEx.sendCustomReportMessageEx(
          id: id,
          category: category,
          event: event,
          label: label,
          value: value,
          connection: connection,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngineEx.sendCustomReportMessageEx] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngineEx.release();
    },
//  skip: !(),
  );

  testWidgets(
    'RtcEngineEx.enableAudioVolumeIndicationEx',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngineEx rtcEngineEx = createAgoraRtcEngineEx();
      await rtcEngineEx.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngineEx.setParameters('{"rtc.enable_debug_log": true}');

      try {
        int interval = 5;
        int smooth = 5;
        bool reportVad = true;
        String connectionChannelId = "hello";
        int connectionLocalUid = 5;
        RtcConnection connection = RtcConnection(
          channelId: connectionChannelId,
          localUid: connectionLocalUid,
        );
        await rtcEngineEx.enableAudioVolumeIndicationEx(
          interval: interval,
          smooth: smooth,
          reportVad: reportVad,
          connection: connection,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngineEx.enableAudioVolumeIndicationEx] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngineEx.release();
    },
//  skip: !(),
  );

  testWidgets(
    'RtcEngineEx.startRtmpStreamWithoutTranscodingEx',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngineEx rtcEngineEx = createAgoraRtcEngineEx();
      await rtcEngineEx.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngineEx.setParameters('{"rtc.enable_debug_log": true}');

      try {
        String url = "hello";
        String connectionChannelId = "hello";
        int connectionLocalUid = 5;
        RtcConnection connection = RtcConnection(
          channelId: connectionChannelId,
          localUid: connectionLocalUid,
        );
        await rtcEngineEx.startRtmpStreamWithoutTranscodingEx(
          url: url,
          connection: connection,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngineEx.startRtmpStreamWithoutTranscodingEx] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngineEx.release();
    },
//  skip: !(),
  );

  testWidgets(
    'RtcEngineEx.startRtmpStreamWithTranscodingEx',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngineEx rtcEngineEx = createAgoraRtcEngineEx();
      await rtcEngineEx.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngineEx.setParameters('{"rtc.enable_debug_log": true}');

      try {
        String url = "hello";
        VideoCodecProfileType transcodingVideoCodecProfile =
            VideoCodecProfileType.videoCodecProfileBaseline;
        VideoCodecTypeForStream transcodingVideoCodecType =
            VideoCodecTypeForStream.videoCodecH264ForStream;
        AudioSampleRateType transcodingAudioSampleRate =
            AudioSampleRateType.audioSampleRate32000;
        AudioCodecProfileType transcodingAudioCodecProfile =
            AudioCodecProfileType.audioCodecProfileLcAac;
        int transcodingWidth = 5;
        int transcodingHeight = 5;
        int transcodingVideoBitrate = 5;
        int transcodingVideoFramerate = 5;
        bool transcodingLowLatency = true;
        int transcodingVideoGop = 5;
        int transcodingBackgroundColor = 5;
        int transcodingUserCount = 5;
        List<TranscodingUser> transcodingTranscodingUsers = [];
        String transcodingTranscodingExtraInfo = "hello";
        String transcodingMetadata = "hello";
        List<RtcImage> transcodingWatermark = [];
        int transcodingWatermarkCount = 5;
        List<RtcImage> transcodingBackgroundImage = [];
        int transcodingBackgroundImageCount = 5;
        int transcodingAudioBitrate = 5;
        int transcodingAudioChannels = 5;
        List<LiveStreamAdvancedFeature> transcodingAdvancedFeatures = [];
        int transcodingAdvancedFeatureCount = 5;
        LiveTranscoding transcoding = LiveTranscoding(
          width: transcodingWidth,
          height: transcodingHeight,
          videoBitrate: transcodingVideoBitrate,
          videoFramerate: transcodingVideoFramerate,
          lowLatency: transcodingLowLatency,
          videoGop: transcodingVideoGop,
          videoCodecProfile: transcodingVideoCodecProfile,
          backgroundColor: transcodingBackgroundColor,
          videoCodecType: transcodingVideoCodecType,
          userCount: transcodingUserCount,
          transcodingUsers: transcodingTranscodingUsers,
          transcodingExtraInfo: transcodingTranscodingExtraInfo,
          metadata: transcodingMetadata,
          watermark: transcodingWatermark,
          watermarkCount: transcodingWatermarkCount,
          backgroundImage: transcodingBackgroundImage,
          backgroundImageCount: transcodingBackgroundImageCount,
          audioSampleRate: transcodingAudioSampleRate,
          audioBitrate: transcodingAudioBitrate,
          audioChannels: transcodingAudioChannels,
          audioCodecProfile: transcodingAudioCodecProfile,
          advancedFeatures: transcodingAdvancedFeatures,
          advancedFeatureCount: transcodingAdvancedFeatureCount,
        );
        String connectionChannelId = "hello";
        int connectionLocalUid = 5;
        RtcConnection connection = RtcConnection(
          channelId: connectionChannelId,
          localUid: connectionLocalUid,
        );
        await rtcEngineEx.startRtmpStreamWithTranscodingEx(
          url: url,
          transcoding: transcoding,
          connection: connection,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngineEx.startRtmpStreamWithTranscodingEx] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngineEx.release();
    },
//  skip: !(),
  );

  testWidgets(
    'RtcEngineEx.updateRtmpTranscodingEx',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngineEx rtcEngineEx = createAgoraRtcEngineEx();
      await rtcEngineEx.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngineEx.setParameters('{"rtc.enable_debug_log": true}');

      try {
        VideoCodecProfileType transcodingVideoCodecProfile =
            VideoCodecProfileType.videoCodecProfileBaseline;
        VideoCodecTypeForStream transcodingVideoCodecType =
            VideoCodecTypeForStream.videoCodecH264ForStream;
        AudioSampleRateType transcodingAudioSampleRate =
            AudioSampleRateType.audioSampleRate32000;
        AudioCodecProfileType transcodingAudioCodecProfile =
            AudioCodecProfileType.audioCodecProfileLcAac;
        int transcodingWidth = 5;
        int transcodingHeight = 5;
        int transcodingVideoBitrate = 5;
        int transcodingVideoFramerate = 5;
        bool transcodingLowLatency = true;
        int transcodingVideoGop = 5;
        int transcodingBackgroundColor = 5;
        int transcodingUserCount = 5;
        List<TranscodingUser> transcodingTranscodingUsers = [];
        String transcodingTranscodingExtraInfo = "hello";
        String transcodingMetadata = "hello";
        List<RtcImage> transcodingWatermark = [];
        int transcodingWatermarkCount = 5;
        List<RtcImage> transcodingBackgroundImage = [];
        int transcodingBackgroundImageCount = 5;
        int transcodingAudioBitrate = 5;
        int transcodingAudioChannels = 5;
        List<LiveStreamAdvancedFeature> transcodingAdvancedFeatures = [];
        int transcodingAdvancedFeatureCount = 5;
        LiveTranscoding transcoding = LiveTranscoding(
          width: transcodingWidth,
          height: transcodingHeight,
          videoBitrate: transcodingVideoBitrate,
          videoFramerate: transcodingVideoFramerate,
          lowLatency: transcodingLowLatency,
          videoGop: transcodingVideoGop,
          videoCodecProfile: transcodingVideoCodecProfile,
          backgroundColor: transcodingBackgroundColor,
          videoCodecType: transcodingVideoCodecType,
          userCount: transcodingUserCount,
          transcodingUsers: transcodingTranscodingUsers,
          transcodingExtraInfo: transcodingTranscodingExtraInfo,
          metadata: transcodingMetadata,
          watermark: transcodingWatermark,
          watermarkCount: transcodingWatermarkCount,
          backgroundImage: transcodingBackgroundImage,
          backgroundImageCount: transcodingBackgroundImageCount,
          audioSampleRate: transcodingAudioSampleRate,
          audioBitrate: transcodingAudioBitrate,
          audioChannels: transcodingAudioChannels,
          audioCodecProfile: transcodingAudioCodecProfile,
          advancedFeatures: transcodingAdvancedFeatures,
          advancedFeatureCount: transcodingAdvancedFeatureCount,
        );
        String connectionChannelId = "hello";
        int connectionLocalUid = 5;
        RtcConnection connection = RtcConnection(
          channelId: connectionChannelId,
          localUid: connectionLocalUid,
        );
        await rtcEngineEx.updateRtmpTranscodingEx(
          transcoding: transcoding,
          connection: connection,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngineEx.updateRtmpTranscodingEx] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngineEx.release();
    },
//  skip: !(),
  );

  testWidgets(
    'RtcEngineEx.stopRtmpStreamEx',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngineEx rtcEngineEx = createAgoraRtcEngineEx();
      await rtcEngineEx.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngineEx.setParameters('{"rtc.enable_debug_log": true}');

      try {
        String url = "hello";
        String connectionChannelId = "hello";
        int connectionLocalUid = 5;
        RtcConnection connection = RtcConnection(
          channelId: connectionChannelId,
          localUid: connectionLocalUid,
        );
        await rtcEngineEx.stopRtmpStreamEx(
          url: url,
          connection: connection,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngineEx.stopRtmpStreamEx] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngineEx.release();
    },
//  skip: !(),
  );

  testWidgets(
    'RtcEngineEx.stopChannelMediaRelayEx',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngineEx rtcEngineEx = createAgoraRtcEngineEx();
      await rtcEngineEx.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngineEx.setParameters('{"rtc.enable_debug_log": true}');

      try {
        String connectionChannelId = "hello";
        int connectionLocalUid = 5;
        RtcConnection connection = RtcConnection(
          channelId: connectionChannelId,
          localUid: connectionLocalUid,
        );
        await rtcEngineEx.stopChannelMediaRelayEx(
          connection,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngineEx.stopChannelMediaRelayEx] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngineEx.release();
    },
//  skip: !(),
  );

  testWidgets(
    'RtcEngineEx.pauseAllChannelMediaRelayEx',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngineEx rtcEngineEx = createAgoraRtcEngineEx();
      await rtcEngineEx.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngineEx.setParameters('{"rtc.enable_debug_log": true}');

      try {
        String connectionChannelId = "hello";
        int connectionLocalUid = 5;
        RtcConnection connection = RtcConnection(
          channelId: connectionChannelId,
          localUid: connectionLocalUid,
        );
        await rtcEngineEx.pauseAllChannelMediaRelayEx(
          connection,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngineEx.pauseAllChannelMediaRelayEx] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngineEx.release();
    },
//  skip: !(),
  );

  testWidgets(
    'RtcEngineEx.resumeAllChannelMediaRelayEx',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngineEx rtcEngineEx = createAgoraRtcEngineEx();
      await rtcEngineEx.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngineEx.setParameters('{"rtc.enable_debug_log": true}');

      try {
        String connectionChannelId = "hello";
        int connectionLocalUid = 5;
        RtcConnection connection = RtcConnection(
          channelId: connectionChannelId,
          localUid: connectionLocalUid,
        );
        await rtcEngineEx.resumeAllChannelMediaRelayEx(
          connection,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngineEx.resumeAllChannelMediaRelayEx] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngineEx.release();
    },
//  skip: !(),
  );

  testWidgets(
    'RtcEngineEx.getUserInfoByUserAccountEx',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngineEx rtcEngineEx = createAgoraRtcEngineEx();
      await rtcEngineEx.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngineEx.setParameters('{"rtc.enable_debug_log": true}');

      try {
        String userAccount = "hello";
        String connectionChannelId = "hello";
        int connectionLocalUid = 5;
        RtcConnection connection = RtcConnection(
          channelId: connectionChannelId,
          localUid: connectionLocalUid,
        );
        await rtcEngineEx.getUserInfoByUserAccountEx(
          userAccount: userAccount,
          connection: connection,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngineEx.getUserInfoByUserAccountEx] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngineEx.release();
    },
//  skip: !(),
  );

  testWidgets(
    'RtcEngineEx.getUserInfoByUidEx',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngineEx rtcEngineEx = createAgoraRtcEngineEx();
      await rtcEngineEx.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngineEx.setParameters('{"rtc.enable_debug_log": true}');

      try {
        int uid = 5;
        String connectionChannelId = "hello";
        int connectionLocalUid = 5;
        RtcConnection connection = RtcConnection(
          channelId: connectionChannelId,
          localUid: connectionLocalUid,
        );
        await rtcEngineEx.getUserInfoByUidEx(
          uid: uid,
          connection: connection,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngineEx.getUserInfoByUidEx] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngineEx.release();
    },
//  skip: !(),
  );

  testWidgets(
    'RtcEngineEx.enableDualStreamModeEx',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngineEx rtcEngineEx = createAgoraRtcEngineEx();
      await rtcEngineEx.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngineEx.setParameters('{"rtc.enable_debug_log": true}');

      try {
        bool enabled = true;
        int dimensionsWidth = 5;
        int dimensionsHeight = 5;
        VideoDimensions streamConfigDimensions = VideoDimensions(
          width: dimensionsWidth,
          height: dimensionsHeight,
        );
        int streamConfigKBitrate = 5;
        int streamConfigFramerate = 5;
        SimulcastStreamConfig streamConfig = SimulcastStreamConfig(
          dimensions: streamConfigDimensions,
          kBitrate: streamConfigKBitrate,
          framerate: streamConfigFramerate,
        );
        String connectionChannelId = "hello";
        int connectionLocalUid = 5;
        RtcConnection connection = RtcConnection(
          channelId: connectionChannelId,
          localUid: connectionLocalUid,
        );
        await rtcEngineEx.enableDualStreamModeEx(
          enabled: enabled,
          streamConfig: streamConfig,
          connection: connection,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngineEx.enableDualStreamModeEx] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngineEx.release();
    },
//  skip: !(),
  );

  testWidgets(
    'RtcEngineEx.setDualStreamModeEx',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngineEx rtcEngineEx = createAgoraRtcEngineEx();
      await rtcEngineEx.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngineEx.setParameters('{"rtc.enable_debug_log": true}');

      try {
        SimulcastStreamMode mode = SimulcastStreamMode.autoSimulcastStream;
        int dimensionsWidth = 5;
        int dimensionsHeight = 5;
        VideoDimensions streamConfigDimensions = VideoDimensions(
          width: dimensionsWidth,
          height: dimensionsHeight,
        );
        int streamConfigKBitrate = 5;
        int streamConfigFramerate = 5;
        SimulcastStreamConfig streamConfig = SimulcastStreamConfig(
          dimensions: streamConfigDimensions,
          kBitrate: streamConfigKBitrate,
          framerate: streamConfigFramerate,
        );
        String connectionChannelId = "hello";
        int connectionLocalUid = 5;
        RtcConnection connection = RtcConnection(
          channelId: connectionChannelId,
          localUid: connectionLocalUid,
        );
        await rtcEngineEx.setDualStreamModeEx(
          mode: mode,
          streamConfig: streamConfig,
          connection: connection,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngineEx.setDualStreamModeEx] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngineEx.release();
    },
//  skip: !(),
  );

  testWidgets(
    'RtcEngineEx.setSimulcastConfigEx',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngineEx rtcEngineEx = createAgoraRtcEngineEx();
      await rtcEngineEx.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngineEx.setParameters('{"rtc.enable_debug_log": true}');

      try {
        List<StreamLayerConfig> simulcastConfigConfigs = [];
        SimulcastConfig simulcastConfig = SimulcastConfig(
          configs: simulcastConfigConfigs,
        );
        String connectionChannelId = "hello";
        int connectionLocalUid = 5;
        RtcConnection connection = RtcConnection(
          channelId: connectionChannelId,
          localUid: connectionLocalUid,
        );
        await rtcEngineEx.setSimulcastConfigEx(
          simulcastConfig: simulcastConfig,
          connection: connection,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngineEx.setSimulcastConfigEx] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngineEx.release();
    },
//  skip: !(),
  );

  testWidgets(
    'RtcEngineEx.takeSnapshotEx',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngineEx rtcEngineEx = createAgoraRtcEngineEx();
      await rtcEngineEx.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngineEx.setParameters('{"rtc.enable_debug_log": true}');

      try {
        String connectionChannelId = "hello";
        int connectionLocalUid = 5;
        RtcConnection connection = RtcConnection(
          channelId: connectionChannelId,
          localUid: connectionLocalUid,
        );
        int uid = 5;
        String filePath = "hello";
        await rtcEngineEx.takeSnapshotEx(
          connection: connection,
          uid: uid,
          filePath: filePath,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngineEx.takeSnapshotEx] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngineEx.release();
    },
//  skip: !(),
  );

  testWidgets(
    'RtcEngineEx.enableContentInspectEx',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngineEx rtcEngineEx = createAgoraRtcEngineEx();
      await rtcEngineEx.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngineEx.setParameters('{"rtc.enable_debug_log": true}');

      try {
        bool enabled = true;
        String configExtraInfo = "hello";
        String configServerConfig = "hello";
        List<ContentInspectModule> configModules = [];
        int configModuleCount = 5;
        ContentInspectConfig config = ContentInspectConfig(
          extraInfo: configExtraInfo,
          serverConfig: configServerConfig,
          modules: configModules,
          moduleCount: configModuleCount,
        );
        String connectionChannelId = "hello";
        int connectionLocalUid = 5;
        RtcConnection connection = RtcConnection(
          channelId: connectionChannelId,
          localUid: connectionLocalUid,
        );
        await rtcEngineEx.enableContentInspectEx(
          enabled: enabled,
          config: config,
          connection: connection,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngineEx.enableContentInspectEx] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngineEx.release();
    },
//  skip: !(),
  );

  testWidgets(
    'RtcEngineEx.startMediaRenderingTracingEx',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngineEx rtcEngineEx = createAgoraRtcEngineEx();
      await rtcEngineEx.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngineEx.setParameters('{"rtc.enable_debug_log": true}');

      try {
        String connectionChannelId = "hello";
        int connectionLocalUid = 5;
        RtcConnection connection = RtcConnection(
          channelId: connectionChannelId,
          localUid: connectionLocalUid,
        );
        await rtcEngineEx.startMediaRenderingTracingEx(
          connection,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngineEx.startMediaRenderingTracingEx] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngineEx.release();
    },
//  skip: !(),
  );

  testWidgets(
    'RtcEngineEx.setParametersEx',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngineEx rtcEngineEx = createAgoraRtcEngineEx();
      await rtcEngineEx.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngineEx.setParameters('{"rtc.enable_debug_log": true}');

      try {
        String connectionChannelId = "hello";
        int connectionLocalUid = 5;
        RtcConnection connection = RtcConnection(
          channelId: connectionChannelId,
          localUid: connectionLocalUid,
        );
        String parameters = "hello";
        await rtcEngineEx.setParametersEx(
          connection: connection,
          parameters: parameters,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngineEx.setParametersEx] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngineEx.release();
    },
//  skip: !(),
  );

  testWidgets(
    'RtcEngineEx.getCallIdEx',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngineEx rtcEngineEx = createAgoraRtcEngineEx();
      await rtcEngineEx.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngineEx.setParameters('{"rtc.enable_debug_log": true}');

      try {
        String connectionChannelId = "hello";
        int connectionLocalUid = 5;
        RtcConnection connection = RtcConnection(
          channelId: connectionChannelId,
          localUid: connectionLocalUid,
        );
        await rtcEngineEx.getCallIdEx(
          connection,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngineEx.getCallIdEx] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngineEx.release();
    },
//  skip: !(),
  );

  testWidgets(
    'RtcEngineEx.sendAudioMetadataEx',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngineEx rtcEngineEx = createAgoraRtcEngineEx();
      await rtcEngineEx.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngineEx.setParameters('{"rtc.enable_debug_log": true}');

      try {
        String connectionChannelId = "hello";
        int connectionLocalUid = 5;
        RtcConnection connection = RtcConnection(
          channelId: connectionChannelId,
          localUid: connectionLocalUid,
        );
        Uint8List metadata = Uint8List.fromList([1, 1, 1, 1, 1]);
        int length = 5;
        await rtcEngineEx.sendAudioMetadataEx(
          connection: connection,
          metadata: metadata,
          length: length,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngineEx.sendAudioMetadataEx] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngineEx.release();
    },
//  skip: !(),
  );

  testWidgets(
    'RtcEngineEx.takeSnapshotWithConfigEx',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngineEx rtcEngineEx = createAgoraRtcEngineEx();
      await rtcEngineEx.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngineEx.setParameters('{"rtc.enable_debug_log": true}');

      try {
        String connectionChannelId = "hello";
        int connectionLocalUid = 5;
        RtcConnection connection = RtcConnection(
          channelId: connectionChannelId,
          localUid: connectionLocalUid,
        );
        int uid = 5;
        VideoModulePosition configPosition =
            VideoModulePosition.positionPostCapturer;
        String configFilePath = "hello";
        SnapshotConfig config = SnapshotConfig(
          filePath: configFilePath,
          position: configPosition,
        );
        await rtcEngineEx.takeSnapshotWithConfigEx(
          connection: connection,
          uid: uid,
          config: config,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngineEx.takeSnapshotWithConfigEx] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngineEx.release();
    },
//  skip: !(),
  );
}
