/// GENERATED BY testcase_gen. DO NOT MODIFY BY HAND.

// ignore_for_file: deprecated_member_use,constant_identifier_names

import 'dart:async';
import 'dart:typed_data';

import 'package:agora_rtc_engine/agora_rtc_engine.dart';
import 'package:flutter/foundation.dart';
import 'package:flutter_test/flutter_test.dart';
import 'package:iris_tester/iris_tester.dart';
import 'package:iris_method_channel/iris_method_channel.dart';

import '../testcases/event_ids_mapping.dart';

void generatedTestCases(ValueGetter<IrisTester> irisTester) {
  testWidgets(
    'MetadataObserver.onMetadataReceived',
    (WidgetTester tester) async {
      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: 'app_id',
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      final onMetadataReceivedCompleter = Completer<bool>();
      final theMetadataObserver = MetadataObserver(
        onMetadataReceived: (Metadata metadata) {
          onMetadataReceivedCompleter.complete(true);
        },
      );

      MetadataType type = MetadataType.unknownMetadata;

      rtcEngine.registerMediaMetadataObserver(
        observer: theMetadataObserver,
        type: type,
      );

// Delay 500 milliseconds to ensure the registerMediaMetadataObserver call completed.
      await Future.delayed(const Duration(milliseconds: 500));

      {
        String metadataChannelId = "hello";
        int metadataUid = 5;
        int metadataSize = 5;
        Uint8List metadataBuffer = Uint8List.fromList([1, 1, 1, 1, 1]);
        int metadataTimeStampMs = 5;
        Metadata metadata = Metadata(
          channelId: metadataChannelId,
          uid: metadataUid,
          size: metadataSize,
          buffer: metadataBuffer,
          timeStampMs: metadataTimeStampMs,
        );

        final eventJson = {
          'metadata': metadata.toJson(),
        };

        final eventIds =
            eventIdsMapping['MetadataObserver_onMetadataReceived'] ?? [];
        for (final event in eventIds) {
          final ret = irisTester().fireEvent(event, params: eventJson);
          // Delay 200 milliseconds to ensure the callback is called.
          await Future.delayed(const Duration(milliseconds: 200));
          // TODO(littlegnal): Most of callbacks on web are not implemented, we're temporarily skip these callbacks at this time.
          if (kIsWeb && ret) {
            if (!onMetadataReceivedCompleter.isCompleted) {
              onMetadataReceivedCompleter.complete(true);
            }
          }
        }
      }

      final eventCalled = await onMetadataReceivedCompleter.future;
      expect(eventCalled, isTrue);

      {
        MetadataType type = MetadataType.unknownMetadata;

        rtcEngine.unregisterMediaMetadataObserver(
          observer: theMetadataObserver,
          type: type,
        );
      }
// Delay 500 milliseconds to ensure the unregisterMediaMetadataObserver call completed.
      await Future.delayed(const Duration(milliseconds: 500));

      await rtcEngine.release();
    },
    timeout: const Timeout(Duration(minutes: 2)),
  );
}
