/// GENERATED BY testcase_gen. DO NOT MODIFY BY HAND.

// ignore_for_file: deprecated_member_use,constant_identifier_names

import 'package:agora_rtc_engine/agora_rtc_engine.dart';
import 'package:flutter_test/flutter_test.dart';
import 'dart:typed_data';
import 'package:flutter/foundation.dart';
import 'package:fake_test_app/main.dart' as app;
import 'package:iris_tester/iris_tester.dart';
import 'package:iris_method_channel/iris_method_channel.dart';

void rtcEngineSmokeTestCases() {
  testWidgets(
    'RtcEngine.initialize',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        ChannelProfileType contextChannelProfile =
            ChannelProfileType.channelProfileCommunication;
        AudioScenarioType contextAudioScenario =
            AudioScenarioType.audioScenarioDefault;
        LogLevel logConfigLevel = LogLevel.logLevelNone;
        String logConfigFilePath = "hello";
        int logConfigFileSizeInKB = 5;
        LogConfig contextLogConfig = LogConfig(
          filePath: logConfigFilePath,
          fileSizeInKB: logConfigFileSizeInKB,
          level: logConfigLevel,
        );
        ThreadPriorityType contextThreadPriority = ThreadPriorityType.lowest;
        String contextAppId = "hello";
        String contextLicense = "hello";
        int contextAreaCode = 5;
        bool contextUseExternalEglContext = true;
        bool contextDomainLimit = true;
        bool contextAutoRegisterAgoraExtensions = true;
        RtcEngineContext context = RtcEngineContext(
          appId: contextAppId,
          channelProfile: contextChannelProfile,
          license: contextLicense,
          audioScenario: contextAudioScenario,
          areaCode: contextAreaCode,
          logConfig: contextLogConfig,
          threadPriority: contextThreadPriority,
          useExternalEglContext: contextUseExternalEglContext,
          domainLimit: contextDomainLimit,
          autoRegisterAgoraExtensions: contextAutoRegisterAgoraExtensions,
        );
        await rtcEngine.initialize(
          context,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.initialize] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.getVersion',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        await rtcEngine.getVersion();
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.getVersion] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.getErrorDescription',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        int code = 5;
        await rtcEngine.getErrorDescription(
          code,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.getErrorDescription] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.queryDeviceScore',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        await rtcEngine.queryDeviceScore();
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.queryDeviceScore] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.preloadChannel',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        String token = "hello";
        String channelId = "hello";
        int uid = 5;
        await rtcEngine.preloadChannel(
          token: token,
          channelId: channelId,
          uid: uid,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.preloadChannel] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.preloadChannelWithUserAccount',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        String token = "hello";
        String channelId = "hello";
        String userAccount = "hello";
        await rtcEngine.preloadChannelWithUserAccount(
          token: token,
          channelId: channelId,
          userAccount: userAccount,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.preloadChannelWithUserAccount] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.updatePreloadChannelToken',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        String token = "hello";
        await rtcEngine.updatePreloadChannelToken(
          token,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.updatePreloadChannelToken] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.joinChannel',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        String token = "hello";
        String channelId = "hello";
        int uid = 5;
        ClientRoleType optionsClientRoleType =
            ClientRoleType.clientRoleBroadcaster;
        AudienceLatencyLevelType optionsAudienceLatencyLevel =
            AudienceLatencyLevelType.audienceLatencyLevelLowLatency;
        VideoStreamType optionsDefaultVideoStreamType =
            VideoStreamType.videoStreamHigh;
        ChannelProfileType optionsChannelProfile =
            ChannelProfileType.channelProfileCommunication;
        bool optionsPublishCameraTrack = true;
        bool optionsPublishSecondaryCameraTrack = true;
        bool optionsPublishThirdCameraTrack = true;
        bool optionsPublishFourthCameraTrack = true;
        bool optionsPublishMicrophoneTrack = true;
        bool optionsPublishScreenCaptureVideo = true;
        bool optionsPublishScreenCaptureAudio = true;
        bool optionsPublishScreenTrack = true;
        bool optionsPublishSecondaryScreenTrack = true;
        bool optionsPublishThirdScreenTrack = true;
        bool optionsPublishFourthScreenTrack = true;
        bool optionsPublishCustomAudioTrack = true;
        int optionsPublishCustomAudioTrackId = 5;
        bool optionsPublishCustomVideoTrack = true;
        bool optionsPublishEncodedVideoTrack = true;
        bool optionsPublishMediaPlayerAudioTrack = true;
        bool optionsPublishMediaPlayerVideoTrack = true;
        bool optionsPublishTranscodedVideoTrack = true;
        bool optionsPublishMixedAudioTrack = true;
        bool optionsPublishLipSyncTrack = true;
        bool optionsAutoSubscribeAudio = true;
        bool optionsAutoSubscribeVideo = true;
        bool optionsEnableAudioRecordingOrPlayout = true;
        int optionsPublishMediaPlayerId = 5;
        int optionsAudioDelayMs = 5;
        int optionsMediaPlayerAudioDelayMs = 5;
        String optionsToken = "hello";
        bool optionsEnableBuiltInMediaEncryption = true;
        bool optionsPublishRhythmPlayerTrack = true;
        bool optionsIsInteractiveAudience = true;
        int optionsCustomVideoTrackId = 5;
        bool optionsIsAudioFilterable = true;
        String optionsParameters = "hello";
        ChannelMediaOptions options = ChannelMediaOptions(
          publishCameraTrack: optionsPublishCameraTrack,
          publishSecondaryCameraTrack: optionsPublishSecondaryCameraTrack,
          publishThirdCameraTrack: optionsPublishThirdCameraTrack,
          publishFourthCameraTrack: optionsPublishFourthCameraTrack,
          publishMicrophoneTrack: optionsPublishMicrophoneTrack,
          publishScreenCaptureVideo: optionsPublishScreenCaptureVideo,
          publishScreenCaptureAudio: optionsPublishScreenCaptureAudio,
          publishScreenTrack: optionsPublishScreenTrack,
          publishSecondaryScreenTrack: optionsPublishSecondaryScreenTrack,
          publishThirdScreenTrack: optionsPublishThirdScreenTrack,
          publishFourthScreenTrack: optionsPublishFourthScreenTrack,
          publishCustomAudioTrack: optionsPublishCustomAudioTrack,
          publishCustomAudioTrackId: optionsPublishCustomAudioTrackId,
          publishCustomVideoTrack: optionsPublishCustomVideoTrack,
          publishEncodedVideoTrack: optionsPublishEncodedVideoTrack,
          publishMediaPlayerAudioTrack: optionsPublishMediaPlayerAudioTrack,
          publishMediaPlayerVideoTrack: optionsPublishMediaPlayerVideoTrack,
          publishTranscodedVideoTrack: optionsPublishTranscodedVideoTrack,
          publishMixedAudioTrack: optionsPublishMixedAudioTrack,
          publishLipSyncTrack: optionsPublishLipSyncTrack,
          autoSubscribeAudio: optionsAutoSubscribeAudio,
          autoSubscribeVideo: optionsAutoSubscribeVideo,
          enableAudioRecordingOrPlayout: optionsEnableAudioRecordingOrPlayout,
          publishMediaPlayerId: optionsPublishMediaPlayerId,
          clientRoleType: optionsClientRoleType,
          audienceLatencyLevel: optionsAudienceLatencyLevel,
          defaultVideoStreamType: optionsDefaultVideoStreamType,
          channelProfile: optionsChannelProfile,
          audioDelayMs: optionsAudioDelayMs,
          mediaPlayerAudioDelayMs: optionsMediaPlayerAudioDelayMs,
          token: optionsToken,
          enableBuiltInMediaEncryption: optionsEnableBuiltInMediaEncryption,
          publishRhythmPlayerTrack: optionsPublishRhythmPlayerTrack,
          isInteractiveAudience: optionsIsInteractiveAudience,
          customVideoTrackId: optionsCustomVideoTrackId,
          isAudioFilterable: optionsIsAudioFilterable,
          parameters: optionsParameters,
        );
        await rtcEngine.joinChannel(
          token: token,
          channelId: channelId,
          uid: uid,
          options: options,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.joinChannel] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.updateChannelMediaOptions',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        ClientRoleType optionsClientRoleType =
            ClientRoleType.clientRoleBroadcaster;
        AudienceLatencyLevelType optionsAudienceLatencyLevel =
            AudienceLatencyLevelType.audienceLatencyLevelLowLatency;
        VideoStreamType optionsDefaultVideoStreamType =
            VideoStreamType.videoStreamHigh;
        ChannelProfileType optionsChannelProfile =
            ChannelProfileType.channelProfileCommunication;
        bool optionsPublishCameraTrack = true;
        bool optionsPublishSecondaryCameraTrack = true;
        bool optionsPublishThirdCameraTrack = true;
        bool optionsPublishFourthCameraTrack = true;
        bool optionsPublishMicrophoneTrack = true;
        bool optionsPublishScreenCaptureVideo = true;
        bool optionsPublishScreenCaptureAudio = true;
        bool optionsPublishScreenTrack = true;
        bool optionsPublishSecondaryScreenTrack = true;
        bool optionsPublishThirdScreenTrack = true;
        bool optionsPublishFourthScreenTrack = true;
        bool optionsPublishCustomAudioTrack = true;
        int optionsPublishCustomAudioTrackId = 5;
        bool optionsPublishCustomVideoTrack = true;
        bool optionsPublishEncodedVideoTrack = true;
        bool optionsPublishMediaPlayerAudioTrack = true;
        bool optionsPublishMediaPlayerVideoTrack = true;
        bool optionsPublishTranscodedVideoTrack = true;
        bool optionsPublishMixedAudioTrack = true;
        bool optionsPublishLipSyncTrack = true;
        bool optionsAutoSubscribeAudio = true;
        bool optionsAutoSubscribeVideo = true;
        bool optionsEnableAudioRecordingOrPlayout = true;
        int optionsPublishMediaPlayerId = 5;
        int optionsAudioDelayMs = 5;
        int optionsMediaPlayerAudioDelayMs = 5;
        String optionsToken = "hello";
        bool optionsEnableBuiltInMediaEncryption = true;
        bool optionsPublishRhythmPlayerTrack = true;
        bool optionsIsInteractiveAudience = true;
        int optionsCustomVideoTrackId = 5;
        bool optionsIsAudioFilterable = true;
        String optionsParameters = "hello";
        ChannelMediaOptions options = ChannelMediaOptions(
          publishCameraTrack: optionsPublishCameraTrack,
          publishSecondaryCameraTrack: optionsPublishSecondaryCameraTrack,
          publishThirdCameraTrack: optionsPublishThirdCameraTrack,
          publishFourthCameraTrack: optionsPublishFourthCameraTrack,
          publishMicrophoneTrack: optionsPublishMicrophoneTrack,
          publishScreenCaptureVideo: optionsPublishScreenCaptureVideo,
          publishScreenCaptureAudio: optionsPublishScreenCaptureAudio,
          publishScreenTrack: optionsPublishScreenTrack,
          publishSecondaryScreenTrack: optionsPublishSecondaryScreenTrack,
          publishThirdScreenTrack: optionsPublishThirdScreenTrack,
          publishFourthScreenTrack: optionsPublishFourthScreenTrack,
          publishCustomAudioTrack: optionsPublishCustomAudioTrack,
          publishCustomAudioTrackId: optionsPublishCustomAudioTrackId,
          publishCustomVideoTrack: optionsPublishCustomVideoTrack,
          publishEncodedVideoTrack: optionsPublishEncodedVideoTrack,
          publishMediaPlayerAudioTrack: optionsPublishMediaPlayerAudioTrack,
          publishMediaPlayerVideoTrack: optionsPublishMediaPlayerVideoTrack,
          publishTranscodedVideoTrack: optionsPublishTranscodedVideoTrack,
          publishMixedAudioTrack: optionsPublishMixedAudioTrack,
          publishLipSyncTrack: optionsPublishLipSyncTrack,
          autoSubscribeAudio: optionsAutoSubscribeAudio,
          autoSubscribeVideo: optionsAutoSubscribeVideo,
          enableAudioRecordingOrPlayout: optionsEnableAudioRecordingOrPlayout,
          publishMediaPlayerId: optionsPublishMediaPlayerId,
          clientRoleType: optionsClientRoleType,
          audienceLatencyLevel: optionsAudienceLatencyLevel,
          defaultVideoStreamType: optionsDefaultVideoStreamType,
          channelProfile: optionsChannelProfile,
          audioDelayMs: optionsAudioDelayMs,
          mediaPlayerAudioDelayMs: optionsMediaPlayerAudioDelayMs,
          token: optionsToken,
          enableBuiltInMediaEncryption: optionsEnableBuiltInMediaEncryption,
          publishRhythmPlayerTrack: optionsPublishRhythmPlayerTrack,
          isInteractiveAudience: optionsIsInteractiveAudience,
          customVideoTrackId: optionsCustomVideoTrackId,
          isAudioFilterable: optionsIsAudioFilterable,
          parameters: optionsParameters,
        );
        await rtcEngine.updateChannelMediaOptions(
          options,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.updateChannelMediaOptions] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.leaveChannel',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        bool optionsStopAudioMixing = true;
        bool optionsStopAllEffect = true;
        bool optionsStopMicrophoneRecording = true;
        LeaveChannelOptions options = LeaveChannelOptions(
          stopAudioMixing: optionsStopAudioMixing,
          stopAllEffect: optionsStopAllEffect,
          stopMicrophoneRecording: optionsStopMicrophoneRecording,
        );
        await rtcEngine.leaveChannel(
          options: options,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.leaveChannel] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.renewToken',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        String token = "hello";
        await rtcEngine.renewToken(
          token,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.renewToken] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.setChannelProfile',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        ChannelProfileType profile =
            ChannelProfileType.channelProfileCommunication;
        await rtcEngine.setChannelProfile(
          profile,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.setChannelProfile] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.setClientRole',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        ClientRoleType role = ClientRoleType.clientRoleBroadcaster;
        AudienceLatencyLevelType optionsAudienceLatencyLevel =
            AudienceLatencyLevelType.audienceLatencyLevelLowLatency;
        ClientRoleOptions options = ClientRoleOptions(
          audienceLatencyLevel: optionsAudienceLatencyLevel,
        );
        await rtcEngine.setClientRole(
          role: role,
          options: options,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.setClientRole] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.startEchoTest',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        int configView = 5;
        bool configEnableAudio = true;
        bool configEnableVideo = true;
        String configToken = "hello";
        String configChannelId = "hello";
        int configIntervalInSeconds = 5;
        EchoTestConfiguration config = EchoTestConfiguration(
          view: configView,
          enableAudio: configEnableAudio,
          enableVideo: configEnableVideo,
          token: configToken,
          channelId: configChannelId,
          intervalInSeconds: configIntervalInSeconds,
        );
        await rtcEngine.startEchoTest(
          config,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.startEchoTest] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.stopEchoTest',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        await rtcEngine.stopEchoTest();
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.stopEchoTest] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.enableMultiCamera',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        bool enabled = true;
        CameraDirection configCameraDirection = CameraDirection.cameraRear;
        CameraFocalLengthType configCameraFocalLengthType =
            CameraFocalLengthType.cameraFocalLengthDefault;
        int formatWidth = 5;
        int formatHeight = 5;
        int formatFps = 5;
        VideoFormat configFormat = VideoFormat(
          width: formatWidth,
          height: formatHeight,
          fps: formatFps,
        );
        String configDeviceId = "hello";
        String configCameraId = "hello";
        bool configFollowEncodeDimensionRatio = true;
        CameraCapturerConfiguration config = CameraCapturerConfiguration(
          cameraDirection: configCameraDirection,
          cameraFocalLengthType: configCameraFocalLengthType,
          deviceId: configDeviceId,
          cameraId: configCameraId,
          followEncodeDimensionRatio: configFollowEncodeDimensionRatio,
          format: configFormat,
        );
        await rtcEngine.enableMultiCamera(
          enabled: enabled,
          config: config,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.enableMultiCamera] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.enableVideo',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        await rtcEngine.enableVideo();
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.enableVideo] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.disableVideo',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        await rtcEngine.disableVideo();
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.disableVideo] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.startPreview',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        VideoSourceType sourceType = VideoSourceType.videoSourceCameraPrimary;
        await rtcEngine.startPreview(
          sourceType: sourceType,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.startPreview] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.stopPreview',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        VideoSourceType sourceType = VideoSourceType.videoSourceCameraPrimary;
        await rtcEngine.stopPreview(
          sourceType: sourceType,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.stopPreview] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.startLastmileProbeTest',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        bool configProbeUplink = true;
        bool configProbeDownlink = true;
        int configExpectedUplinkBitrate = 5;
        int configExpectedDownlinkBitrate = 5;
        LastmileProbeConfig config = LastmileProbeConfig(
          probeUplink: configProbeUplink,
          probeDownlink: configProbeDownlink,
          expectedUplinkBitrate: configExpectedUplinkBitrate,
          expectedDownlinkBitrate: configExpectedDownlinkBitrate,
        );
        await rtcEngine.startLastmileProbeTest(
          config,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.startLastmileProbeTest] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.stopLastmileProbeTest',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        await rtcEngine.stopLastmileProbeTest();
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.stopLastmileProbeTest] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.setVideoEncoderConfiguration',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        VideoCodecType configCodecType = VideoCodecType.videoCodecNone;
        int dimensionsWidth = 5;
        int dimensionsHeight = 5;
        VideoDimensions configDimensions = VideoDimensions(
          width: dimensionsWidth,
          height: dimensionsHeight,
        );
        OrientationMode configOrientationMode =
            OrientationMode.orientationModeAdaptive;
        DegradationPreference configDegradationPreference =
            DegradationPreference.maintainAuto;
        VideoMirrorModeType configMirrorMode =
            VideoMirrorModeType.videoMirrorModeAuto;
        EncodingPreference advanceOptionsEncodingPreference =
            EncodingPreference.preferAuto;
        CompressionPreference advanceOptionsCompressionPreference =
            CompressionPreference.preferCompressionAuto;
        bool advanceOptionsEncodeAlpha = true;
        AdvanceOptions configAdvanceOptions = AdvanceOptions(
          encodingPreference: advanceOptionsEncodingPreference,
          compressionPreference: advanceOptionsCompressionPreference,
          encodeAlpha: advanceOptionsEncodeAlpha,
        );
        int configFrameRate = 5;
        int configBitrate = 5;
        int configMinBitrate = 5;
        VideoEncoderConfiguration config = VideoEncoderConfiguration(
          codecType: configCodecType,
          dimensions: configDimensions,
          frameRate: configFrameRate,
          bitrate: configBitrate,
          minBitrate: configMinBitrate,
          orientationMode: configOrientationMode,
          degradationPreference: configDegradationPreference,
          mirrorMode: configMirrorMode,
          advanceOptions: configAdvanceOptions,
        );
        await rtcEngine.setVideoEncoderConfiguration(
          config,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.setVideoEncoderConfiguration] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.setBeautyEffectOptions',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        bool enabled = true;
        LighteningContrastLevel optionsLighteningContrastLevel =
            LighteningContrastLevel.lighteningContrastLow;
        double optionsLighteningLevel = 5.0;
        double optionsSmoothnessLevel = 5.0;
        double optionsRednessLevel = 5.0;
        double optionsSharpnessLevel = 5.0;
        BeautyOptions options = BeautyOptions(
          lighteningContrastLevel: optionsLighteningContrastLevel,
          lighteningLevel: optionsLighteningLevel,
          smoothnessLevel: optionsSmoothnessLevel,
          rednessLevel: optionsRednessLevel,
          sharpnessLevel: optionsSharpnessLevel,
        );
        MediaSourceType type = MediaSourceType.audioPlayoutSource;
        await rtcEngine.setBeautyEffectOptions(
          enabled: enabled,
          options: options,
          type: type,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.setBeautyEffectOptions] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.setFaceShapeBeautyOptions',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        bool enabled = true;
        FaceShapeBeautyStyle optionsShapeStyle =
            FaceShapeBeautyStyle.faceShapeBeautyStyleFemale;
        int optionsStyleIntensity = 5;
        FaceShapeBeautyOptions options = FaceShapeBeautyOptions(
          shapeStyle: optionsShapeStyle,
          styleIntensity: optionsStyleIntensity,
        );
        MediaSourceType type = MediaSourceType.audioPlayoutSource;
        await rtcEngine.setFaceShapeBeautyOptions(
          enabled: enabled,
          options: options,
          type: type,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.setFaceShapeBeautyOptions] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.setFaceShapeAreaOptions',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        FaceShapeArea optionsShapeArea = FaceShapeArea.faceShapeAreaNone;
        int optionsShapeIntensity = 5;
        FaceShapeAreaOptions options = FaceShapeAreaOptions(
          shapeArea: optionsShapeArea,
          shapeIntensity: optionsShapeIntensity,
        );
        MediaSourceType type = MediaSourceType.audioPlayoutSource;
        await rtcEngine.setFaceShapeAreaOptions(
          options: options,
          type: type,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.setFaceShapeAreaOptions] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.getFaceShapeBeautyOptions',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        MediaSourceType type = MediaSourceType.audioPlayoutSource;
        await rtcEngine.getFaceShapeBeautyOptions(
          type: type,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.getFaceShapeBeautyOptions] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.getFaceShapeAreaOptions',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        FaceShapeArea shapeArea = FaceShapeArea.faceShapeAreaNone;
        MediaSourceType type = MediaSourceType.audioPlayoutSource;
        await rtcEngine.getFaceShapeAreaOptions(
          shapeArea: shapeArea,
          type: type,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.getFaceShapeAreaOptions] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.setFilterEffectOptions',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        bool enabled = true;
        String optionsPath = "hello";
        double optionsStrength = 5.0;
        FilterEffectOptions options = FilterEffectOptions(
          path: optionsPath,
          strength: optionsStrength,
        );
        MediaSourceType type = MediaSourceType.audioPlayoutSource;
        await rtcEngine.setFilterEffectOptions(
          enabled: enabled,
          options: options,
          type: type,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.setFilterEffectOptions] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.setLowlightEnhanceOptions',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        bool enabled = true;
        LowLightEnhanceMode optionsMode =
            LowLightEnhanceMode.lowLightEnhanceAuto;
        LowLightEnhanceLevel optionsLevel =
            LowLightEnhanceLevel.lowLightEnhanceLevelHighQuality;
        LowlightEnhanceOptions options = LowlightEnhanceOptions(
          mode: optionsMode,
          level: optionsLevel,
        );
        MediaSourceType type = MediaSourceType.audioPlayoutSource;
        await rtcEngine.setLowlightEnhanceOptions(
          enabled: enabled,
          options: options,
          type: type,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.setLowlightEnhanceOptions] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.setVideoDenoiserOptions',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        bool enabled = true;
        VideoDenoiserMode optionsMode = VideoDenoiserMode.videoDenoiserAuto;
        VideoDenoiserLevel optionsLevel =
            VideoDenoiserLevel.videoDenoiserLevelHighQuality;
        VideoDenoiserOptions options = VideoDenoiserOptions(
          mode: optionsMode,
          level: optionsLevel,
        );
        MediaSourceType type = MediaSourceType.audioPlayoutSource;
        await rtcEngine.setVideoDenoiserOptions(
          enabled: enabled,
          options: options,
          type: type,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.setVideoDenoiserOptions] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.setColorEnhanceOptions',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        bool enabled = true;
        double optionsStrengthLevel = 5.0;
        double optionsSkinProtectLevel = 5.0;
        ColorEnhanceOptions options = ColorEnhanceOptions(
          strengthLevel: optionsStrengthLevel,
          skinProtectLevel: optionsSkinProtectLevel,
        );
        MediaSourceType type = MediaSourceType.audioPlayoutSource;
        await rtcEngine.setColorEnhanceOptions(
          enabled: enabled,
          options: options,
          type: type,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.setColorEnhanceOptions] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.enableVirtualBackground',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        bool enabled = true;
        BackgroundSourceType backgroundSourceBackgroundSourceType =
            BackgroundSourceType.backgroundNone;
        BackgroundBlurDegree backgroundSourceBlurDegree =
            BackgroundBlurDegree.blurDegreeLow;
        int backgroundSourceColor = 5;
        String backgroundSourceSource = "hello";
        VirtualBackgroundSource backgroundSource = VirtualBackgroundSource(
          backgroundSourceType: backgroundSourceBackgroundSourceType,
          color: backgroundSourceColor,
          source: backgroundSourceSource,
          blurDegree: backgroundSourceBlurDegree,
        );
        SegModelType segpropertyModelType = SegModelType.segModelAi;
        double segpropertyGreenCapacity = 5.0;
        SegmentationProperty segproperty = SegmentationProperty(
          modelType: segpropertyModelType,
          greenCapacity: segpropertyGreenCapacity,
        );
        MediaSourceType type = MediaSourceType.audioPlayoutSource;
        await rtcEngine.enableVirtualBackground(
          enabled: enabled,
          backgroundSource: backgroundSource,
          segproperty: segproperty,
          type: type,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.enableVirtualBackground] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.setupRemoteVideo',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        RenderModeType canvasRenderMode = RenderModeType.renderModeHidden;
        VideoMirrorModeType canvasMirrorMode =
            VideoMirrorModeType.videoMirrorModeAuto;
        VideoViewSetupMode canvasSetupMode =
            VideoViewSetupMode.videoViewSetupReplace;
        VideoSourceType canvasSourceType =
            VideoSourceType.videoSourceCameraPrimary;
        int cropAreaX = 5;
        int cropAreaY = 5;
        int cropAreaWidth = 5;
        int cropAreaHeight = 5;
        Rectangle canvasCropArea = Rectangle(
          x: cropAreaX,
          y: cropAreaY,
          width: cropAreaWidth,
          height: cropAreaHeight,
        );
        VideoModulePosition canvasPosition =
            VideoModulePosition.positionPostCapturer;
        int canvasUid = 5;
        int canvasSubviewUid = 5;
        int canvasView = 5;
        int canvasBackgroundColor = 5;
        int canvasMediaPlayerId = 5;
        bool canvasEnableAlphaMask = true;
        VideoCanvas canvas = VideoCanvas(
          uid: canvasUid,
          subviewUid: canvasSubviewUid,
          view: canvasView,
          backgroundColor: canvasBackgroundColor,
          renderMode: canvasRenderMode,
          mirrorMode: canvasMirrorMode,
          setupMode: canvasSetupMode,
          sourceType: canvasSourceType,
          mediaPlayerId: canvasMediaPlayerId,
          cropArea: canvasCropArea,
          enableAlphaMask: canvasEnableAlphaMask,
          position: canvasPosition,
        );
        await rtcEngine.setupRemoteVideo(
          canvas,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.setupRemoteVideo] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.setupLocalVideo',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        RenderModeType canvasRenderMode = RenderModeType.renderModeHidden;
        VideoMirrorModeType canvasMirrorMode =
            VideoMirrorModeType.videoMirrorModeAuto;
        VideoViewSetupMode canvasSetupMode =
            VideoViewSetupMode.videoViewSetupReplace;
        VideoSourceType canvasSourceType =
            VideoSourceType.videoSourceCameraPrimary;
        int cropAreaX = 5;
        int cropAreaY = 5;
        int cropAreaWidth = 5;
        int cropAreaHeight = 5;
        Rectangle canvasCropArea = Rectangle(
          x: cropAreaX,
          y: cropAreaY,
          width: cropAreaWidth,
          height: cropAreaHeight,
        );
        VideoModulePosition canvasPosition =
            VideoModulePosition.positionPostCapturer;
        int canvasUid = 5;
        int canvasSubviewUid = 5;
        int canvasView = 5;
        int canvasBackgroundColor = 5;
        int canvasMediaPlayerId = 5;
        bool canvasEnableAlphaMask = true;
        VideoCanvas canvas = VideoCanvas(
          uid: canvasUid,
          subviewUid: canvasSubviewUid,
          view: canvasView,
          backgroundColor: canvasBackgroundColor,
          renderMode: canvasRenderMode,
          mirrorMode: canvasMirrorMode,
          setupMode: canvasSetupMode,
          sourceType: canvasSourceType,
          mediaPlayerId: canvasMediaPlayerId,
          cropArea: canvasCropArea,
          enableAlphaMask: canvasEnableAlphaMask,
          position: canvasPosition,
        );
        await rtcEngine.setupLocalVideo(
          canvas,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.setupLocalVideo] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.setVideoScenario',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        VideoApplicationScenarioType scenarioType =
            VideoApplicationScenarioType.applicationScenarioGeneral;
        await rtcEngine.setVideoScenario(
          scenarioType,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.setVideoScenario] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.setVideoQoEPreference',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        VideoQoePreferenceType qoePreference =
            VideoQoePreferenceType.videoQoePreferenceBalance;
        await rtcEngine.setVideoQoEPreference(
          qoePreference,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.setVideoQoEPreference] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.enableAudio',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        await rtcEngine.enableAudio();
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.enableAudio] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.disableAudio',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        await rtcEngine.disableAudio();
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.disableAudio] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.setAudioProfile',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        AudioProfileType profile = AudioProfileType.audioProfileDefault;
        AudioScenarioType scenario = AudioScenarioType.audioScenarioDefault;
        await rtcEngine.setAudioProfile(
          profile: profile,
          scenario: scenario,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.setAudioProfile] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.setAudioScenario',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        AudioScenarioType scenario = AudioScenarioType.audioScenarioDefault;
        await rtcEngine.setAudioScenario(
          scenario,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.setAudioScenario] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.enableLocalAudio',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        bool enabled = true;
        await rtcEngine.enableLocalAudio(
          enabled,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.enableLocalAudio] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.muteLocalAudioStream',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        bool mute = true;
        await rtcEngine.muteLocalAudioStream(
          mute,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.muteLocalAudioStream] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.muteAllRemoteAudioStreams',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        bool mute = true;
        await rtcEngine.muteAllRemoteAudioStreams(
          mute,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.muteAllRemoteAudioStreams] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.muteRemoteAudioStream',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        int uid = 5;
        bool mute = true;
        await rtcEngine.muteRemoteAudioStream(
          uid: uid,
          mute: mute,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.muteRemoteAudioStream] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.muteLocalVideoStream',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        bool mute = true;
        await rtcEngine.muteLocalVideoStream(
          mute,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.muteLocalVideoStream] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.enableLocalVideo',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        bool enabled = true;
        await rtcEngine.enableLocalVideo(
          enabled,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.enableLocalVideo] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.muteAllRemoteVideoStreams',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        bool mute = true;
        await rtcEngine.muteAllRemoteVideoStreams(
          mute,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.muteAllRemoteVideoStreams] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.setRemoteDefaultVideoStreamType',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        VideoStreamType streamType = VideoStreamType.videoStreamHigh;
        await rtcEngine.setRemoteDefaultVideoStreamType(
          streamType,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.setRemoteDefaultVideoStreamType] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.muteRemoteVideoStream',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        int uid = 5;
        bool mute = true;
        await rtcEngine.muteRemoteVideoStream(
          uid: uid,
          mute: mute,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.muteRemoteVideoStream] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.setRemoteVideoStreamType',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        int uid = 5;
        VideoStreamType streamType = VideoStreamType.videoStreamHigh;
        await rtcEngine.setRemoteVideoStreamType(
          uid: uid,
          streamType: streamType,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.setRemoteVideoStreamType] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.setRemoteVideoSubscriptionOptions',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        int uid = 5;
        VideoStreamType optionsType = VideoStreamType.videoStreamHigh;
        bool optionsEncodedFrameOnly = true;
        VideoSubscriptionOptions options = VideoSubscriptionOptions(
          type: optionsType,
          encodedFrameOnly: optionsEncodedFrameOnly,
        );
        await rtcEngine.setRemoteVideoSubscriptionOptions(
          uid: uid,
          options: options,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.setRemoteVideoSubscriptionOptions] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.enableAudioVolumeIndication',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        int interval = 5;
        int smooth = 5;
        bool reportVad = true;
        await rtcEngine.enableAudioVolumeIndication(
          interval: interval,
          smooth: smooth,
          reportVad: reportVad,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.enableAudioVolumeIndication] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.startAudioRecording',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        AudioFileRecordingType configFileRecordingType =
            AudioFileRecordingType.audioFileRecordingMic;
        AudioRecordingQualityType configQuality =
            AudioRecordingQualityType.audioRecordingQualityLow;
        String configFilePath = "hello";
        bool configEncode = true;
        int configSampleRate = 5;
        int configRecordingChannel = 5;
        AudioRecordingConfiguration config = AudioRecordingConfiguration(
          filePath: configFilePath,
          encode: configEncode,
          sampleRate: configSampleRate,
          fileRecordingType: configFileRecordingType,
          quality: configQuality,
          recordingChannel: configRecordingChannel,
        );
        await rtcEngine.startAudioRecording(
          config,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.startAudioRecording] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.registerAudioEncodedFrameObserver',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        AudioEncodedFrameObserverPosition configPostionType =
            AudioEncodedFrameObserverPosition
                .audioEncodedFrameObserverPositionRecord;
        AudioEncodingType configEncodingType =
            AudioEncodingType.audioEncodingTypeAac16000Low;
        AudioEncodedFrameObserverConfig config =
            AudioEncodedFrameObserverConfig(
          postionType: configPostionType,
          encodingType: configEncodingType,
        );
        AudioEncodedFrameObserver observer = AudioEncodedFrameObserver(
          onRecordAudioEncodedFrame: (Uint8List frameBuffer, int length,
              EncodedAudioFrameInfo audioEncodedFrameInfo) {},
          onPlaybackAudioEncodedFrame: (Uint8List frameBuffer, int length,
              EncodedAudioFrameInfo audioEncodedFrameInfo) {},
          onMixedAudioEncodedFrame: (Uint8List frameBuffer, int length,
              EncodedAudioFrameInfo audioEncodedFrameInfo) {},
        );
        rtcEngine.registerAudioEncodedFrameObserver(
          config: config,
          observer: observer,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.registerAudioEncodedFrameObserver] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.stopAudioRecording',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        await rtcEngine.stopAudioRecording();
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.stopAudioRecording] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.startAudioMixing',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        String filePath = "hello";
        bool loopback = true;
        int cycle = 5;
        int startPos = 5;
        await rtcEngine.startAudioMixing(
          filePath: filePath,
          loopback: loopback,
          cycle: cycle,
          startPos: startPos,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.startAudioMixing] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.stopAudioMixing',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        await rtcEngine.stopAudioMixing();
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.stopAudioMixing] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.pauseAudioMixing',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        await rtcEngine.pauseAudioMixing();
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.pauseAudioMixing] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.resumeAudioMixing',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        await rtcEngine.resumeAudioMixing();
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.resumeAudioMixing] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.selectAudioTrack',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        int index = 5;
        await rtcEngine.selectAudioTrack(
          index,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.selectAudioTrack] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.getAudioTrackCount',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        await rtcEngine.getAudioTrackCount();
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.getAudioTrackCount] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.adjustAudioMixingVolume',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        int volume = 5;
        await rtcEngine.adjustAudioMixingVolume(
          volume,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.adjustAudioMixingVolume] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.adjustAudioMixingPublishVolume',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        int volume = 5;
        await rtcEngine.adjustAudioMixingPublishVolume(
          volume,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.adjustAudioMixingPublishVolume] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.getAudioMixingPublishVolume',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        await rtcEngine.getAudioMixingPublishVolume();
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.getAudioMixingPublishVolume] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.adjustAudioMixingPlayoutVolume',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        int volume = 5;
        await rtcEngine.adjustAudioMixingPlayoutVolume(
          volume,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.adjustAudioMixingPlayoutVolume] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.getAudioMixingPlayoutVolume',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        await rtcEngine.getAudioMixingPlayoutVolume();
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.getAudioMixingPlayoutVolume] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.getAudioMixingDuration',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        await rtcEngine.getAudioMixingDuration();
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.getAudioMixingDuration] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.getAudioMixingCurrentPosition',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        await rtcEngine.getAudioMixingCurrentPosition();
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.getAudioMixingCurrentPosition] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.setAudioMixingPosition',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        int pos = 5;
        await rtcEngine.setAudioMixingPosition(
          pos,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.setAudioMixingPosition] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.setAudioMixingDualMonoMode',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        AudioMixingDualMonoMode mode =
            AudioMixingDualMonoMode.audioMixingDualMonoAuto;
        await rtcEngine.setAudioMixingDualMonoMode(
          mode,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.setAudioMixingDualMonoMode] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.setAudioMixingPitch',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        int pitch = 5;
        await rtcEngine.setAudioMixingPitch(
          pitch,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.setAudioMixingPitch] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.setAudioMixingPlaybackSpeed',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        int speed = 5;
        await rtcEngine.setAudioMixingPlaybackSpeed(
          speed,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.setAudioMixingPlaybackSpeed] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.getEffectsVolume',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        await rtcEngine.getEffectsVolume();
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.getEffectsVolume] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.setEffectsVolume',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        int volume = 5;
        await rtcEngine.setEffectsVolume(
          volume,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.setEffectsVolume] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.preloadEffect',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        int soundId = 5;
        String filePath = "hello";
        int startPos = 5;
        await rtcEngine.preloadEffect(
          soundId: soundId,
          filePath: filePath,
          startPos: startPos,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.preloadEffect] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.playEffect',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        int soundId = 5;
        String filePath = "hello";
        int loopCount = 5;
        double pitch = 5.0;
        double pan = 5.0;
        int gain = 5;
        bool publish = true;
        int startPos = 5;
        await rtcEngine.playEffect(
          soundId: soundId,
          filePath: filePath,
          loopCount: loopCount,
          pitch: pitch,
          pan: pan,
          gain: gain,
          publish: publish,
          startPos: startPos,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.playEffect] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.playAllEffects',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        int loopCount = 5;
        double pitch = 5.0;
        double pan = 5.0;
        int gain = 5;
        bool publish = true;
        await rtcEngine.playAllEffects(
          loopCount: loopCount,
          pitch: pitch,
          pan: pan,
          gain: gain,
          publish: publish,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.playAllEffects] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.getVolumeOfEffect',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        int soundId = 5;
        await rtcEngine.getVolumeOfEffect(
          soundId,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.getVolumeOfEffect] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.setVolumeOfEffect',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        int soundId = 5;
        int volume = 5;
        await rtcEngine.setVolumeOfEffect(
          soundId: soundId,
          volume: volume,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.setVolumeOfEffect] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.pauseEffect',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        int soundId = 5;
        await rtcEngine.pauseEffect(
          soundId,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.pauseEffect] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.pauseAllEffects',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        await rtcEngine.pauseAllEffects();
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.pauseAllEffects] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.resumeEffect',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        int soundId = 5;
        await rtcEngine.resumeEffect(
          soundId,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.resumeEffect] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.resumeAllEffects',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        await rtcEngine.resumeAllEffects();
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.resumeAllEffects] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.stopEffect',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        int soundId = 5;
        await rtcEngine.stopEffect(
          soundId,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.stopEffect] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.stopAllEffects',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        await rtcEngine.stopAllEffects();
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.stopAllEffects] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.unloadEffect',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        int soundId = 5;
        await rtcEngine.unloadEffect(
          soundId,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.unloadEffect] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.unloadAllEffects',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        await rtcEngine.unloadAllEffects();
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.unloadAllEffects] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.getEffectDuration',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        String filePath = "hello";
        await rtcEngine.getEffectDuration(
          filePath,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.getEffectDuration] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.setEffectPosition',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        int soundId = 5;
        int pos = 5;
        await rtcEngine.setEffectPosition(
          soundId: soundId,
          pos: pos,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.setEffectPosition] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.getEffectCurrentPosition',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        int soundId = 5;
        await rtcEngine.getEffectCurrentPosition(
          soundId,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.getEffectCurrentPosition] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.enableSoundPositionIndication',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        bool enabled = true;
        await rtcEngine.enableSoundPositionIndication(
          enabled,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.enableSoundPositionIndication] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.setRemoteVoicePosition',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        int uid = 5;
        double pan = 5.0;
        double gain = 5.0;
        await rtcEngine.setRemoteVoicePosition(
          uid: uid,
          pan: pan,
          gain: gain,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.setRemoteVoicePosition] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.enableSpatialAudio',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        bool enabled = true;
        await rtcEngine.enableSpatialAudio(
          enabled,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.enableSpatialAudio] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.setRemoteUserSpatialAudioParams',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        int uid = 5;
        double paramsSpeakerAzimuth = 5.0;
        double paramsSpeakerElevation = 5.0;
        double paramsSpeakerDistance = 5.0;
        int paramsSpeakerOrientation = 5;
        bool paramsEnableBlur = true;
        bool paramsEnableAirAbsorb = true;
        double paramsSpeakerAttenuation = 5.0;
        bool paramsEnableDoppler = true;
        SpatialAudioParams params = SpatialAudioParams(
          speakerAzimuth: paramsSpeakerAzimuth,
          speakerElevation: paramsSpeakerElevation,
          speakerDistance: paramsSpeakerDistance,
          speakerOrientation: paramsSpeakerOrientation,
          enableBlur: paramsEnableBlur,
          enableAirAbsorb: paramsEnableAirAbsorb,
          speakerAttenuation: paramsSpeakerAttenuation,
          enableDoppler: paramsEnableDoppler,
        );
        await rtcEngine.setRemoteUserSpatialAudioParams(
          uid: uid,
          params: params,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.setRemoteUserSpatialAudioParams] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.setVoiceBeautifierPreset',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        VoiceBeautifierPreset preset = VoiceBeautifierPreset.voiceBeautifierOff;
        await rtcEngine.setVoiceBeautifierPreset(
          preset,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.setVoiceBeautifierPreset] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.setAudioEffectPreset',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        AudioEffectPreset preset = AudioEffectPreset.audioEffectOff;
        await rtcEngine.setAudioEffectPreset(
          preset,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.setAudioEffectPreset] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.setVoiceConversionPreset',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        VoiceConversionPreset preset = VoiceConversionPreset.voiceConversionOff;
        await rtcEngine.setVoiceConversionPreset(
          preset,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.setVoiceConversionPreset] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.setAudioEffectParameters',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        AudioEffectPreset preset = AudioEffectPreset.audioEffectOff;
        int param1 = 5;
        int param2 = 5;
        await rtcEngine.setAudioEffectParameters(
          preset: preset,
          param1: param1,
          param2: param2,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.setAudioEffectParameters] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.setVoiceBeautifierParameters',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        VoiceBeautifierPreset preset = VoiceBeautifierPreset.voiceBeautifierOff;
        int param1 = 5;
        int param2 = 5;
        await rtcEngine.setVoiceBeautifierParameters(
          preset: preset,
          param1: param1,
          param2: param2,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.setVoiceBeautifierParameters] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.setVoiceConversionParameters',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        VoiceConversionPreset preset = VoiceConversionPreset.voiceConversionOff;
        int param1 = 5;
        int param2 = 5;
        await rtcEngine.setVoiceConversionParameters(
          preset: preset,
          param1: param1,
          param2: param2,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.setVoiceConversionParameters] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.setLocalVoicePitch',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        double pitch = 5.0;
        await rtcEngine.setLocalVoicePitch(
          pitch,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.setLocalVoicePitch] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.setLocalVoiceFormant',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        double formantRatio = 5.0;
        await rtcEngine.setLocalVoiceFormant(
          formantRatio,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.setLocalVoiceFormant] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.setLocalVoiceEqualization',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        AudioEqualizationBandFrequency bandFrequency =
            AudioEqualizationBandFrequency.audioEqualizationBand31;
        int bandGain = 5;
        await rtcEngine.setLocalVoiceEqualization(
          bandFrequency: bandFrequency,
          bandGain: bandGain,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.setLocalVoiceEqualization] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.setLocalVoiceReverb',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        AudioReverbType reverbKey = AudioReverbType.audioReverbDryLevel;
        int value = 5;
        await rtcEngine.setLocalVoiceReverb(
          reverbKey: reverbKey,
          value: value,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.setLocalVoiceReverb] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.setHeadphoneEQPreset',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        HeadphoneEqualizerPreset preset =
            HeadphoneEqualizerPreset.headphoneEqualizerOff;
        await rtcEngine.setHeadphoneEQPreset(
          preset,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.setHeadphoneEQPreset] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.setHeadphoneEQParameters',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        int lowGain = 5;
        int highGain = 5;
        await rtcEngine.setHeadphoneEQParameters(
          lowGain: lowGain,
          highGain: highGain,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.setHeadphoneEQParameters] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.enableVoiceAITuner',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        bool enabled = true;
        VoiceAiTunerType type = VoiceAiTunerType.voiceAiTunerMatureMale;
        await rtcEngine.enableVoiceAITuner(
          enabled: enabled,
          type: type,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.enableVoiceAITuner] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.setLogFile',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        String filePath = "hello";
        await rtcEngine.setLogFile(
          filePath,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.setLogFile] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.setLogFilter',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        LogFilterType filter = LogFilterType.logFilterOff;
        await rtcEngine.setLogFilter(
          filter,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.setLogFilter] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.setLogLevel',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        LogLevel level = LogLevel.logLevelNone;
        await rtcEngine.setLogLevel(
          level,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.setLogLevel] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.setLogFileSize',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        int fileSizeInKBytes = 5;
        await rtcEngine.setLogFileSize(
          fileSizeInKBytes,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.setLogFileSize] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.uploadLogFile',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        await rtcEngine.uploadLogFile();
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.uploadLogFile] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.writeLog',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        LogLevel level = LogLevel.logLevelNone;
        String fmt = "hello";
        await rtcEngine.writeLog(
          level: level,
          fmt: fmt,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.writeLog] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.setLocalRenderMode',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        RenderModeType renderMode = RenderModeType.renderModeHidden;
        VideoMirrorModeType mirrorMode =
            VideoMirrorModeType.videoMirrorModeAuto;
        await rtcEngine.setLocalRenderMode(
          renderMode: renderMode,
          mirrorMode: mirrorMode,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.setLocalRenderMode] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.setRemoteRenderMode',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        int uid = 5;
        RenderModeType renderMode = RenderModeType.renderModeHidden;
        VideoMirrorModeType mirrorMode =
            VideoMirrorModeType.videoMirrorModeAuto;
        await rtcEngine.setRemoteRenderMode(
          uid: uid,
          renderMode: renderMode,
          mirrorMode: mirrorMode,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.setRemoteRenderMode] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.setLocalRenderTargetFps',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        VideoSourceType sourceType = VideoSourceType.videoSourceCameraPrimary;
        int targetFps = 5;
        await rtcEngine.setLocalRenderTargetFps(
          sourceType: sourceType,
          targetFps: targetFps,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.setLocalRenderTargetFps] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.setRemoteRenderTargetFps',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        int targetFps = 5;
        await rtcEngine.setRemoteRenderTargetFps(
          targetFps,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.setRemoteRenderTargetFps] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.setLocalVideoMirrorMode',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        VideoMirrorModeType mirrorMode =
            VideoMirrorModeType.videoMirrorModeAuto;
        await rtcEngine.setLocalVideoMirrorMode(
          mirrorMode,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.setLocalVideoMirrorMode] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.enableDualStreamMode',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        bool enabled = true;
        int dimensionsWidth = 5;
        int dimensionsHeight = 5;
        VideoDimensions streamConfigDimensions = VideoDimensions(
          width: dimensionsWidth,
          height: dimensionsHeight,
        );
        int streamConfigKBitrate = 5;
        int streamConfigFramerate = 5;
        SimulcastStreamConfig streamConfig = SimulcastStreamConfig(
          dimensions: streamConfigDimensions,
          kBitrate: streamConfigKBitrate,
          framerate: streamConfigFramerate,
        );
        await rtcEngine.enableDualStreamMode(
          enabled: enabled,
          streamConfig: streamConfig,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.enableDualStreamMode] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.setDualStreamMode',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        SimulcastStreamMode mode = SimulcastStreamMode.autoSimulcastStream;
        int dimensionsWidth = 5;
        int dimensionsHeight = 5;
        VideoDimensions streamConfigDimensions = VideoDimensions(
          width: dimensionsWidth,
          height: dimensionsHeight,
        );
        int streamConfigKBitrate = 5;
        int streamConfigFramerate = 5;
        SimulcastStreamConfig streamConfig = SimulcastStreamConfig(
          dimensions: streamConfigDimensions,
          kBitrate: streamConfigKBitrate,
          framerate: streamConfigFramerate,
        );
        await rtcEngine.setDualStreamMode(
          mode: mode,
          streamConfig: streamConfig,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.setDualStreamMode] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.setSimulcastConfig',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        List<StreamLayerConfig> simulcastConfigConfigs = [];
        SimulcastConfig simulcastConfig = SimulcastConfig(
          configs: simulcastConfigConfigs,
        );
        await rtcEngine.setSimulcastConfig(
          simulcastConfig,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.setSimulcastConfig] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.enableCustomAudioLocalPlayback',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        int trackId = 5;
        bool enabled = true;
        await rtcEngine.enableCustomAudioLocalPlayback(
          trackId: trackId,
          enabled: enabled,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.enableCustomAudioLocalPlayback] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.setRecordingAudioFrameParameters',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        int sampleRate = 5;
        int channel = 5;
        RawAudioFrameOpModeType mode =
            RawAudioFrameOpModeType.rawAudioFrameOpModeReadOnly;
        int samplesPerCall = 5;
        await rtcEngine.setRecordingAudioFrameParameters(
          sampleRate: sampleRate,
          channel: channel,
          mode: mode,
          samplesPerCall: samplesPerCall,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.setRecordingAudioFrameParameters] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.setPlaybackAudioFrameParameters',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        int sampleRate = 5;
        int channel = 5;
        RawAudioFrameOpModeType mode =
            RawAudioFrameOpModeType.rawAudioFrameOpModeReadOnly;
        int samplesPerCall = 5;
        await rtcEngine.setPlaybackAudioFrameParameters(
          sampleRate: sampleRate,
          channel: channel,
          mode: mode,
          samplesPerCall: samplesPerCall,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.setPlaybackAudioFrameParameters] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.setMixedAudioFrameParameters',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        int sampleRate = 5;
        int channel = 5;
        int samplesPerCall = 5;
        await rtcEngine.setMixedAudioFrameParameters(
          sampleRate: sampleRate,
          channel: channel,
          samplesPerCall: samplesPerCall,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.setMixedAudioFrameParameters] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.setEarMonitoringAudioFrameParameters',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        int sampleRate = 5;
        int channel = 5;
        RawAudioFrameOpModeType mode =
            RawAudioFrameOpModeType.rawAudioFrameOpModeReadOnly;
        int samplesPerCall = 5;
        await rtcEngine.setEarMonitoringAudioFrameParameters(
          sampleRate: sampleRate,
          channel: channel,
          mode: mode,
          samplesPerCall: samplesPerCall,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.setEarMonitoringAudioFrameParameters] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.setPlaybackAudioFrameBeforeMixingParameters',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        int sampleRate = 5;
        int channel = 5;
        await rtcEngine.setPlaybackAudioFrameBeforeMixingParameters(
          sampleRate: sampleRate,
          channel: channel,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.setPlaybackAudioFrameBeforeMixingParameters] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.enableAudioSpectrumMonitor',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        int intervalInMS = 5;
        await rtcEngine.enableAudioSpectrumMonitor(
          intervalInMS: intervalInMS,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.enableAudioSpectrumMonitor] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.disableAudioSpectrumMonitor',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        await rtcEngine.disableAudioSpectrumMonitor();
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.disableAudioSpectrumMonitor] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.registerAudioSpectrumObserver',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        AudioSpectrumObserver observer = AudioSpectrumObserver(
          onLocalAudioSpectrum: (AudioSpectrumData data) {},
          onRemoteAudioSpectrum: (List spectrums, int spectrumNumber) {},
        );
        rtcEngine.registerAudioSpectrumObserver(
          observer,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.registerAudioSpectrumObserver] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.unregisterAudioSpectrumObserver',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        AudioSpectrumObserver observer = AudioSpectrumObserver(
          onLocalAudioSpectrum: (AudioSpectrumData data) {},
          onRemoteAudioSpectrum: (List spectrums, int spectrumNumber) {},
        );
        rtcEngine.unregisterAudioSpectrumObserver(
          observer,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.unregisterAudioSpectrumObserver] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.adjustRecordingSignalVolume',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        int volume = 5;
        await rtcEngine.adjustRecordingSignalVolume(
          volume,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.adjustRecordingSignalVolume] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.muteRecordingSignal',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        bool mute = true;
        await rtcEngine.muteRecordingSignal(
          mute,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.muteRecordingSignal] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.adjustPlaybackSignalVolume',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        int volume = 5;
        await rtcEngine.adjustPlaybackSignalVolume(
          volume,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.adjustPlaybackSignalVolume] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.adjustUserPlaybackSignalVolume',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        int uid = 5;
        int volume = 5;
        await rtcEngine.adjustUserPlaybackSignalVolume(
          uid: uid,
          volume: volume,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.adjustUserPlaybackSignalVolume] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.setLocalPublishFallbackOption',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        StreamFallbackOptions option =
            StreamFallbackOptions.streamFallbackOptionDisabled;
        await rtcEngine.setLocalPublishFallbackOption(
          option,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.setLocalPublishFallbackOption] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.setRemoteSubscribeFallbackOption',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        StreamFallbackOptions option =
            StreamFallbackOptions.streamFallbackOptionDisabled;
        await rtcEngine.setRemoteSubscribeFallbackOption(
          option,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.setRemoteSubscribeFallbackOption] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.enableExtension',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        String provider = "hello";
        String extension = "hello";
        bool enable = true;
        MediaSourceType type = MediaSourceType.audioPlayoutSource;
        await rtcEngine.enableExtension(
          provider: provider,
          extension: extension,
          enable: enable,
          type: type,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.enableExtension] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.setExtensionProperty',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        String provider = "hello";
        String extension = "hello";
        String key = "hello";
        String value = "hello";
        MediaSourceType type = MediaSourceType.audioPlayoutSource;
        await rtcEngine.setExtensionProperty(
          provider: provider,
          extension: extension,
          key: key,
          value: value,
          type: type,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.setExtensionProperty] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.getExtensionProperty',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        String provider = "hello";
        String extension = "hello";
        String key = "hello";
        int bufLen = 5;
        MediaSourceType type = MediaSourceType.audioPlayoutSource;
        await rtcEngine.getExtensionProperty(
          provider: provider,
          extension: extension,
          key: key,
          bufLen: bufLen,
          type: type,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.getExtensionProperty] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.enableLoopbackRecording',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        bool enabled = true;
        String deviceName = "hello";
        await rtcEngine.enableLoopbackRecording(
          enabled: enabled,
          deviceName: deviceName,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.enableLoopbackRecording] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.adjustLoopbackSignalVolume',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        int volume = 5;
        await rtcEngine.adjustLoopbackSignalVolume(
          volume,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.adjustLoopbackSignalVolume] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.getLoopbackRecordingVolume',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        await rtcEngine.getLoopbackRecordingVolume();
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.getLoopbackRecordingVolume] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.enableInEarMonitoring',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        bool enabled = true;
        EarMonitoringFilterType includeAudioFilters =
            EarMonitoringFilterType.earMonitoringFilterNone;
        await rtcEngine.enableInEarMonitoring(
          enabled: enabled,
          includeAudioFilters: includeAudioFilters,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.enableInEarMonitoring] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.setInEarMonitoringVolume',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        int volume = 5;
        await rtcEngine.setInEarMonitoringVolume(
          volume,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.setInEarMonitoringVolume] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.loadExtensionProvider',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        String path = "hello";
        bool unloadAfterUse = true;
        await rtcEngine.loadExtensionProvider(
          path: path,
          unloadAfterUse: unloadAfterUse,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.loadExtensionProvider] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.setExtensionProviderProperty',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        String provider = "hello";
        String key = "hello";
        String value = "hello";
        await rtcEngine.setExtensionProviderProperty(
          provider: provider,
          key: key,
          value: value,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.setExtensionProviderProperty] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.registerExtension',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        String provider = "hello";
        String extension = "hello";
        MediaSourceType type = MediaSourceType.audioPlayoutSource;
        await rtcEngine.registerExtension(
          provider: provider,
          extension: extension,
          type: type,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.registerExtension] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.setCameraCapturerConfiguration',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        CameraDirection configCameraDirection = CameraDirection.cameraRear;
        CameraFocalLengthType configCameraFocalLengthType =
            CameraFocalLengthType.cameraFocalLengthDefault;
        int formatWidth = 5;
        int formatHeight = 5;
        int formatFps = 5;
        VideoFormat configFormat = VideoFormat(
          width: formatWidth,
          height: formatHeight,
          fps: formatFps,
        );
        String configDeviceId = "hello";
        String configCameraId = "hello";
        bool configFollowEncodeDimensionRatio = true;
        CameraCapturerConfiguration config = CameraCapturerConfiguration(
          cameraDirection: configCameraDirection,
          cameraFocalLengthType: configCameraFocalLengthType,
          deviceId: configDeviceId,
          cameraId: configCameraId,
          followEncodeDimensionRatio: configFollowEncodeDimensionRatio,
          format: configFormat,
        );
        await rtcEngine.setCameraCapturerConfiguration(
          config,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.setCameraCapturerConfiguration] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.destroyCustomVideoTrack',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        int videoTrackId = 5;
        await rtcEngine.destroyCustomVideoTrack(
          videoTrackId,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.destroyCustomVideoTrack] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.destroyCustomEncodedVideoTrack',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        int videoTrackId = 5;
        await rtcEngine.destroyCustomEncodedVideoTrack(
          videoTrackId,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.destroyCustomEncodedVideoTrack] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.switchCamera',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        await rtcEngine.switchCamera();
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.switchCamera] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.isCameraZoomSupported',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        await rtcEngine.isCameraZoomSupported();
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.isCameraZoomSupported] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.isCameraFaceDetectSupported',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        await rtcEngine.isCameraFaceDetectSupported();
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.isCameraFaceDetectSupported] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.isCameraTorchSupported',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        await rtcEngine.isCameraTorchSupported();
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.isCameraTorchSupported] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.isCameraFocusSupported',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        await rtcEngine.isCameraFocusSupported();
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.isCameraFocusSupported] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.isCameraAutoFocusFaceModeSupported',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        await rtcEngine.isCameraAutoFocusFaceModeSupported();
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.isCameraAutoFocusFaceModeSupported] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.setCameraZoomFactor',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        double factor = 5.0;
        await rtcEngine.setCameraZoomFactor(
          factor,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.setCameraZoomFactor] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.enableFaceDetection',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        bool enabled = true;
        await rtcEngine.enableFaceDetection(
          enabled,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.enableFaceDetection] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.getCameraMaxZoomFactor',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        await rtcEngine.getCameraMaxZoomFactor();
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.getCameraMaxZoomFactor] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.setCameraFocusPositionInPreview',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        double positionX = 5.0;
        double positionY = 5.0;
        await rtcEngine.setCameraFocusPositionInPreview(
          positionX: positionX,
          positionY: positionY,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.setCameraFocusPositionInPreview] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.setCameraTorchOn',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        bool isOn = true;
        await rtcEngine.setCameraTorchOn(
          isOn,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.setCameraTorchOn] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.setCameraAutoFocusFaceModeEnabled',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        bool enabled = true;
        await rtcEngine.setCameraAutoFocusFaceModeEnabled(
          enabled,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.setCameraAutoFocusFaceModeEnabled] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.isCameraExposurePositionSupported',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        await rtcEngine.isCameraExposurePositionSupported();
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.isCameraExposurePositionSupported] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.setCameraExposurePosition',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        double positionXinView = 5.0;
        double positionYinView = 5.0;
        await rtcEngine.setCameraExposurePosition(
          positionXinView: positionXinView,
          positionYinView: positionYinView,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.setCameraExposurePosition] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.isCameraExposureSupported',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        await rtcEngine.isCameraExposureSupported();
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.isCameraExposureSupported] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.setCameraExposureFactor',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        double factor = 5.0;
        await rtcEngine.setCameraExposureFactor(
          factor,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.setCameraExposureFactor] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.isCameraAutoExposureFaceModeSupported',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        await rtcEngine.isCameraAutoExposureFaceModeSupported();
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.isCameraAutoExposureFaceModeSupported] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.setCameraAutoExposureFaceModeEnabled',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        bool enabled = true;
        await rtcEngine.setCameraAutoExposureFaceModeEnabled(
          enabled,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.setCameraAutoExposureFaceModeEnabled] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.setCameraStabilizationMode',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        CameraStabilizationMode mode =
            CameraStabilizationMode.cameraStabilizationModeOff;
        await rtcEngine.setCameraStabilizationMode(
          mode,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.setCameraStabilizationMode] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.setDefaultAudioRouteToSpeakerphone',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        bool defaultToSpeaker = true;
        await rtcEngine.setDefaultAudioRouteToSpeakerphone(
          defaultToSpeaker,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.setDefaultAudioRouteToSpeakerphone] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.setEnableSpeakerphone',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        bool speakerOn = true;
        await rtcEngine.setEnableSpeakerphone(
          speakerOn,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.setEnableSpeakerphone] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.isSpeakerphoneEnabled',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        await rtcEngine.isSpeakerphoneEnabled();
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.isSpeakerphoneEnabled] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.setRouteInCommunicationMode',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        int route = 5;
        await rtcEngine.setRouteInCommunicationMode(
          route,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.setRouteInCommunicationMode] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.isCameraCenterStageSupported',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        await rtcEngine.isCameraCenterStageSupported();
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.isCameraCenterStageSupported] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.enableCameraCenterStage',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        bool enabled = true;
        await rtcEngine.enableCameraCenterStage(
          enabled,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.enableCameraCenterStage] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.getScreenCaptureSources',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        int thumbSizeWidth = 5;
        int thumbSizeHeight = 5;
        SIZE thumbSize = SIZE(
          width: thumbSizeWidth,
          height: thumbSizeHeight,
        );
        int iconSizeWidth = 5;
        int iconSizeHeight = 5;
        SIZE iconSize = SIZE(
          width: iconSizeWidth,
          height: iconSizeHeight,
        );
        bool includeScreen = true;
        await rtcEngine.getScreenCaptureSources(
          thumbSize: thumbSize,
          iconSize: iconSize,
          includeScreen: includeScreen,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.getScreenCaptureSources] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.setAudioSessionOperationRestriction',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        AudioSessionOperationRestriction restriction =
            AudioSessionOperationRestriction
                .audioSessionOperationRestrictionNone;
        await rtcEngine.setAudioSessionOperationRestriction(
          restriction,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.setAudioSessionOperationRestriction] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.startScreenCaptureByDisplayId',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        int displayId = 5;
        int regionRectX = 5;
        int regionRectY = 5;
        int regionRectWidth = 5;
        int regionRectHeight = 5;
        Rectangle regionRect = Rectangle(
          x: regionRectX,
          y: regionRectY,
          width: regionRectWidth,
          height: regionRectHeight,
        );
        int dimensionsWidth = 5;
        int dimensionsHeight = 5;
        VideoDimensions captureParamsDimensions = VideoDimensions(
          width: dimensionsWidth,
          height: dimensionsHeight,
        );
        int captureParamsFrameRate = 5;
        int captureParamsBitrate = 5;
        bool captureParamsCaptureMouseCursor = true;
        bool captureParamsWindowFocus = true;
        List<int> captureParamsExcludeWindowList = List.filled(5, 5);
        int captureParamsExcludeWindowCount = 5;
        int captureParamsHighLightWidth = 5;
        int captureParamsHighLightColor = 5;
        bool captureParamsEnableHighLight = true;
        ScreenCaptureParameters captureParams = ScreenCaptureParameters(
          dimensions: captureParamsDimensions,
          frameRate: captureParamsFrameRate,
          bitrate: captureParamsBitrate,
          captureMouseCursor: captureParamsCaptureMouseCursor,
          windowFocus: captureParamsWindowFocus,
          excludeWindowList: captureParamsExcludeWindowList,
          excludeWindowCount: captureParamsExcludeWindowCount,
          highLightWidth: captureParamsHighLightWidth,
          highLightColor: captureParamsHighLightColor,
          enableHighLight: captureParamsEnableHighLight,
        );
        await rtcEngine.startScreenCaptureByDisplayId(
          displayId: displayId,
          regionRect: regionRect,
          captureParams: captureParams,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.startScreenCaptureByDisplayId] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.startScreenCaptureByScreenRect',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        int screenRectX = 5;
        int screenRectY = 5;
        int screenRectWidth = 5;
        int screenRectHeight = 5;
        Rectangle screenRect = Rectangle(
          x: screenRectX,
          y: screenRectY,
          width: screenRectWidth,
          height: screenRectHeight,
        );
        int regionRectX = 5;
        int regionRectY = 5;
        int regionRectWidth = 5;
        int regionRectHeight = 5;
        Rectangle regionRect = Rectangle(
          x: regionRectX,
          y: regionRectY,
          width: regionRectWidth,
          height: regionRectHeight,
        );
        int dimensionsWidth = 5;
        int dimensionsHeight = 5;
        VideoDimensions captureParamsDimensions = VideoDimensions(
          width: dimensionsWidth,
          height: dimensionsHeight,
        );
        int captureParamsFrameRate = 5;
        int captureParamsBitrate = 5;
        bool captureParamsCaptureMouseCursor = true;
        bool captureParamsWindowFocus = true;
        List<int> captureParamsExcludeWindowList = List.filled(5, 5);
        int captureParamsExcludeWindowCount = 5;
        int captureParamsHighLightWidth = 5;
        int captureParamsHighLightColor = 5;
        bool captureParamsEnableHighLight = true;
        ScreenCaptureParameters captureParams = ScreenCaptureParameters(
          dimensions: captureParamsDimensions,
          frameRate: captureParamsFrameRate,
          bitrate: captureParamsBitrate,
          captureMouseCursor: captureParamsCaptureMouseCursor,
          windowFocus: captureParamsWindowFocus,
          excludeWindowList: captureParamsExcludeWindowList,
          excludeWindowCount: captureParamsExcludeWindowCount,
          highLightWidth: captureParamsHighLightWidth,
          highLightColor: captureParamsHighLightColor,
          enableHighLight: captureParamsEnableHighLight,
        );
        await rtcEngine.startScreenCaptureByScreenRect(
          screenRect: screenRect,
          regionRect: regionRect,
          captureParams: captureParams,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.startScreenCaptureByScreenRect] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.getAudioDeviceInfo',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        await rtcEngine.getAudioDeviceInfo();
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.getAudioDeviceInfo] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.startScreenCaptureByWindowId',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        int windowId = 5;
        int regionRectX = 5;
        int regionRectY = 5;
        int regionRectWidth = 5;
        int regionRectHeight = 5;
        Rectangle regionRect = Rectangle(
          x: regionRectX,
          y: regionRectY,
          width: regionRectWidth,
          height: regionRectHeight,
        );
        int dimensionsWidth = 5;
        int dimensionsHeight = 5;
        VideoDimensions captureParamsDimensions = VideoDimensions(
          width: dimensionsWidth,
          height: dimensionsHeight,
        );
        int captureParamsFrameRate = 5;
        int captureParamsBitrate = 5;
        bool captureParamsCaptureMouseCursor = true;
        bool captureParamsWindowFocus = true;
        List<int> captureParamsExcludeWindowList = List.filled(5, 5);
        int captureParamsExcludeWindowCount = 5;
        int captureParamsHighLightWidth = 5;
        int captureParamsHighLightColor = 5;
        bool captureParamsEnableHighLight = true;
        ScreenCaptureParameters captureParams = ScreenCaptureParameters(
          dimensions: captureParamsDimensions,
          frameRate: captureParamsFrameRate,
          bitrate: captureParamsBitrate,
          captureMouseCursor: captureParamsCaptureMouseCursor,
          windowFocus: captureParamsWindowFocus,
          excludeWindowList: captureParamsExcludeWindowList,
          excludeWindowCount: captureParamsExcludeWindowCount,
          highLightWidth: captureParamsHighLightWidth,
          highLightColor: captureParamsHighLightColor,
          enableHighLight: captureParamsEnableHighLight,
        );
        await rtcEngine.startScreenCaptureByWindowId(
          windowId: windowId,
          regionRect: regionRect,
          captureParams: captureParams,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.startScreenCaptureByWindowId] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.setScreenCaptureContentHint',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        VideoContentHint contentHint = VideoContentHint.contentHintNone;
        await rtcEngine.setScreenCaptureContentHint(
          contentHint,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.setScreenCaptureContentHint] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.updateScreenCaptureRegion',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        int regionRectX = 5;
        int regionRectY = 5;
        int regionRectWidth = 5;
        int regionRectHeight = 5;
        Rectangle regionRect = Rectangle(
          x: regionRectX,
          y: regionRectY,
          width: regionRectWidth,
          height: regionRectHeight,
        );
        await rtcEngine.updateScreenCaptureRegion(
          regionRect,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.updateScreenCaptureRegion] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.updateScreenCaptureParameters',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        int dimensionsWidth = 5;
        int dimensionsHeight = 5;
        VideoDimensions captureParamsDimensions = VideoDimensions(
          width: dimensionsWidth,
          height: dimensionsHeight,
        );
        int captureParamsFrameRate = 5;
        int captureParamsBitrate = 5;
        bool captureParamsCaptureMouseCursor = true;
        bool captureParamsWindowFocus = true;
        List<int> captureParamsExcludeWindowList = List.filled(5, 5);
        int captureParamsExcludeWindowCount = 5;
        int captureParamsHighLightWidth = 5;
        int captureParamsHighLightColor = 5;
        bool captureParamsEnableHighLight = true;
        ScreenCaptureParameters captureParams = ScreenCaptureParameters(
          dimensions: captureParamsDimensions,
          frameRate: captureParamsFrameRate,
          bitrate: captureParamsBitrate,
          captureMouseCursor: captureParamsCaptureMouseCursor,
          windowFocus: captureParamsWindowFocus,
          excludeWindowList: captureParamsExcludeWindowList,
          excludeWindowCount: captureParamsExcludeWindowCount,
          highLightWidth: captureParamsHighLightWidth,
          highLightColor: captureParamsHighLightColor,
          enableHighLight: captureParamsEnableHighLight,
        );
        await rtcEngine.updateScreenCaptureParameters(
          captureParams,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.updateScreenCaptureParameters] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.startScreenCapture',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        int audioParamsSampleRate = 5;
        int audioParamsChannels = 5;
        int audioParamsCaptureSignalVolume = 5;
        ScreenAudioParameters captureParamsAudioParams = ScreenAudioParameters(
          sampleRate: audioParamsSampleRate,
          channels: audioParamsChannels,
          captureSignalVolume: audioParamsCaptureSignalVolume,
        );
        int dimensionsWidth = 5;
        int dimensionsHeight = 5;
        VideoDimensions videoParamsDimensions = VideoDimensions(
          width: dimensionsWidth,
          height: dimensionsHeight,
        );
        VideoContentHint videoParamsContentHint =
            VideoContentHint.contentHintNone;
        int videoParamsFrameRate = 5;
        int videoParamsBitrate = 5;
        ScreenVideoParameters captureParamsVideoParams = ScreenVideoParameters(
          dimensions: videoParamsDimensions,
          frameRate: videoParamsFrameRate,
          bitrate: videoParamsBitrate,
          contentHint: videoParamsContentHint,
        );
        bool captureParamsCaptureAudio = true;
        bool captureParamsCaptureVideo = true;
        ScreenCaptureParameters2 captureParams = ScreenCaptureParameters2(
          captureAudio: captureParamsCaptureAudio,
          audioParams: captureParamsAudioParams,
          captureVideo: captureParamsCaptureVideo,
          videoParams: captureParamsVideoParams,
        );
        await rtcEngine.startScreenCapture(
          captureParams,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.startScreenCapture] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.updateScreenCapture',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        int audioParamsSampleRate = 5;
        int audioParamsChannels = 5;
        int audioParamsCaptureSignalVolume = 5;
        ScreenAudioParameters captureParamsAudioParams = ScreenAudioParameters(
          sampleRate: audioParamsSampleRate,
          channels: audioParamsChannels,
          captureSignalVolume: audioParamsCaptureSignalVolume,
        );
        int dimensionsWidth = 5;
        int dimensionsHeight = 5;
        VideoDimensions videoParamsDimensions = VideoDimensions(
          width: dimensionsWidth,
          height: dimensionsHeight,
        );
        VideoContentHint videoParamsContentHint =
            VideoContentHint.contentHintNone;
        int videoParamsFrameRate = 5;
        int videoParamsBitrate = 5;
        ScreenVideoParameters captureParamsVideoParams = ScreenVideoParameters(
          dimensions: videoParamsDimensions,
          frameRate: videoParamsFrameRate,
          bitrate: videoParamsBitrate,
          contentHint: videoParamsContentHint,
        );
        bool captureParamsCaptureAudio = true;
        bool captureParamsCaptureVideo = true;
        ScreenCaptureParameters2 captureParams = ScreenCaptureParameters2(
          captureAudio: captureParamsCaptureAudio,
          audioParams: captureParamsAudioParams,
          captureVideo: captureParamsCaptureVideo,
          videoParams: captureParamsVideoParams,
        );
        await rtcEngine.updateScreenCapture(
          captureParams,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.updateScreenCapture] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.queryScreenCaptureCapability',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        await rtcEngine.queryScreenCaptureCapability();
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.queryScreenCaptureCapability] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.queryCameraFocalLengthCapability',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        await rtcEngine.queryCameraFocalLengthCapability();
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.queryCameraFocalLengthCapability] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.setExternalMediaProjection',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        int mediaProjection = 5;
        await rtcEngine.setExternalMediaProjection(
          mediaProjection,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.setExternalMediaProjection] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.setScreenCaptureScenario',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        ScreenScenarioType screenScenario =
            ScreenScenarioType.screenScenarioDocument;
        await rtcEngine.setScreenCaptureScenario(
          screenScenario,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.setScreenCaptureScenario] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.stopScreenCapture',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        await rtcEngine.stopScreenCapture();
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.stopScreenCapture] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.getCallId',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        await rtcEngine.getCallId();
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.getCallId] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.rate',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        String callId = "hello";
        int rating = 5;
        String description = "hello";
        await rtcEngine.rate(
          callId: callId,
          rating: rating,
          description: description,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.rate] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.complain',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        String callId = "hello";
        String description = "hello";
        await rtcEngine.complain(
          callId: callId,
          description: description,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.complain] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.startRtmpStreamWithoutTranscoding',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        String url = "hello";
        await rtcEngine.startRtmpStreamWithoutTranscoding(
          url,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.startRtmpStreamWithoutTranscoding] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.startRtmpStreamWithTranscoding',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        String url = "hello";
        VideoCodecProfileType transcodingVideoCodecProfile =
            VideoCodecProfileType.videoCodecProfileBaseline;
        VideoCodecTypeForStream transcodingVideoCodecType =
            VideoCodecTypeForStream.videoCodecH264ForStream;
        AudioSampleRateType transcodingAudioSampleRate =
            AudioSampleRateType.audioSampleRate32000;
        AudioCodecProfileType transcodingAudioCodecProfile =
            AudioCodecProfileType.audioCodecProfileLcAac;
        int transcodingWidth = 5;
        int transcodingHeight = 5;
        int transcodingVideoBitrate = 5;
        int transcodingVideoFramerate = 5;
        bool transcodingLowLatency = true;
        int transcodingVideoGop = 5;
        int transcodingBackgroundColor = 5;
        int transcodingUserCount = 5;
        List<TranscodingUser> transcodingTranscodingUsers = [];
        String transcodingTranscodingExtraInfo = "hello";
        String transcodingMetadata = "hello";
        List<RtcImage> transcodingWatermark = [];
        int transcodingWatermarkCount = 5;
        List<RtcImage> transcodingBackgroundImage = [];
        int transcodingBackgroundImageCount = 5;
        int transcodingAudioBitrate = 5;
        int transcodingAudioChannels = 5;
        List<LiveStreamAdvancedFeature> transcodingAdvancedFeatures = [];
        int transcodingAdvancedFeatureCount = 5;
        LiveTranscoding transcoding = LiveTranscoding(
          width: transcodingWidth,
          height: transcodingHeight,
          videoBitrate: transcodingVideoBitrate,
          videoFramerate: transcodingVideoFramerate,
          lowLatency: transcodingLowLatency,
          videoGop: transcodingVideoGop,
          videoCodecProfile: transcodingVideoCodecProfile,
          backgroundColor: transcodingBackgroundColor,
          videoCodecType: transcodingVideoCodecType,
          userCount: transcodingUserCount,
          transcodingUsers: transcodingTranscodingUsers,
          transcodingExtraInfo: transcodingTranscodingExtraInfo,
          metadata: transcodingMetadata,
          watermark: transcodingWatermark,
          watermarkCount: transcodingWatermarkCount,
          backgroundImage: transcodingBackgroundImage,
          backgroundImageCount: transcodingBackgroundImageCount,
          audioSampleRate: transcodingAudioSampleRate,
          audioBitrate: transcodingAudioBitrate,
          audioChannels: transcodingAudioChannels,
          audioCodecProfile: transcodingAudioCodecProfile,
          advancedFeatures: transcodingAdvancedFeatures,
          advancedFeatureCount: transcodingAdvancedFeatureCount,
        );
        await rtcEngine.startRtmpStreamWithTranscoding(
          url: url,
          transcoding: transcoding,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.startRtmpStreamWithTranscoding] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.updateRtmpTranscoding',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        VideoCodecProfileType transcodingVideoCodecProfile =
            VideoCodecProfileType.videoCodecProfileBaseline;
        VideoCodecTypeForStream transcodingVideoCodecType =
            VideoCodecTypeForStream.videoCodecH264ForStream;
        AudioSampleRateType transcodingAudioSampleRate =
            AudioSampleRateType.audioSampleRate32000;
        AudioCodecProfileType transcodingAudioCodecProfile =
            AudioCodecProfileType.audioCodecProfileLcAac;
        int transcodingWidth = 5;
        int transcodingHeight = 5;
        int transcodingVideoBitrate = 5;
        int transcodingVideoFramerate = 5;
        bool transcodingLowLatency = true;
        int transcodingVideoGop = 5;
        int transcodingBackgroundColor = 5;
        int transcodingUserCount = 5;
        List<TranscodingUser> transcodingTranscodingUsers = [];
        String transcodingTranscodingExtraInfo = "hello";
        String transcodingMetadata = "hello";
        List<RtcImage> transcodingWatermark = [];
        int transcodingWatermarkCount = 5;
        List<RtcImage> transcodingBackgroundImage = [];
        int transcodingBackgroundImageCount = 5;
        int transcodingAudioBitrate = 5;
        int transcodingAudioChannels = 5;
        List<LiveStreamAdvancedFeature> transcodingAdvancedFeatures = [];
        int transcodingAdvancedFeatureCount = 5;
        LiveTranscoding transcoding = LiveTranscoding(
          width: transcodingWidth,
          height: transcodingHeight,
          videoBitrate: transcodingVideoBitrate,
          videoFramerate: transcodingVideoFramerate,
          lowLatency: transcodingLowLatency,
          videoGop: transcodingVideoGop,
          videoCodecProfile: transcodingVideoCodecProfile,
          backgroundColor: transcodingBackgroundColor,
          videoCodecType: transcodingVideoCodecType,
          userCount: transcodingUserCount,
          transcodingUsers: transcodingTranscodingUsers,
          transcodingExtraInfo: transcodingTranscodingExtraInfo,
          metadata: transcodingMetadata,
          watermark: transcodingWatermark,
          watermarkCount: transcodingWatermarkCount,
          backgroundImage: transcodingBackgroundImage,
          backgroundImageCount: transcodingBackgroundImageCount,
          audioSampleRate: transcodingAudioSampleRate,
          audioBitrate: transcodingAudioBitrate,
          audioChannels: transcodingAudioChannels,
          audioCodecProfile: transcodingAudioCodecProfile,
          advancedFeatures: transcodingAdvancedFeatures,
          advancedFeatureCount: transcodingAdvancedFeatureCount,
        );
        await rtcEngine.updateRtmpTranscoding(
          transcoding,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.updateRtmpTranscoding] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.startLocalVideoTranscoder',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        VideoCodecType videoOutputConfigurationCodecType =
            VideoCodecType.videoCodecNone;
        int dimensionsWidth = 5;
        int dimensionsHeight = 5;
        VideoDimensions videoOutputConfigurationDimensions = VideoDimensions(
          width: dimensionsWidth,
          height: dimensionsHeight,
        );
        OrientationMode videoOutputConfigurationOrientationMode =
            OrientationMode.orientationModeAdaptive;
        DegradationPreference videoOutputConfigurationDegradationPreference =
            DegradationPreference.maintainAuto;
        VideoMirrorModeType videoOutputConfigurationMirrorMode =
            VideoMirrorModeType.videoMirrorModeAuto;
        EncodingPreference advanceOptionsEncodingPreference =
            EncodingPreference.preferAuto;
        CompressionPreference advanceOptionsCompressionPreference =
            CompressionPreference.preferCompressionAuto;
        bool advanceOptionsEncodeAlpha = true;
        AdvanceOptions videoOutputConfigurationAdvanceOptions = AdvanceOptions(
          encodingPreference: advanceOptionsEncodingPreference,
          compressionPreference: advanceOptionsCompressionPreference,
          encodeAlpha: advanceOptionsEncodeAlpha,
        );
        int videoOutputConfigurationFrameRate = 5;
        int videoOutputConfigurationBitrate = 5;
        int videoOutputConfigurationMinBitrate = 5;
        VideoEncoderConfiguration configVideoOutputConfiguration =
            VideoEncoderConfiguration(
          codecType: videoOutputConfigurationCodecType,
          dimensions: videoOutputConfigurationDimensions,
          frameRate: videoOutputConfigurationFrameRate,
          bitrate: videoOutputConfigurationBitrate,
          minBitrate: videoOutputConfigurationMinBitrate,
          orientationMode: videoOutputConfigurationOrientationMode,
          degradationPreference: videoOutputConfigurationDegradationPreference,
          mirrorMode: videoOutputConfigurationMirrorMode,
          advanceOptions: videoOutputConfigurationAdvanceOptions,
        );
        int configStreamCount = 5;
        List<TranscodingVideoStream> configVideoInputStreams = [];
        bool configSyncWithPrimaryCamera = true;
        LocalTranscoderConfiguration config = LocalTranscoderConfiguration(
          streamCount: configStreamCount,
          videoInputStreams: configVideoInputStreams,
          videoOutputConfiguration: configVideoOutputConfiguration,
          syncWithPrimaryCamera: configSyncWithPrimaryCamera,
        );
        await rtcEngine.startLocalVideoTranscoder(
          config,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.startLocalVideoTranscoder] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.updateLocalTranscoderConfiguration',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        VideoCodecType videoOutputConfigurationCodecType =
            VideoCodecType.videoCodecNone;
        int dimensionsWidth = 5;
        int dimensionsHeight = 5;
        VideoDimensions videoOutputConfigurationDimensions = VideoDimensions(
          width: dimensionsWidth,
          height: dimensionsHeight,
        );
        OrientationMode videoOutputConfigurationOrientationMode =
            OrientationMode.orientationModeAdaptive;
        DegradationPreference videoOutputConfigurationDegradationPreference =
            DegradationPreference.maintainAuto;
        VideoMirrorModeType videoOutputConfigurationMirrorMode =
            VideoMirrorModeType.videoMirrorModeAuto;
        EncodingPreference advanceOptionsEncodingPreference =
            EncodingPreference.preferAuto;
        CompressionPreference advanceOptionsCompressionPreference =
            CompressionPreference.preferCompressionAuto;
        bool advanceOptionsEncodeAlpha = true;
        AdvanceOptions videoOutputConfigurationAdvanceOptions = AdvanceOptions(
          encodingPreference: advanceOptionsEncodingPreference,
          compressionPreference: advanceOptionsCompressionPreference,
          encodeAlpha: advanceOptionsEncodeAlpha,
        );
        int videoOutputConfigurationFrameRate = 5;
        int videoOutputConfigurationBitrate = 5;
        int videoOutputConfigurationMinBitrate = 5;
        VideoEncoderConfiguration configVideoOutputConfiguration =
            VideoEncoderConfiguration(
          codecType: videoOutputConfigurationCodecType,
          dimensions: videoOutputConfigurationDimensions,
          frameRate: videoOutputConfigurationFrameRate,
          bitrate: videoOutputConfigurationBitrate,
          minBitrate: videoOutputConfigurationMinBitrate,
          orientationMode: videoOutputConfigurationOrientationMode,
          degradationPreference: videoOutputConfigurationDegradationPreference,
          mirrorMode: videoOutputConfigurationMirrorMode,
          advanceOptions: videoOutputConfigurationAdvanceOptions,
        );
        int configStreamCount = 5;
        List<TranscodingVideoStream> configVideoInputStreams = [];
        bool configSyncWithPrimaryCamera = true;
        LocalTranscoderConfiguration config = LocalTranscoderConfiguration(
          streamCount: configStreamCount,
          videoInputStreams: configVideoInputStreams,
          videoOutputConfiguration: configVideoOutputConfiguration,
          syncWithPrimaryCamera: configSyncWithPrimaryCamera,
        );
        await rtcEngine.updateLocalTranscoderConfiguration(
          config,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.updateLocalTranscoderConfiguration] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.stopRtmpStream',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        String url = "hello";
        await rtcEngine.stopRtmpStream(
          url,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.stopRtmpStream] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.stopLocalVideoTranscoder',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        await rtcEngine.stopLocalVideoTranscoder();
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.stopLocalVideoTranscoder] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.startLocalAudioMixer',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        int configStreamCount = 5;
        List<MixedAudioStream> configAudioInputStreams = [];
        bool configSyncWithLocalMic = true;
        LocalAudioMixerConfiguration config = LocalAudioMixerConfiguration(
          streamCount: configStreamCount,
          audioInputStreams: configAudioInputStreams,
          syncWithLocalMic: configSyncWithLocalMic,
        );
        await rtcEngine.startLocalAudioMixer(
          config,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.startLocalAudioMixer] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.updateLocalAudioMixerConfiguration',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        int configStreamCount = 5;
        List<MixedAudioStream> configAudioInputStreams = [];
        bool configSyncWithLocalMic = true;
        LocalAudioMixerConfiguration config = LocalAudioMixerConfiguration(
          streamCount: configStreamCount,
          audioInputStreams: configAudioInputStreams,
          syncWithLocalMic: configSyncWithLocalMic,
        );
        await rtcEngine.updateLocalAudioMixerConfiguration(
          config,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.updateLocalAudioMixerConfiguration] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.stopLocalAudioMixer',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        await rtcEngine.stopLocalAudioMixer();
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.stopLocalAudioMixer] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.startCameraCapture',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        VideoSourceType sourceType = VideoSourceType.videoSourceCameraPrimary;
        CameraDirection configCameraDirection = CameraDirection.cameraRear;
        CameraFocalLengthType configCameraFocalLengthType =
            CameraFocalLengthType.cameraFocalLengthDefault;
        int formatWidth = 5;
        int formatHeight = 5;
        int formatFps = 5;
        VideoFormat configFormat = VideoFormat(
          width: formatWidth,
          height: formatHeight,
          fps: formatFps,
        );
        String configDeviceId = "hello";
        String configCameraId = "hello";
        bool configFollowEncodeDimensionRatio = true;
        CameraCapturerConfiguration config = CameraCapturerConfiguration(
          cameraDirection: configCameraDirection,
          cameraFocalLengthType: configCameraFocalLengthType,
          deviceId: configDeviceId,
          cameraId: configCameraId,
          followEncodeDimensionRatio: configFollowEncodeDimensionRatio,
          format: configFormat,
        );
        await rtcEngine.startCameraCapture(
          sourceType: sourceType,
          config: config,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.startCameraCapture] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.stopCameraCapture',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        VideoSourceType sourceType = VideoSourceType.videoSourceCameraPrimary;
        await rtcEngine.stopCameraCapture(
          sourceType,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.stopCameraCapture] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.setCameraDeviceOrientation',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        VideoSourceType type = VideoSourceType.videoSourceCameraPrimary;
        VideoOrientation orientation = VideoOrientation.videoOrientation0;
        await rtcEngine.setCameraDeviceOrientation(
          type: type,
          orientation: orientation,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.setCameraDeviceOrientation] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.setScreenCaptureOrientation',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        VideoSourceType type = VideoSourceType.videoSourceCameraPrimary;
        VideoOrientation orientation = VideoOrientation.videoOrientation0;
        await rtcEngine.setScreenCaptureOrientation(
          type: type,
          orientation: orientation,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.setScreenCaptureOrientation] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.getConnectionState',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        await rtcEngine.getConnectionState();
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.getConnectionState] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.registerEventHandler',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        RtcEngineEventHandler eventHandler = RtcEngineEventHandler(
          onJoinChannelSuccess: (RtcConnection connection, int elapsed) {},
          onRejoinChannelSuccess: (RtcConnection connection, int elapsed) {},
          onProxyConnected: (String channel, int uid, ProxyType proxyType,
              String localProxyIp, int elapsed) {},
          onError: (ErrorCodeType err, String msg) {},
          onAudioQuality: (RtcConnection connection, int remoteUid,
              QualityType quality, int delay, int lost) {},
          onLastmileProbeResult: (LastmileProbeResult result) {},
          onAudioVolumeIndication: (RtcConnection connection, List speakers,
              int speakerNumber, int totalVolume) {},
          onLeaveChannel: (RtcConnection connection, RtcStats stats) {},
          onRtcStats: (RtcConnection connection, RtcStats stats) {},
          onAudioDeviceStateChanged: (String deviceId,
              MediaDeviceType deviceType, MediaDeviceStateType deviceState) {},
          onAudioMixingPositionChanged: (int position) {},
          onAudioMixingFinished: () {},
          onAudioEffectFinished: (int soundId) {},
          onVideoDeviceStateChanged: (String deviceId,
              MediaDeviceType deviceType, MediaDeviceStateType deviceState) {},
          onNetworkQuality: (RtcConnection connection, int remoteUid,
              QualityType txQuality, QualityType rxQuality) {},
          onIntraRequestReceived: (RtcConnection connection) {},
          onUplinkNetworkInfoUpdated: (UplinkNetworkInfo info) {},
          onDownlinkNetworkInfoUpdated: (DownlinkNetworkInfo info) {},
          onLastmileQuality: (QualityType quality) {},
          onFirstLocalVideoFrame:
              (VideoSourceType source, int width, int height, int elapsed) {},
          onFirstLocalVideoFramePublished:
              (RtcConnection connection, int elapsed) {},
          onFirstRemoteVideoDecoded: (RtcConnection connection, int remoteUid,
              int width, int height, int elapsed) {},
          onVideoSizeChanged: (RtcConnection connection,
              VideoSourceType sourceType,
              int uid,
              int width,
              int height,
              int rotation) {},
          onLocalVideoStateChanged: (VideoSourceType source,
              LocalVideoStreamState state, LocalVideoStreamReason reason) {},
          onRemoteVideoStateChanged: (RtcConnection connection,
              int remoteUid,
              RemoteVideoState state,
              RemoteVideoStateReason reason,
              int elapsed) {},
          onFirstRemoteVideoFrame: (RtcConnection connection, int remoteUid,
              int width, int height, int elapsed) {},
          onUserJoined:
              (RtcConnection connection, int remoteUid, int elapsed) {},
          onUserOffline: (RtcConnection connection, int remoteUid,
              UserOfflineReasonType reason) {},
          onUserMuteAudio:
              (RtcConnection connection, int remoteUid, bool muted) {},
          onUserMuteVideo:
              (RtcConnection connection, int remoteUid, bool muted) {},
          onUserEnableVideo:
              (RtcConnection connection, int remoteUid, bool enabled) {},
          onUserStateChanged:
              (RtcConnection connection, int remoteUid, int state) {},
          onUserEnableLocalVideo:
              (RtcConnection connection, int remoteUid, bool enabled) {},
          onRemoteAudioStats:
              (RtcConnection connection, RemoteAudioStats stats) {},
          onLocalAudioStats:
              (RtcConnection connection, LocalAudioStats stats) {},
          onLocalVideoStats:
              (RtcConnection connection, LocalVideoStats stats) {},
          onRemoteVideoStats:
              (RtcConnection connection, RemoteVideoStats stats) {},
          onCameraReady: () {},
          onCameraFocusAreaChanged: (int x, int y, int width, int height) {},
          onCameraExposureAreaChanged: (int x, int y, int width, int height) {},
          onFacePositionChanged: (int imageWidth, int imageHeight,
              List vecRectangle, List vecDistance, int numFaces) {},
          onVideoStopped: () {},
          onAudioMixingStateChanged:
              (AudioMixingStateType state, AudioMixingReasonType reason) {},
          onRhythmPlayerStateChanged:
              (RhythmPlayerStateType state, RhythmPlayerReason reason) {},
          onConnectionLost: (RtcConnection connection) {},
          onConnectionInterrupted: (RtcConnection connection) {},
          onConnectionBanned: (RtcConnection connection) {},
          onStreamMessage: (RtcConnection connection, int remoteUid,
              int streamId, Uint8List data, int length, int sentTs) {},
          onStreamMessageError: (RtcConnection connection, int remoteUid,
              int streamId, ErrorCodeType code, int missed, int cached) {},
          onRequestToken: (RtcConnection connection) {},
          onTokenPrivilegeWillExpire:
              (RtcConnection connection, String token) {},
          onLicenseValidationFailure:
              (RtcConnection connection, LicenseErrorType reason) {},
          onFirstLocalAudioFramePublished:
              (RtcConnection connection, int elapsed) {},
          onFirstRemoteAudioDecoded:
              (RtcConnection connection, int uid, int elapsed) {},
          onFirstRemoteAudioFrame:
              (RtcConnection connection, int userId, int elapsed) {},
          onLocalAudioStateChanged: (RtcConnection connection,
              LocalAudioStreamState state, LocalAudioStreamReason reason) {},
          onRemoteAudioStateChanged: (RtcConnection connection,
              int remoteUid,
              RemoteAudioState state,
              RemoteAudioStateReason reason,
              int elapsed) {},
          onActiveSpeaker: (RtcConnection connection, int uid) {},
          onContentInspectResult: (ContentInspectResult result) {},
          onSnapshotTaken: (RtcConnection connection, int uid, String filePath,
              int width, int height, int errCode) {},
          onClientRoleChanged: (RtcConnection connection,
              ClientRoleType oldRole,
              ClientRoleType newRole,
              ClientRoleOptions newRoleOptions) {},
          onClientRoleChangeFailed: (RtcConnection connection,
              ClientRoleChangeFailedReason reason,
              ClientRoleType currentRole) {},
          onAudioDeviceVolumeChanged:
              (MediaDeviceType deviceType, int volume, bool muted) {},
          onRtmpStreamingStateChanged: (String url,
              RtmpStreamPublishState state, RtmpStreamPublishReason reason) {},
          onRtmpStreamingEvent: (String url, RtmpStreamingEvent eventCode) {},
          onTranscodingUpdated: () {},
          onAudioRoutingChanged: (int routing) {},
          onChannelMediaRelayStateChanged:
              (ChannelMediaRelayState state, ChannelMediaRelayError code) {},
          onLocalPublishFallbackToAudioOnly: (bool isFallbackOrRecover) {},
          onRemoteSubscribeFallbackToAudioOnly:
              (int uid, bool isFallbackOrRecover) {},
          onRemoteAudioTransportStats: (RtcConnection connection, int remoteUid,
              int delay, int lost, int rxKBitRate) {},
          onRemoteVideoTransportStats: (RtcConnection connection, int remoteUid,
              int delay, int lost, int rxKBitRate) {},
          onConnectionStateChanged: (RtcConnection connection,
              ConnectionStateType state, ConnectionChangedReasonType reason) {},
          onWlAccMessage: (RtcConnection connection, WlaccMessageReason reason,
              WlaccSuggestAction action, String wlAccMsg) {},
          onWlAccStats: (RtcConnection connection, WlAccStats currentStats,
              WlAccStats averageStats) {},
          onNetworkTypeChanged: (RtcConnection connection, NetworkType type) {},
          onEncryptionError:
              (RtcConnection connection, EncryptionErrorType errorType) {},
          onPermissionError: (PermissionType permissionType) {},
          onLocalUserRegistered: (int uid, String userAccount) {},
          onUserInfoUpdated: (int uid, UserInfo info) {},
          onUserAccountUpdated: (RtcConnection connection, int remoteUid,
              String remoteUserAccount) {},
          onVideoRenderingTracingResult: (RtcConnection connection,
              int uid,
              MediaTraceEvent currentEvent,
              VideoRenderingTracingInfo tracingInfo) {},
          onLocalVideoTranscoderError:
              (TranscodingVideoStream stream, VideoTranscoderError error) {},
          onUploadLogResult: (RtcConnection connection, String requestId,
              bool success, UploadErrorReason reason) {},
          onAudioSubscribeStateChanged: (String channel,
              int uid,
              StreamSubscribeState oldState,
              StreamSubscribeState newState,
              int elapseSinceLastState) {},
          onVideoSubscribeStateChanged: (String channel,
              int uid,
              StreamSubscribeState oldState,
              StreamSubscribeState newState,
              int elapseSinceLastState) {},
          onAudioPublishStateChanged: (String channel,
              StreamPublishState oldState,
              StreamPublishState newState,
              int elapseSinceLastState) {},
          onVideoPublishStateChanged: (VideoSourceType source,
              String channel,
              StreamPublishState oldState,
              StreamPublishState newState,
              int elapseSinceLastState) {},
          onTranscodedStreamLayoutInfo: (RtcConnection connection, int uid,
              int width, int height, int layoutCount, List layoutlist) {},
          onAudioMetadataReceived: (RtcConnection connection, int uid,
              Uint8List metadata, int length) {},
          onExtensionEventWithContext:
              (ExtensionContext context, String key, String value) {},
          onExtensionStartedWithContext: (ExtensionContext context) {},
          onExtensionStoppedWithContext: (ExtensionContext context) {},
          onExtensionErrorWithContext:
              (ExtensionContext context, int error, String message) {},
          onSetRtmFlagResult: (RtcConnection connection, int code) {},
        );
        rtcEngine.registerEventHandler(
          eventHandler,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.registerEventHandler] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.unregisterEventHandler',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        RtcEngineEventHandler eventHandler = RtcEngineEventHandler(
          onJoinChannelSuccess: (RtcConnection connection, int elapsed) {},
          onRejoinChannelSuccess: (RtcConnection connection, int elapsed) {},
          onProxyConnected: (String channel, int uid, ProxyType proxyType,
              String localProxyIp, int elapsed) {},
          onError: (ErrorCodeType err, String msg) {},
          onAudioQuality: (RtcConnection connection, int remoteUid,
              QualityType quality, int delay, int lost) {},
          onLastmileProbeResult: (LastmileProbeResult result) {},
          onAudioVolumeIndication: (RtcConnection connection, List speakers,
              int speakerNumber, int totalVolume) {},
          onLeaveChannel: (RtcConnection connection, RtcStats stats) {},
          onRtcStats: (RtcConnection connection, RtcStats stats) {},
          onAudioDeviceStateChanged: (String deviceId,
              MediaDeviceType deviceType, MediaDeviceStateType deviceState) {},
          onAudioMixingPositionChanged: (int position) {},
          onAudioMixingFinished: () {},
          onAudioEffectFinished: (int soundId) {},
          onVideoDeviceStateChanged: (String deviceId,
              MediaDeviceType deviceType, MediaDeviceStateType deviceState) {},
          onNetworkQuality: (RtcConnection connection, int remoteUid,
              QualityType txQuality, QualityType rxQuality) {},
          onIntraRequestReceived: (RtcConnection connection) {},
          onUplinkNetworkInfoUpdated: (UplinkNetworkInfo info) {},
          onDownlinkNetworkInfoUpdated: (DownlinkNetworkInfo info) {},
          onLastmileQuality: (QualityType quality) {},
          onFirstLocalVideoFrame:
              (VideoSourceType source, int width, int height, int elapsed) {},
          onFirstLocalVideoFramePublished:
              (RtcConnection connection, int elapsed) {},
          onFirstRemoteVideoDecoded: (RtcConnection connection, int remoteUid,
              int width, int height, int elapsed) {},
          onVideoSizeChanged: (RtcConnection connection,
              VideoSourceType sourceType,
              int uid,
              int width,
              int height,
              int rotation) {},
          onLocalVideoStateChanged: (VideoSourceType source,
              LocalVideoStreamState state, LocalVideoStreamReason reason) {},
          onRemoteVideoStateChanged: (RtcConnection connection,
              int remoteUid,
              RemoteVideoState state,
              RemoteVideoStateReason reason,
              int elapsed) {},
          onFirstRemoteVideoFrame: (RtcConnection connection, int remoteUid,
              int width, int height, int elapsed) {},
          onUserJoined:
              (RtcConnection connection, int remoteUid, int elapsed) {},
          onUserOffline: (RtcConnection connection, int remoteUid,
              UserOfflineReasonType reason) {},
          onUserMuteAudio:
              (RtcConnection connection, int remoteUid, bool muted) {},
          onUserMuteVideo:
              (RtcConnection connection, int remoteUid, bool muted) {},
          onUserEnableVideo:
              (RtcConnection connection, int remoteUid, bool enabled) {},
          onUserStateChanged:
              (RtcConnection connection, int remoteUid, int state) {},
          onUserEnableLocalVideo:
              (RtcConnection connection, int remoteUid, bool enabled) {},
          onRemoteAudioStats:
              (RtcConnection connection, RemoteAudioStats stats) {},
          onLocalAudioStats:
              (RtcConnection connection, LocalAudioStats stats) {},
          onLocalVideoStats:
              (RtcConnection connection, LocalVideoStats stats) {},
          onRemoteVideoStats:
              (RtcConnection connection, RemoteVideoStats stats) {},
          onCameraReady: () {},
          onCameraFocusAreaChanged: (int x, int y, int width, int height) {},
          onCameraExposureAreaChanged: (int x, int y, int width, int height) {},
          onFacePositionChanged: (int imageWidth, int imageHeight,
              List vecRectangle, List vecDistance, int numFaces) {},
          onVideoStopped: () {},
          onAudioMixingStateChanged:
              (AudioMixingStateType state, AudioMixingReasonType reason) {},
          onRhythmPlayerStateChanged:
              (RhythmPlayerStateType state, RhythmPlayerReason reason) {},
          onConnectionLost: (RtcConnection connection) {},
          onConnectionInterrupted: (RtcConnection connection) {},
          onConnectionBanned: (RtcConnection connection) {},
          onStreamMessage: (RtcConnection connection, int remoteUid,
              int streamId, Uint8List data, int length, int sentTs) {},
          onStreamMessageError: (RtcConnection connection, int remoteUid,
              int streamId, ErrorCodeType code, int missed, int cached) {},
          onRequestToken: (RtcConnection connection) {},
          onTokenPrivilegeWillExpire:
              (RtcConnection connection, String token) {},
          onLicenseValidationFailure:
              (RtcConnection connection, LicenseErrorType reason) {},
          onFirstLocalAudioFramePublished:
              (RtcConnection connection, int elapsed) {},
          onFirstRemoteAudioDecoded:
              (RtcConnection connection, int uid, int elapsed) {},
          onFirstRemoteAudioFrame:
              (RtcConnection connection, int userId, int elapsed) {},
          onLocalAudioStateChanged: (RtcConnection connection,
              LocalAudioStreamState state, LocalAudioStreamReason reason) {},
          onRemoteAudioStateChanged: (RtcConnection connection,
              int remoteUid,
              RemoteAudioState state,
              RemoteAudioStateReason reason,
              int elapsed) {},
          onActiveSpeaker: (RtcConnection connection, int uid) {},
          onContentInspectResult: (ContentInspectResult result) {},
          onSnapshotTaken: (RtcConnection connection, int uid, String filePath,
              int width, int height, int errCode) {},
          onClientRoleChanged: (RtcConnection connection,
              ClientRoleType oldRole,
              ClientRoleType newRole,
              ClientRoleOptions newRoleOptions) {},
          onClientRoleChangeFailed: (RtcConnection connection,
              ClientRoleChangeFailedReason reason,
              ClientRoleType currentRole) {},
          onAudioDeviceVolumeChanged:
              (MediaDeviceType deviceType, int volume, bool muted) {},
          onRtmpStreamingStateChanged: (String url,
              RtmpStreamPublishState state, RtmpStreamPublishReason reason) {},
          onRtmpStreamingEvent: (String url, RtmpStreamingEvent eventCode) {},
          onTranscodingUpdated: () {},
          onAudioRoutingChanged: (int routing) {},
          onChannelMediaRelayStateChanged:
              (ChannelMediaRelayState state, ChannelMediaRelayError code) {},
          onLocalPublishFallbackToAudioOnly: (bool isFallbackOrRecover) {},
          onRemoteSubscribeFallbackToAudioOnly:
              (int uid, bool isFallbackOrRecover) {},
          onRemoteAudioTransportStats: (RtcConnection connection, int remoteUid,
              int delay, int lost, int rxKBitRate) {},
          onRemoteVideoTransportStats: (RtcConnection connection, int remoteUid,
              int delay, int lost, int rxKBitRate) {},
          onConnectionStateChanged: (RtcConnection connection,
              ConnectionStateType state, ConnectionChangedReasonType reason) {},
          onWlAccMessage: (RtcConnection connection, WlaccMessageReason reason,
              WlaccSuggestAction action, String wlAccMsg) {},
          onWlAccStats: (RtcConnection connection, WlAccStats currentStats,
              WlAccStats averageStats) {},
          onNetworkTypeChanged: (RtcConnection connection, NetworkType type) {},
          onEncryptionError:
              (RtcConnection connection, EncryptionErrorType errorType) {},
          onPermissionError: (PermissionType permissionType) {},
          onLocalUserRegistered: (int uid, String userAccount) {},
          onUserInfoUpdated: (int uid, UserInfo info) {},
          onUserAccountUpdated: (RtcConnection connection, int remoteUid,
              String remoteUserAccount) {},
          onVideoRenderingTracingResult: (RtcConnection connection,
              int uid,
              MediaTraceEvent currentEvent,
              VideoRenderingTracingInfo tracingInfo) {},
          onLocalVideoTranscoderError:
              (TranscodingVideoStream stream, VideoTranscoderError error) {},
          onUploadLogResult: (RtcConnection connection, String requestId,
              bool success, UploadErrorReason reason) {},
          onAudioSubscribeStateChanged: (String channel,
              int uid,
              StreamSubscribeState oldState,
              StreamSubscribeState newState,
              int elapseSinceLastState) {},
          onVideoSubscribeStateChanged: (String channel,
              int uid,
              StreamSubscribeState oldState,
              StreamSubscribeState newState,
              int elapseSinceLastState) {},
          onAudioPublishStateChanged: (String channel,
              StreamPublishState oldState,
              StreamPublishState newState,
              int elapseSinceLastState) {},
          onVideoPublishStateChanged: (VideoSourceType source,
              String channel,
              StreamPublishState oldState,
              StreamPublishState newState,
              int elapseSinceLastState) {},
          onTranscodedStreamLayoutInfo: (RtcConnection connection, int uid,
              int width, int height, int layoutCount, List layoutlist) {},
          onAudioMetadataReceived: (RtcConnection connection, int uid,
              Uint8List metadata, int length) {},
          onExtensionEventWithContext:
              (ExtensionContext context, String key, String value) {},
          onExtensionStartedWithContext: (ExtensionContext context) {},
          onExtensionStoppedWithContext: (ExtensionContext context) {},
          onExtensionErrorWithContext:
              (ExtensionContext context, int error, String message) {},
          onSetRtmFlagResult: (RtcConnection connection, int code) {},
        );
        rtcEngine.unregisterEventHandler(
          eventHandler,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.unregisterEventHandler] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.setRemoteUserPriority',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        int uid = 5;
        PriorityType userPriority = PriorityType.priorityHigh;
        await rtcEngine.setRemoteUserPriority(
          uid: uid,
          userPriority: userPriority,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.setRemoteUserPriority] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.enableEncryption',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        bool enabled = true;
        EncryptionMode configEncryptionMode = EncryptionMode.aes128Xts;
        String configEncryptionKey = "hello";
        Uint8List configEncryptionKdfSalt = Uint8List.fromList([1, 1, 1, 1, 1]);
        bool configDatastreamEncryptionEnabled = true;
        EncryptionConfig config = EncryptionConfig(
          encryptionMode: configEncryptionMode,
          encryptionKey: configEncryptionKey,
          encryptionKdfSalt: configEncryptionKdfSalt,
          datastreamEncryptionEnabled: configDatastreamEncryptionEnabled,
        );
        await rtcEngine.enableEncryption(
          enabled: enabled,
          config: config,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.enableEncryption] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.sendStreamMessage',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        int streamId = 5;
        Uint8List data = Uint8List.fromList([1, 1, 1, 1, 1]);
        int length = 5;
        await rtcEngine.sendStreamMessage(
          streamId: streamId,
          data: data,
          length: length,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.sendStreamMessage] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.addVideoWatermark',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        String watermarkUrl = "hello";
        int positionInLandscapeModeX = 5;
        int positionInLandscapeModeY = 5;
        int positionInLandscapeModeWidth = 5;
        int positionInLandscapeModeHeight = 5;
        Rectangle optionsPositionInLandscapeMode = Rectangle(
          x: positionInLandscapeModeX,
          y: positionInLandscapeModeY,
          width: positionInLandscapeModeWidth,
          height: positionInLandscapeModeHeight,
        );
        int positionInPortraitModeX = 5;
        int positionInPortraitModeY = 5;
        int positionInPortraitModeWidth = 5;
        int positionInPortraitModeHeight = 5;
        Rectangle optionsPositionInPortraitMode = Rectangle(
          x: positionInPortraitModeX,
          y: positionInPortraitModeY,
          width: positionInPortraitModeWidth,
          height: positionInPortraitModeHeight,
        );
        double watermarkRatioXRatio = 5.0;
        double watermarkRatioYRatio = 5.0;
        double watermarkRatioWidthRatio = 5.0;
        WatermarkRatio optionsWatermarkRatio = WatermarkRatio(
          xRatio: watermarkRatioXRatio,
          yRatio: watermarkRatioYRatio,
          widthRatio: watermarkRatioWidthRatio,
        );
        WatermarkFitMode optionsMode = WatermarkFitMode.fitModeCoverPosition;
        bool optionsVisibleInPreview = true;
        WatermarkOptions options = WatermarkOptions(
          visibleInPreview: optionsVisibleInPreview,
          positionInLandscapeMode: optionsPositionInLandscapeMode,
          positionInPortraitMode: optionsPositionInPortraitMode,
          watermarkRatio: optionsWatermarkRatio,
          mode: optionsMode,
        );
        await rtcEngine.addVideoWatermark(
          watermarkUrl: watermarkUrl,
          options: options,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.addVideoWatermark] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.clearVideoWatermarks',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        await rtcEngine.clearVideoWatermarks();
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.clearVideoWatermarks] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.pauseAudio',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        await rtcEngine.pauseAudio();
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.pauseAudio] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.resumeAudio',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        await rtcEngine.resumeAudio();
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.resumeAudio] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.enableWebSdkInteroperability',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        bool enabled = true;
        await rtcEngine.enableWebSdkInteroperability(
          enabled,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.enableWebSdkInteroperability] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.sendCustomReportMessage',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        String id = "hello";
        String category = "hello";
        String event = "hello";
        String label = "hello";
        int value = 5;
        await rtcEngine.sendCustomReportMessage(
          id: id,
          category: category,
          event: event,
          label: label,
          value: value,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.sendCustomReportMessage] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.registerMediaMetadataObserver',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        MetadataObserver observer = MetadataObserver(
          onMetadataReceived: (Metadata metadata) {},
        );
        MetadataType type = MetadataType.unknownMetadata;
        rtcEngine.registerMediaMetadataObserver(
          observer: observer,
          type: type,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.registerMediaMetadataObserver] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.unregisterMediaMetadataObserver',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        MetadataObserver observer = MetadataObserver(
          onMetadataReceived: (Metadata metadata) {},
        );
        MetadataType type = MetadataType.unknownMetadata;
        rtcEngine.unregisterMediaMetadataObserver(
          observer: observer,
          type: type,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.unregisterMediaMetadataObserver] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.startAudioFrameDump',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        String channelId = "hello";
        int uid = 5;
        String location = "hello";
        String uuid = "hello";
        String passwd = "hello";
        int durationMs = 5;
        bool autoUpload = true;
        await rtcEngine.startAudioFrameDump(
          channelId: channelId,
          uid: uid,
          location: location,
          uuid: uuid,
          passwd: passwd,
          durationMs: durationMs,
          autoUpload: autoUpload,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.startAudioFrameDump] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.stopAudioFrameDump',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        String channelId = "hello";
        int uid = 5;
        String location = "hello";
        await rtcEngine.stopAudioFrameDump(
          channelId: channelId,
          uid: uid,
          location: location,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.stopAudioFrameDump] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.setAINSMode',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        bool enabled = true;
        AudioAinsMode mode = AudioAinsMode.ainsModeBalanced;
        await rtcEngine.setAINSMode(
          enabled: enabled,
          mode: mode,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.setAINSMode] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.registerLocalUserAccount',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        String appId = "hello";
        String userAccount = "hello";
        await rtcEngine.registerLocalUserAccount(
          appId: appId,
          userAccount: userAccount,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.registerLocalUserAccount] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.joinChannelWithUserAccount',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        String token = "hello";
        String channelId = "hello";
        String userAccount = "hello";
        ClientRoleType optionsClientRoleType =
            ClientRoleType.clientRoleBroadcaster;
        AudienceLatencyLevelType optionsAudienceLatencyLevel =
            AudienceLatencyLevelType.audienceLatencyLevelLowLatency;
        VideoStreamType optionsDefaultVideoStreamType =
            VideoStreamType.videoStreamHigh;
        ChannelProfileType optionsChannelProfile =
            ChannelProfileType.channelProfileCommunication;
        bool optionsPublishCameraTrack = true;
        bool optionsPublishSecondaryCameraTrack = true;
        bool optionsPublishThirdCameraTrack = true;
        bool optionsPublishFourthCameraTrack = true;
        bool optionsPublishMicrophoneTrack = true;
        bool optionsPublishScreenCaptureVideo = true;
        bool optionsPublishScreenCaptureAudio = true;
        bool optionsPublishScreenTrack = true;
        bool optionsPublishSecondaryScreenTrack = true;
        bool optionsPublishThirdScreenTrack = true;
        bool optionsPublishFourthScreenTrack = true;
        bool optionsPublishCustomAudioTrack = true;
        int optionsPublishCustomAudioTrackId = 5;
        bool optionsPublishCustomVideoTrack = true;
        bool optionsPublishEncodedVideoTrack = true;
        bool optionsPublishMediaPlayerAudioTrack = true;
        bool optionsPublishMediaPlayerVideoTrack = true;
        bool optionsPublishTranscodedVideoTrack = true;
        bool optionsPublishMixedAudioTrack = true;
        bool optionsPublishLipSyncTrack = true;
        bool optionsAutoSubscribeAudio = true;
        bool optionsAutoSubscribeVideo = true;
        bool optionsEnableAudioRecordingOrPlayout = true;
        int optionsPublishMediaPlayerId = 5;
        int optionsAudioDelayMs = 5;
        int optionsMediaPlayerAudioDelayMs = 5;
        String optionsToken = "hello";
        bool optionsEnableBuiltInMediaEncryption = true;
        bool optionsPublishRhythmPlayerTrack = true;
        bool optionsIsInteractiveAudience = true;
        int optionsCustomVideoTrackId = 5;
        bool optionsIsAudioFilterable = true;
        String optionsParameters = "hello";
        ChannelMediaOptions options = ChannelMediaOptions(
          publishCameraTrack: optionsPublishCameraTrack,
          publishSecondaryCameraTrack: optionsPublishSecondaryCameraTrack,
          publishThirdCameraTrack: optionsPublishThirdCameraTrack,
          publishFourthCameraTrack: optionsPublishFourthCameraTrack,
          publishMicrophoneTrack: optionsPublishMicrophoneTrack,
          publishScreenCaptureVideo: optionsPublishScreenCaptureVideo,
          publishScreenCaptureAudio: optionsPublishScreenCaptureAudio,
          publishScreenTrack: optionsPublishScreenTrack,
          publishSecondaryScreenTrack: optionsPublishSecondaryScreenTrack,
          publishThirdScreenTrack: optionsPublishThirdScreenTrack,
          publishFourthScreenTrack: optionsPublishFourthScreenTrack,
          publishCustomAudioTrack: optionsPublishCustomAudioTrack,
          publishCustomAudioTrackId: optionsPublishCustomAudioTrackId,
          publishCustomVideoTrack: optionsPublishCustomVideoTrack,
          publishEncodedVideoTrack: optionsPublishEncodedVideoTrack,
          publishMediaPlayerAudioTrack: optionsPublishMediaPlayerAudioTrack,
          publishMediaPlayerVideoTrack: optionsPublishMediaPlayerVideoTrack,
          publishTranscodedVideoTrack: optionsPublishTranscodedVideoTrack,
          publishMixedAudioTrack: optionsPublishMixedAudioTrack,
          publishLipSyncTrack: optionsPublishLipSyncTrack,
          autoSubscribeAudio: optionsAutoSubscribeAudio,
          autoSubscribeVideo: optionsAutoSubscribeVideo,
          enableAudioRecordingOrPlayout: optionsEnableAudioRecordingOrPlayout,
          publishMediaPlayerId: optionsPublishMediaPlayerId,
          clientRoleType: optionsClientRoleType,
          audienceLatencyLevel: optionsAudienceLatencyLevel,
          defaultVideoStreamType: optionsDefaultVideoStreamType,
          channelProfile: optionsChannelProfile,
          audioDelayMs: optionsAudioDelayMs,
          mediaPlayerAudioDelayMs: optionsMediaPlayerAudioDelayMs,
          token: optionsToken,
          enableBuiltInMediaEncryption: optionsEnableBuiltInMediaEncryption,
          publishRhythmPlayerTrack: optionsPublishRhythmPlayerTrack,
          isInteractiveAudience: optionsIsInteractiveAudience,
          customVideoTrackId: optionsCustomVideoTrackId,
          isAudioFilterable: optionsIsAudioFilterable,
          parameters: optionsParameters,
        );
        await rtcEngine.joinChannelWithUserAccount(
          token: token,
          channelId: channelId,
          userAccount: userAccount,
          options: options,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.joinChannelWithUserAccount] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.joinChannelWithUserAccountEx',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        String token = "hello";
        String channelId = "hello";
        String userAccount = "hello";
        ClientRoleType optionsClientRoleType =
            ClientRoleType.clientRoleBroadcaster;
        AudienceLatencyLevelType optionsAudienceLatencyLevel =
            AudienceLatencyLevelType.audienceLatencyLevelLowLatency;
        VideoStreamType optionsDefaultVideoStreamType =
            VideoStreamType.videoStreamHigh;
        ChannelProfileType optionsChannelProfile =
            ChannelProfileType.channelProfileCommunication;
        bool optionsPublishCameraTrack = true;
        bool optionsPublishSecondaryCameraTrack = true;
        bool optionsPublishThirdCameraTrack = true;
        bool optionsPublishFourthCameraTrack = true;
        bool optionsPublishMicrophoneTrack = true;
        bool optionsPublishScreenCaptureVideo = true;
        bool optionsPublishScreenCaptureAudio = true;
        bool optionsPublishScreenTrack = true;
        bool optionsPublishSecondaryScreenTrack = true;
        bool optionsPublishThirdScreenTrack = true;
        bool optionsPublishFourthScreenTrack = true;
        bool optionsPublishCustomAudioTrack = true;
        int optionsPublishCustomAudioTrackId = 5;
        bool optionsPublishCustomVideoTrack = true;
        bool optionsPublishEncodedVideoTrack = true;
        bool optionsPublishMediaPlayerAudioTrack = true;
        bool optionsPublishMediaPlayerVideoTrack = true;
        bool optionsPublishTranscodedVideoTrack = true;
        bool optionsPublishMixedAudioTrack = true;
        bool optionsPublishLipSyncTrack = true;
        bool optionsAutoSubscribeAudio = true;
        bool optionsAutoSubscribeVideo = true;
        bool optionsEnableAudioRecordingOrPlayout = true;
        int optionsPublishMediaPlayerId = 5;
        int optionsAudioDelayMs = 5;
        int optionsMediaPlayerAudioDelayMs = 5;
        String optionsToken = "hello";
        bool optionsEnableBuiltInMediaEncryption = true;
        bool optionsPublishRhythmPlayerTrack = true;
        bool optionsIsInteractiveAudience = true;
        int optionsCustomVideoTrackId = 5;
        bool optionsIsAudioFilterable = true;
        String optionsParameters = "hello";
        ChannelMediaOptions options = ChannelMediaOptions(
          publishCameraTrack: optionsPublishCameraTrack,
          publishSecondaryCameraTrack: optionsPublishSecondaryCameraTrack,
          publishThirdCameraTrack: optionsPublishThirdCameraTrack,
          publishFourthCameraTrack: optionsPublishFourthCameraTrack,
          publishMicrophoneTrack: optionsPublishMicrophoneTrack,
          publishScreenCaptureVideo: optionsPublishScreenCaptureVideo,
          publishScreenCaptureAudio: optionsPublishScreenCaptureAudio,
          publishScreenTrack: optionsPublishScreenTrack,
          publishSecondaryScreenTrack: optionsPublishSecondaryScreenTrack,
          publishThirdScreenTrack: optionsPublishThirdScreenTrack,
          publishFourthScreenTrack: optionsPublishFourthScreenTrack,
          publishCustomAudioTrack: optionsPublishCustomAudioTrack,
          publishCustomAudioTrackId: optionsPublishCustomAudioTrackId,
          publishCustomVideoTrack: optionsPublishCustomVideoTrack,
          publishEncodedVideoTrack: optionsPublishEncodedVideoTrack,
          publishMediaPlayerAudioTrack: optionsPublishMediaPlayerAudioTrack,
          publishMediaPlayerVideoTrack: optionsPublishMediaPlayerVideoTrack,
          publishTranscodedVideoTrack: optionsPublishTranscodedVideoTrack,
          publishMixedAudioTrack: optionsPublishMixedAudioTrack,
          publishLipSyncTrack: optionsPublishLipSyncTrack,
          autoSubscribeAudio: optionsAutoSubscribeAudio,
          autoSubscribeVideo: optionsAutoSubscribeVideo,
          enableAudioRecordingOrPlayout: optionsEnableAudioRecordingOrPlayout,
          publishMediaPlayerId: optionsPublishMediaPlayerId,
          clientRoleType: optionsClientRoleType,
          audienceLatencyLevel: optionsAudienceLatencyLevel,
          defaultVideoStreamType: optionsDefaultVideoStreamType,
          channelProfile: optionsChannelProfile,
          audioDelayMs: optionsAudioDelayMs,
          mediaPlayerAudioDelayMs: optionsMediaPlayerAudioDelayMs,
          token: optionsToken,
          enableBuiltInMediaEncryption: optionsEnableBuiltInMediaEncryption,
          publishRhythmPlayerTrack: optionsPublishRhythmPlayerTrack,
          isInteractiveAudience: optionsIsInteractiveAudience,
          customVideoTrackId: optionsCustomVideoTrackId,
          isAudioFilterable: optionsIsAudioFilterable,
          parameters: optionsParameters,
        );
        await rtcEngine.joinChannelWithUserAccountEx(
          token: token,
          channelId: channelId,
          userAccount: userAccount,
          options: options,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.joinChannelWithUserAccountEx] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.getUserInfoByUserAccount',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        String userAccount = "hello";
        await rtcEngine.getUserInfoByUserAccount(
          userAccount,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.getUserInfoByUserAccount] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.getUserInfoByUid',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        int uid = 5;
        await rtcEngine.getUserInfoByUid(
          uid,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.getUserInfoByUid] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.stopChannelMediaRelay',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        await rtcEngine.stopChannelMediaRelay();
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.stopChannelMediaRelay] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.pauseAllChannelMediaRelay',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        await rtcEngine.pauseAllChannelMediaRelay();
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.pauseAllChannelMediaRelay] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.resumeAllChannelMediaRelay',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        await rtcEngine.resumeAllChannelMediaRelay();
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.resumeAllChannelMediaRelay] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.setDirectCdnStreamingAudioConfiguration',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        AudioProfileType profile = AudioProfileType.audioProfileDefault;
        await rtcEngine.setDirectCdnStreamingAudioConfiguration(
          profile,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.setDirectCdnStreamingAudioConfiguration] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.setDirectCdnStreamingVideoConfiguration',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        VideoCodecType configCodecType = VideoCodecType.videoCodecNone;
        int dimensionsWidth = 5;
        int dimensionsHeight = 5;
        VideoDimensions configDimensions = VideoDimensions(
          width: dimensionsWidth,
          height: dimensionsHeight,
        );
        OrientationMode configOrientationMode =
            OrientationMode.orientationModeAdaptive;
        DegradationPreference configDegradationPreference =
            DegradationPreference.maintainAuto;
        VideoMirrorModeType configMirrorMode =
            VideoMirrorModeType.videoMirrorModeAuto;
        EncodingPreference advanceOptionsEncodingPreference =
            EncodingPreference.preferAuto;
        CompressionPreference advanceOptionsCompressionPreference =
            CompressionPreference.preferCompressionAuto;
        bool advanceOptionsEncodeAlpha = true;
        AdvanceOptions configAdvanceOptions = AdvanceOptions(
          encodingPreference: advanceOptionsEncodingPreference,
          compressionPreference: advanceOptionsCompressionPreference,
          encodeAlpha: advanceOptionsEncodeAlpha,
        );
        int configFrameRate = 5;
        int configBitrate = 5;
        int configMinBitrate = 5;
        VideoEncoderConfiguration config = VideoEncoderConfiguration(
          codecType: configCodecType,
          dimensions: configDimensions,
          frameRate: configFrameRate,
          bitrate: configBitrate,
          minBitrate: configMinBitrate,
          orientationMode: configOrientationMode,
          degradationPreference: configDegradationPreference,
          mirrorMode: configMirrorMode,
          advanceOptions: configAdvanceOptions,
        );
        await rtcEngine.setDirectCdnStreamingVideoConfiguration(
          config,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.setDirectCdnStreamingVideoConfiguration] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.startDirectCdnStreaming',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        DirectCdnStreamingEventHandler eventHandler =
            DirectCdnStreamingEventHandler(
          onDirectCdnStreamingStateChanged: (DirectCdnStreamingState state,
              DirectCdnStreamingReason reason, String message) {},
          onDirectCdnStreamingStats: (DirectCdnStreamingStats stats) {},
        );
        String publishUrl = "hello";
        bool optionsPublishCameraTrack = true;
        bool optionsPublishMicrophoneTrack = true;
        bool optionsPublishCustomAudioTrack = true;
        bool optionsPublishCustomVideoTrack = true;
        bool optionsPublishMediaPlayerAudioTrack = true;
        int optionsPublishMediaPlayerId = 5;
        int optionsCustomVideoTrackId = 5;
        DirectCdnStreamingMediaOptions options = DirectCdnStreamingMediaOptions(
          publishCameraTrack: optionsPublishCameraTrack,
          publishMicrophoneTrack: optionsPublishMicrophoneTrack,
          publishCustomAudioTrack: optionsPublishCustomAudioTrack,
          publishCustomVideoTrack: optionsPublishCustomVideoTrack,
          publishMediaPlayerAudioTrack: optionsPublishMediaPlayerAudioTrack,
          publishMediaPlayerId: optionsPublishMediaPlayerId,
          customVideoTrackId: optionsCustomVideoTrackId,
        );
        await rtcEngine.startDirectCdnStreaming(
          eventHandler: eventHandler,
          publishUrl: publishUrl,
          options: options,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.startDirectCdnStreaming] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.stopDirectCdnStreaming',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        await rtcEngine.stopDirectCdnStreaming();
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.stopDirectCdnStreaming] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.updateDirectCdnStreamingMediaOptions',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        bool optionsPublishCameraTrack = true;
        bool optionsPublishMicrophoneTrack = true;
        bool optionsPublishCustomAudioTrack = true;
        bool optionsPublishCustomVideoTrack = true;
        bool optionsPublishMediaPlayerAudioTrack = true;
        int optionsPublishMediaPlayerId = 5;
        int optionsCustomVideoTrackId = 5;
        DirectCdnStreamingMediaOptions options = DirectCdnStreamingMediaOptions(
          publishCameraTrack: optionsPublishCameraTrack,
          publishMicrophoneTrack: optionsPublishMicrophoneTrack,
          publishCustomAudioTrack: optionsPublishCustomAudioTrack,
          publishCustomVideoTrack: optionsPublishCustomVideoTrack,
          publishMediaPlayerAudioTrack: optionsPublishMediaPlayerAudioTrack,
          publishMediaPlayerId: optionsPublishMediaPlayerId,
          customVideoTrackId: optionsCustomVideoTrackId,
        );
        await rtcEngine.updateDirectCdnStreamingMediaOptions(
          options,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.updateDirectCdnStreamingMediaOptions] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.startRhythmPlayer',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        String sound1 = "hello";
        String sound2 = "hello";
        int configBeatsPerMeasure = 5;
        int configBeatsPerMinute = 5;
        AgoraRhythmPlayerConfig config = AgoraRhythmPlayerConfig(
          beatsPerMeasure: configBeatsPerMeasure,
          beatsPerMinute: configBeatsPerMinute,
        );
        await rtcEngine.startRhythmPlayer(
          sound1: sound1,
          sound2: sound2,
          config: config,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.startRhythmPlayer] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.stopRhythmPlayer',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        await rtcEngine.stopRhythmPlayer();
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.stopRhythmPlayer] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.configRhythmPlayer',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        int configBeatsPerMeasure = 5;
        int configBeatsPerMinute = 5;
        AgoraRhythmPlayerConfig config = AgoraRhythmPlayerConfig(
          beatsPerMeasure: configBeatsPerMeasure,
          beatsPerMinute: configBeatsPerMinute,
        );
        await rtcEngine.configRhythmPlayer(
          config,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.configRhythmPlayer] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.takeSnapshot',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        int uid = 5;
        String filePath = "hello";
        await rtcEngine.takeSnapshot(
          uid: uid,
          filePath: filePath,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.takeSnapshot] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.enableContentInspect',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        bool enabled = true;
        String configExtraInfo = "hello";
        String configServerConfig = "hello";
        List<ContentInspectModule> configModules = [];
        int configModuleCount = 5;
        ContentInspectConfig config = ContentInspectConfig(
          extraInfo: configExtraInfo,
          serverConfig: configServerConfig,
          modules: configModules,
          moduleCount: configModuleCount,
        );
        await rtcEngine.enableContentInspect(
          enabled: enabled,
          config: config,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.enableContentInspect] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.adjustCustomAudioPublishVolume',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        int trackId = 5;
        int volume = 5;
        await rtcEngine.adjustCustomAudioPublishVolume(
          trackId: trackId,
          volume: volume,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.adjustCustomAudioPublishVolume] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.adjustCustomAudioPlayoutVolume',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        int trackId = 5;
        int volume = 5;
        await rtcEngine.adjustCustomAudioPlayoutVolume(
          trackId: trackId,
          volume: volume,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.adjustCustomAudioPlayoutVolume] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.setCloudProxy',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        CloudProxyType proxyType = CloudProxyType.noneProxy;
        await rtcEngine.setCloudProxy(
          proxyType,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.setCloudProxy] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.setAdvancedAudioOptions',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        int optionsAudioProcessingChannels = 5;
        AdvancedAudioOptions options = AdvancedAudioOptions(
          audioProcessingChannels: optionsAudioProcessingChannels,
        );
        int sourceType = 5;
        await rtcEngine.setAdvancedAudioOptions(
          options: options,
          sourceType: sourceType,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.setAdvancedAudioOptions] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.setAVSyncSource',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        String channelId = "hello";
        int uid = 5;
        await rtcEngine.setAVSyncSource(
          channelId: channelId,
          uid: uid,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.setAVSyncSource] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.enableVideoImageSource',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        bool enable = true;
        VideoMirrorModeType optionsMirrorMode =
            VideoMirrorModeType.videoMirrorModeAuto;
        String optionsImageUrl = "hello";
        int optionsFps = 5;
        ImageTrackOptions options = ImageTrackOptions(
          imageUrl: optionsImageUrl,
          fps: optionsFps,
          mirrorMode: optionsMirrorMode,
        );
        await rtcEngine.enableVideoImageSource(
          enable: enable,
          options: options,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.enableVideoImageSource] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.getCurrentMonotonicTimeInMs',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        await rtcEngine.getCurrentMonotonicTimeInMs();
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.getCurrentMonotonicTimeInMs] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.enableWirelessAccelerate',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        bool enabled = true;
        await rtcEngine.enableWirelessAccelerate(
          enabled,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.enableWirelessAccelerate] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.getNetworkType',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        await rtcEngine.getNetworkType();
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.getNetworkType] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.setParameters',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        String parameters = "hello";
        await rtcEngine.setParameters(
          parameters,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.setParameters] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.startMediaRenderingTracing',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        await rtcEngine.startMediaRenderingTracing();
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.startMediaRenderingTracing] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.enableInstantMediaRendering',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        await rtcEngine.enableInstantMediaRendering();
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.enableInstantMediaRendering] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.getNtpWallTimeInMs',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        await rtcEngine.getNtpWallTimeInMs();
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.getNtpWallTimeInMs] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.isFeatureAvailableOnDevice',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        FeatureType type = FeatureType.videoVirtualBackground;
        await rtcEngine.isFeatureAvailableOnDevice(
          type,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.isFeatureAvailableOnDevice] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.sendAudioMetadata',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        Uint8List metadata = Uint8List.fromList([1, 1, 1, 1, 1]);
        int length = 5;
        await rtcEngine.sendAudioMetadata(
          metadata: metadata,
          length: length,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.sendAudioMetadata] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.queryHDRCapability',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        VideoModuleType videoModule = VideoModuleType.videoModuleCapturer;
        await rtcEngine.queryHDRCapability(
          videoModule,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.queryHDRCapability] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.startScreenCaptureBySourceType',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        VideoSourceType sourceType = VideoSourceType.videoSourceCameraPrimary;
        int screenRectX = 5;
        int screenRectY = 5;
        int screenRectWidth = 5;
        int screenRectHeight = 5;
        Rectangle configScreenRect = Rectangle(
          x: screenRectX,
          y: screenRectY,
          width: screenRectWidth,
          height: screenRectHeight,
        );
        int dimensionsWidth = 5;
        int dimensionsHeight = 5;
        VideoDimensions paramsDimensions = VideoDimensions(
          width: dimensionsWidth,
          height: dimensionsHeight,
        );
        int paramsFrameRate = 5;
        int paramsBitrate = 5;
        bool paramsCaptureMouseCursor = true;
        bool paramsWindowFocus = true;
        List<int> paramsExcludeWindowList = List.filled(5, 5);
        int paramsExcludeWindowCount = 5;
        int paramsHighLightWidth = 5;
        int paramsHighLightColor = 5;
        bool paramsEnableHighLight = true;
        ScreenCaptureParameters configParams = ScreenCaptureParameters(
          dimensions: paramsDimensions,
          frameRate: paramsFrameRate,
          bitrate: paramsBitrate,
          captureMouseCursor: paramsCaptureMouseCursor,
          windowFocus: paramsWindowFocus,
          excludeWindowList: paramsExcludeWindowList,
          excludeWindowCount: paramsExcludeWindowCount,
          highLightWidth: paramsHighLightWidth,
          highLightColor: paramsHighLightColor,
          enableHighLight: paramsEnableHighLight,
        );
        int regionRectX = 5;
        int regionRectY = 5;
        int regionRectWidth = 5;
        int regionRectHeight = 5;
        Rectangle configRegionRect = Rectangle(
          x: regionRectX,
          y: regionRectY,
          width: regionRectWidth,
          height: regionRectHeight,
        );
        bool configIsCaptureWindow = true;
        int configDisplayId = 5;
        int configWindowId = 5;
        ScreenCaptureConfiguration config = ScreenCaptureConfiguration(
          isCaptureWindow: configIsCaptureWindow,
          displayId: configDisplayId,
          screenRect: configScreenRect,
          windowId: configWindowId,
          params: configParams,
          regionRect: configRegionRect,
        );
        await rtcEngine.startScreenCaptureBySourceType(
          sourceType: sourceType,
          config: config,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.startScreenCaptureBySourceType] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.stopScreenCaptureBySourceType',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        VideoSourceType sourceType = VideoSourceType.videoSourceCameraPrimary;
        await rtcEngine.stopScreenCaptureBySourceType(
          sourceType,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.stopScreenCaptureBySourceType] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.release',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        bool sync = true;
        await rtcEngine.release(
          sync: sync,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.release] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.startPreviewWithoutSourceType',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        await rtcEngine.startPreviewWithoutSourceType();
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.startPreviewWithoutSourceType] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.getAudioDeviceManager',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        rtcEngine.getAudioDeviceManager();
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.getAudioDeviceManager] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.getVideoDeviceManager',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        rtcEngine.getVideoDeviceManager();
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.getVideoDeviceManager] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.getMusicContentCenter',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        rtcEngine.getMusicContentCenter();
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.getMusicContentCenter] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.getMediaEngine',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        rtcEngine.getMediaEngine();
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.getMediaEngine] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.getLocalSpatialAudioEngine',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        rtcEngine.getLocalSpatialAudioEngine();
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.getLocalSpatialAudioEngine] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.getH265Transcoder',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        rtcEngine.getH265Transcoder();
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.getH265Transcoder] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.sendMetaData',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        String metadataChannelId = "hello";
        int metadataUid = 5;
        int metadataSize = 5;
        Uint8List metadataBuffer = Uint8List.fromList([1, 1, 1, 1, 1]);
        int metadataTimeStampMs = 5;
        Metadata metadata = Metadata(
          channelId: metadataChannelId,
          uid: metadataUid,
          size: metadataSize,
          buffer: metadataBuffer,
          timeStampMs: metadataTimeStampMs,
        );
        VideoSourceType sourceType = VideoSourceType.videoSourceCameraPrimary;
        await rtcEngine.sendMetaData(
          metadata: metadata,
          sourceType: sourceType,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.sendMetaData] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.setMaxMetadataSize',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        int size = 5;
        await rtcEngine.setMaxMetadataSize(
          size,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.setMaxMetadataSize] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.unregisterAudioEncodedFrameObserver',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        AudioEncodedFrameObserver observer = AudioEncodedFrameObserver(
          onRecordAudioEncodedFrame: (Uint8List frameBuffer, int length,
              EncodedAudioFrameInfo audioEncodedFrameInfo) {},
          onPlaybackAudioEncodedFrame: (Uint8List frameBuffer, int length,
              EncodedAudioFrameInfo audioEncodedFrameInfo) {},
          onMixedAudioEncodedFrame: (Uint8List frameBuffer, int length,
              EncodedAudioFrameInfo audioEncodedFrameInfo) {},
        );
        rtcEngine.unregisterAudioEncodedFrameObserver(
          observer,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.unregisterAudioEncodedFrameObserver] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.getNativeHandle',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        await rtcEngine.getNativeHandle();
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[RtcEngine.getNativeHandle] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );

  testWidgets(
    'RtcEngine.takeSnapshotWithConfig',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      try {
        int uid = 5;
        VideoModulePosition configPosition =
            VideoModulePosition.positionPostCapturer;
        String configFilePath = "hello";
        SnapshotConfig config = SnapshotConfig(
          filePath: configFilePath,
          position: configPosition,
        );
        await rtcEngine.takeSnapshotWithConfig(
          uid: uid,
          config: config,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[RtcEngine.takeSnapshotWithConfig] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.release();
    },
  );
}
