/// GENERATED BY testcase_gen. DO NOT MODIFY BY HAND.

// ignore_for_file: deprecated_member_use,constant_identifier_names

import 'dart:async';
import 'dart:typed_data';

import 'package:agora_rtc_engine/agora_rtc_engine.dart';
import 'package:flutter/foundation.dart';
import 'package:flutter_test/flutter_test.dart';
import 'package:iris_tester/iris_tester.dart';
import 'package:iris_method_channel/iris_method_channel.dart';

import '../testcases/event_ids_mapping.dart';

void generatedTestCases(ValueGetter<IrisTester> irisTester) {
  testWidgets(
    'MusicContentCenterEventHandler.onMusicChartsResult',
    (WidgetTester tester) async {
      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: 'app_id',
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      final musicContentCenter = rtcEngine.getMusicContentCenter();
      const musicContentCenterConfiguration = MusicContentCenterConfiguration(
          appId: 'app_id', token: 'token', mccUid: 10);
      await musicContentCenter.initialize(musicContentCenterConfiguration);

      final onMusicChartsResultCompleter = Completer<bool>();
      final theMusicContentCenterEventHandler = MusicContentCenterEventHandler(
        onMusicChartsResult: (String requestId, List result,
            MusicContentCenterStateReason reason) {
          onMusicChartsResultCompleter.complete(true);
        },
      );

      musicContentCenter.registerEventHandler(
        theMusicContentCenterEventHandler,
      );

// Delay 500 milliseconds to ensure the registerEventHandler call completed.
      await Future.delayed(const Duration(milliseconds: 500));

      {
        String requestId = "hello";
        final List<MusicChartInfo> result = () {
          String resultItemChartName = "hello";
          int resultItemId = 5;
          MusicChartInfo resultItem = MusicChartInfo(
            chartName: resultItemChartName,
            id: resultItemId,
          );

          return List.filled(5, resultItem);
        }();

        MusicContentCenterStateReason reason =
            MusicContentCenterStateReason.kMusicContentCenterReasonOk;

        final eventJson = {
          'requestId': requestId,
          'result': result,
          'reason': reason.value(),
        };

        final eventIds = eventIdsMapping[
                'MusicContentCenterEventHandler_onMusicChartsResult'] ??
            [];
        for (final event in eventIds) {
          final ret = irisTester().fireEvent(event, params: eventJson);
          // Delay 200 milliseconds to ensure the callback is called.
          await Future.delayed(const Duration(milliseconds: 200));
          // TODO(littlegnal): Most of callbacks on web are not implemented, we're temporarily skip these callbacks at this time.
          if (kIsWeb && ret) {
            if (!onMusicChartsResultCompleter.isCompleted) {
              onMusicChartsResultCompleter.complete(true);
            }
          }
        }
      }

      final eventCalled = await onMusicChartsResultCompleter.future;
      expect(eventCalled, isTrue);

      {
        musicContentCenter.unregisterEventHandler();
      }
// Delay 500 milliseconds to ensure the unregisterEventHandler call completed.
      await Future.delayed(const Duration(milliseconds: 500));

      await musicContentCenter.release();
      await rtcEngine.release();
    },
    timeout: const Timeout(Duration(minutes: 2)),
  );

  testWidgets(
    'MusicContentCenterEventHandler.onMusicCollectionResult',
    (WidgetTester tester) async {
      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: 'app_id',
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      final musicContentCenter = rtcEngine.getMusicContentCenter();
      const musicContentCenterConfiguration = MusicContentCenterConfiguration(
          appId: 'app_id', token: 'token', mccUid: 10);
      await musicContentCenter.initialize(musicContentCenterConfiguration);

      final onMusicCollectionResultCompleter = Completer<bool>();
      final theMusicContentCenterEventHandler = MusicContentCenterEventHandler(
        onMusicCollectionResult: (String requestId, MusicCollection result,
            MusicContentCenterStateReason reason) {
          onMusicCollectionResultCompleter.complete(true);
        },
      );

      musicContentCenter.registerEventHandler(
        theMusicContentCenterEventHandler,
      );

// Delay 500 milliseconds to ensure the registerEventHandler call completed.
      await Future.delayed(const Duration(milliseconds: 500));

      {
        String requestId = "hello";
        MusicCollection? result = null;
        MusicContentCenterStateReason reason =
            MusicContentCenterStateReason.kMusicContentCenterReasonOk;

        final eventJson = {
          'requestId': requestId,
          'reason': reason.value(),
        };

        final eventIds = eventIdsMapping[
                'MusicContentCenterEventHandler_onMusicCollectionResult'] ??
            [];
        for (final event in eventIds) {
          final ret = irisTester().fireEvent(event, params: eventJson);
          // Delay 200 milliseconds to ensure the callback is called.
          await Future.delayed(const Duration(milliseconds: 200));
          // TODO(littlegnal): Most of callbacks on web are not implemented, we're temporarily skip these callbacks at this time.
          if (kIsWeb && ret) {
            if (!onMusicCollectionResultCompleter.isCompleted) {
              onMusicCollectionResultCompleter.complete(true);
            }
          }
        }
      }

      final eventCalled = await onMusicCollectionResultCompleter.future;
      expect(eventCalled, isTrue);

      {
        musicContentCenter.unregisterEventHandler();
      }
// Delay 500 milliseconds to ensure the unregisterEventHandler call completed.
      await Future.delayed(const Duration(milliseconds: 500));

      await musicContentCenter.release();
      await rtcEngine.release();
    },
    timeout: const Timeout(Duration(minutes: 2)),
  );

  testWidgets(
    'MusicContentCenterEventHandler.onLyricResult',
    (WidgetTester tester) async {
      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: 'app_id',
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      final musicContentCenter = rtcEngine.getMusicContentCenter();
      const musicContentCenterConfiguration = MusicContentCenterConfiguration(
          appId: 'app_id', token: 'token', mccUid: 10);
      await musicContentCenter.initialize(musicContentCenterConfiguration);

      final onLyricResultCompleter = Completer<bool>();
      final theMusicContentCenterEventHandler = MusicContentCenterEventHandler(
        onLyricResult: (String requestId, int songCode, String lyricUrl,
            MusicContentCenterStateReason reason) {
          onLyricResultCompleter.complete(true);
        },
      );

      musicContentCenter.registerEventHandler(
        theMusicContentCenterEventHandler,
      );

// Delay 500 milliseconds to ensure the registerEventHandler call completed.
      await Future.delayed(const Duration(milliseconds: 500));

      {
        String requestId = "hello";
        int songCode = 5;
        String lyricUrl = "hello";
        MusicContentCenterStateReason reason =
            MusicContentCenterStateReason.kMusicContentCenterReasonOk;

        final eventJson = {
          'requestId': requestId,
          'songCode': songCode,
          'lyricUrl': lyricUrl,
          'reason': reason.value(),
        };

        final eventIds =
            eventIdsMapping['MusicContentCenterEventHandler_onLyricResult'] ??
                [];
        for (final event in eventIds) {
          final ret = irisTester().fireEvent(event, params: eventJson);
          // Delay 200 milliseconds to ensure the callback is called.
          await Future.delayed(const Duration(milliseconds: 200));
          // TODO(littlegnal): Most of callbacks on web are not implemented, we're temporarily skip these callbacks at this time.
          if (kIsWeb && ret) {
            if (!onLyricResultCompleter.isCompleted) {
              onLyricResultCompleter.complete(true);
            }
          }
        }
      }

      final eventCalled = await onLyricResultCompleter.future;
      expect(eventCalled, isTrue);

      {
        musicContentCenter.unregisterEventHandler();
      }
// Delay 500 milliseconds to ensure the unregisterEventHandler call completed.
      await Future.delayed(const Duration(milliseconds: 500));

      await musicContentCenter.release();
      await rtcEngine.release();
    },
    timeout: const Timeout(Duration(minutes: 2)),
  );

  testWidgets(
    'MusicContentCenterEventHandler.onSongSimpleInfoResult',
    (WidgetTester tester) async {
      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: 'app_id',
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      final musicContentCenter = rtcEngine.getMusicContentCenter();
      const musicContentCenterConfiguration = MusicContentCenterConfiguration(
          appId: 'app_id', token: 'token', mccUid: 10);
      await musicContentCenter.initialize(musicContentCenterConfiguration);

      final onSongSimpleInfoResultCompleter = Completer<bool>();
      final theMusicContentCenterEventHandler = MusicContentCenterEventHandler(
        onSongSimpleInfoResult: (String requestId, int songCode,
            String simpleInfo, MusicContentCenterStateReason reason) {
          onSongSimpleInfoResultCompleter.complete(true);
        },
      );

      musicContentCenter.registerEventHandler(
        theMusicContentCenterEventHandler,
      );

// Delay 500 milliseconds to ensure the registerEventHandler call completed.
      await Future.delayed(const Duration(milliseconds: 500));

      {
        String requestId = "hello";
        int songCode = 5;
        String simpleInfo = "hello";
        MusicContentCenterStateReason reason =
            MusicContentCenterStateReason.kMusicContentCenterReasonOk;

        final eventJson = {
          'requestId': requestId,
          'songCode': songCode,
          'simpleInfo': simpleInfo,
          'reason': reason.value(),
        };

        final eventIds = eventIdsMapping[
                'MusicContentCenterEventHandler_onSongSimpleInfoResult'] ??
            [];
        for (final event in eventIds) {
          final ret = irisTester().fireEvent(event, params: eventJson);
          // Delay 200 milliseconds to ensure the callback is called.
          await Future.delayed(const Duration(milliseconds: 200));
          // TODO(littlegnal): Most of callbacks on web are not implemented, we're temporarily skip these callbacks at this time.
          if (kIsWeb && ret) {
            if (!onSongSimpleInfoResultCompleter.isCompleted) {
              onSongSimpleInfoResultCompleter.complete(true);
            }
          }
        }
      }

      final eventCalled = await onSongSimpleInfoResultCompleter.future;
      expect(eventCalled, isTrue);

      {
        musicContentCenter.unregisterEventHandler();
      }
// Delay 500 milliseconds to ensure the unregisterEventHandler call completed.
      await Future.delayed(const Duration(milliseconds: 500));

      await musicContentCenter.release();
      await rtcEngine.release();
    },
    timeout: const Timeout(Duration(minutes: 2)),
  );

  testWidgets(
    'MusicContentCenterEventHandler.onPreLoadEvent',
    (WidgetTester tester) async {
      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: 'app_id',
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      final musicContentCenter = rtcEngine.getMusicContentCenter();
      const musicContentCenterConfiguration = MusicContentCenterConfiguration(
          appId: 'app_id', token: 'token', mccUid: 10);
      await musicContentCenter.initialize(musicContentCenterConfiguration);

      final onPreLoadEventCompleter = Completer<bool>();
      final theMusicContentCenterEventHandler = MusicContentCenterEventHandler(
        onPreLoadEvent: (String requestId,
            int songCode,
            int percent,
            String lyricUrl,
            PreloadState state,
            MusicContentCenterStateReason reason) {
          onPreLoadEventCompleter.complete(true);
        },
      );

      musicContentCenter.registerEventHandler(
        theMusicContentCenterEventHandler,
      );

// Delay 500 milliseconds to ensure the registerEventHandler call completed.
      await Future.delayed(const Duration(milliseconds: 500));

      {
        String requestId = "hello";
        int songCode = 5;
        int percent = 5;
        String lyricUrl = "hello";
        PreloadState state = PreloadState.kPreloadStateCompleted;
        MusicContentCenterStateReason reason =
            MusicContentCenterStateReason.kMusicContentCenterReasonOk;

        final eventJson = {
          'requestId': requestId,
          'songCode': songCode,
          'percent': percent,
          'lyricUrl': lyricUrl,
          'state': state.value(),
          'reason': reason.value(),
        };

        final eventIds =
            eventIdsMapping['MusicContentCenterEventHandler_onPreLoadEvent'] ??
                [];
        for (final event in eventIds) {
          final ret = irisTester().fireEvent(event, params: eventJson);
          // Delay 200 milliseconds to ensure the callback is called.
          await Future.delayed(const Duration(milliseconds: 200));
          // TODO(littlegnal): Most of callbacks on web are not implemented, we're temporarily skip these callbacks at this time.
          if (kIsWeb && ret) {
            if (!onPreLoadEventCompleter.isCompleted) {
              onPreLoadEventCompleter.complete(true);
            }
          }
        }
      }

      final eventCalled = await onPreLoadEventCompleter.future;
      expect(eventCalled, isTrue);

      {
        musicContentCenter.unregisterEventHandler();
      }
// Delay 500 milliseconds to ensure the unregisterEventHandler call completed.
      await Future.delayed(const Duration(milliseconds: 500));

      await musicContentCenter.release();
      await rtcEngine.release();
    },
    timeout: const Timeout(Duration(minutes: 2)),
  );
}
