/// GENERATED BY testcase_gen. DO NOT MODIFY BY HAND.

// ignore_for_file: deprecated_member_use,constant_identifier_names

import 'package:agora_rtc_engine/agora_rtc_engine.dart';
import 'package:flutter_test/flutter_test.dart';
import 'package:flutter/foundation.dart';
import 'package:fake_test_app/main.dart' as app;
import 'package:iris_tester/iris_tester.dart';
import 'package:iris_method_channel/iris_method_channel.dart';

void mediaRecorderSmokeTestCases() {
  testWidgets(
    'MediaRecorder.setMediaRecorderObserver',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      final mediaRecorder = (await rtcEngine.createMediaRecorder(
          RecorderStreamInfo(channelId: 'hello', uid: 0)))!;

      try {
        MediaRecorderObserver callback = MediaRecorderObserver(
          onRecorderStateChanged: (String channelId, int uid,
              RecorderState state, RecorderReasonCode reason) {},
          onRecorderInfoUpdated:
              (String channelId, int uid, RecorderInfo info) {},
        );
        await mediaRecorder.setMediaRecorderObserver(
          callback,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[MediaRecorder.setMediaRecorderObserver] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.destroyMediaRecorder(mediaRecorder);
      await rtcEngine.release();
    },
//  skip: !(),
  );

  testWidgets(
    'MediaRecorder.startRecording',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      final mediaRecorder = (await rtcEngine.createMediaRecorder(
          RecorderStreamInfo(channelId: 'hello', uid: 0)))!;

      try {
        MediaRecorderContainerFormat configContainerFormat =
            MediaRecorderContainerFormat.formatMp4;
        MediaRecorderStreamType configStreamType =
            MediaRecorderStreamType.streamTypeAudio;
        VideoSourceType configVideoSourceType =
            VideoSourceType.videoSourceCameraPrimary;
        String configStoragePath = "hello";
        int configMaxDurationMs = 5;
        int configRecorderInfoUpdateInterval = 5;
        int configWidth = 5;
        int configHeight = 5;
        int configFps = 5;
        int configSampleRate = 5;
        int configChannelNum = 5;
        MediaRecorderConfiguration config = MediaRecorderConfiguration(
          storagePath: configStoragePath,
          containerFormat: configContainerFormat,
          streamType: configStreamType,
          maxDurationMs: configMaxDurationMs,
          recorderInfoUpdateInterval: configRecorderInfoUpdateInterval,
          width: configWidth,
          height: configHeight,
          fps: configFps,
          sampleRate: configSampleRate,
          channelNum: configChannelNum,
          videoSourceType: configVideoSourceType,
        );
        await mediaRecorder.startRecording(
          config,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[MediaRecorder.startRecording] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.destroyMediaRecorder(mediaRecorder);
      await rtcEngine.release();
    },
//  skip: !(),
  );

  testWidgets(
    'MediaRecorder.stopRecording',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      final mediaRecorder = (await rtcEngine.createMediaRecorder(
          RecorderStreamInfo(channelId: 'hello', uid: 0)))!;

      try {
        await mediaRecorder.stopRecording();
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[MediaRecorder.stopRecording] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await rtcEngine.destroyMediaRecorder(mediaRecorder);
      await rtcEngine.release();
    },
//  skip: !(),
  );
}
