/// GENERATED BY testcase_gen. DO NOT MODIFY BY HAND.

// ignore_for_file: deprecated_member_use,constant_identifier_names

import 'dart:async';
import 'dart:typed_data';

import 'package:agora_rtc_engine/agora_rtc_engine.dart';
import 'package:flutter/foundation.dart';
import 'package:flutter_test/flutter_test.dart';
import 'package:iris_tester/iris_tester.dart';
import 'package:iris_method_channel/iris_method_channel.dart';

import '../testcases/event_ids_mapping.dart';

void generatedTestCases(ValueGetter<IrisTester> irisTester) {
  testWidgets(
    'MediaPlayerVideoFrameObserver.onFrame',
    (WidgetTester tester) async {
      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: 'app_id',
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');
      MediaPlayerController mediaPlayerController = MediaPlayerController(
          rtcEngine: rtcEngine, canvas: const VideoCanvas());
      await mediaPlayerController.initialize();

      final onFrameCompleter = Completer<bool>();
      final theMediaPlayerVideoFrameObserver = MediaPlayerVideoFrameObserver(
        onFrame: (VideoFrame frame) {
          onFrameCompleter.complete(true);
        },
      );

      mediaPlayerController.registerVideoFrameObserver(
        theMediaPlayerVideoFrameObserver,
      );

// Delay 500 milliseconds to ensure the registerVideoFrameObserver call completed.
      await Future.delayed(const Duration(milliseconds: 500));

      {
        VideoPixelFormat frameType = VideoPixelFormat.videoPixelDefault;
        AlphaStitchMode frameAlphaStitchMode = AlphaStitchMode.noAlphaStitch;
        VideoFrameMetaInfo? frameMetaInfo = null;
        int hdr10MetadataInfoRedPrimaryX = 5;
        int hdr10MetadataInfoRedPrimaryY = 5;
        int hdr10MetadataInfoGreenPrimaryX = 5;
        int hdr10MetadataInfoGreenPrimaryY = 5;
        int hdr10MetadataInfoBluePrimaryX = 5;
        int hdr10MetadataInfoBluePrimaryY = 5;
        int hdr10MetadataInfoWhitePointX = 5;
        int hdr10MetadataInfoWhitePointY = 5;
        int hdr10MetadataInfoMaxMasteringLuminance = 5;
        int hdr10MetadataInfoMinMasteringLuminance = 5;
        int hdr10MetadataInfoMaxContentLightLevel = 5;
        int hdr10MetadataInfoMaxFrameAverageLightLevel = 5;
        Hdr10MetadataInfo frameHdr10MetadataInfo = Hdr10MetadataInfo(
          redPrimaryX: hdr10MetadataInfoRedPrimaryX,
          redPrimaryY: hdr10MetadataInfoRedPrimaryY,
          greenPrimaryX: hdr10MetadataInfoGreenPrimaryX,
          greenPrimaryY: hdr10MetadataInfoGreenPrimaryY,
          bluePrimaryX: hdr10MetadataInfoBluePrimaryX,
          bluePrimaryY: hdr10MetadataInfoBluePrimaryY,
          whitePointX: hdr10MetadataInfoWhitePointX,
          whitePointY: hdr10MetadataInfoWhitePointY,
          maxMasteringLuminance: hdr10MetadataInfoMaxMasteringLuminance,
          minMasteringLuminance: hdr10MetadataInfoMinMasteringLuminance,
          maxContentLightLevel: hdr10MetadataInfoMaxContentLightLevel,
          maxFrameAverageLightLevel: hdr10MetadataInfoMaxFrameAverageLightLevel,
        );
        PrimaryID colorSpacePrimaries = PrimaryID.primaryidBt709;
        TransferID colorSpaceTransfer = TransferID.transferidBt709;
        MatrixID colorSpaceMatrix = MatrixID.matrixidRgb;
        RangeID colorSpaceRange = RangeID.rangeidInvalid;
        ColorSpace frameColorSpace = ColorSpace(
          primaries: colorSpacePrimaries,
          transfer: colorSpaceTransfer,
          matrix: colorSpaceMatrix,
          range: colorSpaceRange,
        );
        int frameWidth = 5;
        int frameHeight = 5;
        int frameYStride = 5;
        int frameUStride = 5;
        int frameVStride = 5;
        Uint8List frameYBuffer = Uint8List.fromList([1, 1, 1, 1, 1]);
        Uint8List frameUBuffer = Uint8List.fromList([1, 1, 1, 1, 1]);
        Uint8List frameVBuffer = Uint8List.fromList([1, 1, 1, 1, 1]);
        int frameRotation = 5;
        int frameRenderTimeMs = 5;
        int frameAvsyncType = 5;
        Uint8List frameMetadataBuffer = Uint8List.fromList([1, 1, 1, 1, 1]);
        int frameMetadataSize = 5;
        int frameTextureId = 5;
        List<double> frameMatrix = List.filled(5, 5.0);
        Uint8List frameAlphaBuffer = Uint8List.fromList([1, 1, 1, 1, 1]);
        Uint8List framePixelBuffer = Uint8List.fromList([1, 1, 1, 1, 1]);
        VideoFrame frame = VideoFrame(
          type: frameType,
          width: frameWidth,
          height: frameHeight,
          yStride: frameYStride,
          uStride: frameUStride,
          vStride: frameVStride,
          yBuffer: frameYBuffer,
          uBuffer: frameUBuffer,
          vBuffer: frameVBuffer,
          rotation: frameRotation,
          renderTimeMs: frameRenderTimeMs,
          avsyncType: frameAvsyncType,
          metadataBuffer: frameMetadataBuffer,
          metadataSize: frameMetadataSize,
          textureId: frameTextureId,
          matrix: frameMatrix,
          alphaBuffer: frameAlphaBuffer,
          alphaStitchMode: frameAlphaStitchMode,
          pixelBuffer: framePixelBuffer,
          metaInfo: frameMetaInfo,
          hdr10MetadataInfo: frameHdr10MetadataInfo,
          colorSpace: frameColorSpace,
        );

        final eventJson = {
          'frame': frame.toJson(),
        };

        final eventIds =
            eventIdsMapping['MediaPlayerVideoFrameObserver_onFrame'] ?? [];
        for (final event in eventIds) {
          final ret = irisTester().fireEvent(event, params: eventJson);
          // Delay 200 milliseconds to ensure the callback is called.
          await Future.delayed(const Duration(milliseconds: 200));
          // TODO(littlegnal): Most of callbacks on web are not implemented, we're temporarily skip these callbacks at this time.
          if (kIsWeb && ret) {
            if (!onFrameCompleter.isCompleted) {
              onFrameCompleter.complete(true);
            }
          }
        }
      }

      final eventCalled = await onFrameCompleter.future;
      expect(eventCalled, isTrue);

      {
        mediaPlayerController.unregisterVideoFrameObserver(
          theMediaPlayerVideoFrameObserver,
        );
      }
// Delay 500 milliseconds to ensure the unregisterVideoFrameObserver call completed.
      await Future.delayed(const Duration(milliseconds: 500));

      await rtcEngine.release();
    },
    timeout: const Timeout(Duration(minutes: 2)),
  );
}
