/// GENERATED BY testcase_gen. DO NOT MODIFY BY HAND.

// ignore_for_file: deprecated_member_use,constant_identifier_names

import 'package:agora_rtc_engine/agora_rtc_engine.dart';
import 'package:flutter_test/flutter_test.dart';
import 'dart:typed_data';
import 'package:flutter/foundation.dart';
import 'package:fake_test_app/main.dart' as app;
import 'package:iris_tester/iris_tester.dart';
import 'package:iris_method_channel/iris_method_channel.dart';

void mediaPlayerControllerSmokeTestCases() {
  testWidgets(
    'MediaPlayer.getMediaPlayerId',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      final mediaPlayerController = MediaPlayerController(
          rtcEngine: rtcEngine, canvas: const VideoCanvas(uid: 0));
      await mediaPlayerController.initialize();

      try {
        mediaPlayerController.getMediaPlayerId();
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[MediaPlayer.getMediaPlayerId] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await mediaPlayerController.dispose();
      await rtcEngine.release();
    },
//  skip: !(),
  );

  testWidgets(
    'MediaPlayer.open',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      final mediaPlayerController = MediaPlayerController(
          rtcEngine: rtcEngine, canvas: const VideoCanvas(uid: 0));
      await mediaPlayerController.initialize();

      try {
        String url = "hello";
        int startPos = 5;
        await mediaPlayerController.open(
          url: url,
          startPos: startPos,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[MediaPlayer.open] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await mediaPlayerController.dispose();
      await rtcEngine.release();
    },
//  skip: !(),
  );

  testWidgets(
    'MediaPlayer.openWithMediaSource',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      final mediaPlayerController = MediaPlayerController(
          rtcEngine: rtcEngine, canvas: const VideoCanvas(uid: 0));
      await mediaPlayerController.initialize();

      try {
        String sourceUrl = "hello";
        String sourceUri = "hello";
        int sourceStartPos = 5;
        bool sourceAutoPlay = true;
        bool sourceEnableCache = true;
        bool sourceEnableMultiAudioTrack = true;
        bool sourceIsAgoraSource = true;
        bool sourceIsLiveSource = true;
        MediaSource source = MediaSource(
          url: sourceUrl,
          uri: sourceUri,
          startPos: sourceStartPos,
          autoPlay: sourceAutoPlay,
          enableCache: sourceEnableCache,
          enableMultiAudioTrack: sourceEnableMultiAudioTrack,
          isAgoraSource: sourceIsAgoraSource,
          isLiveSource: sourceIsLiveSource,
        );
        await mediaPlayerController.openWithMediaSource(
          source,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[MediaPlayer.openWithMediaSource] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await mediaPlayerController.dispose();
      await rtcEngine.release();
    },
//  skip: !(),
  );

  testWidgets(
    'MediaPlayer.play',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      final mediaPlayerController = MediaPlayerController(
          rtcEngine: rtcEngine, canvas: const VideoCanvas(uid: 0));
      await mediaPlayerController.initialize();

      try {
        await mediaPlayerController.play();
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[MediaPlayer.play] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await mediaPlayerController.dispose();
      await rtcEngine.release();
    },
//  skip: !(),
  );

  testWidgets(
    'MediaPlayer.pause',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      final mediaPlayerController = MediaPlayerController(
          rtcEngine: rtcEngine, canvas: const VideoCanvas(uid: 0));
      await mediaPlayerController.initialize();

      try {
        await mediaPlayerController.pause();
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[MediaPlayer.pause] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await mediaPlayerController.dispose();
      await rtcEngine.release();
    },
//  skip: !(),
  );

  testWidgets(
    'MediaPlayer.stop',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      final mediaPlayerController = MediaPlayerController(
          rtcEngine: rtcEngine, canvas: const VideoCanvas(uid: 0));
      await mediaPlayerController.initialize();

      try {
        await mediaPlayerController.stop();
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[MediaPlayer.stop] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await mediaPlayerController.dispose();
      await rtcEngine.release();
    },
//  skip: !(),
  );

  testWidgets(
    'MediaPlayer.resume',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      final mediaPlayerController = MediaPlayerController(
          rtcEngine: rtcEngine, canvas: const VideoCanvas(uid: 0));
      await mediaPlayerController.initialize();

      try {
        await mediaPlayerController.resume();
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[MediaPlayer.resume] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await mediaPlayerController.dispose();
      await rtcEngine.release();
    },
//  skip: !(),
  );

  testWidgets(
    'MediaPlayer.seek',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      final mediaPlayerController = MediaPlayerController(
          rtcEngine: rtcEngine, canvas: const VideoCanvas(uid: 0));
      await mediaPlayerController.initialize();

      try {
        int newPos = 5;
        await mediaPlayerController.seek(
          newPos,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[MediaPlayer.seek] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await mediaPlayerController.dispose();
      await rtcEngine.release();
    },
//  skip: !(),
  );

  testWidgets(
    'MediaPlayer.setAudioPitch',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      final mediaPlayerController = MediaPlayerController(
          rtcEngine: rtcEngine, canvas: const VideoCanvas(uid: 0));
      await mediaPlayerController.initialize();

      try {
        int pitch = 5;
        await mediaPlayerController.setAudioPitch(
          pitch,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[MediaPlayer.setAudioPitch] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await mediaPlayerController.dispose();
      await rtcEngine.release();
    },
//  skip: !(),
  );

  testWidgets(
    'MediaPlayer.getDuration',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      final mediaPlayerController = MediaPlayerController(
          rtcEngine: rtcEngine, canvas: const VideoCanvas(uid: 0));
      await mediaPlayerController.initialize();

      try {
        await mediaPlayerController.getDuration();
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[MediaPlayer.getDuration] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await mediaPlayerController.dispose();
      await rtcEngine.release();
    },
//  skip: !(),
  );

  testWidgets(
    'MediaPlayer.getPlayPosition',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      final mediaPlayerController = MediaPlayerController(
          rtcEngine: rtcEngine, canvas: const VideoCanvas(uid: 0));
      await mediaPlayerController.initialize();

      try {
        await mediaPlayerController.getPlayPosition();
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[MediaPlayer.getPlayPosition] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await mediaPlayerController.dispose();
      await rtcEngine.release();
    },
//  skip: !(),
  );

  testWidgets(
    'MediaPlayer.getStreamCount',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      final mediaPlayerController = MediaPlayerController(
          rtcEngine: rtcEngine, canvas: const VideoCanvas(uid: 0));
      await mediaPlayerController.initialize();

      try {
        await mediaPlayerController.getStreamCount();
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[MediaPlayer.getStreamCount] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await mediaPlayerController.dispose();
      await rtcEngine.release();
    },
//  skip: !(),
  );

  testWidgets(
    'MediaPlayer.getStreamInfo',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      final mediaPlayerController = MediaPlayerController(
          rtcEngine: rtcEngine, canvas: const VideoCanvas(uid: 0));
      await mediaPlayerController.initialize();

      try {
        int index = 5;
        await mediaPlayerController.getStreamInfo(
          index,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[MediaPlayer.getStreamInfo] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await mediaPlayerController.dispose();
      await rtcEngine.release();
    },
//  skip: !(),
  );

  testWidgets(
    'MediaPlayer.setLoopCount',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      final mediaPlayerController = MediaPlayerController(
          rtcEngine: rtcEngine, canvas: const VideoCanvas(uid: 0));
      await mediaPlayerController.initialize();

      try {
        int loopCount = 5;
        await mediaPlayerController.setLoopCount(
          loopCount,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[MediaPlayer.setLoopCount] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await mediaPlayerController.dispose();
      await rtcEngine.release();
    },
//  skip: !(),
  );

  testWidgets(
    'MediaPlayer.setPlaybackSpeed',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      final mediaPlayerController = MediaPlayerController(
          rtcEngine: rtcEngine, canvas: const VideoCanvas(uid: 0));
      await mediaPlayerController.initialize();

      try {
        int speed = 5;
        await mediaPlayerController.setPlaybackSpeed(
          speed,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[MediaPlayer.setPlaybackSpeed] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await mediaPlayerController.dispose();
      await rtcEngine.release();
    },
//  skip: !(),
  );

  testWidgets(
    'MediaPlayer.selectAudioTrack',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      final mediaPlayerController = MediaPlayerController(
          rtcEngine: rtcEngine, canvas: const VideoCanvas(uid: 0));
      await mediaPlayerController.initialize();

      try {
        int index = 5;
        await mediaPlayerController.selectAudioTrack(
          index,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[MediaPlayer.selectAudioTrack] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await mediaPlayerController.dispose();
      await rtcEngine.release();
    },
//  skip: !(),
  );

  testWidgets(
    'MediaPlayer.selectMultiAudioTrack',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      final mediaPlayerController = MediaPlayerController(
          rtcEngine: rtcEngine, canvas: const VideoCanvas(uid: 0));
      await mediaPlayerController.initialize();

      try {
        int playoutTrackIndex = 5;
        int publishTrackIndex = 5;
        await mediaPlayerController.selectMultiAudioTrack(
          playoutTrackIndex: playoutTrackIndex,
          publishTrackIndex: publishTrackIndex,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[MediaPlayer.selectMultiAudioTrack] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await mediaPlayerController.dispose();
      await rtcEngine.release();
    },
//  skip: !(),
  );

  testWidgets(
    'MediaPlayer.takeScreenshot',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      final mediaPlayerController = MediaPlayerController(
          rtcEngine: rtcEngine, canvas: const VideoCanvas(uid: 0));
      await mediaPlayerController.initialize();

      try {
        String filename = "hello";
        await mediaPlayerController.takeScreenshot(
          filename,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[MediaPlayer.takeScreenshot] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await mediaPlayerController.dispose();
      await rtcEngine.release();
    },
//  skip: !(),
  );

  testWidgets(
    'MediaPlayer.selectInternalSubtitle',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      final mediaPlayerController = MediaPlayerController(
          rtcEngine: rtcEngine, canvas: const VideoCanvas(uid: 0));
      await mediaPlayerController.initialize();

      try {
        int index = 5;
        await mediaPlayerController.selectInternalSubtitle(
          index,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[MediaPlayer.selectInternalSubtitle] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await mediaPlayerController.dispose();
      await rtcEngine.release();
    },
//  skip: !(),
  );

  testWidgets(
    'MediaPlayer.setExternalSubtitle',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      final mediaPlayerController = MediaPlayerController(
          rtcEngine: rtcEngine, canvas: const VideoCanvas(uid: 0));
      await mediaPlayerController.initialize();

      try {
        String url = "hello";
        await mediaPlayerController.setExternalSubtitle(
          url,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[MediaPlayer.setExternalSubtitle] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await mediaPlayerController.dispose();
      await rtcEngine.release();
    },
//  skip: !(),
  );

  testWidgets(
    'MediaPlayer.getState',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      final mediaPlayerController = MediaPlayerController(
          rtcEngine: rtcEngine, canvas: const VideoCanvas(uid: 0));
      await mediaPlayerController.initialize();

      try {
        await mediaPlayerController.getState();
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[MediaPlayer.getState] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await mediaPlayerController.dispose();
      await rtcEngine.release();
    },
//  skip: !(),
  );

  testWidgets(
    'MediaPlayer.mute',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      final mediaPlayerController = MediaPlayerController(
          rtcEngine: rtcEngine, canvas: const VideoCanvas(uid: 0));
      await mediaPlayerController.initialize();

      try {
        bool muted = true;
        await mediaPlayerController.mute(
          muted,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[MediaPlayer.mute] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await mediaPlayerController.dispose();
      await rtcEngine.release();
    },
//  skip: !(),
  );

  testWidgets(
    'MediaPlayer.getMute',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      final mediaPlayerController = MediaPlayerController(
          rtcEngine: rtcEngine, canvas: const VideoCanvas(uid: 0));
      await mediaPlayerController.initialize();

      try {
        await mediaPlayerController.getMute();
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[MediaPlayer.getMute] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await mediaPlayerController.dispose();
      await rtcEngine.release();
    },
//  skip: !(),
  );

  testWidgets(
    'MediaPlayer.adjustPlayoutVolume',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      final mediaPlayerController = MediaPlayerController(
          rtcEngine: rtcEngine, canvas: const VideoCanvas(uid: 0));
      await mediaPlayerController.initialize();

      try {
        int volume = 5;
        await mediaPlayerController.adjustPlayoutVolume(
          volume,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[MediaPlayer.adjustPlayoutVolume] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await mediaPlayerController.dispose();
      await rtcEngine.release();
    },
//  skip: !(),
  );

  testWidgets(
    'MediaPlayer.getPlayoutVolume',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      final mediaPlayerController = MediaPlayerController(
          rtcEngine: rtcEngine, canvas: const VideoCanvas(uid: 0));
      await mediaPlayerController.initialize();

      try {
        await mediaPlayerController.getPlayoutVolume();
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[MediaPlayer.getPlayoutVolume] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await mediaPlayerController.dispose();
      await rtcEngine.release();
    },
//  skip: !(),
  );

  testWidgets(
    'MediaPlayer.adjustPublishSignalVolume',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      final mediaPlayerController = MediaPlayerController(
          rtcEngine: rtcEngine, canvas: const VideoCanvas(uid: 0));
      await mediaPlayerController.initialize();

      try {
        int volume = 5;
        await mediaPlayerController.adjustPublishSignalVolume(
          volume,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[MediaPlayer.adjustPublishSignalVolume] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await mediaPlayerController.dispose();
      await rtcEngine.release();
    },
//  skip: !(),
  );

  testWidgets(
    'MediaPlayer.getPublishSignalVolume',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      final mediaPlayerController = MediaPlayerController(
          rtcEngine: rtcEngine, canvas: const VideoCanvas(uid: 0));
      await mediaPlayerController.initialize();

      try {
        await mediaPlayerController.getPublishSignalVolume();
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[MediaPlayer.getPublishSignalVolume] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await mediaPlayerController.dispose();
      await rtcEngine.release();
    },
//  skip: !(),
  );

  testWidgets(
    'MediaPlayer.setView',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      final mediaPlayerController = MediaPlayerController(
          rtcEngine: rtcEngine, canvas: const VideoCanvas(uid: 0));
      await mediaPlayerController.initialize();

      try {
        int view = 5;
        await mediaPlayerController.setView(
          view,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[MediaPlayer.setView] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await mediaPlayerController.dispose();
      await rtcEngine.release();
    },
//  skip: !(),
  );

  testWidgets(
    'MediaPlayer.setRenderMode',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      final mediaPlayerController = MediaPlayerController(
          rtcEngine: rtcEngine, canvas: const VideoCanvas(uid: 0));
      await mediaPlayerController.initialize();

      try {
        RenderModeType renderMode = RenderModeType.renderModeHidden;
        await mediaPlayerController.setRenderMode(
          renderMode,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[MediaPlayer.setRenderMode] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await mediaPlayerController.dispose();
      await rtcEngine.release();
    },
//  skip: !(),
  );

  testWidgets(
    'MediaPlayer.registerPlayerSourceObserver',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      final mediaPlayerController = MediaPlayerController(
          rtcEngine: rtcEngine, canvas: const VideoCanvas(uid: 0));
      await mediaPlayerController.initialize();

      try {
        MediaPlayerSourceObserver observer = MediaPlayerSourceObserver(
          onPlayerSourceStateChanged:
              (MediaPlayerState state, MediaPlayerReason reason) {},
          onPositionChanged: (int positionMs, int timestampMs) {},
          onPlayerEvent:
              (MediaPlayerEvent eventCode, int elapsedTime, String message) {},
          onMetaData: (Uint8List data, int length) {},
          onPlayBufferUpdated: (int playCachedBuffer) {},
          onPreloadEvent: (String src, PlayerPreloadEvent event) {},
          onCompleted: () {},
          onAgoraCDNTokenWillExpire: () {},
          onPlayerSrcInfoChanged: (SrcInfo from, SrcInfo to) {},
          onPlayerInfoUpdated: (PlayerUpdatedInfo info) {},
          onPlayerCacheStats: (CacheStatistics stats) {},
          onPlayerPlaybackStats: (PlayerPlaybackStats stats) {},
          onAudioVolumeIndication: (int volume) {},
        );
        mediaPlayerController.registerPlayerSourceObserver(
          observer,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[MediaPlayer.registerPlayerSourceObserver] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await mediaPlayerController.dispose();
      await rtcEngine.release();
    },
//  skip: !(),
  );

  testWidgets(
    'MediaPlayer.unregisterPlayerSourceObserver',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      final mediaPlayerController = MediaPlayerController(
          rtcEngine: rtcEngine, canvas: const VideoCanvas(uid: 0));
      await mediaPlayerController.initialize();

      try {
        MediaPlayerSourceObserver observer = MediaPlayerSourceObserver(
          onPlayerSourceStateChanged:
              (MediaPlayerState state, MediaPlayerReason reason) {},
          onPositionChanged: (int positionMs, int timestampMs) {},
          onPlayerEvent:
              (MediaPlayerEvent eventCode, int elapsedTime, String message) {},
          onMetaData: (Uint8List data, int length) {},
          onPlayBufferUpdated: (int playCachedBuffer) {},
          onPreloadEvent: (String src, PlayerPreloadEvent event) {},
          onCompleted: () {},
          onAgoraCDNTokenWillExpire: () {},
          onPlayerSrcInfoChanged: (SrcInfo from, SrcInfo to) {},
          onPlayerInfoUpdated: (PlayerUpdatedInfo info) {},
          onPlayerCacheStats: (CacheStatistics stats) {},
          onPlayerPlaybackStats: (PlayerPlaybackStats stats) {},
          onAudioVolumeIndication: (int volume) {},
        );
        mediaPlayerController.unregisterPlayerSourceObserver(
          observer,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[MediaPlayer.unregisterPlayerSourceObserver] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await mediaPlayerController.dispose();
      await rtcEngine.release();
    },
//  skip: !(),
  );

  testWidgets(
    'MediaPlayer.registerAudioFrameObserver',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      final mediaPlayerController = MediaPlayerController(
          rtcEngine: rtcEngine, canvas: const VideoCanvas(uid: 0));
      await mediaPlayerController.initialize();

      try {
        AudioPcmFrameSink observer = AudioPcmFrameSink(
          onFrame: (AudioPcmFrame frame) {},
        );
        RawAudioFrameOpModeType mode =
            RawAudioFrameOpModeType.rawAudioFrameOpModeReadOnly;
        mediaPlayerController.registerAudioFrameObserver(
          observer: observer,
          mode: mode,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[MediaPlayer.registerAudioFrameObserver] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await mediaPlayerController.dispose();
      await rtcEngine.release();
    },
//  skip: !(),
  );

  testWidgets(
    'MediaPlayer.unregisterAudioFrameObserver',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      final mediaPlayerController = MediaPlayerController(
          rtcEngine: rtcEngine, canvas: const VideoCanvas(uid: 0));
      await mediaPlayerController.initialize();

      try {
        AudioPcmFrameSink observer = AudioPcmFrameSink(
          onFrame: (AudioPcmFrame frame) {},
        );
        mediaPlayerController.unregisterAudioFrameObserver(
          observer,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[MediaPlayer.unregisterAudioFrameObserver] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await mediaPlayerController.dispose();
      await rtcEngine.release();
    },
//  skip: !(),
  );

  testWidgets(
    'MediaPlayer.registerVideoFrameObserver',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      final mediaPlayerController = MediaPlayerController(
          rtcEngine: rtcEngine, canvas: const VideoCanvas(uid: 0));
      await mediaPlayerController.initialize();

      try {
        MediaPlayerVideoFrameObserver observer = MediaPlayerVideoFrameObserver(
          onFrame: (VideoFrame frame) {},
        );
        mediaPlayerController.registerVideoFrameObserver(
          observer,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[MediaPlayer.registerVideoFrameObserver] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await mediaPlayerController.dispose();
      await rtcEngine.release();
    },
//  skip: !(),
  );

  testWidgets(
    'MediaPlayer.unregisterVideoFrameObserver',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      final mediaPlayerController = MediaPlayerController(
          rtcEngine: rtcEngine, canvas: const VideoCanvas(uid: 0));
      await mediaPlayerController.initialize();

      try {
        MediaPlayerVideoFrameObserver observer = MediaPlayerVideoFrameObserver(
          onFrame: (VideoFrame frame) {},
        );
        mediaPlayerController.unregisterVideoFrameObserver(
          observer,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[MediaPlayer.unregisterVideoFrameObserver] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await mediaPlayerController.dispose();
      await rtcEngine.release();
    },
//  skip: !(),
  );

  testWidgets(
    'MediaPlayer.registerMediaPlayerAudioSpectrumObserver',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      final mediaPlayerController = MediaPlayerController(
          rtcEngine: rtcEngine, canvas: const VideoCanvas(uid: 0));
      await mediaPlayerController.initialize();

      try {
        AudioSpectrumObserver observer = AudioSpectrumObserver(
          onLocalAudioSpectrum: (AudioSpectrumData data) {},
          onRemoteAudioSpectrum: (List spectrums, int spectrumNumber) {},
        );
        int intervalInMS = 5;
        mediaPlayerController.registerMediaPlayerAudioSpectrumObserver(
          observer: observer,
          intervalInMS: intervalInMS,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[MediaPlayer.registerMediaPlayerAudioSpectrumObserver] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await mediaPlayerController.dispose();
      await rtcEngine.release();
    },
//  skip: !(),
  );

  testWidgets(
    'MediaPlayer.unregisterMediaPlayerAudioSpectrumObserver',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      final mediaPlayerController = MediaPlayerController(
          rtcEngine: rtcEngine, canvas: const VideoCanvas(uid: 0));
      await mediaPlayerController.initialize();

      try {
        AudioSpectrumObserver observer = AudioSpectrumObserver(
          onLocalAudioSpectrum: (AudioSpectrumData data) {},
          onRemoteAudioSpectrum: (List spectrums, int spectrumNumber) {},
        );
        mediaPlayerController.unregisterMediaPlayerAudioSpectrumObserver(
          observer,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[MediaPlayer.unregisterMediaPlayerAudioSpectrumObserver] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await mediaPlayerController.dispose();
      await rtcEngine.release();
    },
//  skip: !(),
  );

  testWidgets(
    'MediaPlayer.setAudioDualMonoMode',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      final mediaPlayerController = MediaPlayerController(
          rtcEngine: rtcEngine, canvas: const VideoCanvas(uid: 0));
      await mediaPlayerController.initialize();

      try {
        AudioDualMonoMode mode = AudioDualMonoMode.audioDualMonoStereo;
        await mediaPlayerController.setAudioDualMonoMode(
          mode,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[MediaPlayer.setAudioDualMonoMode] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await mediaPlayerController.dispose();
      await rtcEngine.release();
    },
//  skip: !(),
  );

  testWidgets(
    'MediaPlayer.getPlayerSdkVersion',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      final mediaPlayerController = MediaPlayerController(
          rtcEngine: rtcEngine, canvas: const VideoCanvas(uid: 0));
      await mediaPlayerController.initialize();

      try {
        await mediaPlayerController.getPlayerSdkVersion();
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[MediaPlayer.getPlayerSdkVersion] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await mediaPlayerController.dispose();
      await rtcEngine.release();
    },
//  skip: !(),
  );

  testWidgets(
    'MediaPlayer.getPlaySrc',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      final mediaPlayerController = MediaPlayerController(
          rtcEngine: rtcEngine, canvas: const VideoCanvas(uid: 0));
      await mediaPlayerController.initialize();

      try {
        await mediaPlayerController.getPlaySrc();
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[MediaPlayer.getPlaySrc] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await mediaPlayerController.dispose();
      await rtcEngine.release();
    },
//  skip: !(),
  );

  testWidgets(
    'MediaPlayer.openWithAgoraCDNSrc',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      final mediaPlayerController = MediaPlayerController(
          rtcEngine: rtcEngine, canvas: const VideoCanvas(uid: 0));
      await mediaPlayerController.initialize();

      try {
        String src = "hello";
        int startPos = 5;
        await mediaPlayerController.openWithAgoraCDNSrc(
          src: src,
          startPos: startPos,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[MediaPlayer.openWithAgoraCDNSrc] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await mediaPlayerController.dispose();
      await rtcEngine.release();
    },
//  skip: !(),
  );

  testWidgets(
    'MediaPlayer.getAgoraCDNLineCount',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      final mediaPlayerController = MediaPlayerController(
          rtcEngine: rtcEngine, canvas: const VideoCanvas(uid: 0));
      await mediaPlayerController.initialize();

      try {
        await mediaPlayerController.getAgoraCDNLineCount();
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[MediaPlayer.getAgoraCDNLineCount] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await mediaPlayerController.dispose();
      await rtcEngine.release();
    },
//  skip: !(),
  );

  testWidgets(
    'MediaPlayer.switchAgoraCDNLineByIndex',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      final mediaPlayerController = MediaPlayerController(
          rtcEngine: rtcEngine, canvas: const VideoCanvas(uid: 0));
      await mediaPlayerController.initialize();

      try {
        int index = 5;
        await mediaPlayerController.switchAgoraCDNLineByIndex(
          index,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[MediaPlayer.switchAgoraCDNLineByIndex] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await mediaPlayerController.dispose();
      await rtcEngine.release();
    },
//  skip: !(),
  );

  testWidgets(
    'MediaPlayer.getCurrentAgoraCDNIndex',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      final mediaPlayerController = MediaPlayerController(
          rtcEngine: rtcEngine, canvas: const VideoCanvas(uid: 0));
      await mediaPlayerController.initialize();

      try {
        await mediaPlayerController.getCurrentAgoraCDNIndex();
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[MediaPlayer.getCurrentAgoraCDNIndex] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await mediaPlayerController.dispose();
      await rtcEngine.release();
    },
//  skip: !(),
  );

  testWidgets(
    'MediaPlayer.enableAutoSwitchAgoraCDN',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      final mediaPlayerController = MediaPlayerController(
          rtcEngine: rtcEngine, canvas: const VideoCanvas(uid: 0));
      await mediaPlayerController.initialize();

      try {
        bool enable = true;
        await mediaPlayerController.enableAutoSwitchAgoraCDN(
          enable,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[MediaPlayer.enableAutoSwitchAgoraCDN] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await mediaPlayerController.dispose();
      await rtcEngine.release();
    },
//  skip: !(),
  );

  testWidgets(
    'MediaPlayer.renewAgoraCDNSrcToken',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      final mediaPlayerController = MediaPlayerController(
          rtcEngine: rtcEngine, canvas: const VideoCanvas(uid: 0));
      await mediaPlayerController.initialize();

      try {
        String token = "hello";
        int ts = 5;
        await mediaPlayerController.renewAgoraCDNSrcToken(
          token: token,
          ts: ts,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[MediaPlayer.renewAgoraCDNSrcToken] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await mediaPlayerController.dispose();
      await rtcEngine.release();
    },
//  skip: !(),
  );

  testWidgets(
    'MediaPlayer.switchAgoraCDNSrc',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      final mediaPlayerController = MediaPlayerController(
          rtcEngine: rtcEngine, canvas: const VideoCanvas(uid: 0));
      await mediaPlayerController.initialize();

      try {
        String src = "hello";
        bool syncPts = true;
        await mediaPlayerController.switchAgoraCDNSrc(
          src: src,
          syncPts: syncPts,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[MediaPlayer.switchAgoraCDNSrc] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await mediaPlayerController.dispose();
      await rtcEngine.release();
    },
//  skip: !(),
  );

  testWidgets(
    'MediaPlayer.switchSrc',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      final mediaPlayerController = MediaPlayerController(
          rtcEngine: rtcEngine, canvas: const VideoCanvas(uid: 0));
      await mediaPlayerController.initialize();

      try {
        String src = "hello";
        bool syncPts = true;
        await mediaPlayerController.switchSrc(
          src: src,
          syncPts: syncPts,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[MediaPlayer.switchSrc] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await mediaPlayerController.dispose();
      await rtcEngine.release();
    },
//  skip: !(),
  );

  testWidgets(
    'MediaPlayer.preloadSrc',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      final mediaPlayerController = MediaPlayerController(
          rtcEngine: rtcEngine, canvas: const VideoCanvas(uid: 0));
      await mediaPlayerController.initialize();

      try {
        String src = "hello";
        int startPos = 5;
        await mediaPlayerController.preloadSrc(
          src: src,
          startPos: startPos,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[MediaPlayer.preloadSrc] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await mediaPlayerController.dispose();
      await rtcEngine.release();
    },
//  skip: !(),
  );

  testWidgets(
    'MediaPlayer.playPreloadedSrc',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      final mediaPlayerController = MediaPlayerController(
          rtcEngine: rtcEngine, canvas: const VideoCanvas(uid: 0));
      await mediaPlayerController.initialize();

      try {
        String src = "hello";
        await mediaPlayerController.playPreloadedSrc(
          src,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[MediaPlayer.playPreloadedSrc] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await mediaPlayerController.dispose();
      await rtcEngine.release();
    },
//  skip: !(),
  );

  testWidgets(
    'MediaPlayer.unloadSrc',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      final mediaPlayerController = MediaPlayerController(
          rtcEngine: rtcEngine, canvas: const VideoCanvas(uid: 0));
      await mediaPlayerController.initialize();

      try {
        String src = "hello";
        await mediaPlayerController.unloadSrc(
          src,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[MediaPlayer.unloadSrc] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await mediaPlayerController.dispose();
      await rtcEngine.release();
    },
//  skip: !(),
  );

  testWidgets(
    'MediaPlayer.setSpatialAudioParams',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      final mediaPlayerController = MediaPlayerController(
          rtcEngine: rtcEngine, canvas: const VideoCanvas(uid: 0));
      await mediaPlayerController.initialize();

      try {
        double paramsSpeakerAzimuth = 5.0;
        double paramsSpeakerElevation = 5.0;
        double paramsSpeakerDistance = 5.0;
        int paramsSpeakerOrientation = 5;
        bool paramsEnableBlur = true;
        bool paramsEnableAirAbsorb = true;
        double paramsSpeakerAttenuation = 5.0;
        bool paramsEnableDoppler = true;
        SpatialAudioParams params = SpatialAudioParams(
          speakerAzimuth: paramsSpeakerAzimuth,
          speakerElevation: paramsSpeakerElevation,
          speakerDistance: paramsSpeakerDistance,
          speakerOrientation: paramsSpeakerOrientation,
          enableBlur: paramsEnableBlur,
          enableAirAbsorb: paramsEnableAirAbsorb,
          speakerAttenuation: paramsSpeakerAttenuation,
          enableDoppler: paramsEnableDoppler,
        );
        await mediaPlayerController.setSpatialAudioParams(
          params,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[MediaPlayer.setSpatialAudioParams] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await mediaPlayerController.dispose();
      await rtcEngine.release();
    },
//  skip: !(),
  );

  testWidgets(
    'MediaPlayer.setSoundPositionParams',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      final mediaPlayerController = MediaPlayerController(
          rtcEngine: rtcEngine, canvas: const VideoCanvas(uid: 0));
      await mediaPlayerController.initialize();

      try {
        double pan = 5.0;
        double gain = 5.0;
        await mediaPlayerController.setSoundPositionParams(
          pan: pan,
          gain: gain,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[MediaPlayer.setSoundPositionParams] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await mediaPlayerController.dispose();
      await rtcEngine.release();
    },
//  skip: !(),
  );

  testWidgets(
    'MediaPlayer.setPlayerOptionInInt',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      final mediaPlayerController = MediaPlayerController(
          rtcEngine: rtcEngine, canvas: const VideoCanvas(uid: 0));
      await mediaPlayerController.initialize();

      try {
        String key = "hello";
        int value = 5;
        await mediaPlayerController.setPlayerOptionInInt(
          key: key,
          value: value,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[MediaPlayer.setPlayerOptionInInt] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await mediaPlayerController.dispose();
      await rtcEngine.release();
    },
//  skip: !(),
  );

  testWidgets(
    'MediaPlayer.setPlayerOptionInString',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      final mediaPlayerController = MediaPlayerController(
          rtcEngine: rtcEngine, canvas: const VideoCanvas(uid: 0));
      await mediaPlayerController.initialize();

      try {
        String key = "hello";
        String value = "hello";
        await mediaPlayerController.setPlayerOptionInString(
          key: key,
          value: value,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[MediaPlayer.setPlayerOptionInString] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await mediaPlayerController.dispose();
      await rtcEngine.release();
    },
//  skip: !(),
  );
}
