/// GENERATED BY testcase_gen. DO NOT MODIFY BY HAND.

// ignore_for_file: deprecated_member_use,constant_identifier_names

import 'package:agora_rtc_engine/agora_rtc_engine.dart';
import 'package:flutter_test/flutter_test.dart';
import 'dart:typed_data';
import 'package:flutter/foundation.dart';
import 'package:fake_test_app/main.dart' as app;
import 'package:iris_tester/iris_tester.dart';
import 'package:iris_method_channel/iris_method_channel.dart';

void mediaEngineSmokeTestCases() {
  testWidgets(
    'MediaEngine.registerAudioFrameObserver',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      final mediaEngine = rtcEngine.getMediaEngine();

      try {
        AudioFrameObserver observer = AudioFrameObserver(
          onRecordAudioFrame: (String channelId, AudioFrame audioFrame) {},
          onPlaybackAudioFrame: (String channelId, AudioFrame audioFrame) {},
          onMixedAudioFrame: (String channelId, AudioFrame audioFrame) {},
          onEarMonitoringAudioFrame: (AudioFrame audioFrame) {},
          onPlaybackAudioFrameBeforeMixing:
              (String channelId, int uid, AudioFrame audioFrame) {},
        );
        mediaEngine.registerAudioFrameObserver(
          observer,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[MediaEngine.registerAudioFrameObserver] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await mediaEngine.release();
      await rtcEngine.release();
    },
//  skip: !(),
  );

  testWidgets(
    'MediaEngine.registerVideoFrameObserver',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      final mediaEngine = rtcEngine.getMediaEngine();

      try {
        VideoFrameObserver observer = VideoFrameObserver(
          onCaptureVideoFrame:
              (VideoSourceType sourceType, VideoFrame videoFrame) {},
          onPreEncodeVideoFrame:
              (VideoSourceType sourceType, VideoFrame videoFrame) {},
          onMediaPlayerVideoFrame:
              (VideoFrame videoFrame, int mediaPlayerId) {},
          onRenderVideoFrame:
              (String channelId, int remoteUid, VideoFrame videoFrame) {},
          onTranscodedVideoFrame: (VideoFrame videoFrame) {},
        );
        mediaEngine.registerVideoFrameObserver(
          observer,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[MediaEngine.registerVideoFrameObserver] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await mediaEngine.release();
      await rtcEngine.release();
    },
//  skip: !(),
  );

  testWidgets(
    'MediaEngine.registerVideoEncodedFrameObserver',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      final mediaEngine = rtcEngine.getMediaEngine();

      try {
        VideoEncodedFrameObserver observer = VideoEncodedFrameObserver(
          onEncodedVideoFrameReceived: (int uid, Uint8List imageBuffer,
              int length, EncodedVideoFrameInfo videoEncodedFrameInfo) {},
        );
        mediaEngine.registerVideoEncodedFrameObserver(
          observer,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[MediaEngine.registerVideoEncodedFrameObserver] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await mediaEngine.release();
      await rtcEngine.release();
    },
//  skip: !(),
  );

  testWidgets(
    'MediaEngine.registerFaceInfoObserver',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      final mediaEngine = rtcEngine.getMediaEngine();

      try {
        FaceInfoObserver observer = FaceInfoObserver(
          onFaceInfo: (String outFaceInfo) {},
        );
        mediaEngine.registerFaceInfoObserver(
          observer,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[MediaEngine.registerFaceInfoObserver] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await mediaEngine.release();
      await rtcEngine.release();
    },
//  skip: !(),
  );

  testWidgets(
    'MediaEngine.pushAudioFrame',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      final mediaEngine = rtcEngine.getMediaEngine();

      try {
        AudioFrameType frameType = AudioFrameType.frameTypePcm16;
        BytesPerSample frameBytesPerSample = BytesPerSample.twoBytesPerSample;
        int frameSamplesPerChannel = 5;
        int frameChannels = 5;
        int frameSamplesPerSec = 5;
        Uint8List frameBuffer = Uint8List.fromList([1, 1, 1, 1, 1]);
        int frameRenderTimeMs = 5;
        int frameAvsyncType = 5;
        int framePresentationMs = 5;
        int frameAudioTrackNumber = 5;
        int frameRtpTimestamp = 5;
        AudioFrame frame = AudioFrame(
          type: frameType,
          samplesPerChannel: frameSamplesPerChannel,
          bytesPerSample: frameBytesPerSample,
          channels: frameChannels,
          samplesPerSec: frameSamplesPerSec,
          buffer: frameBuffer,
          renderTimeMs: frameRenderTimeMs,
          avsyncType: frameAvsyncType,
          presentationMs: framePresentationMs,
          audioTrackNumber: frameAudioTrackNumber,
          rtpTimestamp: frameRtpTimestamp,
        );
        int trackId = 5;
        await mediaEngine.pushAudioFrame(
          frame: frame,
          trackId: trackId,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[MediaEngine.pushAudioFrame] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await mediaEngine.release();
      await rtcEngine.release();
    },
//  skip: !(),
  );

  testWidgets(
    'MediaEngine.pullAudioFrame',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      final mediaEngine = rtcEngine.getMediaEngine();

      try {
        AudioFrameType frameType = AudioFrameType.frameTypePcm16;
        BytesPerSample frameBytesPerSample = BytesPerSample.twoBytesPerSample;
        int frameSamplesPerChannel = 5;
        int frameChannels = 5;
        int frameSamplesPerSec = 5;
        Uint8List frameBuffer = Uint8List.fromList([1, 1, 1, 1, 1]);
        int frameRenderTimeMs = 5;
        int frameAvsyncType = 5;
        int framePresentationMs = 5;
        int frameAudioTrackNumber = 5;
        int frameRtpTimestamp = 5;
        AudioFrame frame = AudioFrame(
          type: frameType,
          samplesPerChannel: frameSamplesPerChannel,
          bytesPerSample: frameBytesPerSample,
          channels: frameChannels,
          samplesPerSec: frameSamplesPerSec,
          buffer: frameBuffer,
          renderTimeMs: frameRenderTimeMs,
          avsyncType: frameAvsyncType,
          presentationMs: framePresentationMs,
          audioTrackNumber: frameAudioTrackNumber,
          rtpTimestamp: frameRtpTimestamp,
        );
        await mediaEngine.pullAudioFrame(
          frame,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[MediaEngine.pullAudioFrame] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await mediaEngine.release();
      await rtcEngine.release();
    },
//  skip: !(),
  );

  testWidgets(
    'MediaEngine.setExternalVideoSource',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      final mediaEngine = rtcEngine.getMediaEngine();

      try {
        bool enabled = true;
        bool useTexture = true;
        ExternalVideoSourceType sourceType = ExternalVideoSourceType.videoFrame;
        TCcMode encodedVideoOptionCcMode = TCcMode.ccEnabled;
        VideoCodecType encodedVideoOptionCodecType =
            VideoCodecType.videoCodecNone;
        int encodedVideoOptionTargetBitrate = 5;
        SenderOptions encodedVideoOption = SenderOptions(
          ccMode: encodedVideoOptionCcMode,
          codecType: encodedVideoOptionCodecType,
          targetBitrate: encodedVideoOptionTargetBitrate,
        );
        await mediaEngine.setExternalVideoSource(
          enabled: enabled,
          useTexture: useTexture,
          sourceType: sourceType,
          encodedVideoOption: encodedVideoOption,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[MediaEngine.setExternalVideoSource] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await mediaEngine.release();
      await rtcEngine.release();
    },
//  skip: !(),
  );

  testWidgets(
    'MediaEngine.setExternalRemoteEglContext',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      final mediaEngine = rtcEngine.getMediaEngine();

      try {
        int eglContext = 5;
        await mediaEngine.setExternalRemoteEglContext(
          eglContext,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[MediaEngine.setExternalRemoteEglContext] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await mediaEngine.release();
      await rtcEngine.release();
    },
//  skip: !(),
  );

  testWidgets(
    'MediaEngine.setExternalAudioSource',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      final mediaEngine = rtcEngine.getMediaEngine();

      try {
        bool enabled = true;
        int sampleRate = 5;
        int channels = 5;
        bool localPlayback = true;
        bool publish = true;
        await mediaEngine.setExternalAudioSource(
          enabled: enabled,
          sampleRate: sampleRate,
          channels: channels,
          localPlayback: localPlayback,
          publish: publish,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[MediaEngine.setExternalAudioSource] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await mediaEngine.release();
      await rtcEngine.release();
    },
//  skip: !(),
  );

  testWidgets(
    'MediaEngine.destroyCustomAudioTrack',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      final mediaEngine = rtcEngine.getMediaEngine();

      try {
        int trackId = 5;
        await mediaEngine.destroyCustomAudioTrack(
          trackId,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[MediaEngine.destroyCustomAudioTrack] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await mediaEngine.release();
      await rtcEngine.release();
    },
//  skip: !(),
  );

  testWidgets(
    'MediaEngine.setExternalAudioSink',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      final mediaEngine = rtcEngine.getMediaEngine();

      try {
        bool enabled = true;
        int sampleRate = 5;
        int channels = 5;
        await mediaEngine.setExternalAudioSink(
          enabled: enabled,
          sampleRate: sampleRate,
          channels: channels,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[MediaEngine.setExternalAudioSink] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await mediaEngine.release();
      await rtcEngine.release();
    },
//  skip: !(),
  );

  testWidgets(
    'MediaEngine.enableCustomAudioLocalPlayback',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      final mediaEngine = rtcEngine.getMediaEngine();

      try {
        int trackId = 5;
        bool enabled = true;
        await mediaEngine.enableCustomAudioLocalPlayback(
          trackId: trackId,
          enabled: enabled,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[MediaEngine.enableCustomAudioLocalPlayback] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await mediaEngine.release();
      await rtcEngine.release();
    },
//  skip: !(),
  );

  testWidgets(
    'MediaEngine.pushVideoFrame',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      final mediaEngine = rtcEngine.getMediaEngine();

      try {
        VideoBufferType frameType = VideoBufferType.videoBufferRawData;
        VideoPixelFormat frameFormat = VideoPixelFormat.videoPixelDefault;
        EglContextType frameEglType = EglContextType.eglContext10;
        AlphaStitchMode frameAlphaStitchMode = AlphaStitchMode.noAlphaStitch;
        int hdr10MetadataInfoRedPrimaryX = 5;
        int hdr10MetadataInfoRedPrimaryY = 5;
        int hdr10MetadataInfoGreenPrimaryX = 5;
        int hdr10MetadataInfoGreenPrimaryY = 5;
        int hdr10MetadataInfoBluePrimaryX = 5;
        int hdr10MetadataInfoBluePrimaryY = 5;
        int hdr10MetadataInfoWhitePointX = 5;
        int hdr10MetadataInfoWhitePointY = 5;
        int hdr10MetadataInfoMaxMasteringLuminance = 5;
        int hdr10MetadataInfoMinMasteringLuminance = 5;
        int hdr10MetadataInfoMaxContentLightLevel = 5;
        int hdr10MetadataInfoMaxFrameAverageLightLevel = 5;
        Hdr10MetadataInfo frameHdr10MetadataInfo = Hdr10MetadataInfo(
          redPrimaryX: hdr10MetadataInfoRedPrimaryX,
          redPrimaryY: hdr10MetadataInfoRedPrimaryY,
          greenPrimaryX: hdr10MetadataInfoGreenPrimaryX,
          greenPrimaryY: hdr10MetadataInfoGreenPrimaryY,
          bluePrimaryX: hdr10MetadataInfoBluePrimaryX,
          bluePrimaryY: hdr10MetadataInfoBluePrimaryY,
          whitePointX: hdr10MetadataInfoWhitePointX,
          whitePointY: hdr10MetadataInfoWhitePointY,
          maxMasteringLuminance: hdr10MetadataInfoMaxMasteringLuminance,
          minMasteringLuminance: hdr10MetadataInfoMinMasteringLuminance,
          maxContentLightLevel: hdr10MetadataInfoMaxContentLightLevel,
          maxFrameAverageLightLevel: hdr10MetadataInfoMaxFrameAverageLightLevel,
        );
        PrimaryID colorSpacePrimaries = PrimaryID.primaryidBt709;
        TransferID colorSpaceTransfer = TransferID.transferidBt709;
        MatrixID colorSpaceMatrix = MatrixID.matrixidRgb;
        RangeID colorSpaceRange = RangeID.rangeidInvalid;
        ColorSpace frameColorSpace = ColorSpace(
          primaries: colorSpacePrimaries,
          transfer: colorSpaceTransfer,
          matrix: colorSpaceMatrix,
          range: colorSpaceRange,
        );
        Uint8List frameBuffer = Uint8List.fromList([1, 1, 1, 1, 1]);
        int frameStride = 5;
        int frameHeight = 5;
        int frameCropLeft = 5;
        int frameCropTop = 5;
        int frameCropRight = 5;
        int frameCropBottom = 5;
        int frameRotation = 5;
        int frameTimestamp = 5;
        int frameTextureId = 5;
        int frameFenceObject = 5;
        List<double> frameMatrix = List.filled(5, 5.0);
        Uint8List frameMetadataBuffer = Uint8List.fromList([1, 1, 1, 1, 1]);
        int frameMetadataSize = 5;
        Uint8List frameAlphaBuffer = Uint8List.fromList([1, 1, 1, 1, 1]);
        bool frameFillAlphaBuffer = true;
        int frameD3d11Texture2d = 5;
        int frameTextureSliceIndex = 5;
        ExternalVideoFrame frame = ExternalVideoFrame(
          type: frameType,
          format: frameFormat,
          buffer: frameBuffer,
          stride: frameStride,
          height: frameHeight,
          cropLeft: frameCropLeft,
          cropTop: frameCropTop,
          cropRight: frameCropRight,
          cropBottom: frameCropBottom,
          rotation: frameRotation,
          timestamp: frameTimestamp,
          eglType: frameEglType,
          textureId: frameTextureId,
          fenceObject: frameFenceObject,
          matrix: frameMatrix,
          metadataBuffer: frameMetadataBuffer,
          metadataSize: frameMetadataSize,
          alphaBuffer: frameAlphaBuffer,
          fillAlphaBuffer: frameFillAlphaBuffer,
          alphaStitchMode: frameAlphaStitchMode,
          d3d11Texture2d: frameD3d11Texture2d,
          textureSliceIndex: frameTextureSliceIndex,
          hdr10MetadataInfo: frameHdr10MetadataInfo,
          colorSpace: frameColorSpace,
        );
        int videoTrackId = 5;
        await mediaEngine.pushVideoFrame(
          frame: frame,
          videoTrackId: videoTrackId,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[MediaEngine.pushVideoFrame] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await mediaEngine.release();
      await rtcEngine.release();
    },
//  skip: !(),
  );

  testWidgets(
    'MediaEngine.pushEncodedVideoImage',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      final mediaEngine = rtcEngine.getMediaEngine();

      try {
        Uint8List imageBuffer = Uint8List.fromList([1, 1, 1, 1, 1]);
        int length = 5;
        VideoCodecType videoEncodedFrameInfoCodecType =
            VideoCodecType.videoCodecNone;
        VideoFrameType videoEncodedFrameInfoFrameType =
            VideoFrameType.videoFrameTypeBlankFrame;
        VideoOrientation videoEncodedFrameInfoRotation =
            VideoOrientation.videoOrientation0;
        VideoStreamType videoEncodedFrameInfoStreamType =
            VideoStreamType.videoStreamHigh;
        int videoEncodedFrameInfoUid = 5;
        int videoEncodedFrameInfoWidth = 5;
        int videoEncodedFrameInfoHeight = 5;
        int videoEncodedFrameInfoFramesPerSecond = 5;
        int videoEncodedFrameInfoTrackId = 5;
        int videoEncodedFrameInfoCaptureTimeMs = 5;
        int videoEncodedFrameInfoDecodeTimeMs = 5;
        int videoEncodedFrameInfoPresentationMs = 5;
        EncodedVideoFrameInfo videoEncodedFrameInfo = EncodedVideoFrameInfo(
          uid: videoEncodedFrameInfoUid,
          codecType: videoEncodedFrameInfoCodecType,
          width: videoEncodedFrameInfoWidth,
          height: videoEncodedFrameInfoHeight,
          framesPerSecond: videoEncodedFrameInfoFramesPerSecond,
          frameType: videoEncodedFrameInfoFrameType,
          rotation: videoEncodedFrameInfoRotation,
          trackId: videoEncodedFrameInfoTrackId,
          captureTimeMs: videoEncodedFrameInfoCaptureTimeMs,
          decodeTimeMs: videoEncodedFrameInfoDecodeTimeMs,
          streamType: videoEncodedFrameInfoStreamType,
          presentationMs: videoEncodedFrameInfoPresentationMs,
        );
        int videoTrackId = 5;
        await mediaEngine.pushEncodedVideoImage(
          imageBuffer: imageBuffer,
          length: length,
          videoEncodedFrameInfo: videoEncodedFrameInfo,
          videoTrackId: videoTrackId,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[MediaEngine.pushEncodedVideoImage] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await mediaEngine.release();
      await rtcEngine.release();
    },
//  skip: !(),
  );

  testWidgets(
    'MediaEngine.release',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      final mediaEngine = rtcEngine.getMediaEngine();

      try {
        await mediaEngine.release();
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint('[MediaEngine.release] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await mediaEngine.release();
      await rtcEngine.release();
    },
//  skip: !(),
  );

  testWidgets(
    'MediaEngine.unregisterAudioFrameObserver',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      final mediaEngine = rtcEngine.getMediaEngine();

      try {
        AudioFrameObserver observer = AudioFrameObserver(
          onRecordAudioFrame: (String channelId, AudioFrame audioFrame) {},
          onPlaybackAudioFrame: (String channelId, AudioFrame audioFrame) {},
          onMixedAudioFrame: (String channelId, AudioFrame audioFrame) {},
          onEarMonitoringAudioFrame: (AudioFrame audioFrame) {},
          onPlaybackAudioFrameBeforeMixing:
              (String channelId, int uid, AudioFrame audioFrame) {},
        );
        mediaEngine.unregisterAudioFrameObserver(
          observer,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[MediaEngine.unregisterAudioFrameObserver] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await mediaEngine.release();
      await rtcEngine.release();
    },
//  skip: !(),
  );

  testWidgets(
    'MediaEngine.unregisterVideoFrameObserver',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      final mediaEngine = rtcEngine.getMediaEngine();

      try {
        VideoFrameObserver observer = VideoFrameObserver(
          onCaptureVideoFrame:
              (VideoSourceType sourceType, VideoFrame videoFrame) {},
          onPreEncodeVideoFrame:
              (VideoSourceType sourceType, VideoFrame videoFrame) {},
          onMediaPlayerVideoFrame:
              (VideoFrame videoFrame, int mediaPlayerId) {},
          onRenderVideoFrame:
              (String channelId, int remoteUid, VideoFrame videoFrame) {},
          onTranscodedVideoFrame: (VideoFrame videoFrame) {},
        );
        mediaEngine.unregisterVideoFrameObserver(
          observer,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[MediaEngine.unregisterVideoFrameObserver] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await mediaEngine.release();
      await rtcEngine.release();
    },
//  skip: !(),
  );

  testWidgets(
    'MediaEngine.unregisterVideoEncodedFrameObserver',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      final mediaEngine = rtcEngine.getMediaEngine();

      try {
        VideoEncodedFrameObserver observer = VideoEncodedFrameObserver(
          onEncodedVideoFrameReceived: (int uid, Uint8List imageBuffer,
              int length, EncodedVideoFrameInfo videoEncodedFrameInfo) {},
        );
        mediaEngine.unregisterVideoEncodedFrameObserver(
          observer,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[MediaEngine.unregisterVideoEncodedFrameObserver] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await mediaEngine.release();
      await rtcEngine.release();
    },
//  skip: !(),
  );

  testWidgets(
    'MediaEngine.unregisterFaceInfoObserver',
    (WidgetTester tester) async {
      String engineAppId = const String.fromEnvironment('TEST_APP_ID',
          defaultValue: '<YOUR_APP_ID>');

      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: engineAppId,
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      final mediaEngine = rtcEngine.getMediaEngine();

      try {
        FaceInfoObserver observer = FaceInfoObserver(
          onFaceInfo: (String outFaceInfo) {},
        );
        mediaEngine.unregisterFaceInfoObserver(
          observer,
        );
      } catch (e) {
        if (e is! AgoraRtcException) {
          debugPrint(
              '[MediaEngine.unregisterFaceInfoObserver] error: ${e.toString()}');
          rethrow;
        }

        if (e.code != -4) {
          // Only not supported error supported.
          rethrow;
        }
      }

      await mediaEngine.release();
      await rtcEngine.release();
    },
//  skip: !(),
  );
}
