/// GENERATED BY testcase_gen. DO NOT MODIFY BY HAND.

// ignore_for_file: deprecated_member_use,constant_identifier_names

import 'dart:async';
import 'dart:typed_data';

import 'package:agora_rtc_engine/agora_rtc_engine.dart';
import 'package:flutter/foundation.dart';
import 'package:flutter_test/flutter_test.dart';
import 'package:iris_tester/iris_tester.dart';
import 'package:iris_method_channel/iris_method_channel.dart';

import '../testcases/event_ids_mapping.dart';

void generatedTestCases(ValueGetter<IrisTester> irisTester) {
  testWidgets(
    'FaceInfoObserver.onFaceInfo',
    (WidgetTester tester) async {
      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: 'app_id',
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');
      final mediaEngine = rtcEngine.getMediaEngine();

      final onFaceInfoCompleter = Completer<bool>();
      final theFaceInfoObserver = FaceInfoObserver(
        onFaceInfo: (String outFaceInfo) {
          onFaceInfoCompleter.complete(true);
        },
      );

      mediaEngine.registerFaceInfoObserver(
        theFaceInfoObserver,
      );

// Delay 500 milliseconds to ensure the registerFaceInfoObserver call completed.
      await Future.delayed(const Duration(milliseconds: 500));

      {
        String outFaceInfo = "hello";

        final eventJson = {
          'outFaceInfo': outFaceInfo,
        };

        final eventIds = eventIdsMapping['FaceInfoObserver_onFaceInfo'] ?? [];
        for (final event in eventIds) {
          final ret = irisTester().fireEvent(event, params: eventJson);
          // Delay 200 milliseconds to ensure the callback is called.
          await Future.delayed(const Duration(milliseconds: 200));
          // TODO(littlegnal): Most of callbacks on web are not implemented, we're temporarily skip these callbacks at this time.
          if (kIsWeb && ret) {
            if (!onFaceInfoCompleter.isCompleted) {
              onFaceInfoCompleter.complete(true);
            }
          }
        }
      }

      final eventCalled = await onFaceInfoCompleter.future;
      expect(eventCalled, isTrue);

      {
        mediaEngine.unregisterFaceInfoObserver(
          theFaceInfoObserver,
        );
      }
// Delay 500 milliseconds to ensure the unregisterFaceInfoObserver call completed.
      await Future.delayed(const Duration(milliseconds: 500));

      await rtcEngine.release();
    },
    timeout: const Timeout(Duration(minutes: 2)),
  );
}
