/// GENERATED BY testcase_gen. DO NOT MODIFY BY HAND.

// ignore_for_file: deprecated_member_use,constant_identifier_names

import 'dart:async';
import 'dart:typed_data';

import 'package:agora_rtc_engine/agora_rtc_engine.dart';
import 'package:flutter/foundation.dart';
import 'package:flutter_test/flutter_test.dart';
import 'package:iris_tester/iris_tester.dart';
import 'package:iris_method_channel/iris_method_channel.dart';

import '../testcases/event_ids_mapping.dart';

void generatedTestCases(ValueGetter<IrisTester> irisTester) {
  testWidgets(
    'AudioFrameObserver.onPlaybackAudioFrameBeforeMixing',
    (WidgetTester tester) async {
      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: 'app_id',
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');
      final mediaEngine = rtcEngine.getMediaEngine();

      final onPlaybackAudioFrameBeforeMixingCompleter = Completer<bool>();
      final theAudioFrameObserver = AudioFrameObserver(
        onPlaybackAudioFrameBeforeMixing:
            (String channelId, int uid, AudioFrame audioFrame) {
          onPlaybackAudioFrameBeforeMixingCompleter.complete(true);
        },
      );

      mediaEngine.registerAudioFrameObserver(
        theAudioFrameObserver,
      );

// Delay 500 milliseconds to ensure the registerAudioFrameObserver call completed.
      await Future.delayed(const Duration(milliseconds: 500));

      {
        String channelId = "hello";
        int uid = 5;
        AudioFrameType audioFrameType = AudioFrameType.frameTypePcm16;
        BytesPerSample audioFrameBytesPerSample =
            BytesPerSample.twoBytesPerSample;
        int audioFrameSamplesPerChannel = 5;
        int audioFrameChannels = 5;
        int audioFrameSamplesPerSec = 5;
        Uint8List audioFrameBuffer = Uint8List.fromList([1, 1, 1, 1, 1]);
        int audioFrameRenderTimeMs = 5;
        int audioFrameAvsyncType = 5;
        int audioFramePresentationMs = 5;
        int audioFrameAudioTrackNumber = 5;
        int audioFrameRtpTimestamp = 5;
        AudioFrame audioFrame = AudioFrame(
          type: audioFrameType,
          samplesPerChannel: audioFrameSamplesPerChannel,
          bytesPerSample: audioFrameBytesPerSample,
          channels: audioFrameChannels,
          samplesPerSec: audioFrameSamplesPerSec,
          buffer: audioFrameBuffer,
          renderTimeMs: audioFrameRenderTimeMs,
          avsyncType: audioFrameAvsyncType,
          presentationMs: audioFramePresentationMs,
          audioTrackNumber: audioFrameAudioTrackNumber,
          rtpTimestamp: audioFrameRtpTimestamp,
        );

        final eventJson = {
          'channelId': channelId,
          'uid': uid,
          'audioFrame': audioFrame.toJson(),
        };

        final eventIds = eventIdsMapping[
                'AudioFrameObserver_onPlaybackAudioFrameBeforeMixing'] ??
            [];
        for (final event in eventIds) {
          final ret = irisTester().fireEvent(event, params: eventJson);
          // Delay 200 milliseconds to ensure the callback is called.
          await Future.delayed(const Duration(milliseconds: 200));
          // TODO(littlegnal): Most of callbacks on web are not implemented, we're temporarily skip these callbacks at this time.
          if (kIsWeb && ret) {
            if (!onPlaybackAudioFrameBeforeMixingCompleter.isCompleted) {
              onPlaybackAudioFrameBeforeMixingCompleter.complete(true);
            }
          }
        }
      }

      final eventCalled =
          await onPlaybackAudioFrameBeforeMixingCompleter.future;
      expect(eventCalled, isTrue);

      {
        mediaEngine.unregisterAudioFrameObserver(
          theAudioFrameObserver,
        );
      }
// Delay 500 milliseconds to ensure the unregisterAudioFrameObserver call completed.
      await Future.delayed(const Duration(milliseconds: 500));

      await rtcEngine.release();
    },
    timeout: const Timeout(Duration(minutes: 2)),
  );
}
