/// GENERATED BY testcase_gen. DO NOT MODIFY BY HAND.

// ignore_for_file: deprecated_member_use,constant_identifier_names

import 'dart:async';
import 'dart:typed_data';

import 'package:agora_rtc_engine/agora_rtc_engine.dart';
import 'package:flutter/foundation.dart';
import 'package:flutter_test/flutter_test.dart';
import 'package:iris_tester/iris_tester.dart';
import 'package:iris_method_channel/iris_method_channel.dart';

import '../testcases/event_ids_mapping.dart';

void generatedTestCases(ValueGetter<IrisTester> irisTester) {
  testWidgets(
    'H265TranscoderObserver.onEnableTranscode',
    (WidgetTester tester) async {
      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: 'app_id',
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      final h265Transcoder = rtcEngine.getH265Transcoder();

      final onEnableTranscodeCompleter = Completer<bool>();
      final theH265TranscoderObserver = H265TranscoderObserver(
        onEnableTranscode: (H265TranscodeResult result) {
          onEnableTranscodeCompleter.complete(true);
        },
      );

      h265Transcoder.registerTranscoderObserver(
        theH265TranscoderObserver,
      );

// Delay 500 milliseconds to ensure the registerTranscoderObserver call completed.
      await Future.delayed(const Duration(milliseconds: 500));

      {
        H265TranscodeResult result =
            H265TranscodeResult.h265TranscodeResultUnknown;

        final eventJson = {
          'result': result.value(),
        };

        final eventIds =
            eventIdsMapping['H265TranscoderObserver_onEnableTranscode'] ?? [];
        for (final event in eventIds) {
          final ret = irisTester().fireEvent(event, params: eventJson);
          // Delay 200 milliseconds to ensure the callback is called.
          await Future.delayed(const Duration(milliseconds: 200));
          // TODO(littlegnal): Most of callbacks on web are not implemented, we're temporarily skip these callbacks at this time.
          if (kIsWeb && ret) {
            if (!onEnableTranscodeCompleter.isCompleted) {
              onEnableTranscodeCompleter.complete(true);
            }
          }
        }
      }

      final eventCalled = await onEnableTranscodeCompleter.future;
      expect(eventCalled, isTrue);

      {
        h265Transcoder.unregisterTranscoderObserver(
          theH265TranscoderObserver,
        );
      }
// Delay 500 milliseconds to ensure the unregisterTranscoderObserver call completed.
      await Future.delayed(const Duration(milliseconds: 500));

      await rtcEngine.release();
    },
    timeout: const Timeout(Duration(minutes: 2)),
  );

  testWidgets(
    'H265TranscoderObserver.onQueryChannel',
    (WidgetTester tester) async {
      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: 'app_id',
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      final h265Transcoder = rtcEngine.getH265Transcoder();

      final onQueryChannelCompleter = Completer<bool>();
      final theH265TranscoderObserver = H265TranscoderObserver(
        onQueryChannel: (H265TranscodeResult result, String originChannel,
            String transcodeChannel) {
          onQueryChannelCompleter.complete(true);
        },
      );

      h265Transcoder.registerTranscoderObserver(
        theH265TranscoderObserver,
      );

// Delay 500 milliseconds to ensure the registerTranscoderObserver call completed.
      await Future.delayed(const Duration(milliseconds: 500));

      {
        H265TranscodeResult result =
            H265TranscodeResult.h265TranscodeResultUnknown;
        String originChannel = "hello";
        String transcodeChannel = "hello";

        final eventJson = {
          'result': result.value(),
          'originChannel': originChannel,
          'transcodeChannel': transcodeChannel,
        };

        final eventIds =
            eventIdsMapping['H265TranscoderObserver_onQueryChannel'] ?? [];
        for (final event in eventIds) {
          final ret = irisTester().fireEvent(event, params: eventJson);
          // Delay 200 milliseconds to ensure the callback is called.
          await Future.delayed(const Duration(milliseconds: 200));
          // TODO(littlegnal): Most of callbacks on web are not implemented, we're temporarily skip these callbacks at this time.
          if (kIsWeb && ret) {
            if (!onQueryChannelCompleter.isCompleted) {
              onQueryChannelCompleter.complete(true);
            }
          }
        }
      }

      final eventCalled = await onQueryChannelCompleter.future;
      expect(eventCalled, isTrue);

      {
        h265Transcoder.unregisterTranscoderObserver(
          theH265TranscoderObserver,
        );
      }
// Delay 500 milliseconds to ensure the unregisterTranscoderObserver call completed.
      await Future.delayed(const Duration(milliseconds: 500));

      await rtcEngine.release();
    },
    timeout: const Timeout(Duration(minutes: 2)),
  );

  testWidgets(
    'H265TranscoderObserver.onTriggerTranscode',
    (WidgetTester tester) async {
      RtcEngine rtcEngine = createAgoraRtcEngine();
      await rtcEngine.initialize(RtcEngineContext(
        appId: 'app_id',
        areaCode: AreaCode.areaCodeGlob.value(),
      ));
      await rtcEngine.setParameters('{"rtc.enable_debug_log": true}');

      final h265Transcoder = rtcEngine.getH265Transcoder();

      final onTriggerTranscodeCompleter = Completer<bool>();
      final theH265TranscoderObserver = H265TranscoderObserver(
        onTriggerTranscode: (H265TranscodeResult result) {
          onTriggerTranscodeCompleter.complete(true);
        },
      );

      h265Transcoder.registerTranscoderObserver(
        theH265TranscoderObserver,
      );

// Delay 500 milliseconds to ensure the registerTranscoderObserver call completed.
      await Future.delayed(const Duration(milliseconds: 500));

      {
        H265TranscodeResult result =
            H265TranscodeResult.h265TranscodeResultUnknown;

        final eventJson = {
          'result': result.value(),
        };

        final eventIds =
            eventIdsMapping['H265TranscoderObserver_onTriggerTranscode'] ?? [];
        for (final event in eventIds) {
          final ret = irisTester().fireEvent(event, params: eventJson);
          // Delay 200 milliseconds to ensure the callback is called.
          await Future.delayed(const Duration(milliseconds: 200));
          // TODO(littlegnal): Most of callbacks on web are not implemented, we're temporarily skip these callbacks at this time.
          if (kIsWeb && ret) {
            if (!onTriggerTranscodeCompleter.isCompleted) {
              onTriggerTranscodeCompleter.complete(true);
            }
          }
        }
      }

      final eventCalled = await onTriggerTranscodeCompleter.future;
      expect(eventCalled, isTrue);

      {
        h265Transcoder.unregisterTranscoderObserver(
          theH265TranscoderObserver,
        );
      }
// Delay 500 milliseconds to ensure the unregisterTranscoderObserver call completed.
      await Future.delayed(const Duration(milliseconds: 500));

      await rtcEngine.release();
    },
    timeout: const Timeout(Duration(minutes: 2)),
  );
}
