/// GENERATED BY terra, DO NOT MODIFY BY HAND.

// ignore_for_file: public_member_api_docs, unused_local_variable, unused_import

import 'package:agora_rtc_engine/src/binding_forward_export.dart';
import 'package:agora_rtc_engine/src/binding/impl_forward_export.dart';
import 'package:iris_method_channel/iris_method_channel.dart';

class RtcEngineEventHandlerWrapper implements EventLoopEventHandler {
  const RtcEngineEventHandlerWrapper(this.rtcEngineEventHandler);

  final RtcEngineEventHandler rtcEngineEventHandler;

  @override
  bool operator ==(Object other) {
    if (other.runtimeType != runtimeType) {
      return false;
    }
    return other is RtcEngineEventHandlerWrapper &&
        other.rtcEngineEventHandler == rtcEngineEventHandler;
  }

  @override
  int get hashCode => rtcEngineEventHandler.hashCode;

  @override
  bool handleEventInternal(
      String eventName, String eventData, List<Uint8List> buffers) {
    switch (eventName) {
      case 'onJoinChannelSuccess_263e4cd':
        if (rtcEngineEventHandler.onJoinChannelSuccess == null) {
          return true;
        }
        final jsonMap = jsonDecode(eventData);
        RtcEngineEventHandlerOnJoinChannelSuccessJson paramJson =
            RtcEngineEventHandlerOnJoinChannelSuccessJson.fromJson(jsonMap);
        paramJson = paramJson.fillBuffers(buffers);
        RtcConnection? connection = paramJson.connection;
        int? elapsed = paramJson.elapsed;
        if (connection == null || elapsed == null) {
          return true;
        }
        connection = connection.fillBuffers(buffers);
        rtcEngineEventHandler.onJoinChannelSuccess!(connection, elapsed);
        return true;

      case 'onRejoinChannelSuccess_263e4cd':
        if (rtcEngineEventHandler.onRejoinChannelSuccess == null) {
          return true;
        }
        final jsonMap = jsonDecode(eventData);
        RtcEngineEventHandlerOnRejoinChannelSuccessJson paramJson =
            RtcEngineEventHandlerOnRejoinChannelSuccessJson.fromJson(jsonMap);
        paramJson = paramJson.fillBuffers(buffers);
        RtcConnection? connection = paramJson.connection;
        int? elapsed = paramJson.elapsed;
        if (connection == null || elapsed == null) {
          return true;
        }
        connection = connection.fillBuffers(buffers);
        rtcEngineEventHandler.onRejoinChannelSuccess!(connection, elapsed);
        return true;

      case 'onProxyConnected_9f89fd0':
        if (rtcEngineEventHandler.onProxyConnected == null) {
          return true;
        }
        final jsonMap = jsonDecode(eventData);
        RtcEngineEventHandlerOnProxyConnectedJson paramJson =
            RtcEngineEventHandlerOnProxyConnectedJson.fromJson(jsonMap);
        paramJson = paramJson.fillBuffers(buffers);
        String? channel = paramJson.channel;
        int? uid = paramJson.uid;
        ProxyType? proxyType = paramJson.proxyType;
        String? localProxyIp = paramJson.localProxyIp;
        int? elapsed = paramJson.elapsed;
        if (channel == null ||
            uid == null ||
            proxyType == null ||
            localProxyIp == null ||
            elapsed == null) {
          return true;
        }

        rtcEngineEventHandler.onProxyConnected!(
            channel, uid, proxyType, localProxyIp, elapsed);
        return true;

      case 'onError_d26c0fd':
        if (rtcEngineEventHandler.onError == null) {
          return true;
        }
        final jsonMap = jsonDecode(eventData);
        RtcEngineEventHandlerOnErrorJson paramJson =
            RtcEngineEventHandlerOnErrorJson.fromJson(jsonMap);
        paramJson = paramJson.fillBuffers(buffers);
        ErrorCodeType? err = paramJson.err;
        String? msg = paramJson.msg;
        if (err == null || msg == null) {
          return true;
        }

        rtcEngineEventHandler.onError!(err, msg);
        return true;

      case 'onAudioQuality_5c7294b':
        if (rtcEngineEventHandler.onAudioQuality == null) {
          return true;
        }
        final jsonMap = jsonDecode(eventData);
        RtcEngineEventHandlerOnAudioQualityJson paramJson =
            RtcEngineEventHandlerOnAudioQualityJson.fromJson(jsonMap);
        paramJson = paramJson.fillBuffers(buffers);
        RtcConnection? connection = paramJson.connection;
        int? remoteUid = paramJson.remoteUid;
        QualityType? quality = paramJson.quality;
        int? delay = paramJson.delay;
        int? lost = paramJson.lost;
        if (connection == null ||
            remoteUid == null ||
            quality == null ||
            delay == null ||
            lost == null) {
          return true;
        }
        connection = connection.fillBuffers(buffers);
        rtcEngineEventHandler.onAudioQuality!(
            connection, remoteUid, quality, delay, lost);
        return true;

      case 'onLastmileProbeResult_42b5843':
        if (rtcEngineEventHandler.onLastmileProbeResult == null) {
          return true;
        }
        final jsonMap = jsonDecode(eventData);
        RtcEngineEventHandlerOnLastmileProbeResultJson paramJson =
            RtcEngineEventHandlerOnLastmileProbeResultJson.fromJson(jsonMap);
        paramJson = paramJson.fillBuffers(buffers);
        LastmileProbeResult? result = paramJson.result;
        if (result == null) {
          return true;
        }
        result = result.fillBuffers(buffers);
        rtcEngineEventHandler.onLastmileProbeResult!(result);
        return true;

      case 'onAudioVolumeIndication_781482a':
        if (rtcEngineEventHandler.onAudioVolumeIndication == null) {
          return true;
        }
        final jsonMap = jsonDecode(eventData);
        RtcEngineEventHandlerOnAudioVolumeIndicationJson paramJson =
            RtcEngineEventHandlerOnAudioVolumeIndicationJson.fromJson(jsonMap);
        paramJson = paramJson.fillBuffers(buffers);
        RtcConnection? connection = paramJson.connection;
        List<AudioVolumeInfo>? speakers = paramJson.speakers;
        int? speakerNumber = paramJson.speakerNumber;
        int? totalVolume = paramJson.totalVolume;
        if (connection == null ||
            speakers == null ||
            speakerNumber == null ||
            totalVolume == null) {
          return true;
        }
        connection = connection.fillBuffers(buffers);
        speakers = speakers.map((e) => e.fillBuffers(buffers)).toList();
        rtcEngineEventHandler.onAudioVolumeIndication!(
            connection, speakers, speakerNumber, totalVolume);
        return true;

      case 'onLeaveChannel_c8e730d':
        if (rtcEngineEventHandler.onLeaveChannel == null) {
          return true;
        }
        final jsonMap = jsonDecode(eventData);
        RtcEngineEventHandlerOnLeaveChannelJson paramJson =
            RtcEngineEventHandlerOnLeaveChannelJson.fromJson(jsonMap);
        paramJson = paramJson.fillBuffers(buffers);
        RtcConnection? connection = paramJson.connection;
        RtcStats? stats = paramJson.stats;
        if (connection == null || stats == null) {
          return true;
        }
        connection = connection.fillBuffers(buffers);
        stats = stats.fillBuffers(buffers);
        rtcEngineEventHandler.onLeaveChannel!(connection, stats);
        return true;

      case 'onRtcStats_c8e730d':
        if (rtcEngineEventHandler.onRtcStats == null) {
          return true;
        }
        final jsonMap = jsonDecode(eventData);
        RtcEngineEventHandlerOnRtcStatsJson paramJson =
            RtcEngineEventHandlerOnRtcStatsJson.fromJson(jsonMap);
        paramJson = paramJson.fillBuffers(buffers);
        RtcConnection? connection = paramJson.connection;
        RtcStats? stats = paramJson.stats;
        if (connection == null || stats == null) {
          return true;
        }
        connection = connection.fillBuffers(buffers);
        stats = stats.fillBuffers(buffers);
        rtcEngineEventHandler.onRtcStats!(connection, stats);
        return true;

      case 'onAudioDeviceStateChanged_976d8c3':
        if (rtcEngineEventHandler.onAudioDeviceStateChanged == null) {
          return true;
        }
        final jsonMap = jsonDecode(eventData);
        RtcEngineEventHandlerOnAudioDeviceStateChangedJson paramJson =
            RtcEngineEventHandlerOnAudioDeviceStateChangedJson.fromJson(
                jsonMap);
        paramJson = paramJson.fillBuffers(buffers);
        String? deviceId = paramJson.deviceId;
        MediaDeviceType? deviceType = paramJson.deviceType;
        MediaDeviceStateType? deviceState = paramJson.deviceState;
        if (deviceId == null || deviceType == null || deviceState == null) {
          return true;
        }

        rtcEngineEventHandler.onAudioDeviceStateChanged!(
            deviceId, deviceType, deviceState);
        return true;

      case 'onAudioMixingPositionChanged_f631116':
        if (rtcEngineEventHandler.onAudioMixingPositionChanged == null) {
          return true;
        }
        final jsonMap = jsonDecode(eventData);
        RtcEngineEventHandlerOnAudioMixingPositionChangedJson paramJson =
            RtcEngineEventHandlerOnAudioMixingPositionChangedJson.fromJson(
                jsonMap);
        paramJson = paramJson.fillBuffers(buffers);
        int? position = paramJson.position;
        if (position == null) {
          return true;
        }

        rtcEngineEventHandler.onAudioMixingPositionChanged!(position);
        return true;

      case 'onAudioMixingFinished':
        if (rtcEngineEventHandler.onAudioMixingFinished == null) {
          return true;
        }
        final jsonMap = jsonDecode(eventData);
        RtcEngineEventHandlerOnAudioMixingFinishedJson paramJson =
            RtcEngineEventHandlerOnAudioMixingFinishedJson.fromJson(jsonMap);
        paramJson = paramJson.fillBuffers(buffers);
        rtcEngineEventHandler.onAudioMixingFinished!();
        return true;

      case 'onAudioEffectFinished_46f8ab7':
        if (rtcEngineEventHandler.onAudioEffectFinished == null) {
          return true;
        }
        final jsonMap = jsonDecode(eventData);
        RtcEngineEventHandlerOnAudioEffectFinishedJson paramJson =
            RtcEngineEventHandlerOnAudioEffectFinishedJson.fromJson(jsonMap);
        paramJson = paramJson.fillBuffers(buffers);
        int? soundId = paramJson.soundId;
        if (soundId == null) {
          return true;
        }

        rtcEngineEventHandler.onAudioEffectFinished!(soundId);
        return true;

      case 'onVideoDeviceStateChanged_976d8c3':
        if (rtcEngineEventHandler.onVideoDeviceStateChanged == null) {
          return true;
        }
        final jsonMap = jsonDecode(eventData);
        RtcEngineEventHandlerOnVideoDeviceStateChangedJson paramJson =
            RtcEngineEventHandlerOnVideoDeviceStateChangedJson.fromJson(
                jsonMap);
        paramJson = paramJson.fillBuffers(buffers);
        String? deviceId = paramJson.deviceId;
        MediaDeviceType? deviceType = paramJson.deviceType;
        MediaDeviceStateType? deviceState = paramJson.deviceState;
        if (deviceId == null || deviceType == null || deviceState == null) {
          return true;
        }

        rtcEngineEventHandler.onVideoDeviceStateChanged!(
            deviceId, deviceType, deviceState);
        return true;

      case 'onNetworkQuality_34d8b3c':
        if (rtcEngineEventHandler.onNetworkQuality == null) {
          return true;
        }
        final jsonMap = jsonDecode(eventData);
        RtcEngineEventHandlerOnNetworkQualityJson paramJson =
            RtcEngineEventHandlerOnNetworkQualityJson.fromJson(jsonMap);
        paramJson = paramJson.fillBuffers(buffers);
        RtcConnection? connection = paramJson.connection;
        int? remoteUid = paramJson.remoteUid;
        QualityType? txQuality = paramJson.txQuality;
        QualityType? rxQuality = paramJson.rxQuality;
        if (connection == null ||
            remoteUid == null ||
            txQuality == null ||
            rxQuality == null) {
          return true;
        }
        connection = connection.fillBuffers(buffers);
        rtcEngineEventHandler.onNetworkQuality!(
            connection, remoteUid, txQuality, rxQuality);
        return true;

      case 'onIntraRequestReceived_c81e1a4':
        if (rtcEngineEventHandler.onIntraRequestReceived == null) {
          return true;
        }
        final jsonMap = jsonDecode(eventData);
        RtcEngineEventHandlerOnIntraRequestReceivedJson paramJson =
            RtcEngineEventHandlerOnIntraRequestReceivedJson.fromJson(jsonMap);
        paramJson = paramJson.fillBuffers(buffers);
        RtcConnection? connection = paramJson.connection;
        if (connection == null) {
          return true;
        }
        connection = connection.fillBuffers(buffers);
        rtcEngineEventHandler.onIntraRequestReceived!(connection);
        return true;

      case 'onUplinkNetworkInfoUpdated_cbb1856':
        if (rtcEngineEventHandler.onUplinkNetworkInfoUpdated == null) {
          return true;
        }
        final jsonMap = jsonDecode(eventData);
        RtcEngineEventHandlerOnUplinkNetworkInfoUpdatedJson paramJson =
            RtcEngineEventHandlerOnUplinkNetworkInfoUpdatedJson.fromJson(
                jsonMap);
        paramJson = paramJson.fillBuffers(buffers);
        UplinkNetworkInfo? info = paramJson.info;
        if (info == null) {
          return true;
        }
        info = info.fillBuffers(buffers);
        rtcEngineEventHandler.onUplinkNetworkInfoUpdated!(info);
        return true;

      case 'onDownlinkNetworkInfoUpdated_e9d5bd9':
        if (rtcEngineEventHandler.onDownlinkNetworkInfoUpdated == null) {
          return true;
        }
        final jsonMap = jsonDecode(eventData);
        RtcEngineEventHandlerOnDownlinkNetworkInfoUpdatedJson paramJson =
            RtcEngineEventHandlerOnDownlinkNetworkInfoUpdatedJson.fromJson(
                jsonMap);
        paramJson = paramJson.fillBuffers(buffers);
        DownlinkNetworkInfo? info = paramJson.info;
        if (info == null) {
          return true;
        }
        info = info.fillBuffers(buffers);
        rtcEngineEventHandler.onDownlinkNetworkInfoUpdated!(info);
        return true;

      case 'onLastmileQuality_46f8ab7':
        if (rtcEngineEventHandler.onLastmileQuality == null) {
          return true;
        }
        final jsonMap = jsonDecode(eventData);
        RtcEngineEventHandlerOnLastmileQualityJson paramJson =
            RtcEngineEventHandlerOnLastmileQualityJson.fromJson(jsonMap);
        paramJson = paramJson.fillBuffers(buffers);
        QualityType? quality = paramJson.quality;
        if (quality == null) {
          return true;
        }

        rtcEngineEventHandler.onLastmileQuality!(quality);
        return true;

      case 'onFirstLocalVideoFrame_ebdfd19':
        if (rtcEngineEventHandler.onFirstLocalVideoFrame == null) {
          return true;
        }
        final jsonMap = jsonDecode(eventData);
        RtcEngineEventHandlerOnFirstLocalVideoFrameJson paramJson =
            RtcEngineEventHandlerOnFirstLocalVideoFrameJson.fromJson(jsonMap);
        paramJson = paramJson.fillBuffers(buffers);
        VideoSourceType? source = paramJson.source;
        int? width = paramJson.width;
        int? height = paramJson.height;
        int? elapsed = paramJson.elapsed;
        if (source == null ||
            width == null ||
            height == null ||
            elapsed == null) {
          return true;
        }

        rtcEngineEventHandler.onFirstLocalVideoFrame!(
            source, width, height, elapsed);
        return true;

      case 'onFirstLocalVideoFramePublished_263e4cd':
        if (rtcEngineEventHandler.onFirstLocalVideoFramePublished == null) {
          return true;
        }
        final jsonMap = jsonDecode(eventData);
        RtcEngineEventHandlerOnFirstLocalVideoFramePublishedJson paramJson =
            RtcEngineEventHandlerOnFirstLocalVideoFramePublishedJson.fromJson(
                jsonMap);
        paramJson = paramJson.fillBuffers(buffers);
        RtcConnection? connection = paramJson.connection;
        int? elapsed = paramJson.elapsed;
        if (connection == null || elapsed == null) {
          return true;
        }
        connection = connection.fillBuffers(buffers);
        rtcEngineEventHandler.onFirstLocalVideoFramePublished!(
            connection, elapsed);
        return true;

      case 'onFirstRemoteVideoDecoded_a68170a':
        if (rtcEngineEventHandler.onFirstRemoteVideoDecoded == null) {
          return true;
        }
        final jsonMap = jsonDecode(eventData);
        RtcEngineEventHandlerOnFirstRemoteVideoDecodedJson paramJson =
            RtcEngineEventHandlerOnFirstRemoteVideoDecodedJson.fromJson(
                jsonMap);
        paramJson = paramJson.fillBuffers(buffers);
        RtcConnection? connection = paramJson.connection;
        int? remoteUid = paramJson.remoteUid;
        int? width = paramJson.width;
        int? height = paramJson.height;
        int? elapsed = paramJson.elapsed;
        if (connection == null ||
            remoteUid == null ||
            width == null ||
            height == null ||
            elapsed == null) {
          return true;
        }
        connection = connection.fillBuffers(buffers);
        rtcEngineEventHandler.onFirstRemoteVideoDecoded!(
            connection, remoteUid, width, height, elapsed);
        return true;

      case 'onVideoSizeChanged_99bf45c':
        if (rtcEngineEventHandler.onVideoSizeChanged == null) {
          return true;
        }
        final jsonMap = jsonDecode(eventData);
        RtcEngineEventHandlerOnVideoSizeChangedJson paramJson =
            RtcEngineEventHandlerOnVideoSizeChangedJson.fromJson(jsonMap);
        paramJson = paramJson.fillBuffers(buffers);
        RtcConnection? connection = paramJson.connection;
        VideoSourceType? sourceType = paramJson.sourceType;
        int? uid = paramJson.uid;
        int? width = paramJson.width;
        int? height = paramJson.height;
        int? rotation = paramJson.rotation;
        if (connection == null ||
            sourceType == null ||
            uid == null ||
            width == null ||
            height == null ||
            rotation == null) {
          return true;
        }
        connection = connection.fillBuffers(buffers);
        rtcEngineEventHandler.onVideoSizeChanged!(
            connection, sourceType, uid, width, height, rotation);
        return true;

      case 'onLocalVideoStateChanged_a44228a':
        if (rtcEngineEventHandler.onLocalVideoStateChanged == null) {
          return true;
        }
        final jsonMap = jsonDecode(eventData);
        RtcEngineEventHandlerOnLocalVideoStateChangedJson paramJson =
            RtcEngineEventHandlerOnLocalVideoStateChangedJson.fromJson(jsonMap);
        paramJson = paramJson.fillBuffers(buffers);
        VideoSourceType? source = paramJson.source;
        LocalVideoStreamState? state = paramJson.state;
        LocalVideoStreamReason? reason = paramJson.reason;
        if (source == null || state == null || reason == null) {
          return true;
        }

        rtcEngineEventHandler.onLocalVideoStateChanged!(source, state, reason);
        return true;

      case 'onRemoteVideoStateChanged_a14e9d1':
        if (rtcEngineEventHandler.onRemoteVideoStateChanged == null) {
          return true;
        }
        final jsonMap = jsonDecode(eventData);
        RtcEngineEventHandlerOnRemoteVideoStateChangedJson paramJson =
            RtcEngineEventHandlerOnRemoteVideoStateChangedJson.fromJson(
                jsonMap);
        paramJson = paramJson.fillBuffers(buffers);
        RtcConnection? connection = paramJson.connection;
        int? remoteUid = paramJson.remoteUid;
        RemoteVideoState? state = paramJson.state;
        RemoteVideoStateReason? reason = paramJson.reason;
        int? elapsed = paramJson.elapsed;
        if (connection == null ||
            remoteUid == null ||
            state == null ||
            reason == null ||
            elapsed == null) {
          return true;
        }
        connection = connection.fillBuffers(buffers);
        rtcEngineEventHandler.onRemoteVideoStateChanged!(
            connection, remoteUid, state, reason, elapsed);
        return true;

      case 'onFirstRemoteVideoFrame_a68170a':
        if (rtcEngineEventHandler.onFirstRemoteVideoFrame == null) {
          return true;
        }
        final jsonMap = jsonDecode(eventData);
        RtcEngineEventHandlerOnFirstRemoteVideoFrameJson paramJson =
            RtcEngineEventHandlerOnFirstRemoteVideoFrameJson.fromJson(jsonMap);
        paramJson = paramJson.fillBuffers(buffers);
        RtcConnection? connection = paramJson.connection;
        int? remoteUid = paramJson.remoteUid;
        int? width = paramJson.width;
        int? height = paramJson.height;
        int? elapsed = paramJson.elapsed;
        if (connection == null ||
            remoteUid == null ||
            width == null ||
            height == null ||
            elapsed == null) {
          return true;
        }
        connection = connection.fillBuffers(buffers);
        rtcEngineEventHandler.onFirstRemoteVideoFrame!(
            connection, remoteUid, width, height, elapsed);
        return true;

      case 'onUserJoined_c5499bd':
        if (rtcEngineEventHandler.onUserJoined == null) {
          return true;
        }
        final jsonMap = jsonDecode(eventData);
        RtcEngineEventHandlerOnUserJoinedJson paramJson =
            RtcEngineEventHandlerOnUserJoinedJson.fromJson(jsonMap);
        paramJson = paramJson.fillBuffers(buffers);
        RtcConnection? connection = paramJson.connection;
        int? remoteUid = paramJson.remoteUid;
        int? elapsed = paramJson.elapsed;
        if (connection == null || remoteUid == null || elapsed == null) {
          return true;
        }
        connection = connection.fillBuffers(buffers);
        rtcEngineEventHandler.onUserJoined!(connection, remoteUid, elapsed);
        return true;

      case 'onUserOffline_0a32aac':
        if (rtcEngineEventHandler.onUserOffline == null) {
          return true;
        }
        final jsonMap = jsonDecode(eventData);
        RtcEngineEventHandlerOnUserOfflineJson paramJson =
            RtcEngineEventHandlerOnUserOfflineJson.fromJson(jsonMap);
        paramJson = paramJson.fillBuffers(buffers);
        RtcConnection? connection = paramJson.connection;
        int? remoteUid = paramJson.remoteUid;
        UserOfflineReasonType? reason = paramJson.reason;
        if (connection == null || remoteUid == null || reason == null) {
          return true;
        }
        connection = connection.fillBuffers(buffers);
        rtcEngineEventHandler.onUserOffline!(connection, remoteUid, reason);
        return true;

      case 'onUserMuteAudio_0aac2fe':
        if (rtcEngineEventHandler.onUserMuteAudio == null) {
          return true;
        }
        final jsonMap = jsonDecode(eventData);
        RtcEngineEventHandlerOnUserMuteAudioJson paramJson =
            RtcEngineEventHandlerOnUserMuteAudioJson.fromJson(jsonMap);
        paramJson = paramJson.fillBuffers(buffers);
        RtcConnection? connection = paramJson.connection;
        int? remoteUid = paramJson.remoteUid;
        bool? muted = paramJson.muted;
        if (connection == null || remoteUid == null || muted == null) {
          return true;
        }
        connection = connection.fillBuffers(buffers);
        rtcEngineEventHandler.onUserMuteAudio!(connection, remoteUid, muted);
        return true;

      case 'onUserMuteVideo_0aac2fe':
        if (rtcEngineEventHandler.onUserMuteVideo == null) {
          return true;
        }
        final jsonMap = jsonDecode(eventData);
        RtcEngineEventHandlerOnUserMuteVideoJson paramJson =
            RtcEngineEventHandlerOnUserMuteVideoJson.fromJson(jsonMap);
        paramJson = paramJson.fillBuffers(buffers);
        RtcConnection? connection = paramJson.connection;
        int? remoteUid = paramJson.remoteUid;
        bool? muted = paramJson.muted;
        if (connection == null || remoteUid == null || muted == null) {
          return true;
        }
        connection = connection.fillBuffers(buffers);
        rtcEngineEventHandler.onUserMuteVideo!(connection, remoteUid, muted);
        return true;

      case 'onUserEnableVideo_0aac2fe':
        if (rtcEngineEventHandler.onUserEnableVideo == null) {
          return true;
        }
        final jsonMap = jsonDecode(eventData);
        RtcEngineEventHandlerOnUserEnableVideoJson paramJson =
            RtcEngineEventHandlerOnUserEnableVideoJson.fromJson(jsonMap);
        paramJson = paramJson.fillBuffers(buffers);
        RtcConnection? connection = paramJson.connection;
        int? remoteUid = paramJson.remoteUid;
        bool? enabled = paramJson.enabled;
        if (connection == null || remoteUid == null || enabled == null) {
          return true;
        }
        connection = connection.fillBuffers(buffers);
        rtcEngineEventHandler.onUserEnableVideo!(
            connection, remoteUid, enabled);
        return true;

      case 'onUserStateChanged_65f95a7':
        if (rtcEngineEventHandler.onUserStateChanged == null) {
          return true;
        }
        final jsonMap = jsonDecode(eventData);
        RtcEngineEventHandlerOnUserStateChangedJson paramJson =
            RtcEngineEventHandlerOnUserStateChangedJson.fromJson(jsonMap);
        paramJson = paramJson.fillBuffers(buffers);
        RtcConnection? connection = paramJson.connection;
        int? remoteUid = paramJson.remoteUid;
        int? state = paramJson.state;
        if (connection == null || remoteUid == null || state == null) {
          return true;
        }
        connection = connection.fillBuffers(buffers);
        rtcEngineEventHandler.onUserStateChanged!(connection, remoteUid, state);
        return true;

      case 'onUserEnableLocalVideo_0aac2fe':
        if (rtcEngineEventHandler.onUserEnableLocalVideo == null) {
          return true;
        }
        final jsonMap = jsonDecode(eventData);
        RtcEngineEventHandlerOnUserEnableLocalVideoJson paramJson =
            RtcEngineEventHandlerOnUserEnableLocalVideoJson.fromJson(jsonMap);
        paramJson = paramJson.fillBuffers(buffers);
        RtcConnection? connection = paramJson.connection;
        int? remoteUid = paramJson.remoteUid;
        bool? enabled = paramJson.enabled;
        if (connection == null || remoteUid == null || enabled == null) {
          return true;
        }
        connection = connection.fillBuffers(buffers);
        rtcEngineEventHandler.onUserEnableLocalVideo!(
            connection, remoteUid, enabled);
        return true;

      case 'onRemoteAudioStats_ffbde06':
        if (rtcEngineEventHandler.onRemoteAudioStats == null) {
          return true;
        }
        final jsonMap = jsonDecode(eventData);
        RtcEngineEventHandlerOnRemoteAudioStatsJson paramJson =
            RtcEngineEventHandlerOnRemoteAudioStatsJson.fromJson(jsonMap);
        paramJson = paramJson.fillBuffers(buffers);
        RtcConnection? connection = paramJson.connection;
        RemoteAudioStats? stats = paramJson.stats;
        if (connection == null || stats == null) {
          return true;
        }
        connection = connection.fillBuffers(buffers);
        stats = stats.fillBuffers(buffers);
        rtcEngineEventHandler.onRemoteAudioStats!(connection, stats);
        return true;

      case 'onLocalAudioStats_5657f05':
        if (rtcEngineEventHandler.onLocalAudioStats == null) {
          return true;
        }
        final jsonMap = jsonDecode(eventData);
        RtcEngineEventHandlerOnLocalAudioStatsJson paramJson =
            RtcEngineEventHandlerOnLocalAudioStatsJson.fromJson(jsonMap);
        paramJson = paramJson.fillBuffers(buffers);
        RtcConnection? connection = paramJson.connection;
        LocalAudioStats? stats = paramJson.stats;
        if (connection == null || stats == null) {
          return true;
        }
        connection = connection.fillBuffers(buffers);
        stats = stats.fillBuffers(buffers);
        rtcEngineEventHandler.onLocalAudioStats!(connection, stats);
        return true;

      case 'onLocalVideoStats_3ac0eb4':
        if (rtcEngineEventHandler.onLocalVideoStats == null) {
          return true;
        }
        final jsonMap = jsonDecode(eventData);
        RtcEngineEventHandlerOnLocalVideoStatsJson paramJson =
            RtcEngineEventHandlerOnLocalVideoStatsJson.fromJson(jsonMap);
        paramJson = paramJson.fillBuffers(buffers);
        RtcConnection? connection = paramJson.connection;
        LocalVideoStats? stats = paramJson.stats;
        if (connection == null || stats == null) {
          return true;
        }
        connection = connection.fillBuffers(buffers);
        stats = stats.fillBuffers(buffers);
        rtcEngineEventHandler.onLocalVideoStats!(connection, stats);
        return true;

      case 'onRemoteVideoStats_2f43a70':
        if (rtcEngineEventHandler.onRemoteVideoStats == null) {
          return true;
        }
        final jsonMap = jsonDecode(eventData);
        RtcEngineEventHandlerOnRemoteVideoStatsJson paramJson =
            RtcEngineEventHandlerOnRemoteVideoStatsJson.fromJson(jsonMap);
        paramJson = paramJson.fillBuffers(buffers);
        RtcConnection? connection = paramJson.connection;
        RemoteVideoStats? stats = paramJson.stats;
        if (connection == null || stats == null) {
          return true;
        }
        connection = connection.fillBuffers(buffers);
        stats = stats.fillBuffers(buffers);
        rtcEngineEventHandler.onRemoteVideoStats!(connection, stats);
        return true;

      case 'onCameraReady':
        if (rtcEngineEventHandler.onCameraReady == null) {
          return true;
        }
        final jsonMap = jsonDecode(eventData);
        RtcEngineEventHandlerOnCameraReadyJson paramJson =
            RtcEngineEventHandlerOnCameraReadyJson.fromJson(jsonMap);
        paramJson = paramJson.fillBuffers(buffers);
        rtcEngineEventHandler.onCameraReady!();
        return true;

      case 'onCameraFocusAreaChanged_41c5354':
        if (rtcEngineEventHandler.onCameraFocusAreaChanged == null) {
          return true;
        }
        final jsonMap = jsonDecode(eventData);
        RtcEngineEventHandlerOnCameraFocusAreaChangedJson paramJson =
            RtcEngineEventHandlerOnCameraFocusAreaChangedJson.fromJson(jsonMap);
        paramJson = paramJson.fillBuffers(buffers);
        int? x = paramJson.x;
        int? y = paramJson.y;
        int? width = paramJson.width;
        int? height = paramJson.height;
        if (x == null || y == null || width == null || height == null) {
          return true;
        }

        rtcEngineEventHandler.onCameraFocusAreaChanged!(x, y, width, height);
        return true;

      case 'onCameraExposureAreaChanged_41c5354':
        if (rtcEngineEventHandler.onCameraExposureAreaChanged == null) {
          return true;
        }
        final jsonMap = jsonDecode(eventData);
        RtcEngineEventHandlerOnCameraExposureAreaChangedJson paramJson =
            RtcEngineEventHandlerOnCameraExposureAreaChangedJson.fromJson(
                jsonMap);
        paramJson = paramJson.fillBuffers(buffers);
        int? x = paramJson.x;
        int? y = paramJson.y;
        int? width = paramJson.width;
        int? height = paramJson.height;
        if (x == null || y == null || width == null || height == null) {
          return true;
        }

        rtcEngineEventHandler.onCameraExposureAreaChanged!(x, y, width, height);
        return true;

      case 'onFacePositionChanged_197b4a7':
        if (rtcEngineEventHandler.onFacePositionChanged == null) {
          return true;
        }
        final jsonMap = jsonDecode(eventData);
        RtcEngineEventHandlerOnFacePositionChangedJson paramJson =
            RtcEngineEventHandlerOnFacePositionChangedJson.fromJson(jsonMap);
        paramJson = paramJson.fillBuffers(buffers);
        int? imageWidth = paramJson.imageWidth;
        int? imageHeight = paramJson.imageHeight;
        List<Rectangle>? vecRectangle = paramJson.vecRectangle;
        List<int>? vecDistance = paramJson.vecDistance;
        int? numFaces = paramJson.numFaces;
        if (imageWidth == null ||
            imageHeight == null ||
            vecRectangle == null ||
            vecDistance == null ||
            numFaces == null) {
          return true;
        }
        vecRectangle = vecRectangle.map((e) => e.fillBuffers(buffers)).toList();
        rtcEngineEventHandler.onFacePositionChanged!(
            imageWidth, imageHeight, vecRectangle, vecDistance, numFaces);
        return true;

      case 'onVideoStopped':
        if (rtcEngineEventHandler.onVideoStopped == null) {
          return true;
        }
        final jsonMap = jsonDecode(eventData);
        RtcEngineEventHandlerOnVideoStoppedJson paramJson =
            RtcEngineEventHandlerOnVideoStoppedJson.fromJson(jsonMap);
        paramJson = paramJson.fillBuffers(buffers);
        rtcEngineEventHandler.onVideoStopped!();
        return true;

      case 'onAudioMixingStateChanged_fd2c0a6':
        if (rtcEngineEventHandler.onAudioMixingStateChanged == null) {
          return true;
        }
        final jsonMap = jsonDecode(eventData);
        RtcEngineEventHandlerOnAudioMixingStateChangedJson paramJson =
            RtcEngineEventHandlerOnAudioMixingStateChangedJson.fromJson(
                jsonMap);
        paramJson = paramJson.fillBuffers(buffers);
        AudioMixingStateType? state = paramJson.state;
        AudioMixingReasonType? reason = paramJson.reason;
        if (state == null || reason == null) {
          return true;
        }

        rtcEngineEventHandler.onAudioMixingStateChanged!(state, reason);
        return true;

      case 'onRhythmPlayerStateChanged_09360d2':
        if (rtcEngineEventHandler.onRhythmPlayerStateChanged == null) {
          return true;
        }
        final jsonMap = jsonDecode(eventData);
        RtcEngineEventHandlerOnRhythmPlayerStateChangedJson paramJson =
            RtcEngineEventHandlerOnRhythmPlayerStateChangedJson.fromJson(
                jsonMap);
        paramJson = paramJson.fillBuffers(buffers);
        RhythmPlayerStateType? state = paramJson.state;
        RhythmPlayerReason? reason = paramJson.reason;
        if (state == null || reason == null) {
          return true;
        }

        rtcEngineEventHandler.onRhythmPlayerStateChanged!(state, reason);
        return true;

      case 'onConnectionLost_c81e1a4':
        if (rtcEngineEventHandler.onConnectionLost == null) {
          return true;
        }
        final jsonMap = jsonDecode(eventData);
        RtcEngineEventHandlerOnConnectionLostJson paramJson =
            RtcEngineEventHandlerOnConnectionLostJson.fromJson(jsonMap);
        paramJson = paramJson.fillBuffers(buffers);
        RtcConnection? connection = paramJson.connection;
        if (connection == null) {
          return true;
        }
        connection = connection.fillBuffers(buffers);
        rtcEngineEventHandler.onConnectionLost!(connection);
        return true;

      case 'onConnectionInterrupted_c81e1a4':
        if (rtcEngineEventHandler.onConnectionInterrupted == null) {
          return true;
        }
        final jsonMap = jsonDecode(eventData);
        RtcEngineEventHandlerOnConnectionInterruptedJson paramJson =
            RtcEngineEventHandlerOnConnectionInterruptedJson.fromJson(jsonMap);
        paramJson = paramJson.fillBuffers(buffers);
        RtcConnection? connection = paramJson.connection;
        if (connection == null) {
          return true;
        }
        connection = connection.fillBuffers(buffers);
        rtcEngineEventHandler.onConnectionInterrupted!(connection);
        return true;

      case 'onConnectionBanned_c81e1a4':
        if (rtcEngineEventHandler.onConnectionBanned == null) {
          return true;
        }
        final jsonMap = jsonDecode(eventData);
        RtcEngineEventHandlerOnConnectionBannedJson paramJson =
            RtcEngineEventHandlerOnConnectionBannedJson.fromJson(jsonMap);
        paramJson = paramJson.fillBuffers(buffers);
        RtcConnection? connection = paramJson.connection;
        if (connection == null) {
          return true;
        }
        connection = connection.fillBuffers(buffers);
        rtcEngineEventHandler.onConnectionBanned!(connection);
        return true;

      case 'onStreamMessage_99898cb':
        if (rtcEngineEventHandler.onStreamMessage == null) {
          return true;
        }
        final jsonMap = jsonDecode(eventData);
        RtcEngineEventHandlerOnStreamMessageJson paramJson =
            RtcEngineEventHandlerOnStreamMessageJson.fromJson(jsonMap);
        paramJson = paramJson.fillBuffers(buffers);
        RtcConnection? connection = paramJson.connection;
        int? remoteUid = paramJson.remoteUid;
        int? streamId = paramJson.streamId;
        Uint8List? data = paramJson.data;
        int? length = paramJson.length;
        int? sentTs = paramJson.sentTs;
        if (connection == null ||
            remoteUid == null ||
            streamId == null ||
            data == null ||
            length == null ||
            sentTs == null) {
          return true;
        }
        connection = connection.fillBuffers(buffers);
        rtcEngineEventHandler.onStreamMessage!(
            connection, remoteUid, streamId, data, length, sentTs);
        return true;

      case 'onStreamMessageError_fe302fc':
        if (rtcEngineEventHandler.onStreamMessageError == null) {
          return true;
        }
        final jsonMap = jsonDecode(eventData);
        RtcEngineEventHandlerOnStreamMessageErrorJson paramJson =
            RtcEngineEventHandlerOnStreamMessageErrorJson.fromJson(jsonMap);
        paramJson = paramJson.fillBuffers(buffers);
        RtcConnection? connection = paramJson.connection;
        int? remoteUid = paramJson.remoteUid;
        int? streamId = paramJson.streamId;
        ErrorCodeType? code = paramJson.code;
        int? missed = paramJson.missed;
        int? cached = paramJson.cached;
        if (connection == null ||
            remoteUid == null ||
            streamId == null ||
            code == null ||
            missed == null ||
            cached == null) {
          return true;
        }
        connection = connection.fillBuffers(buffers);
        rtcEngineEventHandler.onStreamMessageError!(
            connection, remoteUid, streamId, code, missed, cached);
        return true;

      case 'onRequestToken_c81e1a4':
        if (rtcEngineEventHandler.onRequestToken == null) {
          return true;
        }
        final jsonMap = jsonDecode(eventData);
        RtcEngineEventHandlerOnRequestTokenJson paramJson =
            RtcEngineEventHandlerOnRequestTokenJson.fromJson(jsonMap);
        paramJson = paramJson.fillBuffers(buffers);
        RtcConnection? connection = paramJson.connection;
        if (connection == null) {
          return true;
        }
        connection = connection.fillBuffers(buffers);
        rtcEngineEventHandler.onRequestToken!(connection);
        return true;

      case 'onTokenPrivilegeWillExpire_8225ea3':
        if (rtcEngineEventHandler.onTokenPrivilegeWillExpire == null) {
          return true;
        }
        final jsonMap = jsonDecode(eventData);
        RtcEngineEventHandlerOnTokenPrivilegeWillExpireJson paramJson =
            RtcEngineEventHandlerOnTokenPrivilegeWillExpireJson.fromJson(
                jsonMap);
        paramJson = paramJson.fillBuffers(buffers);
        RtcConnection? connection = paramJson.connection;
        String? token = paramJson.token;
        if (connection == null || token == null) {
          return true;
        }
        connection = connection.fillBuffers(buffers);
        rtcEngineEventHandler.onTokenPrivilegeWillExpire!(connection, token);
        return true;

      case 'onLicenseValidationFailure_5dfd95e':
        if (rtcEngineEventHandler.onLicenseValidationFailure == null) {
          return true;
        }
        final jsonMap = jsonDecode(eventData);
        RtcEngineEventHandlerOnLicenseValidationFailureJson paramJson =
            RtcEngineEventHandlerOnLicenseValidationFailureJson.fromJson(
                jsonMap);
        paramJson = paramJson.fillBuffers(buffers);
        RtcConnection? connection = paramJson.connection;
        LicenseErrorType? reason = paramJson.reason;
        if (connection == null || reason == null) {
          return true;
        }
        connection = connection.fillBuffers(buffers);
        rtcEngineEventHandler.onLicenseValidationFailure!(connection, reason);
        return true;

      case 'onFirstLocalAudioFramePublished_263e4cd':
        if (rtcEngineEventHandler.onFirstLocalAudioFramePublished == null) {
          return true;
        }
        final jsonMap = jsonDecode(eventData);
        RtcEngineEventHandlerOnFirstLocalAudioFramePublishedJson paramJson =
            RtcEngineEventHandlerOnFirstLocalAudioFramePublishedJson.fromJson(
                jsonMap);
        paramJson = paramJson.fillBuffers(buffers);
        RtcConnection? connection = paramJson.connection;
        int? elapsed = paramJson.elapsed;
        if (connection == null || elapsed == null) {
          return true;
        }
        connection = connection.fillBuffers(buffers);
        rtcEngineEventHandler.onFirstLocalAudioFramePublished!(
            connection, elapsed);
        return true;

      case 'onFirstRemoteAudioDecoded_c5499bd':
        if (rtcEngineEventHandler.onFirstRemoteAudioDecoded == null) {
          return true;
        }
        final jsonMap = jsonDecode(eventData);
        RtcEngineEventHandlerOnFirstRemoteAudioDecodedJson paramJson =
            RtcEngineEventHandlerOnFirstRemoteAudioDecodedJson.fromJson(
                jsonMap);
        paramJson = paramJson.fillBuffers(buffers);
        RtcConnection? connection = paramJson.connection;
        int? uid = paramJson.uid;
        int? elapsed = paramJson.elapsed;
        if (connection == null || uid == null || elapsed == null) {
          return true;
        }
        connection = connection.fillBuffers(buffers);
        rtcEngineEventHandler.onFirstRemoteAudioDecoded!(
            connection, uid, elapsed);
        return true;

      case 'onFirstRemoteAudioFrame_c5499bd':
        if (rtcEngineEventHandler.onFirstRemoteAudioFrame == null) {
          return true;
        }
        final jsonMap = jsonDecode(eventData);
        RtcEngineEventHandlerOnFirstRemoteAudioFrameJson paramJson =
            RtcEngineEventHandlerOnFirstRemoteAudioFrameJson.fromJson(jsonMap);
        paramJson = paramJson.fillBuffers(buffers);
        RtcConnection? connection = paramJson.connection;
        int? userId = paramJson.userId;
        int? elapsed = paramJson.elapsed;
        if (connection == null || userId == null || elapsed == null) {
          return true;
        }
        connection = connection.fillBuffers(buffers);
        rtcEngineEventHandler.onFirstRemoteAudioFrame!(
            connection, userId, elapsed);
        return true;

      case 'onLocalAudioStateChanged_13b6c02':
        if (rtcEngineEventHandler.onLocalAudioStateChanged == null) {
          return true;
        }
        final jsonMap = jsonDecode(eventData);
        RtcEngineEventHandlerOnLocalAudioStateChangedJson paramJson =
            RtcEngineEventHandlerOnLocalAudioStateChangedJson.fromJson(jsonMap);
        paramJson = paramJson.fillBuffers(buffers);
        RtcConnection? connection = paramJson.connection;
        LocalAudioStreamState? state = paramJson.state;
        LocalAudioStreamReason? reason = paramJson.reason;
        if (connection == null || state == null || reason == null) {
          return true;
        }
        connection = connection.fillBuffers(buffers);
        rtcEngineEventHandler.onLocalAudioStateChanged!(
            connection, state, reason);
        return true;

      case 'onRemoteAudioStateChanged_056772e':
        if (rtcEngineEventHandler.onRemoteAudioStateChanged == null) {
          return true;
        }
        final jsonMap = jsonDecode(eventData);
        RtcEngineEventHandlerOnRemoteAudioStateChangedJson paramJson =
            RtcEngineEventHandlerOnRemoteAudioStateChangedJson.fromJson(
                jsonMap);
        paramJson = paramJson.fillBuffers(buffers);
        RtcConnection? connection = paramJson.connection;
        int? remoteUid = paramJson.remoteUid;
        RemoteAudioState? state = paramJson.state;
        RemoteAudioStateReason? reason = paramJson.reason;
        int? elapsed = paramJson.elapsed;
        if (connection == null ||
            remoteUid == null ||
            state == null ||
            reason == null ||
            elapsed == null) {
          return true;
        }
        connection = connection.fillBuffers(buffers);
        rtcEngineEventHandler.onRemoteAudioStateChanged!(
            connection, remoteUid, state, reason, elapsed);
        return true;

      case 'onActiveSpeaker_dd67adc':
        if (rtcEngineEventHandler.onActiveSpeaker == null) {
          return true;
        }
        final jsonMap = jsonDecode(eventData);
        RtcEngineEventHandlerOnActiveSpeakerJson paramJson =
            RtcEngineEventHandlerOnActiveSpeakerJson.fromJson(jsonMap);
        paramJson = paramJson.fillBuffers(buffers);
        RtcConnection? connection = paramJson.connection;
        int? uid = paramJson.uid;
        if (connection == null || uid == null) {
          return true;
        }
        connection = connection.fillBuffers(buffers);
        rtcEngineEventHandler.onActiveSpeaker!(connection, uid);
        return true;

      case 'onContentInspectResult_ba185c8':
        if (rtcEngineEventHandler.onContentInspectResult == null) {
          return true;
        }
        final jsonMap = jsonDecode(eventData);
        RtcEngineEventHandlerOnContentInspectResultJson paramJson =
            RtcEngineEventHandlerOnContentInspectResultJson.fromJson(jsonMap);
        paramJson = paramJson.fillBuffers(buffers);
        ContentInspectResult? result = paramJson.result;
        if (result == null) {
          return true;
        }

        rtcEngineEventHandler.onContentInspectResult!(result);
        return true;

      case 'onSnapshotTaken_5a6a693':
        if (rtcEngineEventHandler.onSnapshotTaken == null) {
          return true;
        }
        final jsonMap = jsonDecode(eventData);
        RtcEngineEventHandlerOnSnapshotTakenJson paramJson =
            RtcEngineEventHandlerOnSnapshotTakenJson.fromJson(jsonMap);
        paramJson = paramJson.fillBuffers(buffers);
        RtcConnection? connection = paramJson.connection;
        int? uid = paramJson.uid;
        String? filePath = paramJson.filePath;
        int? width = paramJson.width;
        int? height = paramJson.height;
        int? errCode = paramJson.errCode;
        if (connection == null ||
            uid == null ||
            filePath == null ||
            width == null ||
            height == null ||
            errCode == null) {
          return true;
        }
        connection = connection.fillBuffers(buffers);
        rtcEngineEventHandler.onSnapshotTaken!(
            connection, uid, filePath, width, height, errCode);
        return true;

      case 'onClientRoleChanged_2acaf10':
        if (rtcEngineEventHandler.onClientRoleChanged == null) {
          return true;
        }
        final jsonMap = jsonDecode(eventData);
        RtcEngineEventHandlerOnClientRoleChangedJson paramJson =
            RtcEngineEventHandlerOnClientRoleChangedJson.fromJson(jsonMap);
        paramJson = paramJson.fillBuffers(buffers);
        RtcConnection? connection = paramJson.connection;
        ClientRoleType? oldRole = paramJson.oldRole;
        ClientRoleType? newRole = paramJson.newRole;
        ClientRoleOptions? newRoleOptions = paramJson.newRoleOptions;
        if (connection == null ||
            oldRole == null ||
            newRole == null ||
            newRoleOptions == null) {
          return true;
        }
        connection = connection.fillBuffers(buffers);

        newRoleOptions = newRoleOptions.fillBuffers(buffers);
        rtcEngineEventHandler.onClientRoleChanged!(
            connection, oldRole, newRole, newRoleOptions);
        return true;

      case 'onClientRoleChangeFailed_5a3af5b':
        if (rtcEngineEventHandler.onClientRoleChangeFailed == null) {
          return true;
        }
        final jsonMap = jsonDecode(eventData);
        RtcEngineEventHandlerOnClientRoleChangeFailedJson paramJson =
            RtcEngineEventHandlerOnClientRoleChangeFailedJson.fromJson(jsonMap);
        paramJson = paramJson.fillBuffers(buffers);
        RtcConnection? connection = paramJson.connection;
        ClientRoleChangeFailedReason? reason = paramJson.reason;
        ClientRoleType? currentRole = paramJson.currentRole;
        if (connection == null || reason == null || currentRole == null) {
          return true;
        }
        connection = connection.fillBuffers(buffers);
        rtcEngineEventHandler.onClientRoleChangeFailed!(
            connection, reason, currentRole);
        return true;

      case 'onAudioDeviceVolumeChanged_55ab726':
        if (rtcEngineEventHandler.onAudioDeviceVolumeChanged == null) {
          return true;
        }
        final jsonMap = jsonDecode(eventData);
        RtcEngineEventHandlerOnAudioDeviceVolumeChangedJson paramJson =
            RtcEngineEventHandlerOnAudioDeviceVolumeChangedJson.fromJson(
                jsonMap);
        paramJson = paramJson.fillBuffers(buffers);
        MediaDeviceType? deviceType = paramJson.deviceType;
        int? volume = paramJson.volume;
        bool? muted = paramJson.muted;
        if (deviceType == null || volume == null || muted == null) {
          return true;
        }

        rtcEngineEventHandler.onAudioDeviceVolumeChanged!(
            deviceType, volume, muted);
        return true;

      case 'onRtmpStreamingStateChanged_1f07503':
        if (rtcEngineEventHandler.onRtmpStreamingStateChanged == null) {
          return true;
        }
        final jsonMap = jsonDecode(eventData);
        RtcEngineEventHandlerOnRtmpStreamingStateChangedJson paramJson =
            RtcEngineEventHandlerOnRtmpStreamingStateChangedJson.fromJson(
                jsonMap);
        paramJson = paramJson.fillBuffers(buffers);
        String? url = paramJson.url;
        RtmpStreamPublishState? state = paramJson.state;
        RtmpStreamPublishReason? reason = paramJson.reason;
        if (url == null || state == null || reason == null) {
          return true;
        }

        rtcEngineEventHandler.onRtmpStreamingStateChanged!(url, state, reason);
        return true;

      case 'onRtmpStreamingEvent_2e48ef5':
        if (rtcEngineEventHandler.onRtmpStreamingEvent == null) {
          return true;
        }
        final jsonMap = jsonDecode(eventData);
        RtcEngineEventHandlerOnRtmpStreamingEventJson paramJson =
            RtcEngineEventHandlerOnRtmpStreamingEventJson.fromJson(jsonMap);
        paramJson = paramJson.fillBuffers(buffers);
        String? url = paramJson.url;
        RtmpStreamingEvent? eventCode = paramJson.eventCode;
        if (url == null || eventCode == null) {
          return true;
        }

        rtcEngineEventHandler.onRtmpStreamingEvent!(url, eventCode);
        return true;

      case 'onTranscodingUpdated':
        if (rtcEngineEventHandler.onTranscodingUpdated == null) {
          return true;
        }
        final jsonMap = jsonDecode(eventData);
        RtcEngineEventHandlerOnTranscodingUpdatedJson paramJson =
            RtcEngineEventHandlerOnTranscodingUpdatedJson.fromJson(jsonMap);
        paramJson = paramJson.fillBuffers(buffers);
        rtcEngineEventHandler.onTranscodingUpdated!();
        return true;

      case 'onAudioRoutingChanged_46f8ab7':
        if (rtcEngineEventHandler.onAudioRoutingChanged == null) {
          return true;
        }
        final jsonMap = jsonDecode(eventData);
        RtcEngineEventHandlerOnAudioRoutingChangedJson paramJson =
            RtcEngineEventHandlerOnAudioRoutingChangedJson.fromJson(jsonMap);
        paramJson = paramJson.fillBuffers(buffers);
        int? routing = paramJson.routing;
        if (routing == null) {
          return true;
        }

        rtcEngineEventHandler.onAudioRoutingChanged!(routing);
        return true;

      case 'onChannelMediaRelayStateChanged_4e92b3c':
        if (rtcEngineEventHandler.onChannelMediaRelayStateChanged == null) {
          return true;
        }
        final jsonMap = jsonDecode(eventData);
        RtcEngineEventHandlerOnChannelMediaRelayStateChangedJson paramJson =
            RtcEngineEventHandlerOnChannelMediaRelayStateChangedJson.fromJson(
                jsonMap);
        paramJson = paramJson.fillBuffers(buffers);
        ChannelMediaRelayState? state = paramJson.state;
        ChannelMediaRelayError? code = paramJson.code;
        if (state == null || code == null) {
          return true;
        }

        rtcEngineEventHandler.onChannelMediaRelayStateChanged!(state, code);
        return true;

      case 'onLocalPublishFallbackToAudioOnly_5039d15':
        if (rtcEngineEventHandler.onLocalPublishFallbackToAudioOnly == null) {
          return true;
        }
        final jsonMap = jsonDecode(eventData);
        RtcEngineEventHandlerOnLocalPublishFallbackToAudioOnlyJson paramJson =
            RtcEngineEventHandlerOnLocalPublishFallbackToAudioOnlyJson.fromJson(
                jsonMap);
        paramJson = paramJson.fillBuffers(buffers);
        bool? isFallbackOrRecover = paramJson.isFallbackOrRecover;
        if (isFallbackOrRecover == null) {
          return true;
        }

        rtcEngineEventHandler
            .onLocalPublishFallbackToAudioOnly!(isFallbackOrRecover);
        return true;

      case 'onRemoteSubscribeFallbackToAudioOnly_dbdc15a':
        if (rtcEngineEventHandler.onRemoteSubscribeFallbackToAudioOnly ==
            null) {
          return true;
        }
        final jsonMap = jsonDecode(eventData);
        RtcEngineEventHandlerOnRemoteSubscribeFallbackToAudioOnlyJson
            paramJson =
            RtcEngineEventHandlerOnRemoteSubscribeFallbackToAudioOnlyJson
                .fromJson(jsonMap);
        paramJson = paramJson.fillBuffers(buffers);
        int? uid = paramJson.uid;
        bool? isFallbackOrRecover = paramJson.isFallbackOrRecover;
        if (uid == null || isFallbackOrRecover == null) {
          return true;
        }

        rtcEngineEventHandler.onRemoteSubscribeFallbackToAudioOnly!(
            uid, isFallbackOrRecover);
        return true;

      case 'onRemoteAudioTransportStats_527a345':
        if (rtcEngineEventHandler.onRemoteAudioTransportStats == null) {
          return true;
        }
        final jsonMap = jsonDecode(eventData);
        RtcEngineEventHandlerOnRemoteAudioTransportStatsJson paramJson =
            RtcEngineEventHandlerOnRemoteAudioTransportStatsJson.fromJson(
                jsonMap);
        paramJson = paramJson.fillBuffers(buffers);
        RtcConnection? connection = paramJson.connection;
        int? remoteUid = paramJson.remoteUid;
        int? delay = paramJson.delay;
        int? lost = paramJson.lost;
        int? rxKBitRate = paramJson.rxKBitRate;
        if (connection == null ||
            remoteUid == null ||
            delay == null ||
            lost == null ||
            rxKBitRate == null) {
          return true;
        }
        connection = connection.fillBuffers(buffers);
        rtcEngineEventHandler.onRemoteAudioTransportStats!(
            connection, remoteUid, delay, lost, rxKBitRate);
        return true;

      case 'onRemoteVideoTransportStats_527a345':
        if (rtcEngineEventHandler.onRemoteVideoTransportStats == null) {
          return true;
        }
        final jsonMap = jsonDecode(eventData);
        RtcEngineEventHandlerOnRemoteVideoTransportStatsJson paramJson =
            RtcEngineEventHandlerOnRemoteVideoTransportStatsJson.fromJson(
                jsonMap);
        paramJson = paramJson.fillBuffers(buffers);
        RtcConnection? connection = paramJson.connection;
        int? remoteUid = paramJson.remoteUid;
        int? delay = paramJson.delay;
        int? lost = paramJson.lost;
        int? rxKBitRate = paramJson.rxKBitRate;
        if (connection == null ||
            remoteUid == null ||
            delay == null ||
            lost == null ||
            rxKBitRate == null) {
          return true;
        }
        connection = connection.fillBuffers(buffers);
        rtcEngineEventHandler.onRemoteVideoTransportStats!(
            connection, remoteUid, delay, lost, rxKBitRate);
        return true;

      case 'onConnectionStateChanged_4075a9c':
        if (rtcEngineEventHandler.onConnectionStateChanged == null) {
          return true;
        }
        final jsonMap = jsonDecode(eventData);
        RtcEngineEventHandlerOnConnectionStateChangedJson paramJson =
            RtcEngineEventHandlerOnConnectionStateChangedJson.fromJson(jsonMap);
        paramJson = paramJson.fillBuffers(buffers);
        RtcConnection? connection = paramJson.connection;
        ConnectionStateType? state = paramJson.state;
        ConnectionChangedReasonType? reason = paramJson.reason;
        if (connection == null || state == null || reason == null) {
          return true;
        }
        connection = connection.fillBuffers(buffers);
        rtcEngineEventHandler.onConnectionStateChanged!(
            connection, state, reason);
        return true;

      case 'onWlAccMessage_2b9068e':
        if (rtcEngineEventHandler.onWlAccMessage == null) {
          return true;
        }
        final jsonMap = jsonDecode(eventData);
        RtcEngineEventHandlerOnWlAccMessageJson paramJson =
            RtcEngineEventHandlerOnWlAccMessageJson.fromJson(jsonMap);
        paramJson = paramJson.fillBuffers(buffers);
        RtcConnection? connection = paramJson.connection;
        WlaccMessageReason? reason = paramJson.reason;
        WlaccSuggestAction? action = paramJson.action;
        String? wlAccMsg = paramJson.wlAccMsg;
        if (connection == null ||
            reason == null ||
            action == null ||
            wlAccMsg == null) {
          return true;
        }
        connection = connection.fillBuffers(buffers);
        rtcEngineEventHandler.onWlAccMessage!(
            connection, reason, action, wlAccMsg);
        return true;

      case 'onWlAccStats_b162607':
        if (rtcEngineEventHandler.onWlAccStats == null) {
          return true;
        }
        final jsonMap = jsonDecode(eventData);
        RtcEngineEventHandlerOnWlAccStatsJson paramJson =
            RtcEngineEventHandlerOnWlAccStatsJson.fromJson(jsonMap);
        paramJson = paramJson.fillBuffers(buffers);
        RtcConnection? connection = paramJson.connection;
        WlAccStats? currentStats = paramJson.currentStats;
        WlAccStats? averageStats = paramJson.averageStats;
        if (connection == null ||
            currentStats == null ||
            averageStats == null) {
          return true;
        }
        connection = connection.fillBuffers(buffers);
        currentStats = currentStats.fillBuffers(buffers);
        averageStats = averageStats.fillBuffers(buffers);
        rtcEngineEventHandler.onWlAccStats!(
            connection, currentStats, averageStats);
        return true;

      case 'onNetworkTypeChanged_388fd6f':
        if (rtcEngineEventHandler.onNetworkTypeChanged == null) {
          return true;
        }
        final jsonMap = jsonDecode(eventData);
        RtcEngineEventHandlerOnNetworkTypeChangedJson paramJson =
            RtcEngineEventHandlerOnNetworkTypeChangedJson.fromJson(jsonMap);
        paramJson = paramJson.fillBuffers(buffers);
        RtcConnection? connection = paramJson.connection;
        NetworkType? type = paramJson.type;
        if (connection == null || type == null) {
          return true;
        }
        connection = connection.fillBuffers(buffers);
        rtcEngineEventHandler.onNetworkTypeChanged!(connection, type);
        return true;

      case 'onEncryptionError_e7a65fe':
        if (rtcEngineEventHandler.onEncryptionError == null) {
          return true;
        }
        final jsonMap = jsonDecode(eventData);
        RtcEngineEventHandlerOnEncryptionErrorJson paramJson =
            RtcEngineEventHandlerOnEncryptionErrorJson.fromJson(jsonMap);
        paramJson = paramJson.fillBuffers(buffers);
        RtcConnection? connection = paramJson.connection;
        EncryptionErrorType? errorType = paramJson.errorType;
        if (connection == null || errorType == null) {
          return true;
        }
        connection = connection.fillBuffers(buffers);
        rtcEngineEventHandler.onEncryptionError!(connection, errorType);
        return true;

      case 'onPermissionError_f37c62b':
        if (rtcEngineEventHandler.onPermissionError == null) {
          return true;
        }
        final jsonMap = jsonDecode(eventData);
        RtcEngineEventHandlerOnPermissionErrorJson paramJson =
            RtcEngineEventHandlerOnPermissionErrorJson.fromJson(jsonMap);
        paramJson = paramJson.fillBuffers(buffers);
        PermissionType? permissionType = paramJson.permissionType;
        if (permissionType == null) {
          return true;
        }

        rtcEngineEventHandler.onPermissionError!(permissionType);
        return true;

      case 'onLocalUserRegistered_1922dd1':
        if (rtcEngineEventHandler.onLocalUserRegistered == null) {
          return true;
        }
        final jsonMap = jsonDecode(eventData);
        RtcEngineEventHandlerOnLocalUserRegisteredJson paramJson =
            RtcEngineEventHandlerOnLocalUserRegisteredJson.fromJson(jsonMap);
        paramJson = paramJson.fillBuffers(buffers);
        int? uid = paramJson.uid;
        String? userAccount = paramJson.userAccount;
        if (uid == null || userAccount == null) {
          return true;
        }

        rtcEngineEventHandler.onLocalUserRegistered!(uid, userAccount);
        return true;

      case 'onUserInfoUpdated_2120245':
        if (rtcEngineEventHandler.onUserInfoUpdated == null) {
          return true;
        }
        final jsonMap = jsonDecode(eventData);
        RtcEngineEventHandlerOnUserInfoUpdatedJson paramJson =
            RtcEngineEventHandlerOnUserInfoUpdatedJson.fromJson(jsonMap);
        paramJson = paramJson.fillBuffers(buffers);
        int? uid = paramJson.uid;
        UserInfo? info = paramJson.info;
        if (uid == null || info == null) {
          return true;
        }
        info = info.fillBuffers(buffers);
        rtcEngineEventHandler.onUserInfoUpdated!(uid, info);
        return true;

      case 'onUserAccountUpdated_de1c015':
        if (rtcEngineEventHandler.onUserAccountUpdated == null) {
          return true;
        }
        final jsonMap = jsonDecode(eventData);
        RtcEngineEventHandlerOnUserAccountUpdatedJson paramJson =
            RtcEngineEventHandlerOnUserAccountUpdatedJson.fromJson(jsonMap);
        paramJson = paramJson.fillBuffers(buffers);
        RtcConnection? connection = paramJson.connection;
        int? remoteUid = paramJson.remoteUid;
        String? remoteUserAccount = paramJson.remoteUserAccount;
        if (connection == null ||
            remoteUid == null ||
            remoteUserAccount == null) {
          return true;
        }
        connection = connection.fillBuffers(buffers);
        rtcEngineEventHandler.onUserAccountUpdated!(
            connection, remoteUid, remoteUserAccount);
        return true;

      case 'onVideoRenderingTracingResult_813c0f4':
        if (rtcEngineEventHandler.onVideoRenderingTracingResult == null) {
          return true;
        }
        final jsonMap = jsonDecode(eventData);
        RtcEngineEventHandlerOnVideoRenderingTracingResultJson paramJson =
            RtcEngineEventHandlerOnVideoRenderingTracingResultJson.fromJson(
                jsonMap);
        paramJson = paramJson.fillBuffers(buffers);
        RtcConnection? connection = paramJson.connection;
        int? uid = paramJson.uid;
        MediaTraceEvent? currentEvent = paramJson.currentEvent;
        VideoRenderingTracingInfo? tracingInfo = paramJson.tracingInfo;
        if (connection == null ||
            uid == null ||
            currentEvent == null ||
            tracingInfo == null) {
          return true;
        }
        connection = connection.fillBuffers(buffers);

        tracingInfo = tracingInfo.fillBuffers(buffers);
        rtcEngineEventHandler.onVideoRenderingTracingResult!(
            connection, uid, currentEvent, tracingInfo);
        return true;

      case 'onLocalVideoTranscoderError_83e3a9c':
        if (rtcEngineEventHandler.onLocalVideoTranscoderError == null) {
          return true;
        }
        final jsonMap = jsonDecode(eventData);
        RtcEngineEventHandlerOnLocalVideoTranscoderErrorJson paramJson =
            RtcEngineEventHandlerOnLocalVideoTranscoderErrorJson.fromJson(
                jsonMap);
        paramJson = paramJson.fillBuffers(buffers);
        TranscodingVideoStream? stream = paramJson.stream;
        VideoTranscoderError? error = paramJson.error;
        if (stream == null || error == null) {
          return true;
        }
        stream = stream.fillBuffers(buffers);
        rtcEngineEventHandler.onLocalVideoTranscoderError!(stream, error);
        return true;

      case 'onUploadLogResult_3115804':
        if (rtcEngineEventHandler.onUploadLogResult == null) {
          return true;
        }
        final jsonMap = jsonDecode(eventData);
        RtcEngineEventHandlerOnUploadLogResultJson paramJson =
            RtcEngineEventHandlerOnUploadLogResultJson.fromJson(jsonMap);
        paramJson = paramJson.fillBuffers(buffers);
        RtcConnection? connection = paramJson.connection;
        String? requestId = paramJson.requestId;
        bool? success = paramJson.success;
        UploadErrorReason? reason = paramJson.reason;
        if (connection == null ||
            requestId == null ||
            success == null ||
            reason == null) {
          return true;
        }
        connection = connection.fillBuffers(buffers);
        rtcEngineEventHandler.onUploadLogResult!(
            connection, requestId, success, reason);
        return true;

      case 'onAudioSubscribeStateChanged_e0ec28e':
        if (rtcEngineEventHandler.onAudioSubscribeStateChanged == null) {
          return true;
        }
        final jsonMap = jsonDecode(eventData);
        RtcEngineEventHandlerOnAudioSubscribeStateChangedJson paramJson =
            RtcEngineEventHandlerOnAudioSubscribeStateChangedJson.fromJson(
                jsonMap);
        paramJson = paramJson.fillBuffers(buffers);
        String? channel = paramJson.channel;
        int? uid = paramJson.uid;
        StreamSubscribeState? oldState = paramJson.oldState;
        StreamSubscribeState? newState = paramJson.newState;
        int? elapseSinceLastState = paramJson.elapseSinceLastState;
        if (channel == null ||
            uid == null ||
            oldState == null ||
            newState == null ||
            elapseSinceLastState == null) {
          return true;
        }

        rtcEngineEventHandler.onAudioSubscribeStateChanged!(
            channel, uid, oldState, newState, elapseSinceLastState);
        return true;

      case 'onVideoSubscribeStateChanged_e0ec28e':
        if (rtcEngineEventHandler.onVideoSubscribeStateChanged == null) {
          return true;
        }
        final jsonMap = jsonDecode(eventData);
        RtcEngineEventHandlerOnVideoSubscribeStateChangedJson paramJson =
            RtcEngineEventHandlerOnVideoSubscribeStateChangedJson.fromJson(
                jsonMap);
        paramJson = paramJson.fillBuffers(buffers);
        String? channel = paramJson.channel;
        int? uid = paramJson.uid;
        StreamSubscribeState? oldState = paramJson.oldState;
        StreamSubscribeState? newState = paramJson.newState;
        int? elapseSinceLastState = paramJson.elapseSinceLastState;
        if (channel == null ||
            uid == null ||
            oldState == null ||
            newState == null ||
            elapseSinceLastState == null) {
          return true;
        }

        rtcEngineEventHandler.onVideoSubscribeStateChanged!(
            channel, uid, oldState, newState, elapseSinceLastState);
        return true;

      case 'onAudioPublishStateChanged_2c13a28':
        if (rtcEngineEventHandler.onAudioPublishStateChanged == null) {
          return true;
        }
        final jsonMap = jsonDecode(eventData);
        RtcEngineEventHandlerOnAudioPublishStateChangedJson paramJson =
            RtcEngineEventHandlerOnAudioPublishStateChangedJson.fromJson(
                jsonMap);
        paramJson = paramJson.fillBuffers(buffers);
        String? channel = paramJson.channel;
        StreamPublishState? oldState = paramJson.oldState;
        StreamPublishState? newState = paramJson.newState;
        int? elapseSinceLastState = paramJson.elapseSinceLastState;
        if (channel == null ||
            oldState == null ||
            newState == null ||
            elapseSinceLastState == null) {
          return true;
        }

        rtcEngineEventHandler.onAudioPublishStateChanged!(
            channel, oldState, newState, elapseSinceLastState);
        return true;

      case 'onVideoPublishStateChanged_5b45b6e':
        if (rtcEngineEventHandler.onVideoPublishStateChanged == null) {
          return true;
        }
        final jsonMap = jsonDecode(eventData);
        RtcEngineEventHandlerOnVideoPublishStateChangedJson paramJson =
            RtcEngineEventHandlerOnVideoPublishStateChangedJson.fromJson(
                jsonMap);
        paramJson = paramJson.fillBuffers(buffers);
        VideoSourceType? source = paramJson.source;
        String? channel = paramJson.channel;
        StreamPublishState? oldState = paramJson.oldState;
        StreamPublishState? newState = paramJson.newState;
        int? elapseSinceLastState = paramJson.elapseSinceLastState;
        if (source == null ||
            channel == null ||
            oldState == null ||
            newState == null ||
            elapseSinceLastState == null) {
          return true;
        }

        rtcEngineEventHandler.onVideoPublishStateChanged!(
            source, channel, oldState, newState, elapseSinceLastState);
        return true;

      case 'onTranscodedStreamLayoutInfo_48f6419':
        if (rtcEngineEventHandler.onTranscodedStreamLayoutInfo == null) {
          return true;
        }
        final jsonMap = jsonDecode(eventData);
        RtcEngineEventHandlerOnTranscodedStreamLayoutInfoJson paramJson =
            RtcEngineEventHandlerOnTranscodedStreamLayoutInfoJson.fromJson(
                jsonMap);
        paramJson = paramJson.fillBuffers(buffers);
        RtcConnection? connection = paramJson.connection;
        int? uid = paramJson.uid;
        int? width = paramJson.width;
        int? height = paramJson.height;
        int? layoutCount = paramJson.layoutCount;
        List<VideoLayout>? layoutlist = paramJson.layoutlist;
        if (connection == null ||
            uid == null ||
            width == null ||
            height == null ||
            layoutCount == null ||
            layoutlist == null) {
          return true;
        }
        connection = connection.fillBuffers(buffers);

        layoutlist = layoutlist.map((e) => e.fillBuffers(buffers)).toList();
        rtcEngineEventHandler.onTranscodedStreamLayoutInfo!(
            connection, uid, width, height, layoutCount, layoutlist);
        return true;

      case 'onAudioMetadataReceived_0d4eb96':
        if (rtcEngineEventHandler.onAudioMetadataReceived == null) {
          return true;
        }
        final jsonMap = jsonDecode(eventData);
        RtcEngineEventHandlerOnAudioMetadataReceivedJson paramJson =
            RtcEngineEventHandlerOnAudioMetadataReceivedJson.fromJson(jsonMap);
        paramJson = paramJson.fillBuffers(buffers);
        RtcConnection? connection = paramJson.connection;
        int? uid = paramJson.uid;
        Uint8List? metadata = paramJson.metadata;
        int? length = paramJson.length;
        if (connection == null ||
            uid == null ||
            metadata == null ||
            length == null) {
          return true;
        }
        connection = connection.fillBuffers(buffers);
        rtcEngineEventHandler.onAudioMetadataReceived!(
            connection, uid, metadata, length);
        return true;

      case 'onExtensionEventWithContext_a5fb27a':
        if (rtcEngineEventHandler.onExtensionEventWithContext == null) {
          return true;
        }
        final jsonMap = jsonDecode(eventData);
        RtcEngineEventHandlerOnExtensionEventWithContextJson paramJson =
            RtcEngineEventHandlerOnExtensionEventWithContextJson.fromJson(
                jsonMap);
        paramJson = paramJson.fillBuffers(buffers);
        ExtensionContext? context = paramJson.context;
        String? key = paramJson.key;
        String? value = paramJson.value;
        if (context == null || key == null || value == null) {
          return true;
        }
        context = context.fillBuffers(buffers);
        rtcEngineEventHandler.onExtensionEventWithContext!(context, key, value);
        return true;

      case 'onExtensionStartedWithContext_67c38e3':
        if (rtcEngineEventHandler.onExtensionStartedWithContext == null) {
          return true;
        }
        final jsonMap = jsonDecode(eventData);
        RtcEngineEventHandlerOnExtensionStartedWithContextJson paramJson =
            RtcEngineEventHandlerOnExtensionStartedWithContextJson.fromJson(
                jsonMap);
        paramJson = paramJson.fillBuffers(buffers);
        ExtensionContext? context = paramJson.context;
        if (context == null) {
          return true;
        }
        context = context.fillBuffers(buffers);
        rtcEngineEventHandler.onExtensionStartedWithContext!(context);
        return true;

      case 'onExtensionStoppedWithContext_67c38e3':
        if (rtcEngineEventHandler.onExtensionStoppedWithContext == null) {
          return true;
        }
        final jsonMap = jsonDecode(eventData);
        RtcEngineEventHandlerOnExtensionStoppedWithContextJson paramJson =
            RtcEngineEventHandlerOnExtensionStoppedWithContextJson.fromJson(
                jsonMap);
        paramJson = paramJson.fillBuffers(buffers);
        ExtensionContext? context = paramJson.context;
        if (context == null) {
          return true;
        }
        context = context.fillBuffers(buffers);
        rtcEngineEventHandler.onExtensionStoppedWithContext!(context);
        return true;

      case 'onExtensionErrorWithContext_a452f11':
        if (rtcEngineEventHandler.onExtensionErrorWithContext == null) {
          return true;
        }
        final jsonMap = jsonDecode(eventData);
        RtcEngineEventHandlerOnExtensionErrorWithContextJson paramJson =
            RtcEngineEventHandlerOnExtensionErrorWithContextJson.fromJson(
                jsonMap);
        paramJson = paramJson.fillBuffers(buffers);
        ExtensionContext? context = paramJson.context;
        int? error = paramJson.error;
        String? message = paramJson.message;
        if (context == null || error == null || message == null) {
          return true;
        }
        context = context.fillBuffers(buffers);
        rtcEngineEventHandler.onExtensionErrorWithContext!(
            context, error, message);
        return true;

      case 'onSetRtmFlagResult_263e4cd':
        if (rtcEngineEventHandler.onSetRtmFlagResult == null) {
          return true;
        }
        final jsonMap = jsonDecode(eventData);
        RtcEngineEventHandlerOnSetRtmFlagResultJson paramJson =
            RtcEngineEventHandlerOnSetRtmFlagResultJson.fromJson(jsonMap);
        paramJson = paramJson.fillBuffers(buffers);
        RtcConnection? connection = paramJson.connection;
        int? code = paramJson.code;
        if (connection == null || code == null) {
          return true;
        }
        connection = connection.fillBuffers(buffers);
        rtcEngineEventHandler.onSetRtmFlagResult!(connection, code);
        return true;
    }
    return false;
  }

  @override
  bool handleEvent(
      String eventName, String eventData, List<Uint8List> buffers) {
    if (!eventName.startsWith('RtcEngineEventHandler')) return false;
    final newEvent = eventName.replaceFirst('RtcEngineEventHandler_', '');
    if (handleEventInternal(newEvent, eventData, buffers)) {
      return true;
    }
    return false;
  }
}

class MetadataObserverWrapper implements EventLoopEventHandler {
  const MetadataObserverWrapper(this.metadataObserver);

  final MetadataObserver metadataObserver;

  @override
  bool operator ==(Object other) {
    if (other.runtimeType != runtimeType) {
      return false;
    }
    return other is MetadataObserverWrapper &&
        other.metadataObserver == metadataObserver;
  }

  @override
  int get hashCode => metadataObserver.hashCode;

  @override
  bool handleEventInternal(
      String eventName, String eventData, List<Uint8List> buffers) {
    switch (eventName) {
      case 'onMetadataReceived_cb7661d':
        if (metadataObserver.onMetadataReceived == null) {
          return true;
        }
        final jsonMap = jsonDecode(eventData);
        MetadataObserverOnMetadataReceivedJson paramJson =
            MetadataObserverOnMetadataReceivedJson.fromJson(jsonMap);
        paramJson = paramJson.fillBuffers(buffers);
        Metadata? metadata = paramJson.metadata;
        if (metadata == null) {
          return true;
        }
        metadata = metadata.fillBuffers(buffers);
        metadataObserver.onMetadataReceived!(metadata);
        return true;
    }
    return false;
  }

  @override
  bool handleEvent(
      String eventName, String eventData, List<Uint8List> buffers) {
    if (!eventName.startsWith('MetadataObserver')) return false;
    final newEvent = eventName.replaceFirst('MetadataObserver_', '');
    if (handleEventInternal(newEvent, eventData, buffers)) {
      return true;
    }
    return false;
  }
}

class DirectCdnStreamingEventHandlerWrapper implements EventLoopEventHandler {
  const DirectCdnStreamingEventHandlerWrapper(
      this.directCdnStreamingEventHandler);

  final DirectCdnStreamingEventHandler directCdnStreamingEventHandler;

  @override
  bool operator ==(Object other) {
    if (other.runtimeType != runtimeType) {
      return false;
    }
    return other is DirectCdnStreamingEventHandlerWrapper &&
        other.directCdnStreamingEventHandler == directCdnStreamingEventHandler;
  }

  @override
  int get hashCode => directCdnStreamingEventHandler.hashCode;

  @override
  bool handleEventInternal(
      String eventName, String eventData, List<Uint8List> buffers) {
    switch (eventName) {
      case 'onDirectCdnStreamingStateChanged_40f1fa3':
        if (directCdnStreamingEventHandler.onDirectCdnStreamingStateChanged ==
            null) {
          return true;
        }
        final jsonMap = jsonDecode(eventData);
        DirectCdnStreamingEventHandlerOnDirectCdnStreamingStateChangedJson
            paramJson =
            DirectCdnStreamingEventHandlerOnDirectCdnStreamingStateChangedJson
                .fromJson(jsonMap);
        paramJson = paramJson.fillBuffers(buffers);
        DirectCdnStreamingState? state = paramJson.state;
        DirectCdnStreamingReason? reason = paramJson.reason;
        String? message = paramJson.message;
        if (state == null || reason == null || message == null) {
          return true;
        }

        directCdnStreamingEventHandler.onDirectCdnStreamingStateChanged!(
            state, reason, message);
        return true;

      case 'onDirectCdnStreamingStats_d50595f':
        if (directCdnStreamingEventHandler.onDirectCdnStreamingStats == null) {
          return true;
        }
        final jsonMap = jsonDecode(eventData);
        DirectCdnStreamingEventHandlerOnDirectCdnStreamingStatsJson paramJson =
            DirectCdnStreamingEventHandlerOnDirectCdnStreamingStatsJson
                .fromJson(jsonMap);
        paramJson = paramJson.fillBuffers(buffers);
        DirectCdnStreamingStats? stats = paramJson.stats;
        if (stats == null) {
          return true;
        }
        stats = stats.fillBuffers(buffers);
        directCdnStreamingEventHandler.onDirectCdnStreamingStats!(stats);
        return true;
    }
    return false;
  }

  @override
  bool handleEvent(
      String eventName, String eventData, List<Uint8List> buffers) {
    if (!eventName.startsWith('DirectCdnStreamingEventHandler')) return false;
    final newEvent =
        eventName.replaceFirst('DirectCdnStreamingEventHandler_', '');
    if (handleEventInternal(newEvent, eventData, buffers)) {
      return true;
    }
    return false;
  }
}
