# This file was auto-generated by Fern from our API Definition.

import typing
from ..core.client_wrapper import SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.secret_response_dto import SecretResponseDto
from ..core.pydantic_utilities import parse_obj_as
from json.decoder import JSONDecodeError
from ..core.api_error import ApiError
from ..types.secret_dto import SecretDto
from ..types.header_dto import HeaderDto
from ..core.serialization import convert_and_respect_annotation_metadata
from ..errors.unprocessable_entity_error import UnprocessableEntityError
from ..types.http_validation_error import HttpValidationError
from ..core.jsonable_encoder import jsonable_encoder
from ..core.client_wrapper import AsyncClientWrapper

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class VaultClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def list_secrets(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[SecretResponseDto]:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[SecretResponseDto]
            Successful Response

        Examples
        --------
        from agenta import AgentaApi

        client = AgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.vault.list_secrets()
        """
        _response = self._client_wrapper.httpx_client.request(
            "vault/v1/secrets",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    typing.List[SecretResponseDto],
                    parse_obj_as(
                        type_=typing.List[SecretResponseDto],  # type: ignore
                        object_=_response.json(),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def create_secret(
        self,
        *,
        secret: SecretDto,
        header: typing.Optional[HeaderDto] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SecretResponseDto:
        """
        Parameters
        ----------
        secret : SecretDto

        header : typing.Optional[HeaderDto]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SecretResponseDto
            Successful Response

        Examples
        --------
        from agenta import AgentaApi, ProviderKeyDto, SecretDto

        client = AgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.vault.create_secret(
            secret=SecretDto(
                data=ProviderKeyDto(
                    provider="openai",
                    key="key",
                ),
            ),
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "vault/v1/secrets",
            method="POST",
            json={
                "header": convert_and_respect_annotation_metadata(
                    object_=header, annotation=HeaderDto, direction="write"
                ),
                "secret": convert_and_respect_annotation_metadata(
                    object_=secret, annotation=SecretDto, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    SecretResponseDto,
                    parse_obj_as(
                        type_=SecretResponseDto,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def read_secret(
        self, secret_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> SecretResponseDto:
        """
        Parameters
        ----------
        secret_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SecretResponseDto
            Successful Response

        Examples
        --------
        from agenta import AgentaApi

        client = AgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.vault.read_secret(
            secret_id="secret_id",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"vault/v1/secrets/{jsonable_encoder(secret_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    SecretResponseDto,
                    parse_obj_as(
                        type_=SecretResponseDto,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def update_secret(
        self,
        secret_id: str,
        *,
        header: typing.Optional[HeaderDto] = OMIT,
        secret: typing.Optional[SecretDto] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SecretResponseDto:
        """
        Parameters
        ----------
        secret_id : str

        header : typing.Optional[HeaderDto]

        secret : typing.Optional[SecretDto]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SecretResponseDto
            Successful Response

        Examples
        --------
        from agenta import AgentaApi

        client = AgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.vault.update_secret(
            secret_id="secret_id",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"vault/v1/secrets/{jsonable_encoder(secret_id)}",
            method="PUT",
            json={
                "header": convert_and_respect_annotation_metadata(
                    object_=header, annotation=HeaderDto, direction="write"
                ),
                "secret": convert_and_respect_annotation_metadata(
                    object_=secret, annotation=SecretDto, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    SecretResponseDto,
                    parse_obj_as(
                        type_=SecretResponseDto,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def delete_secret(
        self, secret_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Parameters
        ----------
        secret_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from agenta import AgentaApi

        client = AgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.vault.delete_secret(
            secret_id="secret_id",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"vault/v1/secrets/{jsonable_encoder(secret_id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)


class AsyncVaultClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def list_secrets(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[SecretResponseDto]:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[SecretResponseDto]
            Successful Response

        Examples
        --------
        import asyncio

        from agenta import AsyncAgentaApi

        client = AsyncAgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.vault.list_secrets()


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "vault/v1/secrets",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    typing.List[SecretResponseDto],
                    parse_obj_as(
                        type_=typing.List[SecretResponseDto],  # type: ignore
                        object_=_response.json(),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def create_secret(
        self,
        *,
        secret: SecretDto,
        header: typing.Optional[HeaderDto] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SecretResponseDto:
        """
        Parameters
        ----------
        secret : SecretDto

        header : typing.Optional[HeaderDto]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SecretResponseDto
            Successful Response

        Examples
        --------
        import asyncio

        from agenta import AsyncAgentaApi, ProviderKeyDto, SecretDto

        client = AsyncAgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.vault.create_secret(
                secret=SecretDto(
                    data=ProviderKeyDto(
                        provider="openai",
                        key="key",
                    ),
                ),
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "vault/v1/secrets",
            method="POST",
            json={
                "header": convert_and_respect_annotation_metadata(
                    object_=header, annotation=HeaderDto, direction="write"
                ),
                "secret": convert_and_respect_annotation_metadata(
                    object_=secret, annotation=SecretDto, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    SecretResponseDto,
                    parse_obj_as(
                        type_=SecretResponseDto,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def read_secret(
        self, secret_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> SecretResponseDto:
        """
        Parameters
        ----------
        secret_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SecretResponseDto
            Successful Response

        Examples
        --------
        import asyncio

        from agenta import AsyncAgentaApi

        client = AsyncAgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.vault.read_secret(
                secret_id="secret_id",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"vault/v1/secrets/{jsonable_encoder(secret_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    SecretResponseDto,
                    parse_obj_as(
                        type_=SecretResponseDto,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def update_secret(
        self,
        secret_id: str,
        *,
        header: typing.Optional[HeaderDto] = OMIT,
        secret: typing.Optional[SecretDto] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SecretResponseDto:
        """
        Parameters
        ----------
        secret_id : str

        header : typing.Optional[HeaderDto]

        secret : typing.Optional[SecretDto]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SecretResponseDto
            Successful Response

        Examples
        --------
        import asyncio

        from agenta import AsyncAgentaApi

        client = AsyncAgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.vault.update_secret(
                secret_id="secret_id",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"vault/v1/secrets/{jsonable_encoder(secret_id)}",
            method="PUT",
            json={
                "header": convert_and_respect_annotation_metadata(
                    object_=header, annotation=HeaderDto, direction="write"
                ),
                "secret": convert_and_respect_annotation_metadata(
                    object_=secret, annotation=SecretDto, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    SecretResponseDto,
                    parse_obj_as(
                        type_=SecretResponseDto,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def delete_secret(
        self, secret_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Parameters
        ----------
        secret_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from agenta import AsyncAgentaApi

        client = AsyncAgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.vault.delete_secret(
                secret_id="secret_id",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"vault/v1/secrets/{jsonable_encoder(secret_id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)
