# This file was auto-generated by Fern from our API Definition.

import typing
from ..core.client_wrapper import SyncClientWrapper
from ..core.request_options import RequestOptions
from .types.add_variant_from_base_and_config_response import (
    AddVariantFromBaseAndConfigResponse,
)
from ..core.pydantic_utilities import parse_obj_as
from ..errors.unprocessable_entity_error import UnprocessableEntityError
from ..types.http_validation_error import HttpValidationError
from json.decoder import JSONDecodeError
from ..core.api_error import ApiError
from ..types.app_variant_response import AppVariantResponse
from ..core.jsonable_encoder import jsonable_encoder
from ..types.variant_action import VariantAction
from ..types.docker_env_vars import DockerEnvVars
from ..types.uri import Uri
from ..core.serialization import convert_and_respect_annotation_metadata
from ..types.app_variant_revision import AppVariantRevision
from ..types.reference_request_model import ReferenceRequestModel
from ..types.config_response_model import ConfigResponseModel
from ..types.config_dto import ConfigDto
from ..types.reference_dto import ReferenceDto
from ..core.client_wrapper import AsyncClientWrapper

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class VariantsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def add_variant_from_base_and_config(
        self,
        *,
        base_id: str,
        new_variant_name: str,
        new_config_name: str,
        parameters: typing.Dict[str, typing.Optional[typing.Any]],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AddVariantFromBaseAndConfigResponse:
        """
        Add a new variant based on an existing one.
        Same as POST /config

        Args:
            payload (AddVariantFromBasePayload): Payload containing base variant ID, new variant name, and parameters.
            stoken_session (SessionContainer, optional): Session container. Defaults to result of verify_session().

        Raises:
            HTTPException: Raised if the variant could not be added or accessed.

        Returns:
            Union[AppVariantResponse, Any]: New variant details or exception.

        Parameters
        ----------
        base_id : str

        new_variant_name : str

        new_config_name : str

        parameters : typing.Dict[str, typing.Optional[typing.Any]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AddVariantFromBaseAndConfigResponse
            Successful Response

        Examples
        --------
        from agenta import AgentaApi

        client = AgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.variants.add_variant_from_base_and_config(
            base_id="base_id",
            new_variant_name="new_variant_name",
            new_config_name="new_config_name",
            parameters={"key": "value"},
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "variants/from-base",
            method="POST",
            json={
                "base_id": base_id,
                "new_variant_name": new_variant_name,
                "new_config_name": new_config_name,
                "parameters": parameters,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    AddVariantFromBaseAndConfigResponse,
                    parse_obj_as(
                        type_=AddVariantFromBaseAndConfigResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def get_variant(
        self,
        variant_id: str,
        *,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AppVariantResponse:
        """
        Parameters
        ----------
        variant_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AppVariantResponse
            Successful Response

        Examples
        --------
        from agenta import AgentaApi

        client = AgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.variants.get_variant(
            variant_id="variant_id",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"variants/{jsonable_encoder(variant_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    AppVariantResponse,
                    parse_obj_as(
                        type_=AppVariantResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def start_variant(
        self,
        variant_id: str,
        *,
        action: VariantAction,
        env_vars: typing.Optional[DockerEnvVars] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Uri:
        """
        Start a variant of an app.

        Args:
            variant_id (str): The ID of the variant to start.
            action (VariantAction): The action to perform on the variant (start).
            env_vars (Optional[DockerEnvVars], optional): The environment variables to inject to the Docker container. Defaults to None.
            stoken_session (SessionContainer, optional): The session container. Defaults to Depends(verify_session()).

        Returns:
            URI: The URL of the started variant.

        Raises:
            HTTPException: If the app container cannot be started.

        Parameters
        ----------
        variant_id : str

        action : VariantAction

        env_vars : typing.Optional[DockerEnvVars]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Uri
            Successful Response

        Examples
        --------
        from agenta import AgentaApi, VariantAction

        client = AgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.variants.start_variant(
            variant_id="variant_id",
            action=VariantAction(
                action="START",
            ),
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"variants/{jsonable_encoder(variant_id)}",
            method="PUT",
            json={
                "action": convert_and_respect_annotation_metadata(
                    object_=action, annotation=VariantAction, direction="write"
                ),
                "env_vars": convert_and_respect_annotation_metadata(
                    object_=env_vars, annotation=DockerEnvVars, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    Uri,
                    parse_obj_as(
                        type_=Uri,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def remove_variant(
        self,
        variant_id: str,
        *,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Optional[typing.Any]:
        """
        Remove a variant from the server.
        In the case it's the last variant using the image, stop the container and remove the image.

        Arguments:



            app_variant -- AppVariant to remove

        Raises:



            HTTPException: If there is a problem removing the app variant

        Parameters
        ----------
        variant_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[typing.Any]
            Successful Response

        Examples
        --------
        from agenta import AgentaApi

        client = AgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.variants.remove_variant(
            variant_id="variant_id",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"variants/{jsonable_encoder(variant_id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    typing.Optional[typing.Any],
                    parse_obj_as(
                        type_=typing.Optional[typing.Any],  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def update_variant_parameters(
        self,
        variant_id: str,
        *,
        parameters: typing.Dict[str, typing.Optional[typing.Any]],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Optional[typing.Any]:
        """
        Updates the parameters for an app variant.

        Args:
            variant_id (str): The ID of the app variant to update.
            payload (UpdateVariantParameterPayload): The payload containing the updated parameters.
            stoken_session (SessionContainer, optional): The session container. Defaults to Depends(verify_session()).

        Raises:
            HTTPException: If there is an error while trying to update the app variant.

        Returns:
            JSONResponse: A JSON response containing the updated app variant parameters.

        Parameters
        ----------
        variant_id : str

        parameters : typing.Dict[str, typing.Optional[typing.Any]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[typing.Any]
            Successful Response

        Examples
        --------
        from agenta import AgentaApi

        client = AgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.variants.update_variant_parameters(
            variant_id="variant_id",
            parameters={"key": "value"},
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"variants/{jsonable_encoder(variant_id)}/parameters",
            method="PUT",
            json={
                "parameters": parameters,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    typing.Optional[typing.Any],
                    parse_obj_as(
                        type_=typing.Optional[typing.Any],  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def update_variant_image(
        self,
        variant_id: str,
        *,
        docker_id: str,
        tags: str,
        type: typing.Optional[str] = OMIT,
        organization_id: typing.Optional[str] = OMIT,
        workspace_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Optional[typing.Any]:
        """
        Updates the image used in an app variant.

        Args:
            variant_id (str): The ID of the app variant to update.
            image (Image): The image information to update.

        Raises:
            HTTPException: If an error occurs while trying to update the app variant.

        Returns:
            JSONResponse: A JSON response indicating whether the update was successful or not.

        Parameters
        ----------
        variant_id : str

        docker_id : str

        tags : str

        type : typing.Optional[str]

        organization_id : typing.Optional[str]

        workspace_id : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[typing.Any]
            Successful Response

        Examples
        --------
        from agenta import AgentaApi

        client = AgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.variants.update_variant_image(
            variant_id="variant_id",
            docker_id="docker_id",
            tags="tags",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"variants/{jsonable_encoder(variant_id)}/image",
            method="PUT",
            json={
                "type": type,
                "docker_id": docker_id,
                "tags": tags,
                "organization_id": organization_id,
                "workspace_id": workspace_id,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    typing.Optional[typing.Any],
                    parse_obj_as(
                        type_=typing.Optional[typing.Any],  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def retrieve_variant_logs(
        self,
        variant_id: str,
        *,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Optional[typing.Any]:
        """
        Parameters
        ----------
        variant_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[typing.Any]
            Successful Response

        Examples
        --------
        from agenta import AgentaApi

        client = AgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.variants.retrieve_variant_logs(
            variant_id="variant_id",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"variants/{jsonable_encoder(variant_id)}/logs",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    typing.Optional[typing.Any],
                    parse_obj_as(
                        type_=typing.Optional[typing.Any],  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def get_variant_revisions(
        self,
        variant_id: str,
        *,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[AppVariantRevision]:
        """
        Parameters
        ----------
        variant_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[AppVariantRevision]
            Successful Response

        Examples
        --------
        from agenta import AgentaApi

        client = AgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.variants.get_variant_revisions(
            variant_id="variant_id",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"variants/{jsonable_encoder(variant_id)}/revisions",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    typing.List[AppVariantRevision],
                    parse_obj_as(
                        type_=typing.List[AppVariantRevision],  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def get_variant_revision(
        self,
        variant_id: str,
        revision_number: int,
        *,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AppVariantRevision:
        """
        Parameters
        ----------
        variant_id : str

        revision_number : int

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AppVariantRevision
            Successful Response

        Examples
        --------
        from agenta import AgentaApi

        client = AgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.variants.get_variant_revision(
            variant_id="variant_id",
            revision_number=1,
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"variants/{jsonable_encoder(variant_id)}/revisions/{jsonable_encoder(revision_number)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    AppVariantRevision,
                    parse_obj_as(
                        type_=AppVariantRevision,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def configs_add(
        self,
        *,
        variant_ref: ReferenceRequestModel,
        application_ref: ReferenceRequestModel,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ConfigResponseModel:
        """
        Parameters
        ----------
        variant_ref : ReferenceRequestModel

        application_ref : ReferenceRequestModel

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ConfigResponseModel
            Successful Response

        Examples
        --------
        from agenta import AgentaApi, ReferenceRequestModel

        client = AgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.variants.configs_add(
            variant_ref=ReferenceRequestModel(),
            application_ref=ReferenceRequestModel(),
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "variants/configs/add",
            method="POST",
            json={
                "variant_ref": convert_and_respect_annotation_metadata(
                    object_=variant_ref,
                    annotation=ReferenceRequestModel,
                    direction="write",
                ),
                "application_ref": convert_and_respect_annotation_metadata(
                    object_=application_ref,
                    annotation=ReferenceRequestModel,
                    direction="write",
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    ConfigResponseModel,
                    parse_obj_as(
                        type_=ConfigResponseModel,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def configs_fetch(
        self,
        *,
        variant_ref: typing.Optional[ReferenceRequestModel] = OMIT,
        environment_ref: typing.Optional[ReferenceRequestModel] = OMIT,
        application_ref: typing.Optional[ReferenceRequestModel] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ConfigResponseModel:
        """
        Parameters
        ----------
        variant_ref : typing.Optional[ReferenceRequestModel]

        environment_ref : typing.Optional[ReferenceRequestModel]

        application_ref : typing.Optional[ReferenceRequestModel]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ConfigResponseModel
            Successful Response

        Examples
        --------
        from agenta import AgentaApi

        client = AgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.variants.configs_fetch()
        """
        _response = self._client_wrapper.httpx_client.request(
            "variants/configs/fetch",
            method="POST",
            json={
                "variant_ref": convert_and_respect_annotation_metadata(
                    object_=variant_ref,
                    annotation=ReferenceRequestModel,
                    direction="write",
                ),
                "environment_ref": convert_and_respect_annotation_metadata(
                    object_=environment_ref,
                    annotation=ReferenceRequestModel,
                    direction="write",
                ),
                "application_ref": convert_and_respect_annotation_metadata(
                    object_=application_ref,
                    annotation=ReferenceRequestModel,
                    direction="write",
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    ConfigResponseModel,
                    parse_obj_as(
                        type_=ConfigResponseModel,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def configs_fork(
        self,
        *,
        variant_ref: typing.Optional[ReferenceRequestModel] = OMIT,
        environment_ref: typing.Optional[ReferenceRequestModel] = OMIT,
        application_ref: typing.Optional[ReferenceRequestModel] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ConfigResponseModel:
        """
        Parameters
        ----------
        variant_ref : typing.Optional[ReferenceRequestModel]

        environment_ref : typing.Optional[ReferenceRequestModel]

        application_ref : typing.Optional[ReferenceRequestModel]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ConfigResponseModel
            Successful Response

        Examples
        --------
        from agenta import AgentaApi

        client = AgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.variants.configs_fork()
        """
        _response = self._client_wrapper.httpx_client.request(
            "variants/configs/fork",
            method="POST",
            json={
                "variant_ref": convert_and_respect_annotation_metadata(
                    object_=variant_ref,
                    annotation=ReferenceRequestModel,
                    direction="write",
                ),
                "environment_ref": convert_and_respect_annotation_metadata(
                    object_=environment_ref,
                    annotation=ReferenceRequestModel,
                    direction="write",
                ),
                "application_ref": convert_and_respect_annotation_metadata(
                    object_=application_ref,
                    annotation=ReferenceRequestModel,
                    direction="write",
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    ConfigResponseModel,
                    parse_obj_as(
                        type_=ConfigResponseModel,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def configs_commit(
        self,
        *,
        config: ConfigDto,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ConfigResponseModel:
        """
        Parameters
        ----------
        config : ConfigDto

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ConfigResponseModel
            Successful Response

        Examples
        --------
        from agenta import AgentaApi, ConfigDto

        client = AgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.variants.configs_commit(
            config=ConfigDto(
                params={"key": "value"},
            ),
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "variants/configs/commit",
            method="POST",
            json={
                "config": convert_and_respect_annotation_metadata(
                    object_=config, annotation=ConfigDto, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    ConfigResponseModel,
                    parse_obj_as(
                        type_=ConfigResponseModel,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def configs_deploy(
        self,
        *,
        variant_ref: ReferenceRequestModel,
        environment_ref: ReferenceRequestModel,
        application_ref: typing.Optional[ReferenceRequestModel] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ConfigResponseModel:
        """
        Parameters
        ----------
        variant_ref : ReferenceRequestModel

        environment_ref : ReferenceRequestModel

        application_ref : typing.Optional[ReferenceRequestModel]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ConfigResponseModel
            Successful Response

        Examples
        --------
        from agenta import AgentaApi, ReferenceRequestModel

        client = AgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.variants.configs_deploy(
            variant_ref=ReferenceRequestModel(),
            environment_ref=ReferenceRequestModel(),
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "variants/configs/deploy",
            method="POST",
            json={
                "variant_ref": convert_and_respect_annotation_metadata(
                    object_=variant_ref,
                    annotation=ReferenceRequestModel,
                    direction="write",
                ),
                "environment_ref": convert_and_respect_annotation_metadata(
                    object_=environment_ref,
                    annotation=ReferenceRequestModel,
                    direction="write",
                ),
                "application_ref": convert_and_respect_annotation_metadata(
                    object_=application_ref,
                    annotation=ReferenceRequestModel,
                    direction="write",
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    ConfigResponseModel,
                    parse_obj_as(
                        type_=ConfigResponseModel,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def configs_delete(
        self,
        *,
        variant_ref: ReferenceRequestModel,
        application_ref: typing.Optional[ReferenceRequestModel] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> int:
        """
        Parameters
        ----------
        variant_ref : ReferenceRequestModel

        application_ref : typing.Optional[ReferenceRequestModel]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        int
            Successful Response

        Examples
        --------
        from agenta import AgentaApi, ReferenceRequestModel

        client = AgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.variants.configs_delete(
            variant_ref=ReferenceRequestModel(),
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "variants/configs/delete",
            method="POST",
            json={
                "variant_ref": convert_and_respect_annotation_metadata(
                    object_=variant_ref,
                    annotation=ReferenceRequestModel,
                    direction="write",
                ),
                "application_ref": convert_and_respect_annotation_metadata(
                    object_=application_ref,
                    annotation=ReferenceRequestModel,
                    direction="write",
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    int,
                    parse_obj_as(
                        type_=int,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def configs_list(
        self,
        *,
        application_ref: ReferenceDto,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[ConfigResponseModel]:
        """
        Parameters
        ----------
        application_ref : ReferenceDto

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[ConfigResponseModel]
            Successful Response

        Examples
        --------
        from agenta import AgentaApi, ReferenceDto

        client = AgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.variants.configs_list(
            application_ref=ReferenceDto(),
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "variants/configs/list",
            method="POST",
            json={
                "application_ref": convert_and_respect_annotation_metadata(
                    object_=application_ref, annotation=ReferenceDto, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    typing.List[ConfigResponseModel],
                    parse_obj_as(
                        type_=typing.List[ConfigResponseModel],  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def configs_history(
        self,
        *,
        variant_ref: ReferenceRequestModel,
        application_ref: typing.Optional[ReferenceRequestModel] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[ConfigResponseModel]:
        """
        Parameters
        ----------
        variant_ref : ReferenceRequestModel

        application_ref : typing.Optional[ReferenceRequestModel]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[ConfigResponseModel]
            Successful Response

        Examples
        --------
        from agenta import AgentaApi, ReferenceRequestModel

        client = AgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.variants.configs_history(
            variant_ref=ReferenceRequestModel(),
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "variants/configs/history",
            method="POST",
            json={
                "variant_ref": convert_and_respect_annotation_metadata(
                    object_=variant_ref,
                    annotation=ReferenceRequestModel,
                    direction="write",
                ),
                "application_ref": convert_and_respect_annotation_metadata(
                    object_=application_ref,
                    annotation=ReferenceRequestModel,
                    direction="write",
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    typing.List[ConfigResponseModel],
                    parse_obj_as(
                        type_=typing.List[ConfigResponseModel],  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)


class AsyncVariantsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def add_variant_from_base_and_config(
        self,
        *,
        base_id: str,
        new_variant_name: str,
        new_config_name: str,
        parameters: typing.Dict[str, typing.Optional[typing.Any]],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AddVariantFromBaseAndConfigResponse:
        """
        Add a new variant based on an existing one.
        Same as POST /config

        Args:
            payload (AddVariantFromBasePayload): Payload containing base variant ID, new variant name, and parameters.
            stoken_session (SessionContainer, optional): Session container. Defaults to result of verify_session().

        Raises:
            HTTPException: Raised if the variant could not be added or accessed.

        Returns:
            Union[AppVariantResponse, Any]: New variant details or exception.

        Parameters
        ----------
        base_id : str

        new_variant_name : str

        new_config_name : str

        parameters : typing.Dict[str, typing.Optional[typing.Any]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AddVariantFromBaseAndConfigResponse
            Successful Response

        Examples
        --------
        import asyncio

        from agenta import AsyncAgentaApi

        client = AsyncAgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.variants.add_variant_from_base_and_config(
                base_id="base_id",
                new_variant_name="new_variant_name",
                new_config_name="new_config_name",
                parameters={"key": "value"},
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "variants/from-base",
            method="POST",
            json={
                "base_id": base_id,
                "new_variant_name": new_variant_name,
                "new_config_name": new_config_name,
                "parameters": parameters,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    AddVariantFromBaseAndConfigResponse,
                    parse_obj_as(
                        type_=AddVariantFromBaseAndConfigResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def get_variant(
        self,
        variant_id: str,
        *,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AppVariantResponse:
        """
        Parameters
        ----------
        variant_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AppVariantResponse
            Successful Response

        Examples
        --------
        import asyncio

        from agenta import AsyncAgentaApi

        client = AsyncAgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.variants.get_variant(
                variant_id="variant_id",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"variants/{jsonable_encoder(variant_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    AppVariantResponse,
                    parse_obj_as(
                        type_=AppVariantResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def start_variant(
        self,
        variant_id: str,
        *,
        action: VariantAction,
        env_vars: typing.Optional[DockerEnvVars] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Uri:
        """
        Start a variant of an app.

        Args:
            variant_id (str): The ID of the variant to start.
            action (VariantAction): The action to perform on the variant (start).
            env_vars (Optional[DockerEnvVars], optional): The environment variables to inject to the Docker container. Defaults to None.
            stoken_session (SessionContainer, optional): The session container. Defaults to Depends(verify_session()).

        Returns:
            URI: The URL of the started variant.

        Raises:
            HTTPException: If the app container cannot be started.

        Parameters
        ----------
        variant_id : str

        action : VariantAction

        env_vars : typing.Optional[DockerEnvVars]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Uri
            Successful Response

        Examples
        --------
        import asyncio

        from agenta import AsyncAgentaApi, VariantAction

        client = AsyncAgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.variants.start_variant(
                variant_id="variant_id",
                action=VariantAction(
                    action="START",
                ),
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"variants/{jsonable_encoder(variant_id)}",
            method="PUT",
            json={
                "action": convert_and_respect_annotation_metadata(
                    object_=action, annotation=VariantAction, direction="write"
                ),
                "env_vars": convert_and_respect_annotation_metadata(
                    object_=env_vars, annotation=DockerEnvVars, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    Uri,
                    parse_obj_as(
                        type_=Uri,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def remove_variant(
        self,
        variant_id: str,
        *,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Optional[typing.Any]:
        """
        Remove a variant from the server.
        In the case it's the last variant using the image, stop the container and remove the image.

        Arguments:



            app_variant -- AppVariant to remove

        Raises:



            HTTPException: If there is a problem removing the app variant

        Parameters
        ----------
        variant_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[typing.Any]
            Successful Response

        Examples
        --------
        import asyncio

        from agenta import AsyncAgentaApi

        client = AsyncAgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.variants.remove_variant(
                variant_id="variant_id",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"variants/{jsonable_encoder(variant_id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    typing.Optional[typing.Any],
                    parse_obj_as(
                        type_=typing.Optional[typing.Any],  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def update_variant_parameters(
        self,
        variant_id: str,
        *,
        parameters: typing.Dict[str, typing.Optional[typing.Any]],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Optional[typing.Any]:
        """
        Updates the parameters for an app variant.

        Args:
            variant_id (str): The ID of the app variant to update.
            payload (UpdateVariantParameterPayload): The payload containing the updated parameters.
            stoken_session (SessionContainer, optional): The session container. Defaults to Depends(verify_session()).

        Raises:
            HTTPException: If there is an error while trying to update the app variant.

        Returns:
            JSONResponse: A JSON response containing the updated app variant parameters.

        Parameters
        ----------
        variant_id : str

        parameters : typing.Dict[str, typing.Optional[typing.Any]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[typing.Any]
            Successful Response

        Examples
        --------
        import asyncio

        from agenta import AsyncAgentaApi

        client = AsyncAgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.variants.update_variant_parameters(
                variant_id="variant_id",
                parameters={"key": "value"},
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"variants/{jsonable_encoder(variant_id)}/parameters",
            method="PUT",
            json={
                "parameters": parameters,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    typing.Optional[typing.Any],
                    parse_obj_as(
                        type_=typing.Optional[typing.Any],  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def update_variant_image(
        self,
        variant_id: str,
        *,
        docker_id: str,
        tags: str,
        type: typing.Optional[str] = OMIT,
        organization_id: typing.Optional[str] = OMIT,
        workspace_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Optional[typing.Any]:
        """
        Updates the image used in an app variant.

        Args:
            variant_id (str): The ID of the app variant to update.
            image (Image): The image information to update.

        Raises:
            HTTPException: If an error occurs while trying to update the app variant.

        Returns:
            JSONResponse: A JSON response indicating whether the update was successful or not.

        Parameters
        ----------
        variant_id : str

        docker_id : str

        tags : str

        type : typing.Optional[str]

        organization_id : typing.Optional[str]

        workspace_id : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[typing.Any]
            Successful Response

        Examples
        --------
        import asyncio

        from agenta import AsyncAgentaApi

        client = AsyncAgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.variants.update_variant_image(
                variant_id="variant_id",
                docker_id="docker_id",
                tags="tags",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"variants/{jsonable_encoder(variant_id)}/image",
            method="PUT",
            json={
                "type": type,
                "docker_id": docker_id,
                "tags": tags,
                "organization_id": organization_id,
                "workspace_id": workspace_id,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    typing.Optional[typing.Any],
                    parse_obj_as(
                        type_=typing.Optional[typing.Any],  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def retrieve_variant_logs(
        self,
        variant_id: str,
        *,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Optional[typing.Any]:
        """
        Parameters
        ----------
        variant_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[typing.Any]
            Successful Response

        Examples
        --------
        import asyncio

        from agenta import AsyncAgentaApi

        client = AsyncAgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.variants.retrieve_variant_logs(
                variant_id="variant_id",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"variants/{jsonable_encoder(variant_id)}/logs",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    typing.Optional[typing.Any],
                    parse_obj_as(
                        type_=typing.Optional[typing.Any],  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def get_variant_revisions(
        self,
        variant_id: str,
        *,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[AppVariantRevision]:
        """
        Parameters
        ----------
        variant_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[AppVariantRevision]
            Successful Response

        Examples
        --------
        import asyncio

        from agenta import AsyncAgentaApi

        client = AsyncAgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.variants.get_variant_revisions(
                variant_id="variant_id",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"variants/{jsonable_encoder(variant_id)}/revisions",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    typing.List[AppVariantRevision],
                    parse_obj_as(
                        type_=typing.List[AppVariantRevision],  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def get_variant_revision(
        self,
        variant_id: str,
        revision_number: int,
        *,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AppVariantRevision:
        """
        Parameters
        ----------
        variant_id : str

        revision_number : int

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AppVariantRevision
            Successful Response

        Examples
        --------
        import asyncio

        from agenta import AsyncAgentaApi

        client = AsyncAgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.variants.get_variant_revision(
                variant_id="variant_id",
                revision_number=1,
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"variants/{jsonable_encoder(variant_id)}/revisions/{jsonable_encoder(revision_number)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    AppVariantRevision,
                    parse_obj_as(
                        type_=AppVariantRevision,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def configs_add(
        self,
        *,
        variant_ref: ReferenceRequestModel,
        application_ref: ReferenceRequestModel,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ConfigResponseModel:
        """
        Parameters
        ----------
        variant_ref : ReferenceRequestModel

        application_ref : ReferenceRequestModel

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ConfigResponseModel
            Successful Response

        Examples
        --------
        import asyncio

        from agenta import AsyncAgentaApi, ReferenceRequestModel

        client = AsyncAgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.variants.configs_add(
                variant_ref=ReferenceRequestModel(),
                application_ref=ReferenceRequestModel(),
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "variants/configs/add",
            method="POST",
            json={
                "variant_ref": convert_and_respect_annotation_metadata(
                    object_=variant_ref,
                    annotation=ReferenceRequestModel,
                    direction="write",
                ),
                "application_ref": convert_and_respect_annotation_metadata(
                    object_=application_ref,
                    annotation=ReferenceRequestModel,
                    direction="write",
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    ConfigResponseModel,
                    parse_obj_as(
                        type_=ConfigResponseModel,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def configs_fetch(
        self,
        *,
        variant_ref: typing.Optional[ReferenceRequestModel] = OMIT,
        environment_ref: typing.Optional[ReferenceRequestModel] = OMIT,
        application_ref: typing.Optional[ReferenceRequestModel] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ConfigResponseModel:
        """
        Parameters
        ----------
        variant_ref : typing.Optional[ReferenceRequestModel]

        environment_ref : typing.Optional[ReferenceRequestModel]

        application_ref : typing.Optional[ReferenceRequestModel]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ConfigResponseModel
            Successful Response

        Examples
        --------
        import asyncio

        from agenta import AsyncAgentaApi

        client = AsyncAgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.variants.configs_fetch()


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "variants/configs/fetch",
            method="POST",
            json={
                "variant_ref": convert_and_respect_annotation_metadata(
                    object_=variant_ref,
                    annotation=ReferenceRequestModel,
                    direction="write",
                ),
                "environment_ref": convert_and_respect_annotation_metadata(
                    object_=environment_ref,
                    annotation=ReferenceRequestModel,
                    direction="write",
                ),
                "application_ref": convert_and_respect_annotation_metadata(
                    object_=application_ref,
                    annotation=ReferenceRequestModel,
                    direction="write",
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    ConfigResponseModel,
                    parse_obj_as(
                        type_=ConfigResponseModel,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def configs_fork(
        self,
        *,
        variant_ref: typing.Optional[ReferenceRequestModel] = OMIT,
        environment_ref: typing.Optional[ReferenceRequestModel] = OMIT,
        application_ref: typing.Optional[ReferenceRequestModel] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ConfigResponseModel:
        """
        Parameters
        ----------
        variant_ref : typing.Optional[ReferenceRequestModel]

        environment_ref : typing.Optional[ReferenceRequestModel]

        application_ref : typing.Optional[ReferenceRequestModel]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ConfigResponseModel
            Successful Response

        Examples
        --------
        import asyncio

        from agenta import AsyncAgentaApi

        client = AsyncAgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.variants.configs_fork()


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "variants/configs/fork",
            method="POST",
            json={
                "variant_ref": convert_and_respect_annotation_metadata(
                    object_=variant_ref,
                    annotation=ReferenceRequestModel,
                    direction="write",
                ),
                "environment_ref": convert_and_respect_annotation_metadata(
                    object_=environment_ref,
                    annotation=ReferenceRequestModel,
                    direction="write",
                ),
                "application_ref": convert_and_respect_annotation_metadata(
                    object_=application_ref,
                    annotation=ReferenceRequestModel,
                    direction="write",
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    ConfigResponseModel,
                    parse_obj_as(
                        type_=ConfigResponseModel,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def configs_commit(
        self,
        *,
        config: ConfigDto,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ConfigResponseModel:
        """
        Parameters
        ----------
        config : ConfigDto

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ConfigResponseModel
            Successful Response

        Examples
        --------
        import asyncio

        from agenta import AsyncAgentaApi, ConfigDto

        client = AsyncAgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.variants.configs_commit(
                config=ConfigDto(
                    params={"key": "value"},
                ),
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "variants/configs/commit",
            method="POST",
            json={
                "config": convert_and_respect_annotation_metadata(
                    object_=config, annotation=ConfigDto, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    ConfigResponseModel,
                    parse_obj_as(
                        type_=ConfigResponseModel,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def configs_deploy(
        self,
        *,
        variant_ref: ReferenceRequestModel,
        environment_ref: ReferenceRequestModel,
        application_ref: typing.Optional[ReferenceRequestModel] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ConfigResponseModel:
        """
        Parameters
        ----------
        variant_ref : ReferenceRequestModel

        environment_ref : ReferenceRequestModel

        application_ref : typing.Optional[ReferenceRequestModel]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ConfigResponseModel
            Successful Response

        Examples
        --------
        import asyncio

        from agenta import AsyncAgentaApi, ReferenceRequestModel

        client = AsyncAgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.variants.configs_deploy(
                variant_ref=ReferenceRequestModel(),
                environment_ref=ReferenceRequestModel(),
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "variants/configs/deploy",
            method="POST",
            json={
                "variant_ref": convert_and_respect_annotation_metadata(
                    object_=variant_ref,
                    annotation=ReferenceRequestModel,
                    direction="write",
                ),
                "environment_ref": convert_and_respect_annotation_metadata(
                    object_=environment_ref,
                    annotation=ReferenceRequestModel,
                    direction="write",
                ),
                "application_ref": convert_and_respect_annotation_metadata(
                    object_=application_ref,
                    annotation=ReferenceRequestModel,
                    direction="write",
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    ConfigResponseModel,
                    parse_obj_as(
                        type_=ConfigResponseModel,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def configs_delete(
        self,
        *,
        variant_ref: ReferenceRequestModel,
        application_ref: typing.Optional[ReferenceRequestModel] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> int:
        """
        Parameters
        ----------
        variant_ref : ReferenceRequestModel

        application_ref : typing.Optional[ReferenceRequestModel]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        int
            Successful Response

        Examples
        --------
        import asyncio

        from agenta import AsyncAgentaApi, ReferenceRequestModel

        client = AsyncAgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.variants.configs_delete(
                variant_ref=ReferenceRequestModel(),
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "variants/configs/delete",
            method="POST",
            json={
                "variant_ref": convert_and_respect_annotation_metadata(
                    object_=variant_ref,
                    annotation=ReferenceRequestModel,
                    direction="write",
                ),
                "application_ref": convert_and_respect_annotation_metadata(
                    object_=application_ref,
                    annotation=ReferenceRequestModel,
                    direction="write",
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    int,
                    parse_obj_as(
                        type_=int,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def configs_list(
        self,
        *,
        application_ref: ReferenceDto,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[ConfigResponseModel]:
        """
        Parameters
        ----------
        application_ref : ReferenceDto

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[ConfigResponseModel]
            Successful Response

        Examples
        --------
        import asyncio

        from agenta import AsyncAgentaApi, ReferenceDto

        client = AsyncAgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.variants.configs_list(
                application_ref=ReferenceDto(),
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "variants/configs/list",
            method="POST",
            json={
                "application_ref": convert_and_respect_annotation_metadata(
                    object_=application_ref, annotation=ReferenceDto, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    typing.List[ConfigResponseModel],
                    parse_obj_as(
                        type_=typing.List[ConfigResponseModel],  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def configs_history(
        self,
        *,
        variant_ref: ReferenceRequestModel,
        application_ref: typing.Optional[ReferenceRequestModel] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[ConfigResponseModel]:
        """
        Parameters
        ----------
        variant_ref : ReferenceRequestModel

        application_ref : typing.Optional[ReferenceRequestModel]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[ConfigResponseModel]
            Successful Response

        Examples
        --------
        import asyncio

        from agenta import AsyncAgentaApi, ReferenceRequestModel

        client = AsyncAgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.variants.configs_history(
                variant_ref=ReferenceRequestModel(),
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "variants/configs/history",
            method="POST",
            json={
                "variant_ref": convert_and_respect_annotation_metadata(
                    object_=variant_ref,
                    annotation=ReferenceRequestModel,
                    direction="write",
                ),
                "application_ref": convert_and_respect_annotation_metadata(
                    object_=application_ref,
                    annotation=ReferenceRequestModel,
                    direction="write",
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    typing.List[ConfigResponseModel],
                    parse_obj_as(
                        type_=typing.List[ConfigResponseModel],  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)
