# This file was auto-generated by Fern from our API Definition.

import typing
from ..core.client_wrapper import SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.evaluator import Evaluator
from ..core.pydantic_utilities import parse_obj_as
from json.decoder import JSONDecodeError
from ..core.api_error import ApiError
from ..types.evaluator_mapping_output_interface import EvaluatorMappingOutputInterface
from ..errors.unprocessable_entity_error import UnprocessableEntityError
from ..types.http_validation_error import HttpValidationError
from ..types.evaluator_output_interface import EvaluatorOutputInterface
from ..core.jsonable_encoder import jsonable_encoder
from ..types.evaluator_config import EvaluatorConfig
from ..core.client_wrapper import AsyncClientWrapper

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class EvaluatorsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def get_evaluators_endpoint(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[Evaluator]:
        """
        Endpoint to fetch a list of evaluators.

        Returns:
            List[Evaluator]: A list of evaluator objects.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[Evaluator]
            Successful Response

        Examples
        --------
        from agenta import AgentaApi

        client = AgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.evaluators.get_evaluators_endpoint()
        """
        _response = self._client_wrapper.httpx_client.request(
            "evaluators",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    typing.List[Evaluator],
                    parse_obj_as(
                        type_=typing.List[Evaluator],  # type: ignore
                        object_=_response.json(),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def evaluator_data_map(
        self,
        *,
        inputs: typing.Dict[str, typing.Optional[typing.Any]],
        mapping: typing.Dict[str, typing.Optional[typing.Any]],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> EvaluatorMappingOutputInterface:
        """
        Endpoint to map the experiment data tree to evaluator interface.

        Args:
            request (Request): The request object.
            payload (EvaluatorMappingInputInterface): The payload containing the request data.

        Returns:
            EvaluatorMappingOutputInterface: the evaluator mapping output object

        Parameters
        ----------
        inputs : typing.Dict[str, typing.Optional[typing.Any]]

        mapping : typing.Dict[str, typing.Optional[typing.Any]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EvaluatorMappingOutputInterface
            Successful Response

        Examples
        --------
        from agenta import AgentaApi

        client = AgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.evaluators.evaluator_data_map(
            inputs={"key": "value"},
            mapping={"key": "value"},
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "evaluators/map",
            method="POST",
            json={
                "inputs": inputs,
                "mapping": mapping,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    EvaluatorMappingOutputInterface,
                    parse_obj_as(
                        type_=EvaluatorMappingOutputInterface,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def evaluator_run(
        self,
        evaluator_key: str,
        *,
        inputs: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        settings: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        credentials: typing.Optional[
            typing.Dict[str, typing.Optional[typing.Any]]
        ] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> EvaluatorOutputInterface:
        """
        Endpoint to evaluate LLM app run

        Args:
            request (Request): The request object.
            evaluator_key (str): The key of the evaluator.
            payload (EvaluatorInputInterface): The payload containing the request data.

        Returns:
            result: EvaluatorOutputInterface object containing the outputs.

        Parameters
        ----------
        evaluator_key : str

        inputs : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]

        settings : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]

        credentials : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EvaluatorOutputInterface
            Successful Response

        Examples
        --------
        from agenta import AgentaApi

        client = AgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.evaluators.evaluator_run(
            evaluator_key="evaluator_key",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"evaluators/{jsonable_encoder(evaluator_key)}/run",
            method="POST",
            json={
                "inputs": inputs,
                "settings": settings,
                "credentials": credentials,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    EvaluatorOutputInterface,
                    parse_obj_as(
                        type_=EvaluatorOutputInterface,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def get_evaluator_configs(
        self, *, app_id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[EvaluatorConfig]:
        """
        Endpoint to fetch evaluator configurations for a specific app.

        Args:
            app_id (str): The ID of the app.

        Returns:
            List[EvaluatorConfigDB]: A list of evaluator configuration objects.

        Parameters
        ----------
        app_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[EvaluatorConfig]
            Successful Response

        Examples
        --------
        from agenta import AgentaApi

        client = AgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.evaluators.get_evaluator_configs(
            app_id="app_id",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "evaluators/configs",
            method="GET",
            params={
                "app_id": app_id,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    typing.List[EvaluatorConfig],
                    parse_obj_as(
                        type_=typing.List[EvaluatorConfig],  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def create_new_evaluator_config(
        self,
        *,
        app_id: str,
        name: str,
        evaluator_key: str,
        settings_values: typing.Dict[str, typing.Optional[typing.Any]],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> EvaluatorConfig:
        """
        Endpoint to fetch evaluator configurations for a specific app.

        Args:
            app_id (str): The ID of the app.

        Returns:
            EvaluatorConfigDB: Evaluator configuration api model.

        Parameters
        ----------
        app_id : str

        name : str

        evaluator_key : str

        settings_values : typing.Dict[str, typing.Optional[typing.Any]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EvaluatorConfig
            Successful Response

        Examples
        --------
        from agenta import AgentaApi

        client = AgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.evaluators.create_new_evaluator_config(
            app_id="app_id",
            name="name",
            evaluator_key="evaluator_key",
            settings_values={"key": "value"},
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "evaluators/configs",
            method="POST",
            json={
                "app_id": app_id,
                "name": name,
                "evaluator_key": evaluator_key,
                "settings_values": settings_values,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    EvaluatorConfig,
                    parse_obj_as(
                        type_=EvaluatorConfig,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def get_evaluator_config(
        self,
        evaluator_config_id: str,
        *,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> EvaluatorConfig:
        """
        Endpoint to fetch evaluator configurations for a specific app.

        Returns:
            List[EvaluatorConfigDB]: A list of evaluator configuration objects.

        Parameters
        ----------
        evaluator_config_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EvaluatorConfig
            Successful Response

        Examples
        --------
        from agenta import AgentaApi

        client = AgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.evaluators.get_evaluator_config(
            evaluator_config_id="evaluator_config_id",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"evaluators/configs/{jsonable_encoder(evaluator_config_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    EvaluatorConfig,
                    parse_obj_as(
                        type_=EvaluatorConfig,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def update_evaluator_config(
        self,
        evaluator_config_id: str,
        *,
        name: typing.Optional[str] = OMIT,
        evaluator_key: typing.Optional[str] = OMIT,
        settings_values: typing.Optional[
            typing.Dict[str, typing.Optional[typing.Any]]
        ] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> EvaluatorConfig:
        """
        Endpoint to update evaluator configurations for a specific app.

        Returns:
            List[EvaluatorConfigDB]: A list of evaluator configuration objects.

        Parameters
        ----------
        evaluator_config_id : str

        name : typing.Optional[str]

        evaluator_key : typing.Optional[str]

        settings_values : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EvaluatorConfig
            Successful Response

        Examples
        --------
        from agenta import AgentaApi

        client = AgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.evaluators.update_evaluator_config(
            evaluator_config_id="evaluator_config_id",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"evaluators/configs/{jsonable_encoder(evaluator_config_id)}",
            method="PUT",
            json={
                "name": name,
                "evaluator_key": evaluator_key,
                "settings_values": settings_values,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    EvaluatorConfig,
                    parse_obj_as(
                        type_=EvaluatorConfig,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def delete_evaluator_config(
        self,
        evaluator_config_id: str,
        *,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> bool:
        """
        Endpoint to delete a specific evaluator configuration.

        Args:
            evaluator_config_id (str): The unique identifier of the evaluator configuration.

        Returns:
            bool: True if deletion was successful, False otherwise.

        Parameters
        ----------
        evaluator_config_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        bool
            Successful Response

        Examples
        --------
        from agenta import AgentaApi

        client = AgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.evaluators.delete_evaluator_config(
            evaluator_config_id="evaluator_config_id",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"evaluators/configs/{jsonable_encoder(evaluator_config_id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    bool,
                    parse_obj_as(
                        type_=bool,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)


class AsyncEvaluatorsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def get_evaluators_endpoint(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[Evaluator]:
        """
        Endpoint to fetch a list of evaluators.

        Returns:
            List[Evaluator]: A list of evaluator objects.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[Evaluator]
            Successful Response

        Examples
        --------
        import asyncio

        from agenta import AsyncAgentaApi

        client = AsyncAgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.evaluators.get_evaluators_endpoint()


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "evaluators",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    typing.List[Evaluator],
                    parse_obj_as(
                        type_=typing.List[Evaluator],  # type: ignore
                        object_=_response.json(),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def evaluator_data_map(
        self,
        *,
        inputs: typing.Dict[str, typing.Optional[typing.Any]],
        mapping: typing.Dict[str, typing.Optional[typing.Any]],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> EvaluatorMappingOutputInterface:
        """
        Endpoint to map the experiment data tree to evaluator interface.

        Args:
            request (Request): The request object.
            payload (EvaluatorMappingInputInterface): The payload containing the request data.

        Returns:
            EvaluatorMappingOutputInterface: the evaluator mapping output object

        Parameters
        ----------
        inputs : typing.Dict[str, typing.Optional[typing.Any]]

        mapping : typing.Dict[str, typing.Optional[typing.Any]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EvaluatorMappingOutputInterface
            Successful Response

        Examples
        --------
        import asyncio

        from agenta import AsyncAgentaApi

        client = AsyncAgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.evaluators.evaluator_data_map(
                inputs={"key": "value"},
                mapping={"key": "value"},
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "evaluators/map",
            method="POST",
            json={
                "inputs": inputs,
                "mapping": mapping,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    EvaluatorMappingOutputInterface,
                    parse_obj_as(
                        type_=EvaluatorMappingOutputInterface,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def evaluator_run(
        self,
        evaluator_key: str,
        *,
        inputs: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        settings: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        credentials: typing.Optional[
            typing.Dict[str, typing.Optional[typing.Any]]
        ] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> EvaluatorOutputInterface:
        """
        Endpoint to evaluate LLM app run

        Args:
            request (Request): The request object.
            evaluator_key (str): The key of the evaluator.
            payload (EvaluatorInputInterface): The payload containing the request data.

        Returns:
            result: EvaluatorOutputInterface object containing the outputs.

        Parameters
        ----------
        evaluator_key : str

        inputs : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]

        settings : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]

        credentials : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EvaluatorOutputInterface
            Successful Response

        Examples
        --------
        import asyncio

        from agenta import AsyncAgentaApi

        client = AsyncAgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.evaluators.evaluator_run(
                evaluator_key="evaluator_key",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"evaluators/{jsonable_encoder(evaluator_key)}/run",
            method="POST",
            json={
                "inputs": inputs,
                "settings": settings,
                "credentials": credentials,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    EvaluatorOutputInterface,
                    parse_obj_as(
                        type_=EvaluatorOutputInterface,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def get_evaluator_configs(
        self, *, app_id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[EvaluatorConfig]:
        """
        Endpoint to fetch evaluator configurations for a specific app.

        Args:
            app_id (str): The ID of the app.

        Returns:
            List[EvaluatorConfigDB]: A list of evaluator configuration objects.

        Parameters
        ----------
        app_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[EvaluatorConfig]
            Successful Response

        Examples
        --------
        import asyncio

        from agenta import AsyncAgentaApi

        client = AsyncAgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.evaluators.get_evaluator_configs(
                app_id="app_id",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "evaluators/configs",
            method="GET",
            params={
                "app_id": app_id,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    typing.List[EvaluatorConfig],
                    parse_obj_as(
                        type_=typing.List[EvaluatorConfig],  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def create_new_evaluator_config(
        self,
        *,
        app_id: str,
        name: str,
        evaluator_key: str,
        settings_values: typing.Dict[str, typing.Optional[typing.Any]],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> EvaluatorConfig:
        """
        Endpoint to fetch evaluator configurations for a specific app.

        Args:
            app_id (str): The ID of the app.

        Returns:
            EvaluatorConfigDB: Evaluator configuration api model.

        Parameters
        ----------
        app_id : str

        name : str

        evaluator_key : str

        settings_values : typing.Dict[str, typing.Optional[typing.Any]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EvaluatorConfig
            Successful Response

        Examples
        --------
        import asyncio

        from agenta import AsyncAgentaApi

        client = AsyncAgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.evaluators.create_new_evaluator_config(
                app_id="app_id",
                name="name",
                evaluator_key="evaluator_key",
                settings_values={"key": "value"},
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "evaluators/configs",
            method="POST",
            json={
                "app_id": app_id,
                "name": name,
                "evaluator_key": evaluator_key,
                "settings_values": settings_values,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    EvaluatorConfig,
                    parse_obj_as(
                        type_=EvaluatorConfig,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def get_evaluator_config(
        self,
        evaluator_config_id: str,
        *,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> EvaluatorConfig:
        """
        Endpoint to fetch evaluator configurations for a specific app.

        Returns:
            List[EvaluatorConfigDB]: A list of evaluator configuration objects.

        Parameters
        ----------
        evaluator_config_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EvaluatorConfig
            Successful Response

        Examples
        --------
        import asyncio

        from agenta import AsyncAgentaApi

        client = AsyncAgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.evaluators.get_evaluator_config(
                evaluator_config_id="evaluator_config_id",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"evaluators/configs/{jsonable_encoder(evaluator_config_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    EvaluatorConfig,
                    parse_obj_as(
                        type_=EvaluatorConfig,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def update_evaluator_config(
        self,
        evaluator_config_id: str,
        *,
        name: typing.Optional[str] = OMIT,
        evaluator_key: typing.Optional[str] = OMIT,
        settings_values: typing.Optional[
            typing.Dict[str, typing.Optional[typing.Any]]
        ] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> EvaluatorConfig:
        """
        Endpoint to update evaluator configurations for a specific app.

        Returns:
            List[EvaluatorConfigDB]: A list of evaluator configuration objects.

        Parameters
        ----------
        evaluator_config_id : str

        name : typing.Optional[str]

        evaluator_key : typing.Optional[str]

        settings_values : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EvaluatorConfig
            Successful Response

        Examples
        --------
        import asyncio

        from agenta import AsyncAgentaApi

        client = AsyncAgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.evaluators.update_evaluator_config(
                evaluator_config_id="evaluator_config_id",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"evaluators/configs/{jsonable_encoder(evaluator_config_id)}",
            method="PUT",
            json={
                "name": name,
                "evaluator_key": evaluator_key,
                "settings_values": settings_values,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    EvaluatorConfig,
                    parse_obj_as(
                        type_=EvaluatorConfig,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def delete_evaluator_config(
        self,
        evaluator_config_id: str,
        *,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> bool:
        """
        Endpoint to delete a specific evaluator configuration.

        Args:
            evaluator_config_id (str): The unique identifier of the evaluator configuration.

        Returns:
            bool: True if deletion was successful, False otherwise.

        Parameters
        ----------
        evaluator_config_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        bool
            Successful Response

        Examples
        --------
        import asyncio

        from agenta import AsyncAgentaApi

        client = AsyncAgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.evaluators.delete_evaluator_config(
                evaluator_config_id="evaluator_config_id",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"evaluators/configs/{jsonable_encoder(evaluator_config_id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    bool,
                    parse_obj_as(
                        type_=bool,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)
