# This file was auto-generated by Fern from our API Definition.

import typing
from ..core.client_wrapper import SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.app_variant_response import AppVariantResponse
from ..core.jsonable_encoder import jsonable_encoder
from ..core.pydantic_utilities import parse_obj_as
from ..errors.unprocessable_entity_error import UnprocessableEntityError
from ..types.http_validation_error import HttpValidationError
from json.decoder import JSONDecodeError
from ..core.api_error import ApiError
from ..types.app import App
from ..types.create_app_output import CreateAppOutput
from ..types.update_app_output import UpdateAppOutput
from ..types.environment_output import EnvironmentOutput
from ..types.environment_output_extended import EnvironmentOutputExtended
from ..core.client_wrapper import AsyncClientWrapper

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class AppsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def list_app_variants(
        self, app_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[AppVariantResponse]:
        """
        Retrieve a list of app variants for a given app ID.

        Args:
            app_id (str): The ID of the app to retrieve variants for.
            stoken_session (SessionContainer, optional): The session container to verify the user's session. Defaults to Depends(verify_session()).

        Returns:
            List[AppVariantResponse]: A list of app variants for the given app ID.

        Parameters
        ----------
        app_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[AppVariantResponse]
            Successful Response

        Examples
        --------
        from agenta import AgentaApi

        client = AgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.apps.list_app_variants(
            app_id="app_id",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"apps/{jsonable_encoder(app_id)}/variants",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    typing.List[AppVariantResponse],
                    parse_obj_as(
                        type_=typing.List[AppVariantResponse],  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def get_variant_by_env(
        self,
        *,
        app_id: str,
        environment: str,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AppVariantResponse:
        """
        Retrieve the app variant based on the provided app_id and environment.

        Args:
            app_id (str): The ID of the app to retrieve the variant for.
            environment (str): The environment of the app variant to retrieve.
            stoken_session (SessionContainer, optional): The session token container. Defaults to Depends(verify_session()).

        Raises:
            HTTPException: If the app variant is not found (status_code=500), or if a ValueError is raised (status_code=400), or if any other exception is raised (status_code=500).

        Returns:
            AppVariantResponse: The retrieved app variant.

        Parameters
        ----------
        app_id : str

        environment : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AppVariantResponse
            Successful Response

        Examples
        --------
        from agenta import AgentaApi

        client = AgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.apps.get_variant_by_env(
            app_id="app_id",
            environment="environment",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "apps/get_variant_by_env",
            method="GET",
            params={
                "app_id": app_id,
                "environment": environment,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    AppVariantResponse,
                    parse_obj_as(
                        type_=AppVariantResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def list_apps(
        self,
        *,
        app_name: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[App]:
        """
        Retrieve a list of apps filtered by app_name.

        Args:
            app_name (Optional[str]): The name of the app to filter by.
            stoken_session (SessionContainer): The session container.

        Returns:
            List[App]: A list of apps filtered by app_name.

        Raises:
            HTTPException: If there was an error retrieving the list of apps.

        Parameters
        ----------
        app_name : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[App]
            Successful Response

        Examples
        --------
        from agenta import AgentaApi

        client = AgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.apps.list_apps()
        """
        _response = self._client_wrapper.httpx_client.request(
            "apps",
            method="GET",
            params={
                "app_name": app_name,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    typing.List[App],
                    parse_obj_as(
                        type_=typing.List[App],  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def create_app(
        self,
        *,
        app_name: str,
        project_id: typing.Optional[str] = OMIT,
        workspace_id: typing.Optional[str] = OMIT,
        organization_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreateAppOutput:
        """
        Create a new app for a user or organization.

        Args:
            payload (CreateApp): The payload containing the app name and organization ID (optional).
            stoken_session (SessionContainer): The session container containing the user's session token.

        Returns:
            CreateAppOutput: The output containing the newly created app's ID and name.

        Raises:
            HTTPException: If there is an error creating the app or the user does not have permission to access the app.

        Parameters
        ----------
        app_name : str

        project_id : typing.Optional[str]

        workspace_id : typing.Optional[str]

        organization_id : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateAppOutput
            Successful Response

        Examples
        --------
        from agenta import AgentaApi

        client = AgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.apps.create_app(
            app_name="app_name",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "apps",
            method="POST",
            json={
                "app_name": app_name,
                "project_id": project_id,
                "workspace_id": workspace_id,
                "organization_id": organization_id,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    CreateAppOutput,
                    parse_obj_as(
                        type_=CreateAppOutput,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def remove_app(
        self, app_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.Optional[typing.Any]:
        """
        Remove app, all its variant, containers and images

        Arguments:
            app -- App to remove

        Parameters
        ----------
        app_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[typing.Any]
            Successful Response

        Examples
        --------
        from agenta import AgentaApi

        client = AgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.apps.remove_app(
            app_id="app_id",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"apps/{jsonable_encoder(app_id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    typing.Optional[typing.Any],
                    parse_obj_as(
                        type_=typing.Optional[typing.Any],  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def update_app(
        self,
        app_id: str,
        *,
        app_name: str,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UpdateAppOutput:
        """
        Update an app for a user or organization.

        Args:
            app_id (str): The ID of the app.
            payload (UpdateApp): The payload containing the app name.
            stoken_session (SessionContainer): The session container containing the user's session token.

        Returns:
            UpdateAppOuput: The output containing the newly created app's ID and name.

        Raises:
            HTTPException: If there is an error creating the app or the user does not have permission to access the app.

        Parameters
        ----------
        app_id : str

        app_name : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UpdateAppOutput
            Successful Response

        Examples
        --------
        from agenta import AgentaApi

        client = AgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.apps.update_app(
            app_id="app_id",
            app_name="app_name",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"apps/{jsonable_encoder(app_id)}",
            method="PATCH",
            json={
                "app_name": app_name,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    UpdateAppOutput,
                    parse_obj_as(
                        type_=UpdateAppOutput,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def add_variant_from_image(
        self,
        app_id: str,
        *,
        variant_name: str,
        docker_id: str,
        tags: str,
        base_name: typing.Optional[str] = OMIT,
        config_name: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Optional[typing.Any]:
        """
        Add a new variant to an app based on a Docker image.

        Args:
            app_id (str): The ID of the app to add the variant to.
            payload (AddVariantFromImagePayload): The payload containing information about the variant to add.
            stoken_session (SessionContainer, optional): The session container. Defaults to Depends(verify_session()).

        Raises:
            HTTPException: If the feature flag is set to "demo" or if the image does not have a tag starting with the registry name (agenta-server) or if the image is not found or if the user does not have access to the app.

        Returns:
            dict: The newly added variant.

        Parameters
        ----------
        app_id : str

        variant_name : str

        docker_id : str

        tags : str

        base_name : typing.Optional[str]

        config_name : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[typing.Any]
            Successful Response

        Examples
        --------
        from agenta import AgentaApi

        client = AgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.apps.add_variant_from_image(
            app_id="app_id",
            variant_name="variant_name",
            docker_id="docker_id",
            tags="tags",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"apps/{jsonable_encoder(app_id)}/variant/from-image",
            method="POST",
            json={
                "variant_name": variant_name,
                "docker_id": docker_id,
                "tags": tags,
                "base_name": base_name,
                "config_name": config_name,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    typing.Optional[typing.Any],
                    parse_obj_as(
                        type_=typing.Optional[typing.Any],  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def create_app_and_variant_from_template(
        self,
        *,
        app_name: str,
        template_id: str,
        env_vars: typing.Dict[str, str],
        project_id: typing.Optional[str] = OMIT,
        workspace_id: typing.Optional[str] = OMIT,
        organization_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AppVariantResponse:
        """
        Create an app and variant from a template.

        Args:
            payload (CreateAppVariant): The payload containing the app and variant information.
            stoken_session (SessionContainer, optional): The session container. Defaults to Depends(verify_session()).

        Raises:
            HTTPException: If the user has reached the app limit or if an app with the same name already exists.

        Returns:
            AppVariantResponse: The output of the created app variant.

        Parameters
        ----------
        app_name : str

        template_id : str

        env_vars : typing.Dict[str, str]

        project_id : typing.Optional[str]

        workspace_id : typing.Optional[str]

        organization_id : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AppVariantResponse
            Successful Response

        Examples
        --------
        from agenta import AgentaApi

        client = AgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.apps.create_app_and_variant_from_template(
            app_name="app_name",
            template_id="template_id",
            env_vars={"key": "value"},
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "apps/app_and_variant_from_template",
            method="POST",
            json={
                "app_name": app_name,
                "template_id": template_id,
                "project_id": project_id,
                "workspace_id": workspace_id,
                "env_vars": env_vars,
                "organization_id": organization_id,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    AppVariantResponse,
                    parse_obj_as(
                        type_=AppVariantResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def list_environments(
        self, app_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[EnvironmentOutput]:
        """
        Retrieve a list of environments for a given app ID.

        Args:
            app_id (str): The ID of the app to retrieve environments for.
            stoken_session (SessionContainer, optional): The session container. Defaults to Depends(verify_session()).

        Returns:
            List[EnvironmentOutput]: A list of environment objects.

        Parameters
        ----------
        app_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[EnvironmentOutput]
            Successful Response

        Examples
        --------
        from agenta import AgentaApi

        client = AgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.apps.list_environments(
            app_id="app_id",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"apps/{jsonable_encoder(app_id)}/environments",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    typing.List[EnvironmentOutput],
                    parse_obj_as(
                        type_=typing.List[EnvironmentOutput],  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def environment_revisions(
        self,
        app_id: str,
        environment_name: typing.Optional[typing.Any],
        *,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> EnvironmentOutputExtended:
        """
        Parameters
        ----------
        app_id : str

        environment_name : typing.Optional[typing.Any]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EnvironmentOutputExtended
            Successful Response

        Examples
        --------
        from agenta import AgentaApi

        client = AgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.apps.environment_revisions(
            app_id="app_id",
            environment_name={"key": "value"},
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"apps/{jsonable_encoder(app_id)}/revisions/{jsonable_encoder(environment_name)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    EnvironmentOutputExtended,
                    parse_obj_as(
                        type_=EnvironmentOutputExtended,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)


class AsyncAppsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def list_app_variants(
        self, app_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[AppVariantResponse]:
        """
        Retrieve a list of app variants for a given app ID.

        Args:
            app_id (str): The ID of the app to retrieve variants for.
            stoken_session (SessionContainer, optional): The session container to verify the user's session. Defaults to Depends(verify_session()).

        Returns:
            List[AppVariantResponse]: A list of app variants for the given app ID.

        Parameters
        ----------
        app_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[AppVariantResponse]
            Successful Response

        Examples
        --------
        import asyncio

        from agenta import AsyncAgentaApi

        client = AsyncAgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.apps.list_app_variants(
                app_id="app_id",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"apps/{jsonable_encoder(app_id)}/variants",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    typing.List[AppVariantResponse],
                    parse_obj_as(
                        type_=typing.List[AppVariantResponse],  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def get_variant_by_env(
        self,
        *,
        app_id: str,
        environment: str,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AppVariantResponse:
        """
        Retrieve the app variant based on the provided app_id and environment.

        Args:
            app_id (str): The ID of the app to retrieve the variant for.
            environment (str): The environment of the app variant to retrieve.
            stoken_session (SessionContainer, optional): The session token container. Defaults to Depends(verify_session()).

        Raises:
            HTTPException: If the app variant is not found (status_code=500), or if a ValueError is raised (status_code=400), or if any other exception is raised (status_code=500).

        Returns:
            AppVariantResponse: The retrieved app variant.

        Parameters
        ----------
        app_id : str

        environment : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AppVariantResponse
            Successful Response

        Examples
        --------
        import asyncio

        from agenta import AsyncAgentaApi

        client = AsyncAgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.apps.get_variant_by_env(
                app_id="app_id",
                environment="environment",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "apps/get_variant_by_env",
            method="GET",
            params={
                "app_id": app_id,
                "environment": environment,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    AppVariantResponse,
                    parse_obj_as(
                        type_=AppVariantResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def list_apps(
        self,
        *,
        app_name: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[App]:
        """
        Retrieve a list of apps filtered by app_name.

        Args:
            app_name (Optional[str]): The name of the app to filter by.
            stoken_session (SessionContainer): The session container.

        Returns:
            List[App]: A list of apps filtered by app_name.

        Raises:
            HTTPException: If there was an error retrieving the list of apps.

        Parameters
        ----------
        app_name : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[App]
            Successful Response

        Examples
        --------
        import asyncio

        from agenta import AsyncAgentaApi

        client = AsyncAgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.apps.list_apps()


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "apps",
            method="GET",
            params={
                "app_name": app_name,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    typing.List[App],
                    parse_obj_as(
                        type_=typing.List[App],  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def create_app(
        self,
        *,
        app_name: str,
        project_id: typing.Optional[str] = OMIT,
        workspace_id: typing.Optional[str] = OMIT,
        organization_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreateAppOutput:
        """
        Create a new app for a user or organization.

        Args:
            payload (CreateApp): The payload containing the app name and organization ID (optional).
            stoken_session (SessionContainer): The session container containing the user's session token.

        Returns:
            CreateAppOutput: The output containing the newly created app's ID and name.

        Raises:
            HTTPException: If there is an error creating the app or the user does not have permission to access the app.

        Parameters
        ----------
        app_name : str

        project_id : typing.Optional[str]

        workspace_id : typing.Optional[str]

        organization_id : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateAppOutput
            Successful Response

        Examples
        --------
        import asyncio

        from agenta import AsyncAgentaApi

        client = AsyncAgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.apps.create_app(
                app_name="app_name",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "apps",
            method="POST",
            json={
                "app_name": app_name,
                "project_id": project_id,
                "workspace_id": workspace_id,
                "organization_id": organization_id,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    CreateAppOutput,
                    parse_obj_as(
                        type_=CreateAppOutput,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def remove_app(
        self, app_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.Optional[typing.Any]:
        """
        Remove app, all its variant, containers and images

        Arguments:
            app -- App to remove

        Parameters
        ----------
        app_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[typing.Any]
            Successful Response

        Examples
        --------
        import asyncio

        from agenta import AsyncAgentaApi

        client = AsyncAgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.apps.remove_app(
                app_id="app_id",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"apps/{jsonable_encoder(app_id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    typing.Optional[typing.Any],
                    parse_obj_as(
                        type_=typing.Optional[typing.Any],  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def update_app(
        self,
        app_id: str,
        *,
        app_name: str,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UpdateAppOutput:
        """
        Update an app for a user or organization.

        Args:
            app_id (str): The ID of the app.
            payload (UpdateApp): The payload containing the app name.
            stoken_session (SessionContainer): The session container containing the user's session token.

        Returns:
            UpdateAppOuput: The output containing the newly created app's ID and name.

        Raises:
            HTTPException: If there is an error creating the app or the user does not have permission to access the app.

        Parameters
        ----------
        app_id : str

        app_name : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UpdateAppOutput
            Successful Response

        Examples
        --------
        import asyncio

        from agenta import AsyncAgentaApi

        client = AsyncAgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.apps.update_app(
                app_id="app_id",
                app_name="app_name",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"apps/{jsonable_encoder(app_id)}",
            method="PATCH",
            json={
                "app_name": app_name,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    UpdateAppOutput,
                    parse_obj_as(
                        type_=UpdateAppOutput,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def add_variant_from_image(
        self,
        app_id: str,
        *,
        variant_name: str,
        docker_id: str,
        tags: str,
        base_name: typing.Optional[str] = OMIT,
        config_name: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Optional[typing.Any]:
        """
        Add a new variant to an app based on a Docker image.

        Args:
            app_id (str): The ID of the app to add the variant to.
            payload (AddVariantFromImagePayload): The payload containing information about the variant to add.
            stoken_session (SessionContainer, optional): The session container. Defaults to Depends(verify_session()).

        Raises:
            HTTPException: If the feature flag is set to "demo" or if the image does not have a tag starting with the registry name (agenta-server) or if the image is not found or if the user does not have access to the app.

        Returns:
            dict: The newly added variant.

        Parameters
        ----------
        app_id : str

        variant_name : str

        docker_id : str

        tags : str

        base_name : typing.Optional[str]

        config_name : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[typing.Any]
            Successful Response

        Examples
        --------
        import asyncio

        from agenta import AsyncAgentaApi

        client = AsyncAgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.apps.add_variant_from_image(
                app_id="app_id",
                variant_name="variant_name",
                docker_id="docker_id",
                tags="tags",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"apps/{jsonable_encoder(app_id)}/variant/from-image",
            method="POST",
            json={
                "variant_name": variant_name,
                "docker_id": docker_id,
                "tags": tags,
                "base_name": base_name,
                "config_name": config_name,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    typing.Optional[typing.Any],
                    parse_obj_as(
                        type_=typing.Optional[typing.Any],  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def create_app_and_variant_from_template(
        self,
        *,
        app_name: str,
        template_id: str,
        env_vars: typing.Dict[str, str],
        project_id: typing.Optional[str] = OMIT,
        workspace_id: typing.Optional[str] = OMIT,
        organization_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AppVariantResponse:
        """
        Create an app and variant from a template.

        Args:
            payload (CreateAppVariant): The payload containing the app and variant information.
            stoken_session (SessionContainer, optional): The session container. Defaults to Depends(verify_session()).

        Raises:
            HTTPException: If the user has reached the app limit or if an app with the same name already exists.

        Returns:
            AppVariantResponse: The output of the created app variant.

        Parameters
        ----------
        app_name : str

        template_id : str

        env_vars : typing.Dict[str, str]

        project_id : typing.Optional[str]

        workspace_id : typing.Optional[str]

        organization_id : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AppVariantResponse
            Successful Response

        Examples
        --------
        import asyncio

        from agenta import AsyncAgentaApi

        client = AsyncAgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.apps.create_app_and_variant_from_template(
                app_name="app_name",
                template_id="template_id",
                env_vars={"key": "value"},
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "apps/app_and_variant_from_template",
            method="POST",
            json={
                "app_name": app_name,
                "template_id": template_id,
                "project_id": project_id,
                "workspace_id": workspace_id,
                "env_vars": env_vars,
                "organization_id": organization_id,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    AppVariantResponse,
                    parse_obj_as(
                        type_=AppVariantResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def list_environments(
        self, app_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[EnvironmentOutput]:
        """
        Retrieve a list of environments for a given app ID.

        Args:
            app_id (str): The ID of the app to retrieve environments for.
            stoken_session (SessionContainer, optional): The session container. Defaults to Depends(verify_session()).

        Returns:
            List[EnvironmentOutput]: A list of environment objects.

        Parameters
        ----------
        app_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[EnvironmentOutput]
            Successful Response

        Examples
        --------
        import asyncio

        from agenta import AsyncAgentaApi

        client = AsyncAgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.apps.list_environments(
                app_id="app_id",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"apps/{jsonable_encoder(app_id)}/environments",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    typing.List[EnvironmentOutput],
                    parse_obj_as(
                        type_=typing.List[EnvironmentOutput],  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def environment_revisions(
        self,
        app_id: str,
        environment_name: typing.Optional[typing.Any],
        *,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> EnvironmentOutputExtended:
        """
        Parameters
        ----------
        app_id : str

        environment_name : typing.Optional[typing.Any]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EnvironmentOutputExtended
            Successful Response

        Examples
        --------
        import asyncio

        from agenta import AsyncAgentaApi

        client = AsyncAgentaApi(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.apps.environment_revisions(
                app_id="app_id",
                environment_name={"key": "value"},
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"apps/{jsonable_encoder(app_id)}/revisions/{jsonable_encoder(environment_name)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    EnvironmentOutputExtended,
                    parse_obj_as(
                        type_=EnvironmentOutputExtended,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)
