"""scope project_id to db models/entities

Revision ID: c00a326c625a
Revises: 22d29365f5fc
Create Date: 2024-09-12 20:34:16.175845

"""

import os
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa

from agenta_backend.migrations.postgres import utils


# revision identifiers, used by Alembic.
revision: str = "c00a326c625a"
down_revision: Union[str, None] = "22d29365f5fc"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    engine = sa.create_engine(os.getenv("POSTGRES_URI"))
    op.add_column("app_db", sa.Column("project_id", sa.UUID(), nullable=True))
    op.drop_constraint("app_db_user_id_fkey", "app_db", type_="foreignkey")
    op.create_foreign_key(
        "app_db_projects_fkey",
        "app_db",
        "projects",
        ["project_id"],
        ["id"],
        ondelete="CASCADE",
    )
    op.drop_column("app_db", "user_id")
    op.add_column(
        "app_variant_revisions", sa.Column("project_id", sa.UUID(), nullable=True)
    )
    op.create_foreign_key(
        "app_variant_revisions_projects_fkey",
        "app_variant_revisions",
        "projects",
        ["project_id"],
        ["id"],
        ondelete="CASCADE",
    )
    op.add_column("app_variants", sa.Column("project_id", sa.UUID(), nullable=True))
    op.drop_constraint("app_variants_user_id_fkey", "app_variants", type_="foreignkey")
    op.create_foreign_key(
        "app_variants_projects_fkey",
        "app_variants",
        "projects",
        ["project_id"],
        ["id"],
        ondelete="CASCADE",
    )
    op.drop_column("app_variants", "user_id")
    op.add_column("bases", sa.Column("project_id", sa.UUID(), nullable=True))
    op.drop_constraint("bases_app_id_fkey", "bases", type_="foreignkey")
    op.drop_constraint("bases_user_id_fkey", "bases", type_="foreignkey")
    op.create_foreign_key(
        "bases_projects_fkey",
        "bases",
        "projects",
        ["project_id"],
        ["id"],
        ondelete="CASCADE",
    )
    op.drop_column("bases", "user_id")
    op.add_column("deployments", sa.Column("project_id", sa.UUID(), nullable=True))
    op.drop_constraint("deployments_user_id_fkey", "deployments", type_="foreignkey")
    op.create_foreign_key(
        "deployments_projects_fkey",
        "deployments",
        "projects",
        ["project_id"],
        ["id"],
        ondelete="CASCADE",
    )
    op.drop_column("deployments", "user_id")
    op.add_column("docker_images", sa.Column("project_id", sa.UUID(), nullable=True))
    op.drop_constraint(
        "docker_images_user_id_fkey", "docker_images", type_="foreignkey"
    )
    op.create_foreign_key(
        "docker_images_projects_fkey",
        "docker_images",
        "projects",
        ["project_id"],
        ["id"],
        ondelete="CASCADE",
    )
    op.drop_column("docker_images", "user_id")
    op.add_column("environments", sa.Column("project_id", sa.UUID(), nullable=True))
    op.drop_constraint("environments_user_id_fkey", "environments", type_="foreignkey")
    op.create_foreign_key(
        "environments_projects_fkey",
        "environments",
        "projects",
        ["project_id"],
        ["id"],
        ondelete="CASCADE",
    )
    op.drop_column("environments", "user_id")
    op.add_column(
        "environments_revisions", sa.Column("project_id", sa.UUID(), nullable=True)
    )
    op.create_foreign_key(
        "environments_revisions_projects_fkey",
        "environments_revisions",
        "projects",
        ["project_id"],
        ["id"],
        ondelete="CASCADE",
    )
    op.add_column(
        "evaluation_scenarios", sa.Column("project_id", sa.UUID(), nullable=True)
    )
    op.drop_constraint(
        "evaluation_scenarios_user_id_fkey", "evaluation_scenarios", type_="foreignkey"
    )
    op.create_foreign_key(
        "evaluation_scenarios_projects_fkey",
        "evaluation_scenarios",
        "projects",
        ["project_id"],
        ["id"],
        ondelete="CASCADE",
    )
    op.drop_column("evaluation_scenarios", "user_id")
    op.add_column("evaluations", sa.Column("project_id", sa.UUID(), nullable=True))
    op.drop_constraint("evaluations_user_id_fkey", "evaluations", type_="foreignkey")
    op.create_foreign_key(
        "evaluations_projects_fkey",
        "evaluations",
        "projects",
        ["project_id"],
        ["id"],
        ondelete="CASCADE",
    )
    op.drop_column("evaluations", "user_id")
    op.add_column(
        "evaluators_configs", sa.Column("project_id", sa.UUID(), nullable=True)
    )
    op.drop_constraint(
        "evaluators_configs_user_id_fkey", "evaluators_configs", type_="foreignkey"
    )
    op.drop_constraint(
        "evaluators_configs_app_id_fkey", "evaluators_configs", type_="foreignkey"
    )
    op.create_foreign_key(
        "evaluators_configs_projects_fkey",
        "evaluators_configs",
        "projects",
        ["project_id"],
        ["id"],
        ondelete="CASCADE",
    )
    op.drop_column("evaluators_configs", "app_id")
    op.drop_column("evaluators_configs", "user_id")
    op.add_column(
        "human_evaluations", sa.Column("project_id", sa.UUID(), nullable=True)
    )
    op.drop_constraint(
        "human_evaluations_user_id_fkey", "human_evaluations", type_="foreignkey"
    )
    op.create_foreign_key(
        "human_evaluations_projects_fkey",
        "human_evaluations",
        "projects",
        ["project_id"],
        ["id"],
        ondelete="CASCADE",
    )
    op.drop_column("human_evaluations", "user_id")
    op.add_column(
        "human_evaluations_scenarios", sa.Column("project_id", sa.UUID(), nullable=True)
    )
    op.drop_constraint(
        "human_evaluations_scenarios_user_id_fkey",
        "human_evaluations_scenarios",
        type_="foreignkey",
    )
    op.create_foreign_key(
        "human_evaluations_scenarios_projects_fkey",
        "human_evaluations_scenarios",
        "projects",
        ["project_id"],
        ["id"],
        ondelete="CASCADE",
    )
    op.drop_column("human_evaluations_scenarios", "user_id")
    op.alter_column("projects", "is_default", existing_type=sa.BOOLEAN(), nullable=True)
    op.add_column("testsets", sa.Column("project_id", sa.UUID(), nullable=True))
    if not utils.unique_constraint_exists(engine, "testsets", "testsets_user_id_fkey"):
        op.drop_constraint("testsets_user_id_fkey", "testsets", type_="foreignkey")
        op.drop_constraint("testsets_app_id_fkey", "testsets", type_="foreignkey")

    op.create_foreign_key(
        "testsets_projects_fkey",
        "testsets",
        "projects",
        ["project_id"],
        ["id"],
        ondelete="CASCADE",
    )
    op.drop_column("testsets", "app_id")
    op.drop_column("testsets", "user_id")
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column(
        "testsets", sa.Column("user_id", sa.UUID(), autoincrement=False, nullable=True)
    )
    op.add_column(
        "testsets", sa.Column("app_id", sa.UUID(), autoincrement=False, nullable=True)
    )
    op.create_foreign_key(
        "testsets_app_id_fkey",
        "testsets",
        "app_db",
        ["app_id"],
        ["id"],
        ondelete="CASCADE",
    )
    op.create_foreign_key(
        "testsets_user_id_fkey", "testsets", "users", ["user_id"], ["id"]
    )
    op.drop_column("testsets", "project_id")
    op.alter_column(
        "projects", "is_default", existing_type=sa.BOOLEAN(), nullable=False
    )
    op.add_column(
        "human_evaluations_scenarios",
        sa.Column("user_id", sa.UUID(), autoincrement=False, nullable=True),
    )
    op.create_foreign_key(
        "human_evaluations_scenarios_user_id_fkey",
        "human_evaluations_scenarios",
        "users",
        ["user_id"],
        ["id"],
    )
    op.drop_column("human_evaluations_scenarios", "project_id")
    op.add_column(
        "human_evaluations",
        sa.Column("user_id", sa.UUID(), autoincrement=False, nullable=True),
    )
    op.create_foreign_key(
        "human_evaluations_user_id_fkey",
        "human_evaluations",
        "users",
        ["user_id"],
        ["id"],
    )
    op.drop_column("human_evaluations", "project_id")
    op.add_column(
        "evaluators_configs",
        sa.Column("user_id", sa.UUID(), autoincrement=False, nullable=True),
    )
    op.add_column(
        "evaluators_configs",
        sa.Column("app_id", sa.UUID(), autoincrement=False, nullable=True),
    )
    op.create_foreign_key(
        "evaluators_configs_app_id_fkey",
        "evaluators_configs",
        "app_db",
        ["app_id"],
        ["id"],
        ondelete="SET NULL",
    )
    op.create_foreign_key(
        "evaluators_configs_user_id_fkey",
        "evaluators_configs",
        "users",
        ["user_id"],
        ["id"],
    )
    op.drop_column("evaluators_configs", "project_id")
    op.add_column(
        "evaluations",
        sa.Column("user_id", sa.UUID(), autoincrement=False, nullable=True),
    )
    op.create_foreign_key(
        "evaluations_user_id_fkey", "evaluations", "users", ["user_id"], ["id"]
    )
    op.drop_column("evaluations", "project_id")
    op.add_column(
        "evaluation_scenarios",
        sa.Column("user_id", sa.UUID(), autoincrement=False, nullable=True),
    )
    op.create_foreign_key(
        "evaluation_scenarios_user_id_fkey",
        "evaluation_scenarios",
        "users",
        ["user_id"],
        ["id"],
    )
    op.drop_column("evaluation_scenarios", "project_id")
    op.drop_column("environments_revisions", "project_id")
    op.add_column(
        "environments",
        sa.Column("user_id", sa.UUID(), autoincrement=False, nullable=True),
    )
    op.create_foreign_key(
        "environments_user_id_fkey", "environments", "users", ["user_id"], ["id"]
    )
    op.drop_column("environments", "project_id")
    op.add_column(
        "docker_images",
        sa.Column("user_id", sa.UUID(), autoincrement=False, nullable=True),
    )
    op.create_foreign_key(
        "docker_images_user_id_fkey", "docker_images", "users", ["user_id"], ["id"]
    )
    op.drop_column("docker_images", "project_id")
    op.add_column(
        "deployments",
        sa.Column("user_id", sa.UUID(), autoincrement=False, nullable=True),
    )
    op.create_foreign_key(
        "deployments_user_id_fkey", "deployments", "users", ["user_id"], ["id"]
    )
    op.drop_column("deployments", "project_id")
    op.add_column(
        "bases", sa.Column("user_id", sa.UUID(), autoincrement=False, nullable=True)
    )
    op.create_foreign_key("bases_user_id_fkey", "bases", "users", ["user_id"], ["id"])
    op.create_foreign_key(
        "bases_app_id_fkey", "bases", "app_db", ["app_id"], ["id"], ondelete="CASCADE"
    )
    op.drop_column("bases", "project_id")
    op.add_column(
        "app_variants",
        sa.Column("user_id", sa.UUID(), autoincrement=False, nullable=True),
    )
    op.create_foreign_key(
        "app_variants_user_id_fkey", "app_variants", "users", ["user_id"], ["id"]
    )
    op.drop_column("app_variants", "project_id")
    op.drop_column("app_variant_revisions", "project_id")
    op.add_column(
        "app_db", sa.Column("user_id", sa.UUID(), autoincrement=False, nullable=True)
    )
    op.create_foreign_key("app_db_user_id_fkey", "app_db", "users", ["user_id"], ["id"])
    op.drop_column("app_db", "project_id")
    # ### end Alembic commands ###
