"""add_nodes_dbe

Revision ID: 847972cfa14a
Revises: 55bdd2e9a465
Create Date: 2024-11-07 12:21:19.080345

"""

from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision: str = "847972cfa14a"
down_revision: Union[str, None] = "55bdd2e9a465"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "nodes",
        sa.Column("project_id", sa.UUID(), nullable=False),
        sa.Column(
            "created_at",
            sa.TIMESTAMP(timezone=True),
            server_default=sa.text("CURRENT_TIMESTAMP"),
            nullable=False,
        ),
        sa.Column("updated_at", sa.TIMESTAMP(timezone=True), nullable=True),
        sa.Column("updated_by_id", sa.UUID(), nullable=True),
        sa.Column("root_id", sa.UUID(), nullable=False),
        sa.Column("tree_id", sa.UUID(), nullable=False),
        sa.Column("tree_type", sa.Enum("INVOCATION", name="treetype"), nullable=True),
        sa.Column("node_id", sa.UUID(), nullable=False),
        sa.Column("node_name", sa.String(), nullable=False),
        sa.Column(
            "node_type",
            sa.Enum(
                "AGENT",
                "WORKFLOW",
                "CHAIN",
                "TASK",
                "TOOL",
                "EMBEDDING",
                "QUERY",
                "COMPLETION",
                "CHAT",
                "RERANK",
                name="nodetype",
            ),
            nullable=True,
        ),
        sa.Column("parent_id", sa.UUID(), nullable=True),
        sa.Column("time_start", sa.TIMESTAMP(), nullable=False),
        sa.Column("time_end", sa.TIMESTAMP(), nullable=False),
        sa.Column(
            "status",
            postgresql.JSONB(none_as_null=True, astext_type=sa.Text()),
            nullable=True,
        ),
        sa.Column(
            "data",
            postgresql.JSONB(none_as_null=True, astext_type=sa.Text()),
            nullable=True,
        ),
        sa.Column(
            "metrics",
            postgresql.JSONB(none_as_null=True, astext_type=sa.Text()),
            nullable=True,
        ),
        sa.Column(
            "meta",
            postgresql.JSONB(none_as_null=True, astext_type=sa.Text()),
            nullable=True,
        ),
        sa.Column(
            "refs",
            postgresql.JSONB(none_as_null=True, astext_type=sa.Text()),
            nullable=True,
        ),
        sa.Column(
            "exception",
            postgresql.JSONB(none_as_null=True, astext_type=sa.Text()),
            nullable=True,
        ),
        sa.Column(
            "links",
            postgresql.JSONB(none_as_null=True, astext_type=sa.Text()),
            nullable=True,
        ),
        sa.Column("content", sa.String(), nullable=True),
        sa.Column(
            "otel",
            postgresql.JSONB(none_as_null=True, astext_type=sa.Text()),
            nullable=True,
        ),
        sa.PrimaryKeyConstraint("project_id", "node_id"),
    )
    op.create_index(
        "index_project_id_node_id", "nodes", ["project_id", "created_at"], unique=False
    )
    op.create_index(
        "index_project_id_root_id", "nodes", ["project_id", "root_id"], unique=False
    )
    op.create_index(
        "index_project_id_tree_id", "nodes", ["project_id", "tree_id"], unique=False
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index("index_project_id_tree_id", table_name="nodes")
    op.drop_index("index_project_id_root_id", table_name="nodes")
    op.drop_index("index_project_id_node_id", table_name="nodes")
    op.drop_table("nodes")
    # ### end Alembic commands ###
