"""Set user_id column in db entities to be optional --- prep for project_id scoping

Revision ID: 6cfe239894fb
Revises: 362gbs21a2ee
Create Date: 2024-09-12 15:25:29.462793

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = "6cfe239894fb"
down_revision: Union[str, None] = "362gbs21a2ee"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.alter_column("docker_images", "user_id", existing_type=sa.UUID, nullable=True)
    op.alter_column("app_db", "user_id", existing_type=sa.UUID, nullable=True)
    op.alter_column("deployments", "user_id", existing_type=sa.UUID, nullable=True)
    op.alter_column("bases", "user_id", existing_type=sa.UUID, nullable=True)
    op.alter_column("app_variants", "user_id", existing_type=sa.UUID, nullable=True)
    op.alter_column("environments", "user_id", existing_type=sa.UUID, nullable=True)
    op.alter_column("testsets", "user_id", existing_type=sa.UUID, nullable=True)
    op.alter_column(
        "evaluators_configs", "user_id", existing_type=sa.UUID, nullable=True
    )
    op.alter_column(
        "human_evaluations", "user_id", existing_type=sa.UUID, nullable=True
    )
    op.alter_column(
        "human_evaluations_scenarios", "user_id", existing_type=sa.UUID, nullable=True
    )
    op.alter_column("evaluations", "user_id", existing_type=sa.UUID, nullable=True)
    op.alter_column(
        "evaluation_scenarios", "user_id", existing_type=sa.UUID, nullable=True
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.alter_column("docker_images", "user_id", existing_type=sa.UUID, nullable=False)
    op.alter_column("app_db", "user_id", existing_type=sa.UUID, nullable=False)
    op.alter_column("deployments", "user_id", existing_type=sa.UUID, nullable=False)
    op.alter_column("bases", "user_id", existing_type=sa.UUID, nullable=False)
    op.alter_column("app_variants", "user_id", existing_type=sa.UUID, nullable=False)
    op.alter_column("environments", "user_id", existing_type=sa.UUID, nullable=False)
    op.alter_column("testsets", "user_id", existing_type=sa.UUID, nullable=False)
    op.alter_column(
        "evaluators_configs", "user_id", existing_type=sa.UUID, nullable=False
    )
    op.alter_column(
        "human_evaluations", "user_id", existing_type=sa.UUID, nullable=False
    )
    op.alter_column(
        "human_evaluations_scenarios", "user_id", existing_type=sa.UUID, nullable=False
    )
    op.alter_column("evaluations", "user_id", existing_type=sa.UUID, nullable=False)
    op.alter_column(
        "evaluation_scenarios", "user_id", existing_type=sa.UUID, nullable=False
    )
    # ### end Alembic commands ###
