"""Added the 'app_type' column to the 'app_db' table

Revision ID: 0f086ebc2f82
Revises: 847972cfa14a
Create Date: 2024-09-09 10:11:05.429116

"""

from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = "0f086ebc2f82"
down_revision: Union[str, None] = "847972cfa14a"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###

    # Create the enum type first
    app_enumtype = sa.Enum(
        "CHAT_TEMPLATE",
        "COMPLETION_TEMPLATE",
        "CUSTOM",
        name="app_enumtype",
    )
    app_enumtype.create(op.get_bind(), checkfirst=True)

    # Then add the column using the enum type
    op.add_column(
        "app_db",
        sa.Column(
            "app_type",
            app_enumtype,
            nullable=True,
        ),
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###

    # Drop the column first
    op.drop_column("app_db", "app_type")

    # Then drop the enum type
    app_enumtype = sa.Enum(
        "CHAT_TEMPLATE",
        "COMPLETION_TEMPLATE",
        "CUSTOM",
        name="app_enumtype",
    )
    app_enumtype.drop(op.get_bind(), checkfirst=True)
    # ### end Alembic commands ###
