# Contribution Guidelines

Thank you for considering contributing to our project! At the moment, the project is still under development, and `we are accepting any external contributions` and we will support you to raise `new issues` to improve the repository. However, feel free to explore the codebase and documentation, and stay tuned for future updates when we open up contributions. Before getting started, please take a moment to review the following guidelines.


## Code of Conduct

Please review and adhere to our [Code of Conduct](./CODE_OF_CONDUCT.md) to ensure a positive and inclusive environment for all contributors and community members.

## How to Contribute

1. **Fork the repository**: Fork the repository to your GitHub account.
2. **Create a new branch**: Create a new branch for your contribution: `git checkout -b feature/new-feature`.
3. **Make your changes**: Make your changes and ensure they adhere to the project's coding conventions and style guidelines.
4. **Test your changes**: Test your changes thoroughly.
5. **Commit your changes**: Commit your changes with descriptive commit messages: `git commit -m "Add new feature"`.
6. **Push your changes**: Push your changes to your fork: `git push origin feature/new-feature`.
7. **Submit a pull request**: Submit a pull request to the main repository's `main` branch.

## Contribution Guidelines

- **Follow coding conventions**: Follow the project's coding conventions and style guidelines.
- **Documentation**: Ensure your code changes are well-documented and include relevant comments.
- **Clear commit messages**: Write clear and concise commit messages.
- **Specific pull requests**: Make sure your pull request addresses a specific issue or feature request. If none exists, consider creating one to discuss your proposed changes with the maintainers.
- **Open to feedback**: Be open to feedback and constructive criticism from maintainers and other contributors.

## Reporting Issues

If you encounter any bugs, issues, or have suggestions for improvements, please [create a new issue](https://github.com/your-repository/issues) in the repository. Provide detailed information about the problem or suggestion to help us understand and address it effectively.

We look forward to your contributions in the future!
