
# Javascript Syntax

## Loops and Objects
1. What questions do you have from the [Ruby to JS Worksheet](https://github.com/Ada-Developers-Academy/textbook-curriculum/blob/master/10-JavaScript/exercises/ruby-to-js-worksheet.md)?
    * Please share any different implementations you have from the provided solutions. 
    * If you're not sure where to start, consider Problem #4.
1. How are [Javascript objects](https://github.com/Ada-Developers-Academy/textbook-curriculum/blob/master/10-JavaScript/js-intro.md#objects-are-everything) similar / different from Ruby hashes? 
    * Describe dot notation.
1. Review the syntax for different types of [loops](https://www.educative.io/courses/introduction-to-javascript-first-steps/gx7Om5LKkyG). What questions do you have?
1. What questions do you have from the [functions pratice in the educative course](https://www.educative.io/courses/introduction-to-javascript-first-steps/YQ09Gy8BoQW)?
    * Share your implementation of `detectArguments()` function.
1.  What questions do you have from the  [putting it all together in the educative course](https://www.educative.io/courses/introduction-to-javascript-first-steps/qVlxqvG4E33)?
    * Share your implementation of `addValues()` function.

## Functions and JS Adagrams

1. Now that you've had a chance to practice functions as a part of JS Adagrams, what new questions or sticking points have you come across?

1. In the context of JS Adagrams, what new questions have emerged around Jest and testing?

1. What questions do you have about the project instructions, now that you have had time to look at and start work?

1. How have you approached structuring data for Wave 1 of JS Adagrams? How has your data structure ensured a weighted distribution (that is, how did you make sure you are more likely to draw and A than a Z)?

1. How has approaching Wave 2 compared to Adagrams in Ruby? Is there anything about Javascript that makes the problem easier or harder?

1. How was your approach to Wave 3 of Adagrams different in JavaScript compared to Ruby?
1. Have you attempted Wave 4 of Adagrams yet?
    * Did you make use of a helper function?
    * Have you made good progress on it?
    * Are there things you know how to do in Ruby but are having trouble doing in JavaScript?
1. Do you have any remaining questions about Adagrams?
    * Do you want to share your code to get feedback on specific parts?

# React

## React Components
1. In the Identifying Components Worksheet Pt 2, what elements/parts of the site felt like they should be components? Why did they feel like they should be components?
    * If possible, everyone should share one
1. In the Identifying Components Worksheet Pt 2, did you have any components that were repeated (as in, there were multiples of the same component on this page)? If yes, what parts of those components were similar with each other, and what parts were different from each other?
    * If possible, everyone should share one
1. In the Identifying Components Worksheet Pt 2, what components were nested inside of another component? How did you determine that?
    * If possible, everyone should share one

## Props
1. What is a prop?
    * In the Timeline project, what were the props given to the `TimelineEvent` component, and how were they passed?
    * In the Timeline project, what were the props given to the `Timeline` component, and how were they passed?

## React File Structure
1. What are the differences in workflow between React code, working with vanilla JavaScript code, and working with Ruby code?
    * What are the differences in folder structure and how to run the projects?
    * What are the differences in using git?

## React Timeline
1. What questions do you have about Timeline?
    * Do you want to share your code to get feedback on specific parts?

## Inspiration Board
1. What are all the components in this project? How do the components relate to each other? 
    * Which components contain which other components?
    * Which components are "siblings" of each other?
1. What props should Board take?
1. What props should Card take?
1. What props should NewCardForm take?
1. Will there be a component that you need to use the `useEffect` hook for? If so which one(s) and why do we need to use it?
1. Do you have any questions about snapshot testing? 
    * Any additional questions about user interaction testing?

## Forms Worksheet
1. What is an event handler? Describe the event handler(s) you needed to make to manage the form data. What was the responsibility of these event handler(s)?
1. How would you describe the relationship between the five input elements and their event handlers?
    * Share your code! Let's view 2 different implementations and discuss the elements and event handlers! Volunteers?
1. How would you describe what is in state, and how it is managed/updated within this assignment?
    * Share your code! Let's view 2 different implementations and discuss how state is managed! Volunteers?

## Exquisite React
1. Which component has the form fields? How do you read the user input from these form fields?
1. Where does the form data need to go? (What component(s) need the form data?)
1. How do you reset the form? What kind of code do you need to write?
1. What questions do you have about Exquisite React?
    * Do you want to share your code to get feedback on specific parts?

## Tic-Tac-Toe
1. When a user clicks on a Square, the Square component needs to be able to respond to the click, and change the Square's value. What props and state need to be affected and changed? What components need to be affected and changed?
1. What questions do you have about Tic Tac Toe?
    * Would anyone like to share their code to get feedback on specific parts?