# API Jigsaw

## Format

In this activity, we will be learning and then teaching each other, in the format of two rounds: the research round and the teaching round.

In the research round, you will meet with your first assigned group to learn about an assigned topic.

In the teaching round, your research round group will disseminate and you will go into your a second assigned group. It is your responsibility to teach this group about that topic.

## What to Research

You will be learning and teaching each other about other APIs, what they do, what they can't do, and how to read the documentation.

### Where to Start

You will want to start the official documentation for the API, any "getting started" tutorials that the API's official website lists, and any tutorials or blog posts that you find from the Internet. You will want to answer the questions:

1. What does this API do on a high level?
1. How is the documentation organized? Are there tutorials? Is there a list of all of the API endpoints?
1. What are some queries (`GET` requests) that any developer using this API can make?
1. What are some commands (`POST` requests) that any developer using this API can make?
1. Do these endpoints give back a response in JSON?
1. For each endpoint that you inspect, does the API document what happens when there's an error?
1. Overall, reflect: What kind of situation is the best time to use this API? (Could you use it on your Hotel project?) If you needed to use this API, how easy was it to read and learn about it?

##### Challenge Yourself: Optional Questions

1. What is the most hidden secret that you can discover in this API? For example, using the Github API, you can find out when a user's birthday is. Is there something surprising, humorous, or strange that you can get from this API?
1. What is something you would predict you could do with this API, but (as far as you can tell) you _can't_ do?
1. Is this API open-source? What does that mean in this case?

### APIs

1. [Instagram's Graph API](https://developers.facebook.com/products/instagram/)
1. [Yelp's Fusion API](https://www.yelp.com/fusion)
1. [OpenWeather's API](https://openweathermap.org/api)
1. [Wolfram Alpha's Simple API (and other pre-built APIs)](http://products.wolframalpha.com/api/)
1. [Open Bank Project](https://www.openbankproject.com)'s API (Direct link to their [API Explorer here](https://apiexplorer.openbankproject.com/)) (Note from the Instructors: This is the weirdest API to read because it relies a lot of domain knowledge about banking. Work on finding an answer, not necessarily a correct answer. 🙂)
1. [The Color API](https://www.thecolorapi.com) and [TMDb's API](https://www.themoviedb.org/documentation/api)
