# Preview of Rails

## Introduction

As we transition from exploring programming fundamentals and making CLI programs into web development, we will need to shift our focus.

## Learning Goals

At the end of this lesson, you should be able to...

- adjust expectations for what kinds of problems we will be solving
- have resources to follow for preparing your computer (development environment) for Ruby on Rails development
- have resources to follow for preparing your perspective for Ruby on Rails development

<!-- ## Examples of Rails apps -->
<!-- Maybe add some visuals about different Rails apps? The auditorium lecture for Rails day 1 already includes some of this, though -->

## Web Dev Introduces Different Problems to Solve

We've already looked at the difference of static vs. dynamic websites in our Intro to Web lecture in HTML & CSS week.

Previously, we created static websites and used HTML and CSS to determine the structure of pages. Now, we are going to create websites that dynamically change based on the information available and use Ruby on Rails to do so.

In dynamic web development, we will be thinking of different sets of problems, such as the following examples:

- When we go to a website that has a catalog of books, how do we store all of the books and book data?
- What navigation links, controls, buttons, UI elements, panels, etc. are different between a user who is a customer vs. a user who is an administrator?
- When we click on a link that includes data that is invalid or missing, what should show up and display? What should the user do? How do they do it?

All of this will build on our programming fundamentals that we've learned so far, too!

## Stuff to Do Before the First Day of Rails

1. Read and follow all directions in [Installfest for Rails](installfest-rails.md)
1. Set up the [Ada Rails Template](https://github.com/Ada-Developers-Academy/textbook-curriculum/blob/master/08-rails/rails-template-setup.md) - Time box to 20 minutes
1. Watch ["What is Ruby on Rails?" by Mackenzie Child](https://youtu.be/zppMfm4fuxM) (4 min.)
1. Watch ["Your First Rails App" by Mackenzie Child](https://youtu.be/fP64Wvz13AM) (10 min.)
1. Do pre-reading: [Ada's resource: What is Ruby on Rails?](what-is-ruby-on-rails.md)


## Conclusion

This is a list of the bare minimum to do before the Rails unit. If you were given other instructions to do before the Rails unit, then please be sure to do them. If not, then don't worry about it!

Unless specifically told to do so, you are not expected to make a Rails project before we do so together in class.
