# Hike Finder: ActiveRecord Practice

## Introduction

Welcome to the Hike Finder exercises. This sequence of worksheets is designed to provide practice working with ActiveRecord models.

Each worksheet will begin by describing a database setup, then give a sequence of questions about how to interact with that database. Some questions will ask you for specific ruby code that could be typed at the Rails console or written in a controller, and some will be comprehension questions.

You are welcome to use whatever tools you need to answer these questions, including lecture notes, internet searches, and other students. The terminal and Rails console might be especially useful for building commands. If you're not sure whether something will work, try it!

Each worksheet also has an answer sheet in the [solutions](solutions) directory. These are provided so that you can check your work. The recommended workflow is to complete an entire worksheet before looking at the answers, unless you get truly stuck.

## Table of Contents

- [Section 1: working with a single model](single-model.md)
- [Section 2: one-to-many relationships](one-to-many.md)
- [Section 3: validations](validations.md)
- [Section 4: many-to-many relationships](many-to-many.md)

## Reference Implementation

We built a real Rails app to test all this out! You can find it at https://github.com/AdaGold/hike-finder

![Hiking boot.](hiking-boot.png "Credit: https://melbournechapter.net/explore/clipart-hiking-boot/")
