# HTML/CSS Pre-Work Assignment

## Introduction

As we transition from exploring programming fundamentals and making CLI programs into web development, we will need to shift our focus.

## CLIs vs. Web Interfaces

With CLI programs, users interacted... well, with the command line! (CLI stands for Command Line Interface!). We used Ruby methods like `puts` and `gets.chomp` in order to let the user **see** things and **do** things.

In websites and web apps, we want the user to interact with the web browser, like Google Chrome or Mozilla Firefox. In order to get users to **see** things and **do** things, instead of writing _Ruby_ code, we need to write HTML and CSS.

### (HTML && CSS) != Ruby

Writing HTML and CSS should feel different compared to Ruby.

Instead of focusing on writing procedural instructions, we write, structure, organize, and categorize website content.

## Why Is There So Much Pre-Work?

Learning and writing HTML and CSS is material that works _really_ well when it's self-paced.

Our HTML and CSS curriculum is designed to start off as self-paced. We'll focus our class time on small exercises and answering questions.

This means that we will rely even more on our skills to:
- Ask questions, and research answers online
- Use online resources
- Work with ambiguous details and solutions

---

# Pre-Work Assignments

There are two parts. Please note the due dates per part on your class calendar.

## Part 1 Instructions

1. From the list below, pick an online learning platform focused on HTML, and **spend 1 hour on it**.
2. From the list below, pick an online learning platform focused on CSS, and **spend 1 hour on it**.
3. Complete the **“Intro to HTML Comprehension Questions”** assignment found in Schoology. Keep the answers on your computer. We will review your answers in class.
4. Complete the **“Intro to CSS Comprehension Questions”** assignment found in Schoology. Keep the answers on your computer. We will review your answers in class.

### HTML Online Learning Platforms

- [Scrimba HTML](https://scrimba.com/g/ghtml) - Interactive Video Lesson
- [Khan Academy HTML](https://www.khanacademy.org/computing/computer-programming/html-css/intro-to-html/v/making-webpages-intro) - Interactive Video Lesson
- [Codecademy HTML](https://www.codecademy.com/courses/learn-html/lessons/intro-to-html/exercises/body-html?action=resume_content_item) - Interactive Textbased Lesson
- [Sololearn HTML](https://www.sololearn.com/Course/HTML/) - Interactive Textbased Lesson


### CSS Online Learning Platforms

- [Scrimba CSS](https://scrimba.com/g/gintrotocss) - Interactive Video Lesson
- [Khan Academy CSS](https://www.khanacademy.org/computing/computer-programming/html-css/intro-to-css/pt/css-basics) - Interactive Video Lesson
- [Codecademy CSS](https://www.codecademy.com/learn/learn-css) - Interactive Textbased Lesson
- [Sololearn CSS](https://www.sololearn.com/Course/CSS/) - Interactive Textbased Lesson


### Optional: HTML and CSS Combined Online Learning Platforms

- [Scrimba HTML/CSS](https://scrimba.com/g/ghtmlcss) - Interactive Video Lesson

## Part 2 Instructions

1. Complete the **“Attributes, Classes, IDs Comprehension Questions”** assignment found in Schoology. Keep the answers on your computer. We will review your answers in class.
2. Complete the **“Cascades and Inheritance Comprehension Questions”** assignment found in Schoology. Keep the answers on your computer. We will review your answers in class.

