# Stacks and Queues

## Prerequisite
To follow this lesson, you must have a good understanding of the fundamentals _linear_ data structures:
1. [Arrays](..\classroom\Arrays.md)
1. [LinkedLists](linked_lists.md)

## Introduction
<b>Stacks</b> and <b>Queues</b> are both _linear_ and _homogeneous_ data structures. We come across various examples of stacks and queues in real life.

Examples of <b>stack</b>:
- a stack of ironed clothes (it's easiest to add a new ironed shirt on top and remove the top-most clothing in the stack)
- a stack of plates
- a stack of books

Examples of <b>queue</b>:
- A queue at the bus stop
- A queue at the driver's license office

These examples showcase the need for additional rules for governing operations in how we use linearly structured data and prove the need for having <b>stacks</b> and <b>queues</b> defined as data structure in computer science.

In this lesson, we'll take a look at the following:
1. [Abstract Data Types for Stacks and Queues](adt.md)
1. [Using Stacks and Queues](consumers_of_stacks_and_queues.md)
1. [Implementing a Stack](stack.md)
1. [Implementing a Queue](queue.md)