# ADTs / Stacks / Queues

## Presentation
+ [ADTs / Stacks / Queues](https://drive.google.com/open?id=1rsxjS8l4Lo21nskccyBH7Hap19NfL-D1BNGgiPlW0bc)

## Assignment
+ [AdaGold/stacks-queues](https://github.com/AdaGold/stacks-queues)

## Notes

### Data Structures and Abstract Data Types (ADTs)

In computer science, a data structure is a particular way of organizing data in a computer so that it can be used efficiently.  Data structures can implement one or more particular abstract data types (ADT), which specify the operations that can be performed on a data structure and the computational complexity of those operations. In comparison, a data structure is a concrete implementation of the specification provided by an ADT.

- ADT - Rules that we must follow when interacting with data.
- Data Structure - An implementation of an ADT; something you can actually interact with.

Different kinds of data structures are suited to different kinds of applications, and some are highly specialized to specific tasks.

### Stacks and Queues
Stacks and Queues are special cases of an ordered list.  

#### Stack
A stack is an ordered list where all insertions and removals are made only from one end.  This end is usually referred to as ‘top’.  This structure is similar to a stack of lunch trays. The first tray you put on the stack is the last tray you take off the stack.  Likewise, the last tray you put on the stack is the first tray you take off the stack. This process is called LIFO, last in is the first out.

#### Queue
A queue is an ordered list where insertions are made at one end (usually referred to as the back) and removals are made from the other end (usually referred to as the front). This structure is similar to a lunch line. The first person to enter the line is the first person to exit the line.  Likewise, the last person to enter the line is the last person to exit the line. This process is called FIFO, first in is the first out.

## Comprehension Questions

1. What is an ADT?
1. What is a stack?
1. What are the 5 methods in Stack and what does each do?
1. What is a queue?
1. What are the 5 methods in Queue and what does each do?
