# Practicing Interview Problems

| TASKS
|-------------------------------------------------
| 1. Read Articles
| 2. Come up with some example answers to chitchat questions.
| 3. Practice whiteboarding in front of a peer/partner

Technical interviews can be stressful, but like most anything else, they are a learned, practiced skill. DON'T PANIC! Technical interviews are not necessarily about evaluating the validity of your solution, but often are more about evaluating a candidate's technical communication skills and problem solving approach.

## 1. Read these articles
  + [Big O Notation: Using not-boring math to measure code's efficiency](https://www.interviewcake.com/article/big-o-notation-time-and-space-complexity)
  + [Coding Interview Tips: How to get better at technical interviews without practicing](https://www.interviewcake.com/article/coding-interview-tips)

## 2. Chit-chat Questions
Come up with 1 example for each of the following:
  1. example of an interesting technical problem you solved
  1. example of an interpersonal conflict you overcame
  1. example of leadership or ownership
  1. story about what you should have done differently in a past project

## 3. Practice
Practice solving a problem in front of another person and talking out your solutions. This person can be a peer/partner/friend and they can be technical or not technical. Your goal is to spend 15-20 minutes tackling a problem in front of someone else. Ideally on a whiteboard, but if you don't have a whiteboard, on paper. Have the person you are working with read you a question from [here](https://github.com/Ada-Developers-Academy/textbook-curriculum/blob/master/04-cs-fundamentals/interview-prep/interview-questions-algorithms.md). **Don't stress about the solution! Make sure you understand the problem, state your assumptions, talk out loud!**

Technical Questions: Problem Solving approach

1. **Understand the Probem**
   * Ask your interviewer questions
   * Create a specific example - given inputs and expected output

1. **Devise a plan**
   * What is the simplest approach that you can think of?
   * Have you solved any similar problems
   * Outline your approach in plain English
   * State your assumptions and ask more questions if needed

1. **Execute the plan**
   * Turn your plain language description into code
   * Write whiteboard code slowly
   * Ask questions / call out places where you don't know the syntax

1. **Check your answer**
   * Run examples through your whiteboard code
   * Can you improve your solution? Red, Green, Refactor!

## Assignment
<!-- - Watch [Google: How to prepare for a  technical interview](https://www.youtube.com/watch?v=ko-KkSmp-Lk) -->
- Watch [Google: Example coding interview](https://www.youtube.com/watch?v=XKu_SEDAykw)
- Practice (more the better) white boarding questions in 20 minute slots with peers, friends and mentors.

## Slide Deck

- [Slides on Interview Preparation](https://docs.google.com/presentation/d/1cc6sePkEsksLNW0eFl3HfuPvo3bzJqC4XIzjjc811so/edit#slide=id.p1)

All content is licensed under a [Creative Commons Attribution-NonCommercial-NoDerivatives 4.0 International License](http://creativecommons.org/licenses/by-nc-nd/4.0/)

[![Creative Commons License](https://i.creativecommons.org/l/by-nc-nd/4.0/88x31.png)](http://creativecommons.org/licenses/by-nc-nd/4.0/)

## Previous Interview Questions

- [Compiled Interview Questions](https://docs.google.com/spreadsheets/d/1fEDgUvF3e7VVVzlkrV2X6_5nqFA7_34B7FdWsZUDxZc/edit#gid=677105308)

## Resources

- [Technical Interview Guide](https://yangshun.github.io/tech-interview-handbook/introduction)
- [Interview Cake Website](https://www.interviewcake.com/)
- [Leetcode](http://leetcode.com/)
- [HackerEarth](https://www.hackerearth.com/practice/)
