# CS Fundamentals

Welcome to Computer Science Fundamentals!  In this class you will study classic computer science concepts and topics.  Specifically we will focus on:

- **Algorithms** - Devising step-by-step solutions for a problem.
  - This includes common _design patterns_ or common types of problems that provide reusable solutions.
  - This also includes deriving the runtime (speed) and memory (space) complexity of the algorithm and using it to evaluate the efficiency of the algorithm.
- **Data Structures** - Abstract data types that organize data in specific ways.
  - This will include, _Arrays_, _Stacks_, _Queues_, _Linked Lists_, and _Hashes_.
  - We will also learn when to choose a particular data structure based on it's runtime and memory usage.
- **Interview Preparation** - How to be successful in a technical interview.
  - This includes the interview process, typical types of questions and interview strategies for success.  
- **Various Computer Science Topics**  - A variety of techniques and concepts.
  - _Recursion_
  - _Binary Numbers_
  - Memory & Computer Internals

## Goals for the Course

When you finish CS Fundamentals we want you to be able to:

- Explain how a variety of algorithms work
- Examine an algorithm and compare and contrast it's runtime efficiency
- Write an algorithm both on the whiteboard and in a text editor
- Explain the use-cases for a variety of data structures
- Evaluate which data structure is best to use for a particular need
- Pass a technical interview
- Write recursive methods
- Explain how binary numbers work
- Discuss how a CPU and computer are structured at a high-level

## Motivation

**Question** So why study CS Fundamentals?  

As you may have discovered there are always many ways to solve any problem, but some solutions may prove more or less optimal than others.  A solution that works for 100 users might not work as well with 1 million.  Identifying areas of your application which scale poorly, and developing more scalable applications and picking more efficient data structures can make an enormous difference in performance.

A more directly applicable point is the fact that traditional technical interviews focus heavily on cs fundamentals questions.  Traditional whiteboarding involves writing efficent code and identifying it's runtime efficiency.

## Course Methodology

Computer Science fundamentals can seem very abstract and difficult to understand.  The class only meets 2 hours per week and only have 10 sessions (20 hours) of classtime.  Therefore we will operate primarily as a [Flipped Classroom](https://www.blendedlearning.org/models/?gclid=Cj0KCQjwv8nqBRDGARIsAHfR9wAcM6swwFYULVLgf782OrWhek4U5eTkxxWt0Zt8MzXNne701u7lIhkaAouaEALw_wcB#flip).  In our flipped classroom students will watch video lessons and read course material as homework.  In class we will discuss the concepts, answer questions and work on exercises.  In that manner you can get help from classmates and the instructor as you work on assignments.  The goal is that most coursework can be done in class.

## How To Get Help

There are a number of ways to get help.  In general if you are stuck for more than 30 minutes on a specific problem you should:

1. Ask a neighbor and discuss the problem
1. Post to the #CS-Fundamentals slack channel, asking for support from classmates
1. Ask a question of your instructor in person or via slack
1. Come by Office Hours in project time Tuesday through Saturday
1. Check with a tutor, other instructor or TA

Be aware that we have 49 students, and you will likely get a faster response by checking with a neighbor before the instructor.  

## Course Norms

This course requires more attention and focus due to it's abstract nature, 48 students and 2-hour blocks.  You will want to avoid using:

- Email
- Chatting
- Browsing the Web
- Working on regular classroom assignments

If you find that you have trouble, feel free to shut down your computer and take notes on paper during discussions.

That said:

- Food is ok, but avoid smelly or noisy food
- Knitting and fiddling is okay
- Feel free to get up and stretch, but avoid blocking others
- Headphones are fine for independent practice

## Schedule

1. [Binary Numbers](https://github.com/Ada-Developers-Academy/textbook-curriculum/blob/master/04-cs-fundamentals/classroom/Binary.md)
1. [Arrays](https://github.com/Ada-Developers-Academy/textbook-curriculum/blob/master/04-cs-fundamentals/classroom/Arrays.md)
1. [Introduction to Data Structures](https://github.com/Ada-Developers-Academy/textbook-curriculum/blob/master/04-cs-fundamentals/classroom/intro-to-data-structures.md)
1. [Efficiency of Algorithms & Big-O](https://github.com/Ada-Developers-Academy/textbook-curriculum/blob/master/04-cs-fundamentals/classroom/efficiency-of-algorithms.md)
1. [Sorting](https://github.com/Ada-Developers-Academy/textbook-curriculum/blob/master/04-cs-fundamentals/classroom/Sorting.md)
1. [Introduction to Function Calls & Recursion](https://github.com/Ada-Developers-Academy/textbook-curriculum/blob/master/04-cs-fundamentals/classroom/function-calls.md)
1. [Introduction to Hash Tables](https://github.com/Ada-Developers-Academy/textbook-curriculum/blob/master/04-cs-fundamentals/classroom/hash-tables.md)
1. [The Interview Process](https://github.com/Ada-Developers-Academy/textbook-curriculum/blob/master/04-cs-fundamentals/classroom/Interview-prorocess.md)
1. [Recursion](https://github.com/Ada-Developers-Academy/textbook-curriculum/blob/master/04-cs-fundamentals/classroom/Introduction%20to%20Recursion.md)
1. [Recursive Programming Strategies](recursive-strategies.md)
2. [Linked Lists](https://github.com/Ada-Developers-Academy/textbook-curriculum/blob/master/04-cs-fundamentals/classroom/Introduction%20to%20Linked%20Lists.md) - Under Construction
3. [Software Design](https://github.com/Ada-Developers-Academy/textbook-curriculum/blob/master/04-cs-fundamentals/classroom/Software%20Design.md) - Under Construction


## Tips For Success

1. Make sure to read the curriculum and watch the videos before class
1. Ask questions!
1. Talk about your code with classmates
1. Take advantage of Office Hours and TAs
1. Do the exercises and review your project feedback

## Open Curriculum & Document

The curriculum and even this document are **not** set in stone.  If you want to suggest a change in a curriculum document, feel free to edit the markdown and open a pull request.  This includes **this** document.

## Outside Resources

These resources are **not** required for CS Fundamentals, but if you want to go further than we can in class, they can be useful.

- [Introduction to Algorithms PDF](http://web.karabuk.edu.tr/hakankutucu/CME222/MIT[1].Press.Introduction.to.Algorithms.2nd.Edition.eBook-TLFeBOOK.pdf)  & [Textbook](https://mitpress.mit.edu/books/introduction-algorithms-third-edition)
- [Grokking Algorithms](https://www.manning.com/books/grokking-algorithms)
- [MIT Open Courseware Intro to Algorithms](https://ocw.mit.edu/courses/electrical-engineering-and-computer-science/6-006-introduction-to-algorithms-fall-2011/)
