# The Interview Process

The tech hiring process can be stressful, but doing well as a job applicant is a _learned skill_.  You _will likely_ feel awkward and uncomfortable in the beginning, but there is a key secret to remember.

![don't panic](images/dontpanic.jpg)

The Ada curriculum and community provide a strong support network to help you succeed in the interview process.

## Objectives

By the end of this lesson you should be able to:

- Describe the most common steps in the application process.
- Understand hiring terminology such as:
  - Interview Loop
  - Whiteboard Interview
  - Coding Challenge
  
## Slides

- [Whiteboarding Interviews Slides](https://docs.google.com/presentation/d/1cc6sePkEsksLNW0eFl3HfuPvo3bzJqC4XIzjjc811so/edit) - No video lesson

## The Typical Tech Hiring Process

When applying for a junior developer position in Seattle, applicants typically follow these steps.

1. Applying for a position
1. Phone or video chat screen
1. In person-interview
1. Offer - Negotiation
1. Acceptance

Sometimes an applicant may skip a phone screening or a company might require additional interviews, or provide homework in the form of a coding challenge.

### Application

A junior developer can apply for a position in many ways, this can include an online application form on the company website or a job-listing site like [Indeed](https://www.indeed.com/q-Apply-jobs.html).  Sometimes it can also include talking to a recruiter, a colleague at the company, or a hiring manager at a local meet-up.  Universities like the University of Washington hold job-fairs.  There are a lot of ways to get in the door as a junior developer.

### Phone Screen

A phone screen, despite the name might be either on the phone or via an online platform such as Skype or Google Hangout.  You will likely initially talk to a recruiter, but the call may involve a hiring manager.  You may or may not be asked technical questions, but the goal of a phone screen is generally to narrow down the list of candidates for on site interviews.  Generally you should be ready to talk about work experience you have, projects you have worked on and how your interests align with the company and team you are applying for.  

Before a phone screen it is a good idea to:

- Review the job listing and take notes
- Review your resume as the interviewer will likely ask questions drawn from your experience.
- Prepare some questions to help you determine if the position is right for you.
- Find a quiet place with good connectivity.

### In-person Interview

A technical in-person interview can vary greatly in length and process.  Typically however you will have some initial time to greet and introduce yourself to the interviewer(s) with some brief chitchat.  

Then the interviewer will begin the technical portion of the interview.  This is often a _whiteboard interview_, meant to test your ability to solve new problems and communicate your thinking.  You will be given a problem and a whiteboard and asked to develop a solution and explain it to the interviewer.  


## The Ada Internship-Interview Process

As part of being an Ada student you will be placed in a internship with a sponsoring company.  To help determine placement and to give you practice interviewing, you will be assigned 6 Ada sponsors.  Over the course of a week, you will interview with each of the 6 assigned sponsors in 30-minute technical interviews.

### Mock Interviews

As an Ada student you will be matched up for a practice interview, called a "mock interview" with an experienced hiring manager or engineer.  They will give you a sample interview problem and conduct a practice interview with you.  After the "mock interview" the interviewer will write up a set of feedback for you to help you prepare for your actual internship interviews.

Remember:  

![don't panic](images/dontpanic.jpg)

How you perform in your mock interview will not affect your internship placement.  The mock interview is designed to give you practice and experience with a technical interview and provide you useful feedback.

## The Internship Interview

Each internship interview is 30-minutes long and will consist of a few minutes of introduction, followed by a whiteboard question.  Make use of the [whiteboarding strategies](Whiteboarding-Tips.md#3-practice), we discuss in CS Fundamentals.  As a student, you are expected to prepare for each interview and try your upmost.  Some companies do not follow the whiteboard format, instead asking questions about work-history and projects or a pair-programming exercise.  

After the interviews conclude, both students & interviewers provide feedback to Ada staff which is used to decide placements.  Some feedback from interviewers will also be made available to students after internships begin.

## Terminology

- **Phone Screen** - An initial telephone or internet chat with a job candidate to ensure the candidate's suitability for an in-peron interview.  This could involve a hiring manager, but is more likely to involve a recruiter.
- **Coding Challenge** - A "homework" assignment given to job candidates to assess their programming skills and practices such as regularly committing and writing tests.
- **Whiteboard Interview** - A Whiteboard interview is typically a problem solving exercise where a job applicant is asked to solve a programming or design problem on a whiteboard.  Applicants are assessed both on their _coding skills_ and ability to _communicate_ their reasoning.  Whiteboard interviews can, instead of using a physical whiteboard involve pair programming, or a shared screen environment. 

## Resources

- [Google Sample Whiteboard Interview (youtube)](https://youtu.be/XKu_SEDAykw)
- [Cracking the Coding Interview](http://www.crackingthecodinginterview.com/contents.html)
- [Whiteboarding Tips](Whiteboarding-Tips.md)

## Additional Whiteboard Practice Resources
- [Code challenge and white boarding practice on HackerRank](https://www.hackerrank.com/)
- [Practice problems on LeetCode](https://leetcode.com/)
- [Code challenge and white boarding practice on CodeFlights](https://codefights.com/)
- [White boarding practice by pairing up on Pramp](https://www.pramp.com/) - Online practice coding interviews 6 free.
- [Cohort 3 List](https://docs.google.com/spreadsheets/d/1t-kN_dFZp2OJQJI9yJW8JrS1c_aK-Hi6k9DWP1bw_40/edit?ts=56a027f7#gid=570475651)
- [Cohort 4 List](https://docs.google.com/spreadsheets/d/1pnWSQHcvV8rQ1R-e_D7uTO-YF3cfCmrK6SteoiWwTzM/edit?usp=sharing)
- [Cohort 5 List](https://docs.google.com/spreadsheets/d/1nBLF_YGHmkqP6xb6QfJKrOBtqa2ZA0YpuRltI1wU_bE/edit#gid=0)
- [Cohort 7 List](https://docs.google.com/spreadsheets/d/1ZJ_gL2oidqdYzgL5lk0Ew-KyFm_yK5J8SZmD-sW-G0U/edit?usp=sharing)
- [Cohort 8 List](https://docs.google.com/spreadsheets/d/1fEDgUvF3e7VVVzlkrV2X6_5nqFA7_34B7FdWsZUDxZc/edit?usp=sharing)


## References

- [Don't panic image from Wired.com](https://www.wired.com/2009/05/dont-panic-its-towel-day/)
