# Arrays, Time & Space complexities
## Learning Goals
+ Time and space complexitites
+ Array data structure and related algorithms
  + Visit or print each value, one by one
  + Search for a value
  + Reverse the values
  + Find max/min alue
  + Sort in ascending/descending order

## Required:
Go through what you've already learned in CS Fundamentals classroom curriculum:
   + [Data structures and Abstract Data Types](https://github.com/Ada-Developers-Academy/textbook-curriculum/blob/master/04-cs-fundamentals/classroom/ADTs-Stacks-Queues.md)
   + [Native Arrays](https://github.com/Ada-Developers-Academy/textbook-curriculum/blob/master/04-cs-fundamentals/classroom/Array-vs-ArrayList.md)
   + [Algorithmic efficiency and Sorting](https://github.com/Ada-Developers-Academy/textbook-curriculum/blob/master/04-cs-fundamentals/classroom/Sorting-Efficiency.md)
   + [Merge sort](https://github.com/Ada-Developers-Academy/textbook-curriculum/blob/master/04-cs-fundamentals/classroom/Mergesort.md)

## Exercises
Design an algorithm, deduce the space and time complexity and then, author functions to do the following:
1. Given an array of integers and the array length, reverse the array in place.
2. Given an array of integers and the array length, return the reversed array without altering the original array.
3. Given an array of integers and the array length, check if a specific, given value exists in the array. Return true if the value is found, false otherwse.
4. Given an unsorted array and its length, return the max value in the array.
5. Given an unsorted array and its length, return the min value in the array.
6. Print each value in the array, given an integer array and it's length.
7. Given a sorted, integer array and its length, insert a given value into the array while keeping the array sorted.
8. Given an unsorted integer array and its length, delete a given value from the array.
9. Given an unsorted integer array and its length, sort the array in ascending order.
10. Given an unsorted integer array and its length, sort the array in descending order.

## Assignment
Implement methods in using_restricted_array.rb in [Ada-C7/Restricted-Array](https://github.com/Ada-C7/Restricted-Array)

## Additional Resources:
+ [Sorting algorithms](http://www.geeksforgeeks.org/sorting-algorithms/)
+ Kal academy's material on [Linear Data Structures](https://drive.google.com/open?id=0BxHords9odw3cDhCdGMxcWFVRms)
+ Read through and watch videos on [Linked List vs Array](http://www.geeksforgeeks.org/linked-list-vs-array/)

## Optional offline problem sets
+ In "Cracking the Coding Interview" book, "Chapter 1: Arrays and Strings"
+ In "Cracking the Coding Interview" book, "Chapter 11: Sorting and Searching"

## Slide Deck
+ Slide Deck used in class</br>
<span xmlns:dct="http://purl.org/dc/terms/" property="dct:title"><a href="https://drive.google.com/file/d/0B__DV26QHsH4aHNVT0lrVVFOSEk/view?usp=sharing">Arrays</a></span> is licensed under a <a rel="license" href="http://creativecommons.org/licenses/by-nc-nd/4.0/">Creative Commons Attribution-NonCommercial-NoDerivatives 4.0 International License</a>.</br>
<a rel="license" href="http://creativecommons.org/licenses/by-nc-nd/4.0/"><img alt="Creative Commons License" style="border-width:0" src="https://i.creativecommons.org/l/by-nc-nd/4.0/88x31.png" /></a><br /> 
