# Pair Feedback and Code Reviews

When we pair program or program collaboratively professionally, we want to open as many opportunities to give and receive feedback as possible.

As part of pairing or group projects, the pair/group needs to take 15-30 minutes to give and receive feedback. It is best to give and receive feedback after any activity or session of pairing concludes, while the session is still fresh in your memory. If you don't have the chance to give/receive feedback immediately after a pairing session, take notes while you remember.

At Ada, we'll explicitly ask each pair/group to spend time giving/receiving feedback with each other at least once before project submission.

Feedback can be about:
- Code
- The pairing experience

Feedback should always be:
- Actionable
- Specific
- Kind
- Empathetic (for yourself and for others)

Topics to cover are:
- What went well for you
  - Affirmations for you and your pair/group
- What could have gone better for you

Also check out the [general guidelines to improve pair programming](https://github.com/Ada-Developers-Academy/textbook-curriculum/blob/master/00-programming-fundamentals/programming-techniques-pairs-or-solo.md). 


## How to Give a Code Review

Code reviews are one of the best ways to provide feedback on someone's work. There are a lot of tools to assist with making code reviews, such as the review/comment system on pull requests on GitHub.

It is not part of the curriculum at Ada for students to give code reviews (to each other). Even so, we want to prepare everyone to be able to contribute to giving feedback on someone else's code.

Reviewing code can seem daunting, so here are some suggested readings on giving good code review comments.

#### ThoughtBot's Guide to Code Reviews

The entire guide is good, concise, effective, and accurate. [Read all of it, and read it here](https://github.com/thoughtbot/guides/tree/master/code-review).

Here are some notable tips from the guide:
- Accept that many programming decisions are opinions. Discuss tradeoffs, which you prefer, and reach a resolution quickly.
- Good questions avoid judgment and avoid assumptions about the author's perspective.
- Avoid selective ownership of code. ("mine", "not mine", "yours")
- Avoid using terms that could be seen as referring to personal traits. ("dumb", "stupid"). Assume everyone is intelligent and well-meaning.
- Be explicit. Remember people don't always understand your intentions online.
- Be humble. ("I'm not sure - let's look it up.")
- Don't use sarcasm.
- Keep it real. If emoji, animated gifs, or humor aren't you, don't force them. If they are, use them with aplomb.

#### Never say “you”

> Option 1: Replace ‘you’ with ‘we’ ... “We” reinforces the team’s collective responsibility for the code. The author may move on to a different company and so might you, but the team who owns this code will remain in one form or another.

> Option 2: Remove the subject from the sentence. Another way to avoid using “you” is to use a shorthand that omits the subject from the sentence

> An additional option is to phrase it as a question, beginning with “what about…” or “how about…”

> - [Michael Lynch, How to Do Code Reviews Like a Human ](https://mtlynch.io/human-code-reviews-1/)

#### Frame feedback as requests, not commands

> You would expect reviewers to dial up their politeness in reviews, but bizarrely I’ve found them to go the opposite direction. ...  Frame your notes as requests or suggestions, not commands. ...

> People like to feel in control of their own work. Making a request of the author gives them a sense of autonomy. ...

> Requests also make it easier for the author to push back politely. Maybe they have a good reason for their choice. If you frame your feedback as a command, any pushback from the author comes across as disobedience. If you frame your feedback as a request or a question, the author can simply answer you.

> - [Michael Lynch, How to Do Code Reviews Like a Human ](https://mtlynch.io/human-code-reviews-1/)

#### Tie notes to principles, not opinions

> When you give the author a note, explain both your suggested change and the reason for the change. ... Grounding your notes in principles frames the discussion in a constructive way.

> - [Michael Lynch, How to Do Code Reviews Like a Human ](https://mtlynch.io/human-code-reviews-1/)


## Additional Notes

A lot of people write about how to effectively pair program, ask/give/receive feedback, or give effective code reviews. There is no one-size-fits-all solution!

At Ada, if there are any issues or concerns that you and your teammate(s) cannot resolve, please seek the support from Ada staff.
