# Intro to Social Justice Curriculum

Hi Adies!

By joining the Ada community, you are joining us in the crucial work of creating an educational space that strives to be just, equitable, and explicitly anti-oppression. In the attached materials, you’ll be asked to read and think about issues of identity, privilege, oppression, and social justice. This may be new to you, or it may be a huge piece of your daily, lived experience. Our readings in this packet will focus primarily on race and gender, but our work together throughout your time at Ada will cover a wider breadth of social justice and identity issues.  Our goal here is to build some of the basic linguistic and conceptual skills that will start the work of having safe, productive, community-affirming conversations.

If some of your identities align with majority groups and thinking about privilege is new to you, these readings may bring up feelings of defensiveness, anger, guilt, or sadness. I encourage you to be open to those feelings, interrogate them, and do more research before arriving at Ada. You can also reach out to me throughout this process.

If some of your identities align with underrepresented or oppressed groups, these readings may feel very “101” or potentially triggering. You know your own needs and the best uses for your time. I encourage you to at least skim this material so you know what your more privileged classmates are working on, but do so to your own levels of comfort and interest. I think the articles by Ellen Chisa and Erica Joy will be interesting regardless.

I look forward to meeting all of you! This work shouldn’t take you more than a couple hours total, please contact me if you feel stuck on any concepts.

Sarah Ervin
Student Counselor
sarah@adadevelopersacademy.org


Statement of Inclusivity: Ada Developers Academy is designed to be an inclusive, positive learning environment for all students, regardless of sexual orientation, disability, physical appearance, education, age, race, or religion. All women (cis and trans*) and people with non-binary gender who feel a part of women's community are encouraged to apply.

# Readings

1. [#FFFFFF Diversity by Erica Joy](https://medium.com/this-is-hard/ffffff-diversity-1bd2b3421e8a#.os3cox669)
1. ["Minimum Bar" Diversity by Ellen Chisa](https://medium.com/@ellenchisa/minimum-bar-diversity-2b8342428de4#.uc9lmzczn)
1. [Privilege 101 by Sian Ferguson](http://everydayfeminism.com/2014/09/what-is-privilege/)

While you aren't being asked specific follow-up questions on these articles, they will give you an excellent reference point for some of the key concepts we're exploring and will give you some context for the following exercise.

# Exercises

##  Breaking Down Identity

Although we come to Ada because we identify with female community, none of us come here bearing only our gender identity. We will carry with us into Ada all the different parts of ourselves, including race, sexuality, ethnicity, religion, and class, just to name a few. Some parts of ourselves may garner privilege, while others may be culturally marginalized.  We can use the term “intersectionality” to refer to this understanding of multiplicity.

Please answer the following reflection question on a separate paper.


1. List as many of your own identity categories as you can: (e.g. race, class, gender, age, religion, education, family structure, etc)





2. Which part of your identity are you most aware of on a daily basis?



3. Which part of your identity are you least aware of on a daily basis?



4. Which part of your identity was the most emphasized growing up?



5. Which part of your identity do you feel is the most misunderstood?



6. Which part of your identity do you feel is the most difficult to discuss with those who identify differently?



7. Which part of your identity grants you the most privilege?



8. Which part of your identity feels the most marginalized?



## Vocab


Below is a vocabulary list we’d like you to be familiar with when you arrive at Ada. Some of the terms you’ve seen in your readings, some you have not. It is not exhaustive, and we will be increasing our community vocabulary throughout our time together. Write your own definition for the terms you already know and research definitions for anything you aren’t sure of.



Privilege:




Oppression:




Ally:




Intersectionality:





Institutional racism/sexism/ableism etc.:




Structural racism/sexism/ableism etc.:




Queer:




Transgender:




Cisgender:




Non-Binary:




# Email Reflection

Send me an email to sarah@adadevelopersacademy.org answering the following questions. This can be as short or long as you want it to be.

1. What was your level of familiarity with these concepts and                                               terms prior to this?
1. Why do think we do work around social justice at Ada when we're here to learn tech?
1. Do you want to attend the follow-up conversation on August 2 at 4:15 pm? If so, what thoughts or questions make you want to join?
1. Any other thoughts, concerns, or reflections you want to share with me?
