# Code Journals

## Purpose

The purpose of the Code Journal is to give each individual at least one tool for self-reflection. With the practice of consistently filling out the code journal, we hope to accomplish the following specific things:

- Teach and practice self-reflection
- Reinforce weekly learning goals
- Give you an artifact to catalog and review your learnings over time

**An Ada instructor will never ask to see your code journal.**

## How

The code journal is yours. Feel free to fill it out and use it however is most useful for you. Use markers and draw and bullet journal if that's what works best for you! Keep it clean and orderly if that's what you'd like, or scribble in it and draw pictures if you need to.

The only thing that we ask is that each person is intentional about how they reflect. It may be useful to use the following template for your weekly entry. This template emphasizes reflecting on the learning goals.

---

**Week #X**

Question | My Response |
--- | --- |
fill in Learning Goal #0 | fill in your reflection on Learning Goal #0
... | ...
fill in Learning Goal #(X-1) | fill in your reflection on Learning Goal #(X-1)
What went well for me this week? |
What concepts were the most difficult for me this week? |
What are things I'd like to keep doing? |
What are things I'd like to change or start doing? What are things I need to do better on? |

---

Other models of reflection that we highly recommend:

#### Reflection using Bloom's Taxonomy

_**Note:** This is is a paraphrased version of a model presented in [this article.](http://peterpappas.com/2010/01/reflective-student-taxonomy-reflection-.html)_

- What was the assignment? When was it due? Did I get it turned in on time?
- Do I understand the parts of the assignment and how they connect? Do I see where this fits in with what we are studying?
- How was this assignment similar to other assignments? Do I see connections in either content, product or process?
- Were the strategies, skills and procedures I used effective for this assignment? Do I see any patterns in how I approached my work – such as  following an outline, keeping to deadlines? What were the results of the approach I used – was it efficient, or could I have eliminated or reorganized steps?
- How can I best use my strengths to improve? What steps should I take or resources should I use to meet my challenges? What suggestions do I have for my teacher or my peers to improve our learning environment?

#### Reflective Sentence Starters

_**Note:** This is is a paraphrased version of a model presented in [this article.](http://mrrobinsonau.blogspot.ca/2009/04/reflective-writing-sentence-starters.html)_

- Record what happened (_"Thinking back over the day what I valued most was..."_)
- Insights into what you think and feel (_"I keep thinking about..."_)
- Thinking about your own learning (_"Something I have found out about myself is..."_, _"I need to ask for more help about..."_)
- Thinking more deeply (_"My point of view is..."_)
- Thinking about alternative points of view (_"I would never have thought about the problem in that way..."_)
- Conclusions (_"In the future I would like to..."_)

### Where can I find the Learning Goals for the week?

You can find learning goals listed at the beginning of each lecture.

## Duration

During the classroom portion of Ada, we will schedule a small amount of time every week to work on your code journal. This time may be included with a weekly assessment, or during project time.

After the classroom portion of Ada, it is up to you how you would like to continue your code journaling!
