# Object Oriented Design Practice

The purpose of this exercise is to give you practice designing objects and the way they would interact. The goal is _not_ to write the code to complete the exercise, though you're welcome to if you would like. There aren't right or wrong answers, specifically, but _decisions_ you can make to structure your code.

## Problem Statement
We need to design a system that would allow us to utilize a deck of cards in a [BlackJack game](https://www.youtube.com/watch?v=qd5oc9hLrXg). This deck and cards should not have behavior specific to any particular game, while a Game class would relate to the specific implementation of BlackJack.

The user of a deck of cards should be able to shuffle the cards as well as deal cards. To deal, the user should be able to specify the number of players who will be dealt a specified number of cards.

## Design
Questions:
- How does a deck relate to a Game?
- How does a card relate to a deck?
- What properties would a Game have?
- What properties does a card have?

## Complete
- Determine which classes you would create
  - For each class, define the attributes and methods you would utilize
  - Method definitions should include any parameters you would be using as well as return values
