# Exercism as Part of Ada's Ruby Unit

## Introduction

[Exercism.io](https://exercism.io) is a free online community that provides programming exercises that are language-specific and TDD-style to encourage code practice and mentorship.

On Exercism.io, we should expect to find resources for the following:

- Dozens of TDD-style programming practices for Ruby and other languages
- Scaffolding for community and mentorship

## How We Assign and Review Exercism

At Ada, from time-to-time, **we will assign specific exercises for you to complete.** As a pattern, these will often be over the weekend, and unrelated to our projects. However, they are specifically curated problems to help increase our practice with Ruby, TDD, and problem-solving.

In these cases, the following process will happen:

- As homework, you will see a specific exercise on Exercism assigned for completion by a certain day
- Assuming that Exercism's CLI tool has been setup, installed, and configured onto your laptop, you will use the Exercism CLI tool to download that exercise to your laptop
- You will work on and complete a solution to this exercise. A completed solution will pass all of the provided tests. You are not required to submit your solution via Exercism.io, **you are only required to keep your solution on your own local computer**
- After the due date, when we review that exercise, we will spend in-class time to check work. At times, we will present submissions to the class

## Setup

Exercism has an up-to-date, thorough, and wonderful guide on how to get started. However, here are some important notes:

- We recommend that you sign-in using your GitHub account, but this is not necessary (it's just a lot faster)
- **You must sign up using the "Practice Mode"** (we require that you do not use "Mentored Mode")
- Exercism will, by default, configure all programming exercises to download to a default directory on your computer. **Read through the Terminal output to find out where Exercism downloads your exercises.**

With those notes, get started using Exercism using their [Getting Started Guide](https://exercism.io/getting-started)

- Sign up for the Ruby track
- Follow their directions for getting started on the "Hello World" problem. You can trust and follow their directions for installing their CLI tool and any dependencies
  - When working on Hello World, check out the files `GETTING_STARTED.md` and `README.md` that are included in that folder

### How to Run the Tests

[Exercism has a guide on how to read and run the tests on the Ruby track here.](https://exercism.io/tracks/ruby/tests)

## Problems We Will Assign at Ada

With no promise to order or schedule, Ada roughly has plans to assign the following problems:

- Hello World
- Leap
- Hamming
- Word Count
- Luhn
- RNA Transcription
- Roman Numeral Reverter

## Using Exercism beyond Ada's Assignments

You are free to do other Exercism problems at any time. You are also free to engage with the Exercism community if you wish.
