# Built-in Ruby Methods Jigsaw

## Format

In this activity, we will be learning and then teaching each other, in the format of two rounds: the research round and the teaching round.

In the research round, you will meet with your first assigned group to learn about an assigned topic.

In the teaching round, your research round group will disseminate and you will go into your a second assigned group. It is your responsibility to teach this group about that topic.

## What to Research

You will be learning and teaching each other a variety of methods Ruby defines for strings, arrays, and hashes.

You will be practicing and teaching each other **how to read through the Ruby documentation** to find these answers.

### Where to Start

You will want to start with the official Ruby docs for your given method. To find the right web page, you may want to directly use a search engine, or you can look through the Ruby docs for [String](https://ruby-doc.org/core/String.html), [Array](https://ruby-doc.org/core/Array.html), and [Hash](https://ruby-doc.org/core/Hash.html). You will want to answer the questions:

1. What does this method do on a high level?
1. What does it return?
1. What does the code block do? (this question is relevant to only some methods)
1. What kind of syntax does it require?
1. What does a code example look like?

### Methods

1. `String#include?` & `String#upcase` & `String#downcase` & `String#swapcase`
1. `Array#first` & `Array#last` & `Array#rotate`
1. `Array#empty?` & `Array#clear`
1. `Hash#keys` & `Hash#key?`
1. `Hash#values` & `Hash#value?`
1. `Hash#invert`
