## Ruby Fundamentals

1. [Compound Conditionals: Truth Tables and Parse Trees](compound-and-complex-conditionals.md)
1. [Conditional Control Structures](conditional-control-structures.md)
1. [Methods](methods.md)
    - [Activity: Built-in Ruby Methods Jigsaw](./exercises/built-in-ruby-methods-jigsaw.md)
    - [Activity: Friendship Note](./exercises/friendship-note.md)
1. [Intro to Data Structures: Arrays and Hashes](data-structures.md)
1. [Nesting Arrays and Hashes](nesting-arrays-hashes.md)
1. [Scope](scope.md)
1. [Constants](constants.md)
1. [Intro to `Enumerable`s](intro-to-enumerables.md)
    - [Activity: `Enumerable`s Jigsaw](./exercises/enumerables-jigsaw.md)
1. [Intro to Ruby Gems](intro-to-ruby-gems.md)
1. [Keyword Arguments](keword-arguments.md)

## Object-Oriented Programming
1. [Classes Overview](classes-overview.md)
1. [Classes in Ruby](classes-in-ruby.md)
    - [Worksheet: Objects](./exercises/oo-worksheet.md)
1. [Classes Part 2: Helper Methods and Self](classes-part-2.md)

## Exercises
- [Worksheet: Object Types](./exercises/data-types-worksheet.md)
- [Practice on Conditionals](./exercises/conditionals.md)
- [Worksheet: Loop Table](./exercises/loop-table-worksheet.md)
- [Worksheet: While Loops](./exercises/while-worksheet.md)
- [Worksheet: Data Transformation](./exercises/data-transformation-worksheet.md)
- [Object Orientation: Library Book](./exercises/oo-library.md)
- [Object Orientation: Flower](./exercises/oo-flower.md)
