# Using Planning Boards

## Learning Goals
- Understand Ada's recommended best-practices for using planning boards in Trello
- Practice creating a planning board with tasks scheduled by iteration

## Prerequisite
This lesson will be hard to follow if students haven't first received the [Intro to Agile lesson](https://github.com/Ada-Developers-Academy/textbook-curriculum/blob/master/00-programming-fundamentals/intro-to-agile.md)

## Ada Suggested Practices
1. Create cards as User Stories 
    - Format: "As a user, I can ...[, so that I...]". 
        - eg. "As a user, I can browse products by merchant, so that I can explore all the cool stuff my favorite merchant sells and buy more stuff."
    - This helps you as a developer focus on what matters to the user. Without articulating your work this way, it's SO EASY to get distracted by lots of technical issues that may or may not actually matter to the end user!
1. Sort user stories by priority and approach the project by focusing on completing one story at a time.
    - For group projects, this means focusing on one story at a time per person.
1. Use checklists on each user story to break the story up into smaller tasks. 
    - This makes it easier to ensure every task you’re working on is directly related to the user story you’re currently focused on.
    - This way, with each user story you complete, you know you already have this much to show off for your demo!
    - If something in the checklist ends up being a big task in its own right, you can turn individual checklist items into their own cards!
1. Organize Trello cards by “Iteration", week, or priority. 
    - Find some way of setting due dates for a piece of work
      - eg. If a story represents ~30% of what you have left to do for the project and you have 13 more working days, it should be due in 13 days * .30 = 3.9 days (or around 4 days).
      - For bEtsy, your stories might be small enough that you want to set due date a whole list, then use that due date to assign due dates for each story in the list
    - This way you have some idea how you’re tracking: whether you’re ahead, behind, or on-track. 
1. If there are one or two user stories that feel the scariest or riskiest, start working on those as early as you possibly can. 
    - That will give you more time to make mistakes and it will give you more time to change your idea if something seems like it isn’t quite going to work like you expected.

  ## Exercise
  Let's create a trello board for bEtsy togeher!
  After we've created all the user-stories, we'll walk through this list and make sure we've followed each of them.
  (We won't take the time to make checklists for each user story but we'll pick a couple to make checklists for.)
  
  Here is a [template of a bEtsy trello board](https://trello.com/b/v9k5cmBB/example-betsy-board), but we're going to make one from scratch to practice.
