# User Stories

## Learning Goals
Students should be able to:
- Explain the concept of a user story.
- Write user stories to gather requirements.

## Overview

As developers, when we begin to develop software we start by gathering requirements.  These requirements are written by or for the customer to help developers put together the tasks needed to build the software.

A user story is a sentence identifying the type of user, the task and often the goal the task accomplishes.  

For example:  

- As an **Air BNB host** I want to **pull up a calendar listing all my reservations** so **I can plan my schedule**.  
- As an **Anynomous user on Expedia** I want to **search for flights by day** so **I can find a cheap flight**.

User stories are typically written on index cards or post-it notes and they help define what needs to be done in a project.  Sometimes they have acceptance tests attached to them.  

Once the initial round of stories is created they are prioritized and often put into a kanban board to be scheduled.  We will talk more about [kanban](http://kanbanblog.com/explained/) when we address [Agile](intro-to-agile.md).

![A simple Kanban board](https://agilesista.files.wordpress.com/2016/01/sample-kanban.jpg?w=625)

A typical template for a user story could be:

-  As a _____________  I want to _____________  so ________________.

This template identifies the who, what and why of the story.

## Why do it this way?

So why gather requirements with user-stories?  Users often don't know exactly what they want.  They are better able to picture what they want to be able to **do**.  

Using user stories we can gather the tasks our software needs to be able to perform and prioritize the tasks.  Then we can begin implementing the features and get more details on each user story as we implement them.

That doesn't mean every user story gets implemented as originally defined.  Using Agile techniques we develop software in increments building or prototyping features and solicting more user feedback.  As developers it's important to recognize that code is always changing. User stories help us narrow down the functionality our software needs and adapt to changing requirements.



## Things to avoid in user stories
User stories should focus on the user experience and avoid...
- Implementation details
- Making a story too big and complex. They should be small discrete tasks. Break down tasks that are too big and complicated into smaller stories.

## Resources
- [Wikipedia on User Stories](https://en.wikipedia.org/wiki/User_story)
- [Video on user stories](https://www.youtube.com/watch?v=LGeDZmrWwsw)
