

# macOS & Chrome Useful Apps

## macOS Apps

Below are some useful macOS apps for productivity as a developer.

| App Name  | Description  |
|---|---|
| [Alfred](http://www.alfredapp.com/)  | Alfred is a replacement for Spotlight as an application launcher or automation tool.    |
| [Flux](https://justgetflux.com/)  | f.lux fixes this: it makes the color of your computer's display adapt to the time of day, warm at night and like sunlight during the day.    |
| [Spectacle](https://www.spectacleapp.com/)  | Move and resize windows with ease.    |
| [Magnet](https://itunes.apple.com/us/app/magnet/id441258766?mt=12) | Another window manager, featuring drag-to-snap |
| [HyperSwitch](https://www.macupdate.com/app/mac/41769/hyperswitch) | Make window switching behave like Windows/Linux |
| [Slack](https://slack.com/downloads/osx)  | Slack has a desktop client for Mac Users.  |
| [Skype](https://www.skype.com/en/download-skype/skype-for-mac/)  | Skype is a great way to call friends and family online or directly to their phones.    |
| [Dropbox](http://dropbox.com/)  | Dropbox, OneDrive & Google Drive are great ways to backup your files to the cloud.  Use one:  **Back up your files!**  |
| [OneDrive](https://onedrive.live.com/about/en-us/download/)  | Dropbox, OneDrive & Google Drive are great ways to backup your files to the cloud.  Use one:  **Back up your files!**  |
| [Google Drive](https://www.google.com/drive/download/)  | Dropbox, OneDrive & Google Drive are great ways to backup your files to the cloud.  Use one:  **Back up your files!**  |
| [Freespace](https://itunes.apple.com/us/app/freespace/id457520846?mt=12) | Freespace is a handy app to show you how much disk space you have left.  My mac has a **very** small drive so I'm constantly using this.
| [Synergy](https://symless.com/synergy) | Use one mouse/keyboard to control multiple computers. Useful if you have a desktop at home you like to dock with



## Chrome Extensions


| Extension Name  | Description  |
|---|---|
| **Security and Privacy** |
| [uBlock Origin](https://chrome.google.com/webstore/detail/ublock-origin/cjpalhdlnbpafiamejdnhcphjbkeiagm) | Ads aren't just annoying, they cause websites to load slower and are a common attack vector for hackers. This addon blocks them. It's your computer - only run the code you want!
| [Privacy Badger](https://chrome.google.com/webstore/detail/privacy-badger/pkehgijcmpdhfbdbbnkijodmdjhbjlgp?hl=en-US) | Agressively prevents websites (and their advertisers) from tracking you.
| [HTTPS Everywhere](https://chrome.google.com/webstore/detail/https-everywhere/gcbommkclmclpchllfjekcdonpmejbdp?hl=en) | Always use a secure connection, if the site you're connecting to supports it.
| Password Manager ([LastPass](https://www.lastpass.com/) or many others) | Find yourself writing down passwords or reusing the same ones over and over? Use a password manager instead! Secure and simple.
| **Useful Tools** |
| [Postman](https://chrome.google.com/webstore/detail/postman-interceptor/aicmkgpgakddgnaphhhpliifpcfhicfo)  |  A useful app later at Ada to test APIs.
| [LucidChart](https://chrome.google.com/webstore/detail/lucidchart-diagrams-deskt/djejicklhojeokkfmdelnempiecmdomj) | This is a great service.  It lets you draw charts in the browser.  It connects to Google Apps and lets you save them there.  The free version is limited, but the paid version isn't too expensive at:  $5 per month.  
| [Momentum](https://chrome.google.com/webstore/detail/momentum/laookkfknpbbblfpciffpaejjkokdgca) | A new daily image is shown on each new tab, and it lets you build a todo list.  
| [BuiltWith](https://chrome.google.com/webstore/detail/builtwith-technology-prof/dapjbgnjinbpoindlpdmhochffioedbn?hl=en) | Find out what technology was used to build this website

---
## Resources
*  [Apple's tips for Going from PC to Mac](https://support.apple.com/en-us/HT204216)
