# How to Study like a Programmer

## Learning Goals

- Have a broad overview of different layers of abstraction to study
- Have a reference to past Ada student testimonials of study skills
- Have a recommended list of study strategies and resources
- Have a recommended list of tools

## The Role of a Programmer is to Learn to Learn

One of the biggest goals that the Ada program (from Jump Start to beyond graduation) is to foster the skill of **learning to learn.**

As a programmer in a field that changes so quickly, your most valuable asset will be how you manage your own individual learning.

What is the difference between a computer and a programmer?

Computers are strong at

- handling large amounts of data
- doing large calculations
- executing algorithms at scale
- generating things that follow specific rules

Human brains, on the other hand, are strong at

- pattern-finding
- decision-making
- designing
- interpreting
- jumping between messy layers of abstraction
- creating from nothing

A key element to thriving as a programmer will be to leverage computers for their strengths, so that you have the resources to work on your own problem-solving skills.

## Levels of Learning and Study in Programming

Studying, especially if you have not been in the classroom in a while, is really challenging! If you don't have a grasp on what your study habits work best for you, it will take time and experimentation to find out what's most effective.

In general, if there is a gap in knowledge that you want to tackle, it helps to know what level of learning may require further inspection.

1. **Knowledge:**
    - Do you know what all of the vocabulary means?
    - Do you have definitions for different pieces of vocabulary?
    - Can you recite the definition if someone asked you?
    - Do you know the standard syntax of this concept?
    - Which websites and resources and notes have the definitions to the relevant vocabulary?
2. **Understand:**
    - Do you have examples about this concept?
    - Can you recognize when this concept is relevant?
    - Can you recognize when this concept is not relevant?
    - Can you recognize the standard syntax of this concept, and its variations?
    - Which websites, resources, notes, and projects have example syntax?
3. **Apply:**
    - Can you create examples of this concept?
    - Can you repeat and modify any examples?
    - If someone says that this concept is relevant, can you find a way to apply this concept and fit it into the bigger picture?
    - Can you write, look up, and research the standard syntax of this concept, and its variations?
4. **Analyze:** On a bigger scale of systems...
    - Can you recognize what different factors impact this concept?
    - Can you recognize what consequences this concept can imply?
    - What are the technical trade-offs for this programming concept?
5. **Evaluate:** On a bigger scale of systems...
    - Can you recognize when to use, defend, or critique this concept?
    - Can you figure out when to use this programming concept/technique versus a different programming concept/technique?
6. **Create:** On a bigger scale of systems...
    - Can you determine how to orchestrate this concept in combination with other concepts?
    - Can you create a program that may or may not utilize this concept?

If this looks a lot like a programmer-specific version of the [general Bloom's Taxonomy model](https://en.wikipedia.org/wiki/Bloom%27s_taxonomy), then you're totally spot on :)

## Past Adie Study-Skills Testimonials

Every now and then we collect testimonials from graduated Adies who reflected on transitioning from having zero study skills to forging their study patterns. They are collectively located [here](https://drive.google.com/drive/folders/16TXs8qJ61KaNs8AmAdrQb8t4uX4OPnf5).

## General Study Techniques

### Generic Breaking up a Problem Format

While every problem is unique, when programming, here is a generic set of steps to follow for each programming problem:

1. Restate what you are trying to do. Is it clear? What questions do you have to make it more clear?
1. For this problem, what assumptions do you need to make?
1. Create some criteria so you understand when you have successfully solved the problem. Create some concrete examples for yourself that will show that you have solved the problem
1. Break up the problem into smaller sub-problems that are a smaller part
1. Approach the sub-problems, targeting the sub-problems that you know how to solve first
1. Document your questions. Determine if you should find the answers to those questions now or later.
1. Repeat!

### Generic Debugging

Sometimes, your program is not doing what it should be doing, and you stare at the code and you're unsure about what part of the code isn't correct. Here is a generic set of steps to follow for each bug:

1. What is the bug? How are you observing it?
1. When you observe the bug, what things are true? What is the value for each variable that is relevant? How do you know that is true? Have you confirmed that it's true?
1. What is the most specific piece of code that does something different than what you expect it to do? **What is the expected result, and how does it compare to the actual result?**
1. Come up with a theory of what is happening and why it's happening
1. Test this theory!
1. Document what you tried and what the results were... Probably on a piece of paper or a separate file.
1. Repeat this process until the bug is fixed!

### Activities and Techniques that are Tried and True

- Feeling like classroom time is overwhelming? Consider: Look at the calendar and the lessons the night before, and pre-read the lectures
- Feeling like reading material on programming is unnatural? Consider: Read this resource on [how to read programming books](http://www.pathsensitive.com/2018/01/the-benjamin-franklin-method-of-reading.html)
- Feeling like you lose focus on the task at hand? Consider: Using physical paper and sticky notes to write down the specific task you are trying to accomplish
- Feeling like you lose focus over time? Consider: Using a time management method like [Pomodoro Technique](https://en.wikipedia.org/wiki/Pomodoro_Technique) to help enable frequent breaks and frequent periods of flow
- Finding that your knowledge and understanding level of vocabulary is lacking? Consider: Utilize flashcards for specific vocabulary, concepts, and syntax
- Finding that you are craving more review in your own words? Consider: Making crib sheets (1-page review notes of the crucial knowledge) at the end of the week
- Feeling isolated? Please consider having proactive communication with other students and staff! Staff is on your side for your success, and your proactive communication with staff can lead to opportunities and resources
- Want a video series we recommend? Consider: ["Crash course" on study skills](https://www.youtube.com/playlist?list=PL8dPuuaLjXtNcAJRf3bE1IJU6nMfHj86W)

## Conclusion

Finding your own study style is challenging, but necessary. Luckily, there are a lot of existing resources and ideas, as well as your own understanding of yourself and your own creativity!

Finding your own study style will take a lot of time, a lot of experimentation, and a lot of feedback from yourself to figure out what works.

Your peers, your instructors, and the Ada staff are all prepared and excited to help you find your best study style!

When you find your best way of how you like to study, those skills will carry over into internships and jobs, so you can confidently say that you have learned how to learn effectively.
