# What is a Retrospective?

"Agile" is a set of methodologies and processes of software development. In Agile, a sprint is a phase of a project. A project is completed over many sprints. Agile teams conduct a _retrospective_ after each sprint. This is an opportunity to examine how the team is working together. It's a mediated conversation about the process by which the team is accomplishing its tasks and goals.

We will get more into depth about Agile software development over the curriculum.

## Our Retros

Retros can vary a lot in format. At Ada, we will do the following process:

### Preparation During the Week

During the week, whenever it wouldn't disrupt other classroom activities, add your thoughts and observations to the retro board. We will use the four categories below to classify our experiences and things that we want to acknowledge or discuss:

1. Challenges & Opportunities for Improvement
1. Less Of
1. More Of
1. Positive Experiences & Recognition

### Retro Process

At Ada, our specific process will be the following:

1. Gather everyone into the room
1. Get attendance
1. Deliver any news or announcements
1. Give a preview for next week
1. Request that someone take notes
1. Request that everyone else closes their laptops
1. Deliver the prime directive
1. Proceed with the retro

## Facilitation

One of the most common fears people have when first trying a retrospective is that the ritual will become a negative gripe session, interspersed with blame and counter blame. Those can be cathartic, but they won't contribute to learning nor help us improve our classroom experience. We will intercept and counteract those fears with the __Retrospective Prime Directive__:

> Regardless of what we discover, we understand and truly believe that everyone did the best job they could, given what they knew at the time, their skills and abilities, the resources available, and the situation at hand.

There will always be a facilitator during retro. At Ada, the facilitator will likely always be an instructor. The facilitator's job during retro is to moderate the conversation. They will stop the group from getting into the weeds, and do their best to give everyone the same opportunity to be heard. In specific, their job is to:

1. Set the Stage -> organize notes, introduce process
1. Gather Data -> read organized notes, provide context (if necessary), 
1. Generate Insights -> lead discussion, suggest actionable items (if appropriate)
1. Decide What to Do -> Is recognition enough? Is there an action item someone gets?
1. Close the Retrospective -> Respect people's time
