# How to Pseudocode

As our programs become more complicated, it is harder to know where to get started, break down the steps that need to be done and and still write clean code.

By breaking down the problem before writing code we can better prioritize what needs to be done and the steps involved to arrive at the minimum of what is needed to solve the problem.


## What is Pseudocode?
It allows you to think through the logic of a solving a problem before implementing 'real' code. So you don't have to think about the exact coding language syntax until you have laid out all the steps needed to create the program.


**Benefits of Pseudocode:**
- Makes Changes Easier
- Documents Your Work
- Allows for easier code reviews
- Supports Iterative Refinement


Pseudocode uses the structural conventions of a programming language, but is intended for human reading rather than machine reading.


## Additional Resources
- [Khan Academy Video: Planning with Pseudo-code](https://www.khanacademy.org/computing/computer-programming/programming/good-practices/p/planning-with-pseudo-code)
- [Wikihow: How to Write Pseudocode](http://www.wikihow.com/Write-Pseudocode)
