# Introduction to Agile
## Learning Goals
- What is _Waterfall_? What is _Agile?_ What is _agile_?
- How to _stand up_? Why to _stand up_?
- What is _Kanban_? Why is _Kanban_?


## Two Competing Ideas in Creating Software: Iterative vs Waterfall
Agile development is a set of methodologies that promotes iterative, adaptive, and rapid development. I really like agile. Waterfall is an older methodology that puts forth the idea that software can be designed, beginning to end, before development begins. Here are the primary differences:

### Waterfall
- Project focused
- Project time line many months to years.
- Testing phase after development phase

### Iterative
- Product focused
- Project time several days to weeks (referred to as a _sprint_).
- Testing integrated with development

## Stand Up
> Daily stand-up meetings have become a common ritual of many teams, especially in Agile software development. However, there are many subtle details that distinguish effective stand-ups and a waste of time.

Stand up is a daily meeting for a small team, typically at the same place and time each day. During the meeting everyone meets standing up (get it?). Each team member takes _no more than one minutes_ to answer three questions:

1. What did I accomplish yesterday?
2. What will I do today?
3. What obstacles are impeding my progress?

The point is to keep is short and sweet. Do not:

1. Ask in-depth questions of others. Instead, quickly communicate a time to meet individually to talk _after standup_.
1. Ramble.
1. Show up unprepared.

## Kanban!
A Kanban board is visual representation of the _stories_ related to a project. It's used to know, at a glance, what everyone is working on, what's been done, and what's still waiting to be done. The simplest Kanban board consists of three columns: "to-do", "in progress" and "done":

![A simple Kanban board](https://upload.wikimedia.org/wikipedia/commons/thumb/d/d3/Simple-kanban-board-.jpg/1200px-Simple-kanban-board-.jpg)

Typically software projects need more distinction, but three columns are not a bad place to start.

In _agile development_, the _stories_ that haven't been started are collected in a _backlog_. At the beginning of a _sprint_, the team decides what work can be accomplished within the confines of the _sprint_ and move those stories to _on deck_. As _stories_ are picked up by developers, they move to _in progress_. Once completed, the _stories_ move to _done_. You'd think that's the last step, but it's not. There's often one or two more columns after _done_: _customer acceptance_ and _live/deployed_.

At any point, if progress is impeded or superceded, a _story_ can be moved back to _on deck_ or even the _backlog_.

We're going to practice the style of project management by using an online system called [Trello](http://www.trello.com) to document and manage _stories_.

## Further Reading
- [User Stories](http://en.wikipedia.org/wiki/User_story)
- [TDD](http://en.wikipedia.org/wiki/Test-driven_development) & [BDD](http://en.wikipedia.org/wiki/Behavior-driven_development)
- [Continuous Integration (CI)](http://en.wikipedia.org/wiki/Continuous_integration)
- [Pair Programming](http://en.wikipedia.org/wiki/Pair_programming)
- [Agile "Manifesto"](http://agilemanifesto.org/)
- [Using Trello for Agile Project Management](https://blog.trello.com/how-to-scrum-and-trello-for-teams-at-work)
- [Parens Sample Trello Board](https://trello.com/b/CzsyAnKG)
- [MIT Open Course on Agile Game Development](https://www.youtube.com/watch?v=UxMpn92vGXs)
