﻿# 7/22/2024 - v24.1.1

## Fundamentals
- Updated SegmentedBar to support ScrollViewer.IsScrollChainingEnabled.
## Themes
- Updated MenuHeadingFontWeight theme resource from Bold to SemiBold.
- Updated TextBox control theme to work around a ScrollViewer issue.
## Shared Library
- Added new ScrollableOverflowPresenter properties for ScrollBackwardCommand, ScrollForwardCommand, and AllowEmbeddedScrollButtons that can be used to hide the built-in scroll buttons and bind scroll operations to other controls.  Added a new sample to demonstrate the feature.
- Added the ResizablePopupContentHost and PopupResizeGrip primitive controls.
- Added OverlayInputFilter that can be used with WindowOverlayManager to control which content is disabled when an overlay is displayed (like those used by User Prompt).
- Improved accessibility of ScrollableOverflowPresenter embedded scroll buttons.
- Updated ScrollableOverflowPresenter to support ScrollViewer.IsScrollChainingEnabled by only marking mouse wheel events as handled when scrolling was actually performed.
- Fixed issue where changing ScrollableOverflowPresenter.UseInfiniteConstraint did not trigger an updated layout.
- Fixed issue where CopyButton and ToggleThemeButton might not have a default theme applied.

---

# 5/6/2024 - v24.1.0

## Fundamentals
- Added the Card control, which displayed grouped information for a single subject.
- Added the CircularProgressBar control, which renders a progress percentage in a ring shape using fluent animations, and also supports an indeterminate state.
- Added the InfoBar control, which displays essential information to a user without disrupting the user flow.
- Added the SegmentedBar control, which can be used to select a single item with fluent animations.
- Added the SettingsCard, SettingsExpander, and SettingsGroup controls, which can be used to organize and present configurable settings.
- Added UserPromptBuilder.Tag property and WithTag method for storing arbitrary data.
- Updated Avatar control styles to prevent button-related style class names (e.g., 'theme-solid', 'theme-link') from changing the Avatar theme.
- Updated BadgeAdorner to automatically bind Badge.DataContext to the adorned element's DataContext when Badge.DataContext is null.
- Updated BadgeAdorner to enable clipping when the Badge is within the bounds of the adorned element and disable clipping when outside the bounds.
- Renamed UserPromptControl's FooterImage and StatusImage properties as FooterImageSource and StatusImageSource.
- Fixed a possible exception when assigning the owner of a UserPromptWindow if the explicit owner was undefined and the coerced owner was invalid.
## Themes
- Added the ThemeProperties.ToggleSwitchHasFarAffinityProperty attached property with updated ToggleSwitch theme to allow the knob/track of a ToggleSwitch to be arranged on the right side of the control instead of the left.
- Updated native control themes with changes in Avalonia through v11.0.10.
- Adjusted the default font size ratios for smaller sizes.
## Shared Library
- Added the ScrollableOverflowPresenter control that displays scroll buttons when its content overflows the available space.
- Added ShadowChrome.IsAnimationEnabled property which can be used to enable or disable animated property transitions.
- Added the ImageControlConverter value converter that can create an Image control for an IImage source.
- Updated DegreeAngleAnimator to be registered as a custom animator in ModernTheme's static constructor.
- Updated DynamicImage.DisabledOpacity so that it is relative to the control's opacity.
- Updated HyperlinkTextBlock to support 'size-*' style classes.
- Updated MeshGradientPresenter to work with Avalonia v11.1 API changes.
- Updated ImageProvider's cloning of RadialGradientBrush instances to work with Avalonia v11.1 API changes.
- Renamed ActiproSoftware.UI.Avalonia.Controls.Converters.ImageKeyToImageConverter as ImageKeyToImageSourceConverter.
- Renamed ActiproSoftware.UI.Avalonia.Media.SharedImageKeys as SharedImageSourceKeys.
## All
- Updated the minimum Avalonia dependency from v11.0.5 to v11.0.7.

---
