﻿# 2/5/2024 - v23.1.3

## Fundamentals
- Added new Avatar and AvatarGroup controls that render images, glyphs, initials, or text to represent people.
- Added new Badge and NumericBadge controls that add contextual information to other controls.
- Added the RingSpinner control that can inform an end user that some form of processing is occurring.
- Fixed UserPromptBuilder auto-size to owner when displayed on screens with high DPI.
## Themes
- Improved the ListBox, TreeView, and DataGrid templates to better support rounded corners when CornerRadius is set.
## Shared Library
- Added the RingSlice shape that can render a portion (or the entire circle) of a ring shape.

---

# 12/4/2023 - v23.1.2

## Themes
- Added the ThemeProperties.SpinnerHasHorizontalOrientation attached property that can arrange ButtonSpinner and NumericUpDown buttons horizontally, making them more touch-friendly.
- Added the ThemeDefinition.SpinnerHasHorizontalOrientation property that provides a global default for the ThemeProperties.SpinnerHasHorizontalOrientation attached property.
- Fixed an issue where the new density-related markup extensions added in the previous build weren't parsing numbers with invariant culture, which had led to excessive padding on some systems.
- Fixed an issue where a menu item's sub-menu could close when the pointer was over the popup's shadow.
## Shared Library
- Added various members to the UIColor structure to support the OKLAB and OKLCH color models.
- Added the UIColor.ToChromaticAdaptation method that updates the color to render clearly on a given background.
- Added the UIColor.ToGrayscale method that updates the color to a grayscale value.
- Added the Color.ToUIColor extension method that converts a Color to a UIColor.
- Added the IOrientedElement interface and numerous extension methods.
- Added the ShadowChrome.Background and Padding properties.
- Updated ArrayExtension and DelimitedArrayExtension to return generic object arrays for AOT compatibility instead of type-specific arrays.  The ArrayExtension.Type property has been deprecated and will be removed in a future release.
## All
- Improved support for trimming and Native AOT (Ahead-of-Time).

---

# 11/14/2023 - v23.1.1

## Themes
- Added a new ThemeDefinition.UserInterfaceDensity property with Compact, Normal, and Spacious options that can alter spacing throughout an application's user interface.  The default value is Normal, and can be changed in the Sample Browser with new View menu items.
- Added a new documentation topic on User Interface Density.
- Added the ScaledThicknessExtension, ScaledCornerRadiusExtension, ScaledDoubleExtension, and ScaledGridLengthExtension markup extensions to support dynamic values that scale based on UI density.
- Added neutral control theme brush resources for outline, soft, and solid themes (e.g., ControlBackgroundBrushOutline, ControlBackgroundBrushSoft, ControlBackgroundBrushSolid, etc.).
- Updated controls and themes to adjust their appearance based on UI density.
- Updated the default ThemeDefinition.SwitchScale value to work better with common font sizes.
- Updated ScrollBar thumbs to be slightly thinner by default.
- Updated Calendar to have a smaller overall size.
- Fixed a memory leak in ThemeProperties related to watching StyledElement.Classes for changes.
## Shared Library
- Updated the overlay host, which is used by user prompts in Overlay display mode, to fluently animate in content.
- Updated ChromedTitleBar to work around an issue in Windows 10 where an outer window border/shadow may not be rendered.

---

# 10/17/2023 - v23.1.0
## All
- First release.

---
